/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.ConceptGroupGenerator;
import com.sun.java.help.search.RoleFiller;

class GeneratorHeap {
    private static final int InitSize = 128;
    private int _heapSize = 0;
    private ConceptGroupGenerator[] _heap = new ConceptGroupGenerator[128];
    private int _size = 128;
    private int _free = 0;

    public void reset() {
        this._free = 0;
    }

    public void addGenerator(ConceptGroupGenerator conceptGroupGenerator) {
        if (this._free == this._size) {
            ConceptGroupGenerator[] conceptGroupGeneratorArray = new ConceptGroupGenerator[this._size *= 2];
            System.arraycopy(this._heap, 0, conceptGroupGeneratorArray, 0, this._free);
            this._heap = conceptGroupGeneratorArray;
        }
        this._heap[this._free++] = conceptGroupGenerator;
    }

    private void buildHeap() {
        for (int i2 = this._heapSize / 2; i2 >= 0; --i2) {
            this.heapify(i2);
        }
    }

    private void heapify(int n2) {
        int n3;
        int n4 = n2 + 1 << 1;
        int n5 = n4 - 1;
        int n6 = n3 = n5 < this._heapSize && this._heap[n5].position() < this._heap[n2].position() ? n5 : n2;
        if (n4 < this._heapSize && this._heap[n4].position() < this._heap[n3].position()) {
            n3 = n4;
        }
        if (n3 != n2) {
            ConceptGroupGenerator conceptGroupGenerator = this._heap[n3];
            this._heap[n3] = this._heap[n2];
            this._heap[n2] = conceptGroupGenerator;
            this.heapify(n3);
        }
    }

    public boolean start(RoleFiller[] roleFillerArray) throws Exception {
        this._heapSize = this._free;
        if (this._heapSize > 0) {
            for (int i2 = 0; i2 < this._free; ++i2) {
                this._heap[i2].next();
            }
            this.buildHeap();
            this._heap[0].generateFillers(roleFillerArray);
            return true;
        }
        return false;
    }

    public boolean next(RoleFiller[] roleFillerArray) throws Exception {
        if (this._heapSize > 0) {
            if (!this._heap[0].next()) {
                if (this._heapSize > 1) {
                    this._heap[0] = this._heap[--this._heapSize];
                } else {
                    this._heapSize = 0;
                    return false;
                }
            }
            this.heapify(0);
            this._heap[0].generateFillers(roleFillerArray);
            return true;
        }
        return false;
    }
}

