/*
 * Decompiled with CFR 0.152.
 */
package de.humatic.dsj;

import de.humatic.dsj.DSEnvironment;
import de.humatic.dsj.DSJException;
import de.humatic.dsj.DSJUtils;
import de.humatic.dsj.DSMediaType;
import de.humatic.dsj.ext.Registry;
import java.io.File;
import java.io.FileInputStream;
import java.util.Vector;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class DSFilterInfo
implements Comparable {
    public static final int SHOW_USER_DIALOG = -2;
    public static final int SHOW_DLG_SAVE = -4;
    public static final int DO_NOT_USE = -1;
    public static final int CAPTURE_VIDEO = 0;
    public static final int CAPTURE_AUDIO = 1;
    public static final int CAPTURE_MPEG = 2;
    public static final int CAPTURE_DV = 3;
    public static final int IAMVideoCompression = 0;
    public static final int QUALITY = 1;
    public static final int CRUNCH = 2;
    public static final int KEYFRAME = 4;
    public static final int BFRAME = 8;
    public boolean isDescriptive;
    boolean a;
    private boolean b;
    private boolean c;
    String path = "none";
    String name = "none";
    String CLSID = "none";
    String subGUID = "none";
    String preferredPin = "none";
    int type = 254;
    int preferredFormat = -1;
    int wmProfileFlags = 0;
    int category = -1;
    int tvFormat;
    private int[] codecCaps = new int[]{-1, -1, -1, -1, -1, -1, -1, -1};
    int[] pinFormatMap = new int[]{1};
    private Vector a;
    private DSPinInfo[] a;
    private DSPinInfo[] b;
    private DSPinInfo[] c = true;
    private DSCrossBarInfo a;
    private DSTVTunerInfo a;

    DSFilterInfo() {
        new String(new byte[]{-3});
    }

    public static DSFilterInfo doNotRender() {
        return new DSFilterInfo(-1);
    }

    public static DSFilterInfo filterInfoForName(String string) throws DSJException {
        try {
            int n2;
            if (string.equalsIgnoreCase("dsj_Dump")) {
                return new DSFilterInfo("dsj_Dump", "{1209BB63-E9D1-4f03-AC25-426367DEB524}");
            }
            DSFilterInfo[] dSFilterInfoArray = null;
            dSFilterInfoArray = DSEnvironment.getFilters(4);
            for (n2 = 0; n2 < dSFilterInfoArray.length; ++n2) {
                if (!dSFilterInfoArray[n2].getName().equalsIgnoreCase(string)) continue;
                return dSFilterInfoArray[n2];
            }
            for (n2 = 0; n2 < DSEnvironment.getFilterCategories().length; ++n2) {
                if (n2 == 4 || n2 == 9 || n2 == 10 || n2 == 11 || n2 == 19) continue;
                dSFilterInfoArray = DSEnvironment.getFilters(n2);
                for (int i2 = 0; i2 < dSFilterInfoArray.length; ++i2) {
                    if (!dSFilterInfoArray[i2].getName().trim().equalsIgnoreCase(string)) continue;
                    return dSFilterInfoArray[i2];
                }
            }
        }
        catch (Exception exception) {}
        throw new DSJException("filterInfoForName: " + string + ", no such filter", -10);
    }

    DSFilterInfo(int n2) {
        new String(new byte[]{-3});
        this.type = n2;
    }

    public DSFilterInfo(String string, String string2) {
        new String(new byte[]{-3});
        try {
            this.name = DSJUtils.a(string);
        }
        catch (Exception exception) {}
        try {
            this.CLSID = DSJUtils.a(string2);
            return;
        }
        catch (Exception exception) {
            this.CLSID = "CLSID unknown";
            return;
        }
    }

    DSFilterInfo(String string, String string2, int n2) {
        new String(new byte[]{-3});
        try {
            this.name = DSJUtils.a(string);
        }
        catch (Exception exception) {}
        try {
            this.path = DSJUtils.a(string2);
        }
        catch (Exception exception) {}
        this.category = n2;
        this.type = n2 == 7 ? 0 : 1;
    }

    public static DSFilterInfo filterInfoForCLSID(String string) throws DSJException {
        try {
            int n2;
            try {
                if (string.indexOf("{") < 0) {
                    string = "{" + string.trim();
                }
                if (string.indexOf("}") < 0) {
                    string = string.trim() + "}";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string.trim().equalsIgnoreCase("{1209BB63-E9D1-4f03-AC25-426367DEB524}")) {
                return new DSFilterInfo("dsj_Dump", "{1209BB63-E9D1-4f03-AC25-426367DEB524}");
            }
            DSFilterInfo[] dSFilterInfoArray = null;
            dSFilterInfoArray = DSEnvironment.getFilters(4);
            for (n2 = 0; n2 < dSFilterInfoArray.length; ++n2) {
                if (!dSFilterInfoArray[n2].getCLSID().equalsIgnoreCase(string.trim())) continue;
                return dSFilterInfoArray[n2];
            }
            for (n2 = 0; n2 < DSEnvironment.getFilterCategories().length; ++n2) {
                if (n2 == 4 || n2 == 9 || n2 == 10 || n2 == 11 || n2 == 19) continue;
                dSFilterInfoArray = DSEnvironment.getFilters(n2);
                for (int i2 = 0; i2 < dSFilterInfoArray.length; ++i2) {
                    if (!dSFilterInfoArray[i2].getCLSID().equalsIgnoreCase(string.trim())) continue;
                    return dSFilterInfoArray[i2];
                }
            }
        }
        catch (Exception exception) {}
        throw new DSJException("filterInfoForCLSID: " + string + ", no such filter", -10);
    }

    public static DSFilterInfo createFileInfo(String string) {
        DSFilterInfo dSFilterInfo = DSFilterInfo.doNotRender();
        try {
            File file = new File(string);
            string = file.getAbsolutePath();
        }
        catch (Exception exception) {}
        dSFilterInfo.setPath(string);
        dSFilterInfo.setCategory(4);
        return dSFilterInfo;
    }

    public static DSFilterInfo filterInfoForProfile(File object) {
        DSFilterInfo dSFilterInfo = new DSFilterInfo();
        try {
            StringBuffer stringBuffer = new StringBuffer();
            object = new FileInputStream(((File)object).getAbsoluteFile());
            int n2 = 0;
            int n3 = -1;
            while ((n2 = ((FileInputStream)object).read()) >= 0) {
                if (n2 < 32 || n2 >= 126 || n2 == 32 && n3 == 32) continue;
                stringBuffer.append(new String(new byte[]{(byte)n2}));
                n3 = n2;
            }
            dSFilterInfo.setPath(new String(stringBuffer.toString()));
            ((FileInputStream)object).close();
            stringBuffer.setLength(0);
        }
        catch (Exception exception) {
            return null;
        }
        dSFilterInfo.setName("WMProfile");
        return dSFilterInfo;
    }

    public static DSFilterInfo filterInfoForProfile(String string) {
        DSFilterInfo dSFilterInfo = new DSFilterInfo();
        dSFilterInfo.setName("WMProfile");
        dSFilterInfo.setPath(string);
        return dSFilterInfo;
    }

    public static DSFilterInfo filterInfoForSystemProfile(int n2) throws DSJException {
        if (n2 < 0 || n2 > 27) {
            throw new DSJException("Invalid profile index: " + n2, -4);
        }
        DSFilterInfo dSFilterInfo = new DSFilterInfo();
        dSFilterInfo.setName("WMProfile");
        dSFilterInfo.setPath(String.valueOf(n2));
        return dSFilterInfo;
    }

    public static DSFilterInfo filterInfoForCodecState(String string, File file) throws DSJException {
        int n2;
        if (!file.exists()) {
            throw new DSJException("Codecstate - file not found: " + file.getAbsolutePath(), -9);
        }
        DSFilterInfo dSFilterInfo = null;
        DSFilterInfo[][] dSFilterInfoArray = DSEnvironment.getEncoders();
        for (n2 = 0; n2 < dSFilterInfoArray[0].length; ++n2) {
            if (!dSFilterInfoArray[0][n2].getName().equalsIgnoreCase(string)) continue;
            dSFilterInfo = dSFilterInfoArray[0][n2];
            break;
        }
        if (dSFilterInfo == null) {
            for (n2 = 0; n2 < dSFilterInfoArray[1].length; ++n2) {
                if (!dSFilterInfoArray[1][n2].getName().equalsIgnoreCase(string)) continue;
                dSFilterInfo = dSFilterInfoArray[1][n2];
                break;
            }
        }
        if (dSFilterInfo == null) {
            dSFilterInfo = DSFilterInfo.filterInfoForName(string);
        }
        if (dSFilterInfo == null) {
            throw new DSJException("No such filter: " + string, -10);
        }
        dSFilterInfo.setName(dSFilterInfo.getName() + "|" + file.getAbsolutePath());
        dSFilterInfo.setCLSID(dSFilterInfo.getCLSID() + "|" + file.getAbsolutePath());
        return dSFilterInfo;
    }

    public static DSFilterInfo filterInfoForCodecState(String string, String string2) throws DSJException {
        DSFilterInfo dSFilterInfo = string.indexOf("{") == 0 ? DSFilterInfo.filterInfoForCLSID(string) : DSFilterInfo.filterInfoForName(string);
        if (dSFilterInfo == null) {
            throw new DSJException("No such filter: " + string, -10);
        }
        string = DSEnvironment.createStructuredStorage(true, "dsj\\" + DSEnvironment.getProcessID() + "\\" + string + ".stg", "dsj_FilterState", DSJUtils.byteArrayFromHexString(string2));
        if (string.equalsIgnoreCase("error")) {
            throw new DSJException("Can't create storage", -1);
        }
        dSFilterInfo.setName(dSFilterInfo.getName() + "|" + string);
        dSFilterInfo.setCLSID(dSFilterInfo.getCLSID() + "|" + string);
        return dSFilterInfo;
    }

    public static DSFilterInfo filterInfoForDll(String object, String string) throws DSJException {
        Object object2;
        if (((String)object).indexOf(":/") < 0 && ((String)object).indexOf(":\\") < 0) {
            throw new DSJException("Not a full path", -39);
        }
        if (string == null || string.length() < 36) {
            throw new DSJException("Invalid CLSID", -39);
        }
        try {
            object = ((String)object).replace('/', '\\');
        }
        catch (Exception exception) {
            object2 = exception;
            exception.printStackTrace();
        }
        if (string.indexOf("{") < 0) {
            string = "{" + string + "}";
        }
        if (((String)(object2 = ((String)object).substring(((String)object).lastIndexOf("\\") + 1))).indexOf(".") != -1) {
            object2 = ((String)object2).substring(0, ((String)object2).lastIndexOf("."));
        }
        object = new DSFilterInfo((String)object2 + "^" + (String)object, string + "^" + (String)object);
        return object;
    }

    void changed() {
        System.out.println("FilterInfo changed: " + this.getName());
        this.b = true;
        this.a().removeAllElements();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName());
        if (this.CLSID != null) {
            stringBuffer.append("  CLSID: " + this.getCLSID());
        }
        if (this.path != null && !this.path.equalsIgnoreCase("none")) {
            stringBuffer.append("\npath: " + this.getPath());
        }
        try {
            for (int i2 = 0; i2 < this.a.size(); ++i2) {
                DSPinInfo dSPinInfo = (DSPinInfo)this.a.get(i2);
                stringBuffer.append("\n     Pin ID:   " + dSPinInfo.b);
                stringBuffer.append("\n     Pin name:      " + dSPinInfo.a);
                stringBuffer.append("\n     Pin type: " + dSPinInfo.a + "  direction: " + (dSPinInfo.b == 1 ? "in" : "out"));
                stringBuffer.append("\n      \t  Formats: ");
                for (int i3 = 0; i3 < dSPinInfo.a().size(); ++i3) {
                    DSMediaType dSMediaType = (DSMediaType)dSPinInfo.a().get(i3);
                    if (dSMediaType.a.equals("Video")) {
                        stringBuffer.append("\n      \t      " + dSMediaType.a + " - " + dSMediaType.b + ", width: " + dSMediaType.d + ", height: " + dSMediaType.e + ", bitDepth: " + dSMediaType.i);
                        continue;
                    }
                    if (dSMediaType.a.equals("Audio")) {
                        stringBuffer.append("\n      \t      " + dSMediaType.a + " - " + dSMediaType.b + ", ch.: " + dSMediaType.g + ", sampleRate: " + dSMediaType.h + ", bits: " + dSMediaType.i + ". kbps: " + dSMediaType.getBitRate());
                        continue;
                    }
                    stringBuffer.append("\n      \t        " + dSMediaType.a + " - " + dSMediaType.b);
                }
            }
            stringBuffer.append("\n");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {}
        return stringBuffer.toString();
    }

    void setType(int n2) {
        this.type = n2;
    }

    void setPath(String string) {
        if (!string.equalsIgnoreCase("null")) {
            this.path = DSJUtils.a(string);
        }
    }

    void setName(String string) {
        this.name = string;
    }

    void setCLSID(String string) {
        this.CLSID = string;
    }

    void setCategory(int n2) {
        this.category = n2;
    }

    void setSubGUID(String string) {
        this.subGUID = string;
    }

    void setCompressorCaps(int n2) {
        this.codecCaps[3] = n2 >>> 24;
        this.codecCaps[2] = n2 >> 16 & 0xFF;
        this.codecCaps[1] = n2 >> 8 & 0xFF;
        this.codecCaps[0] = n2 & 0xFF;
    }

    public String getPath() {
        if (this.path.equalsIgnoreCase("none")) {
            return this.name;
        }
        return this.path;
    }

    public String getName() {
        if (this.name.indexOf("|") > 0) {
            return this.name.substring(0, this.name.indexOf("|"));
        }
        if (this.name.indexOf("^") > 0) {
            return this.name.substring(0, this.name.indexOf("^"));
        }
        return this.name;
    }

    public String getCLSID() {
        if (this.CLSID == null || this.CLSID.indexOf("none") >= 0 || this.CLSID.indexOf("unknown") >= 0) {
            try {
                DSFilterInfo dSFilterInfo = DSFilterInfo.filterInfoForName(this.getName());
                this.CLSID = dSFilterInfo.CLSID;
            }
            catch (Exception exception) {}
        }
        if (this.CLSID != null && this.CLSID.indexOf("|") > 0) {
            return this.CLSID.substring(0, this.CLSID.indexOf("|"));
        }
        if (this.CLSID != null && this.CLSID.indexOf("^") > 0) {
            return this.CLSID.substring(0, this.CLSID.indexOf("^"));
        }
        return this.CLSID;
    }

    public String getSubGUID() {
        return this.subGUID;
    }

    public String getDllLocation() throws DSJException {
        Registry.setAccessLevel(1);
        return Registry.getSubKeyValue_String(0, "CLSID\\" + this.getCLSID() + "\\InprocServer32", "");
    }

    public int getType() {
        return this.type;
    }

    public boolean isNullInfo() {
        return this.type < 0;
    }

    void setAvailable(boolean bl) {
        this.c = bl;
    }

    final boolean a() {
        return this.c;
    }

    void setTVFormat(int n2) {
        this.tvFormat = n2;
    }

    public void setPreferredFormat(int n2) {
        if (this.pinFormatMap == null || this.pinFormatMap.length == 1) {
            this.closeQuery(true);
        }
        this.preferredFormat = n2;
        try {
            for (int i2 = 0; i2 < this.getDownstreamPins().length; ++i2) {
                this.pinFormatMap[4 + (i2 << 1)] = n2;
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public int getPreferredFormat() {
        return this.preferredFormat;
    }

    public int compareTo(Object object) {
        if (!(object instanceof DSFilterInfo)) {
            return -1;
        }
        return this.getName().compareToIgnoreCase(((DSFilterInfo)object).getName());
    }

    public DSPinInfo[] getPins() {
        return this.a(-1L, -1L);
    }

    final DSPinInfo[] a(long l2, long l3) {
        int n2;
        if (this.type == -1 || !this.c || this.isDescriptive) {
            return null;
        }
        if (this.a != null && !this.b) {
            return this.a;
        }
        if (this.a().size() == 0 && (n2 = this.a(l2, l3)) < 0) {
            throw new DSJException("cant resolve filter " + DSJException.hresultToHexString(n2), n2);
        }
        this.a = new DSPinInfo[this.a().size()];
        this.a().toArray(this.a);
        return this.a;
    }

    public DSPinInfo[] getDownstreamPins() {
        return this.b(-1L, -1L);
    }

    final DSPinInfo[] b(long l2, long l3) {
        int n2;
        int n3;
        if (this.type == -1 || !this.c || this.isDescriptive) {
            return null;
        }
        if (this.a().size() == 0 && (n3 = this.a(l2, l3)) < 0) {
            throw new DSJException("cant resolve filter " + DSJException.hresultToHexString(n3), n3);
        }
        if (this.b != null) {
            return this.b;
        }
        int n4 = 0;
        for (n2 = 0; n2 < this.a().size(); ++n2) {
            if (((DSPinInfo)this.a().get((int)n2)).b != 0) continue;
            ++n4;
        }
        this.b = new DSPinInfo[n4];
        n2 = 0;
        for (n4 = 0; n4 < this.a().size(); ++n4) {
            if (((DSPinInfo)this.a().get((int)n4)).b != 0) continue;
            this.b[n2++] = (DSPinInfo)this.a().get(n4);
        }
        return this.b;
    }

    public DSPinInfo[] getUpstreamPins() {
        return this.c(-1L, -1L);
    }

    final DSPinInfo[] c(long l2, long l3) {
        int n2;
        int n3;
        if (this.type == -1 || !this.c || this.isDescriptive) {
            return null;
        }
        if (this.a().size() == 0 && (n3 = this.a(l2, l3)) < 0) {
            throw new DSJException("cant resolve filter " + DSJException.hresultToHexString(n3), n3);
        }
        if (this.c != null) {
            return this.c;
        }
        int n4 = 0;
        for (n2 = 0; n2 < this.a().size(); ++n2) {
            if (((DSPinInfo)this.a().get((int)n2)).b != 1) continue;
            ++n4;
        }
        this.c = new DSPinInfo[n4];
        n2 = 0;
        for (n4 = 0; n4 < this.a().size(); ++n4) {
            if (((DSPinInfo)this.a().get((int)n4)).b != 1) continue;
            this.c[n2++] = (DSPinInfo)this.a().get(n4);
        }
        return this.c;
    }

    public DSCrossBarInfo getCrossBarInfo() {
        return this.a;
    }

    public DSTVTunerInfo getTVTunerInfo() {
        return this.a;
    }

    private Vector a() {
        if (this.a == null) {
            this.a = new Vector();
        }
        return this.a;
    }

    final DSPinInfo a() {
        if (this.a == null) {
            this.a = new Vector();
        }
        DSPinInfo dSPinInfo = new DSPinInfo(this, this);
        this.a.add(dSPinInfo);
        return dSPinInfo;
    }

    final void a(String string, String string2) {
        DSPinInfo dSPinInfo = this.a();
        this.a().b = 1;
        dSPinInfo.a = string;
        dSPinInfo.b = string;
        if (string2 != null) {
            dSPinInfo = this.a();
            this.a().b = 0;
            dSPinInfo.a = string2;
            dSPinInfo.b = string2;
        }
    }

    DSPinInfo addPin(String object, String string, int n2, int n3, int n4) {
        object = new DSPinInfo(this, this, (String)object, string, n2, n3, n4);
        this.a().add(object);
        return object;
    }

    DSCrossBarInfo addCrossBar() {
        if (this.a == null) {
            this.a = new DSCrossBarInfo(this);
        }
        return this.a;
    }

    void addTVTuner(int n2, int n3, int n4, int n5, int n6) {
        this.a = new DSTVTunerInfo(this, n2, n3, n4, n5, n6);
    }

    final void a() {
        this.a = null;
        this.a = null;
        this.b = null;
        this.c = null;
        this.b = true;
    }

    public boolean resolve() {
        return this.a(-1L, -1L) == 0;
    }

    final int a(long l2, long l3) {
        try {
            String string;
            String string2;
            long l4;
            long l5;
            DSFilterInfo dSFilterInfo;
            if (this.isDescriptive) {
                return -1;
            }
            Vector vector = null;
            Vector vector2 = new Vector();
            int n2 = 0;
            if (this.getName().indexOf(":/") != -1) {
                dSFilterInfo = this;
                l5 = l2;
                l4 = l3;
                string2 = this.getName();
                string = "none";
            } else {
                dSFilterInfo = this;
                l5 = l2;
                l4 = l3;
                string2 = this.getName() == null || this.getName().length() == 0 ? "None" : this.getName();
                string = this.getCLSID() == null || this.getCLSID().length() == 0 ? "None" : this.getCLSID();
            }
            n2 = dSFilterInfo.resolveFilter(l5, l4, string2, string, vector2);
            if (n2 < 0) {
                return n2;
            }
            int n3 = 0;
            DSPinInfo dSPinInfo = null;
            for (int i2 = 0; i2 < vector2.size(); ++i2) {
                DSFilterInfo dSFilterInfo2;
                if (vector2.get(i2).toString().equals("pin")) {
                    vector = this.a();
                    n3 = 2;
                    dSFilterInfo2 = this;
                    dSPinInfo = new DSPinInfo(dSFilterInfo2, dSFilterInfo2);
                    vector.add(dSPinInfo);
                    continue;
                }
                if (n3 < 0) continue;
                try {
                    if (vector2.get(i2).toString().equals("formats")) {
                        dSPinInfo.a();
                        n3 = 100;
                        continue;
                    }
                    if (vector2.get(i2).toString().equals("mediatypes")) {
                        dSPinInfo.a();
                        n3 = 100;
                        continue;
                    }
                    new String(new byte[]{-3});
                    block5 : switch (n3) {
                        case 2: {
                            vector2.get(i2).toString();
                            dSFilterInfo2 = null;
                            break;
                        }
                        case 3: {
                            dSPinInfo.a = DSJUtils.a(vector2.get(i2).toString());
                            break;
                        }
                        case 4: {
                            dSPinInfo.b = DSJUtils.a(vector2.get(i2).toString());
                            break;
                        }
                        case 5: {
                            dSPinInfo.b = Integer.valueOf(vector2.get(i2).toString());
                            for (int i3 = 0; i3 < vector.size() - 1; ++i3) {
                                DSPinInfo dSPinInfo2 = (DSPinInfo)vector.get(i3);
                                if (!dSPinInfo2.a.equalsIgnoreCase(dSPinInfo.a) || !dSPinInfo2.b.equalsIgnoreCase(dSPinInfo.b) || dSPinInfo2.b != dSPinInfo.b) continue;
                                vector.remove(dSPinInfo);
                                n3 = -2;
                                break block5;
                            }
                            break;
                        }
                    }
                    if (n3 >= 6 && n3 < 100) {
                        dSPinInfo.a(vector2.get(i2).toString());
                    }
                    if (n3 >= 100) {
                        try {
                            Object object = vector2.get(i2++).toString().split(",");
                            object = new DSMediaType(Integer.parseInt(object[0].trim()), Integer.parseInt(object[1].trim()), Integer.parseInt(object[2].trim()));
                            try {
                                ((DSMediaType)object).a((byte[])vector2.get(i2));
                            }
                            catch (ClassCastException classCastException) {}
                            dSPinInfo.a((DSMediaType)object);
                        }
                        catch (Exception exception) {
                            Exception exception2 = exception;
                            exception.printStackTrace();
                        }
                    }
                    ++n3;
                    continue;
                }
                catch (Exception exception) {}
            }
            this.a = n2 == 0;
            this.b = false;
            return n2;
        }
        catch (Exception exception) {
            Exception exception3 = exception;
            exception.printStackTrace();
            return -1;
        }
    }

    native int resolveFilter(long var1, long var3, String var5, String var6, Vector var7);

    void closeQuery(boolean n2) {
        try {
            if (n2 == 0) {
                this.pinFormatMap = new int[16];
                this.pinFormatMap[0] = 16;
                return;
            }
            this.pinFormatMap = new int[(this.getDownstreamPins().length << 1) + 4];
            this.pinFormatMap[0] = this.pinFormatMap.length;
            for (n2 = 1; n2 < this.pinFormatMap.length; ++n2) {
                this.pinFormatMap[n2] = -1;
            }
            for (n2 = 0; n2 < this.getDownstreamPins().length; ++n2) {
                this.getDownstreamPins()[n2].c = n2;
            }
            if (this.getDownstreamPins().length == 1 && this.getDownstreamPins()[0].getType() == 2) {
                this.pinFormatMap[1] = 1;
            }
            return;
        }
        catch (DSJException dSJException) {
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class DSMediaFormat
    extends DSMediaType {
        private boolean a;
        float b;
        float c;
        private final DSFilterInfo a;

        DSMediaFormat(DSFilterInfo dSFilterInfo, int n2, int n3, int n4) {
            this.a = dSFilterInfo;
            super(n2, n3, n4);
            this.b = -1.0f;
            this.c = -1.0f;
        }

        DSMediaFormat(DSFilterInfo dSFilterInfo, int[] nArray) {
            this.a = dSFilterInfo;
            this.b = -1.0f;
            this.c = -1.0f;
            this.a = nArray[0];
            this.b = nArray[1];
            this.c = nArray[2];
            this.a = DSEnvironment.getMediaMajorTypeString(nArray[0]);
            this.b = (float)DSEnvironment.getMediaSubTypeString(nArray[1]);
            if (!this.a) {
                this.d = nArray[3];
                this.e = nArray[4];
                this.f = nArray[5];
                if (this.f > 0) {
                    this.a = 1000.0f / (float)this.f;
                }
                try {
                    this.i = nArray[6];
                    this.b = (float)nArray[7] / 100.0f;
                    this.c = (float)nArray[8] / 100.0f;
                    return;
                }
                catch (Exception exception) {
                    return;
                }
            }
            this.g = nArray[3];
            this.h = nArray[4];
            this.j = (nArray[5] << 3) / 1000;
            this.i = nArray[6];
        }

        public boolean isDefaultFormat() {
            return this.a;
        }

        public float[] getFrameRateRange() {
            if (this.a) {
                return null;
            }
            return new float[]{this.b, this.a.tvFormat >= 16 && this.c > 25.0f ? 25.0f : this.c};
        }

        public String getDisplayString() {
            if (this.a.equals("Video")) {
                return new String((String)this.b + ", " + this.d + " * " + this.e + ", " + this.i + " bits" + (this.a ? ", (def)" : ""));
            }
            if (this.a.equals("Audio")) {
                return new String(this.g + "ch., " + (float)this.h / 1000.0f + "khz " + this.i + "bit" + (this.a ? ", (def)" : ""));
            }
            if (!this.a.equals("unknown")) {
                return new String((String)this.a + ", " + (String)this.b + (this.a ? ", (def)" : ""));
            }
            return "DSMediaFormat - unknown major type";
        }

        static void a(DSMediaFormat dSMediaFormat) {
            v0.a = true;
        }
    }

    public class DSTVTunerInfo {
        private int a;
        private int b;
        private int c;
        private int d;
        private int e;

        DSTVTunerInfo(DSFilterInfo dSFilterInfo, int n2, int n3, int n4, int n5, int n6) {
            this.a = n2;
            this.b = n3;
            this.c = n4;
            this.d = n5;
            this.e = n6;
        }

        public String getTVFormat() {
            return DSTVTunerInfo.a(this.a);
        }

        public int getTuningSpace() {
            return this.b;
        }

        public int getCountryCode() {
            return this.c;
        }

        public int getMinChannel() {
            return this.d;
        }

        public int getMaxChannel() {
            return this.e;
        }

        private static String a(int n2) {
            String string = "unknown format";
            switch (n2) {
                case 0: {
                    string = "AnalogVideo_None";
                    break;
                }
                case 1: {
                    string = "NTSC_M";
                    break;
                }
                case 2: {
                    string = "NTSC_M_J";
                    break;
                }
                case 4: {
                    string = "NTSC_433";
                    break;
                }
                case 16: {
                    string = "PAL_B";
                    break;
                }
                case 32: {
                    string = "PAL_D";
                    break;
                }
                case 256: {
                    string = "PAL_I";
                    break;
                }
                case 512: {
                    string = "PAL_M";
                    break;
                }
                case 1024: {
                    string = "PAL_N";
                    break;
                }
                case 2048: {
                    string = "PAL_60";
                    break;
                }
                case 65536: {
                    string = "SECAM_B";
                    break;
                }
                case 131072: {
                    string = "SECAM_D";
                    break;
                }
                case 262144: {
                    string = "SECAM_G";
                    break;
                }
                case 524288: {
                    string = "SECAM_H";
                    break;
                }
                case 0x1000000: {
                    string = "SECAM_K";
                    break;
                }
                case 0x2000000: {
                    string = "SECAM_K1";
                    break;
                }
                case 0x4000000: {
                    string = "SECAM_L";
                    break;
                }
                case 134117728: {
                    string = "SECAM_L1";
                    break;
                }
                case 0x100000: {
                    string = "PAL_N_COMBO";
                }
            }
            return string;
        }

        public String toString() {
            return "TVFormat: " + DSTVTunerInfo.a(this.a) + ", TuningSpace: " + this.b + ", countryCode: " + this.c + ", min.Channel: " + this.d + ", max.Channel: " + this.e;
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class DSCrossBarInfo {
        private DSCrossBarPin[] a;
        private DSCrossBarPin[] b;
        private Vector a;
        private Vector b;

        DSCrossBarInfo(DSFilterInfo dSFilterInfo) {
        }

        public DSCrossBarPin[] getCrossBarInputs() {
            if (this.a == null) {
                return null;
            }
            if (this.a != null) {
                return this.a;
            }
            this.a = new DSCrossBarPin[this.a.size()];
            this.a.toArray(this.a);
            return this.a;
        }

        public DSCrossBarPin[] getVideoInputs() {
            int n2 = 0;
            for (int i2 = 0; i2 < this.getCrossBarInputs().length; ++i2) {
                if (DSCrossBarPin.a(this.getCrossBarInputs()[i2]).indexOf("Video") < 0) continue;
                ++n2;
            }
            DSCrossBarPin[] dSCrossBarPinArray = new DSCrossBarPin[n2];
            n2 = 0;
            for (int i3 = 0; i3 < this.getCrossBarInputs().length; ++i3) {
                if (DSCrossBarPin.a(this.getCrossBarInputs()[i3]).indexOf("Video") < 0) continue;
                dSCrossBarPinArray[n2++] = this.getCrossBarInputs()[i3];
            }
            return dSCrossBarPinArray;
        }

        public DSCrossBarPin[] getCrossBarOutputs() {
            if (this.b == null) {
                return null;
            }
            if (this.b != null) {
                return this.b;
            }
            this.b = new DSCrossBarPin[this.b.size()];
            this.b.toArray(this.b);
            return this.b;
        }

        void addInput(String stringArray) {
            if (this.a == null) {
                this.a = new Vector();
            }
            stringArray = stringArray.split(",");
            this.a.add(new DSCrossBarPin(this, 1, Integer.valueOf(stringArray[0].trim()), Integer.valueOf(stringArray[1].trim()), -1, stringArray[2].trim()));
        }

        void addOutput(String stringArray) {
            if (this.b == null) {
                this.b = new Vector();
            }
            stringArray = stringArray.split(",");
            this.b.add(new DSCrossBarPin(this, 0, Integer.valueOf(stringArray[0].trim()), Integer.valueOf(stringArray[1].trim()), Integer.valueOf(stringArray[2].trim()), stringArray[3].trim()));
        }

        /*
         * Duplicate member names - consider using --renamedupmembers true
         */
        public class DSCrossBarPin {
            private int a;
            private int b;
            private int c;
            private int d;
            private String a;

            DSCrossBarPin(DSCrossBarInfo dSCrossBarInfo, int n2, int n3, int n4, int n5, String string) {
                this.c = n2;
                this.a = n4;
                this.d = n5;
                this.b = n3;
                this.a = string;
            }

            public int getID() {
                return this.b;
            }

            public int getRelatedID() {
                return this.a;
            }

            public String getName() {
                return this.a;
            }

            public String toString() {
                return (this.c == 0 ? "out:" : " in: ") + this.a + "   " + this.b + "  related to " + this.a + "  routedTo: " + this.d;
            }

            static String a(DSCrossBarPin dSCrossBarPin) {
                return dSCrossBarPin.a;
            }
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class DSPinInfo {
        public static final int PINDIR_OUTPUT = 0;
        public static final int PINDIR_INPUT = 1;
        int a;
        int b;
        private int d;
        int c;
        String a;
        String b;
        private Vector a;
        private DSFilterInfo a;
        private DSMediaType[] a;
        private DSMediaFormat a;
        private final DSFilterInfo b;

        DSPinInfo(DSFilterInfo dSFilterInfo, DSFilterInfo dSFilterInfo2, String string, String string2, int n2, int n3, int n4) {
            this.b = dSFilterInfo;
            this.d = 0;
            this.a = dSFilterInfo2;
            this.a = string;
            this.b = string2;
            this.b = n2;
            this.c = n3;
            this.a = n4;
        }

        DSPinInfo(DSFilterInfo dSFilterInfo, DSFilterInfo dSFilterInfo2) {
            this.b = dSFilterInfo;
            this.d = 0;
            this.a = dSFilterInfo2;
        }

        final Vector a() {
            if (this.a == null) {
                this.a = new Vector();
            }
            return this.a;
        }

        public DSMediaType[] getFormats() {
            if (this.a != null) {
                return this.a;
            }
            this.a = new DSMediaType[this.a().size()];
            this.a().toArray(this.a);
            return this.a;
        }

        public void setPreferredFormat(int n2) {
            try {
                DSPinInfo dSPinInfo = this;
                dSPinInfo.a.pinFormatMap[(this.c << 1) + 4] = n2;
            }
            catch (Exception exception) {}
            this.d = n2;
        }

        public int getPreferredFormat() {
            return this.d;
        }

        public void setPreferredFrameRate(float f2) {
            DSPinInfo dSPinInfo = this;
            if (dSPinInfo.a.pinFormatMap[(this.c << 1) + 4] < 0) {
                dSPinInfo = this;
                dSPinInfo.a.pinFormatMap[(this.c << 1) + 4] = this.d;
            }
            dSPinInfo = this;
            dSPinInfo.a.pinFormatMap[(this.c << 1) + 5] = (int)f2;
        }

        public int getPreferredFrameRate() {
            return this.b.pinFormatMap[(this.c << 1) + 5];
        }

        public String getID() {
            return this.b;
        }

        public String getName() {
            if (this.a.length() == 0 || this.a.getBytes()[0] < 0) {
                return this.getID();
            }
            return this.a;
        }

        public DSMediaType getDefaultFormat() {
            return this.a;
        }

        public int getType() {
            return this.a;
        }

        public int getDirection() {
            return this.b;
        }

        final void a(DSMediaType dSMediaType) {
            if (!this.a().contains(dSMediaType)) {
                this.a().add(dSMediaType);
            }
        }

        void addFormat(int n2, int n3, int n4, byte[] byArray, int n5, int n6) {
            DSMediaFormat dSMediaFormat = new DSMediaFormat(this.b, n2, n3, n4);
            if (byArray != null) {
                dSMediaFormat.a(byArray);
            }
            if (n5 >= 0 && n6 >= 0) {
                dSMediaFormat.b = (float)n5 / 100.0f;
                dSMediaFormat.c = (float)n6 / 100.0f;
            } else if (n5 == -2) {
                for (n3 = 0; n3 < this.a().size(); ++n3) {
                    if (!dSMediaFormat.compare((DSMediaType)this.a().get(n3), 0)) continue;
                    DSMediaFormat.a((DSMediaFormat)this.a().get(n3));
                    this.a = (DSMediaFormat)this.a().get(n3);
                    this.setPreferredFormat(n3);
                    return;
                }
                DSMediaFormat.a(dSMediaFormat);
            }
            this.a().add(dSMediaFormat);
            this.a.a = true;
        }

        final void a(String stringArray) {
            if ((stringArray = stringArray.split(",")).length > 0) {
                int[] nArray = new int[stringArray.length];
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    nArray[i2] = Integer.valueOf(stringArray[i2].trim());
                }
                this.a().add(new DSMediaFormat(this.b, nArray));
            }
        }

        final DSFilterInfo a() {
            return this.a;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("PinInfo for:\n ID: ");
            stringBuffer.append(this.getID());
            stringBuffer.append(" on: ");
            DSPinInfo dSPinInfo = this;
            stringBuffer.append(dSPinInfo.a.getName());
            stringBuffer.append("\n name: ");
            stringBuffer.append(this.getName());
            stringBuffer.append("\n dir.: ");
            stringBuffer.append(this.getDirection());
            return stringBuffer.toString();
        }
    }
}

