/*
 * Decompiled with CFR 0.152.
 */
package de.humatic.dsj;

import de.humatic.dsj.DSEnvironment;
import de.humatic.dsj.DSJUtils;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class DSMediaType {
    public static final int MT_VIDEO = 0;
    public static final int MT_AUDIO = 1;
    public static final int MT_STREAM = 2;
    public static final int MT_INTERLEAVED = 3;
    public static final int MT_LINE21 = 4;
    public static final int MT_MIDI = 5;
    public static final int MT_ANALOG_VIDEO = 6;
    public static final int MT_ANALOG_AUDIO = 7;
    public static final int MT_TIMECODE = 8;
    public static final int MT_TEXT = 9;
    public static final int SST_ASF = 20;
    public static final int SST_AVI = 21;
    public static final int SST_MPEG1_SYSTEM = 40;
    public static final int SST_MPEG_PS = 124;
    public static final int SST_MPEG_TS = 125;
    public static final int SST_DV = 16;
    public static final int SST_FLV = 1024;
    public static final int SST_MKV = 1025;
    public static final int SST_WEBM = 1026;
    public static final int SST_MP4 = 1030;
    public static final int SST_WAVE = 100;
    public static final int VST_RGB4 = 0;
    public static final int VST_RGB8 = 1;
    public static final int VST_RGB565 = 2;
    public static final int VST_RGB555 = 3;
    public static final int VST_RGB24 = 4;
    public static final int VST_RGB32 = 5;
    public static final int VST_ARGB32 = 6;
    public static final int VST_AYUV = 7;
    public static final int VST_UYVY = 8;
    public static final int VST_Y411 = 9;
    public static final int VST_Y41P = 10;
    public static final int VST_Y211 = 11;
    public static final int VST_YUY2 = 12;
    public static final int VST_YVYU = 13;
    public static final int VST_YUYV = 14;
    public static final int VST_DVSL = 15;
    public static final int VST_DVSD = 16;
    public static final int VST_DVHD = 17;
    public static final int VST_DV25 = 18;
    public static final int VST_DV50 = 19;
    public static final int VST_DVH1 = 20;
    public static final int VST_I420 = 30;
    public static final int VST_MPEG1 = 44;
    public static final int VST_MPEG2 = 60;
    public static final int VST_MPEG1System = 40;
    public static final int VST_MPEG1VideoCD = 41;
    public static final int VST_MPEG1Packet = 42;
    public static final int MPEG1Payload = 43;
    public static final int MPEG1Video = 44;
    public static final int MPEG1Audio = 45;
    public static final int MPEG1AudioPayload = 46;
    public static final int VST_MPEG2_VIDEO = 60;
    public static final int VST_IMP2 = 844123465;
    public static final int VST_FORMAT_MPEG2Video = 120;
    public static final int ATSC_SI = 121;
    public static final int DVB_SI = 122;
    public static final int VST_MPEG2_PROGRAM = 124;
    public static final int VST_MPEG2_TRANSPORT = 125;
    public static final int VST_MPEG2_SECTIONS = 126;
    public static final int VST_MPEG2_PES = 127;
    public static final int VST_MP4V = 130;
    public static final int VST_ASF = 149;
    public static final int VST_OGG = 250;
    public static final int VST_THEORA = 251;
    public static final int VST_3IVX = 260;
    public static final int VST_RV40 = 265;
    public static final int VST_XVIDMKV = 266;
    public static final int VST_FLV = 267;
    public static final int VST_VP8 = 808996950;
    public static final int QTV = -2;
    public static final int AST_PCM = 100;
    public static final int AST_MP2A = 62;
    public static final int AST_MPEG1_AUDIO_PAYLOAD = 80;
    public static final int AST_MP3 = 85;
    public static final int AST_GSM = 49;
    public static final int AST_MPEG1Packet = 102;
    public static final int AST_MPEG1Payload = 103;
    public static final int AST_MPEG2_AUDIO = 104;
    public static final int AST_DVD_LPCM_AUDIO = 105;
    public static final int AST_DRM_Audio = 107;
    public static final int AST_IEEE_FLOAT = 108;
    public static final int AST_DOLBY_AC3 = 109;
    public static final int AST_DOLBY_AC3_SPDIF = 110;
    public static final int AST_RAW_SPORT = 111;
    public static final int AST_SPDIF_TAG_241h = 112;
    public static final int AST_MPEG1 = 103;
    public static final int AST_WF_MPEG1 = 46;
    public static final int AST_MPEG2 = 104;
    public static final int AST_AAC = 255;
    public static final int AST_MP4A = 256;
    public static final int AST_AMR = 1919770995;
    public static final int AST_ASF = 149;
    public static final int AST_REAL = 270;
    public static final int AST_AC3 = 8192;
    public static final int AST_VORBIS = -1926246133;
    public static final int AST_VORBIS_ENC = -1979357524;
    public static final int AST_VORBIS_LEAD = -841178411;
    public static final int QTA = -2;
    public static final int VIDEO_INFO = 0;
    public static final int VIDEO_INFO2 = 1;
    public static final int MPEG_VIDEO_INFO = 2;
    public static final int MPEG2_VIDEO_INFO = 3;
    public static final int WAVEFORMAT = 0;
    public static final int MPEG1WAVEFORMAT = 2;
    public static final int VORBISFORMAT = -1284632449;
    public static final int NONE = 5;
    public static final int WMFORMAT_MPEG2Video = 150;
    public static final int WMFORMAT_Script = 151;
    public static final int WMFORMAT_VideoInfo = 152;
    public static final int WMFORMAT_WaveFormatEx = 153;
    public static final int WMFORMAT_WebStream = 154;
    public static final int WMMEDIASUBTYPE_ACELPnet = 155;
    public static final int WMMEDIASUBTYPE_Base = 156;
    public static final int WMMEDIASUBTYPE_DRM = 157;
    public static final int WMMEDIASUBTYPE_MP3 = 158;
    public static final int WMMEDIASUBTYPE_MP43 = 159;
    public static final int WMMEDIASUBTYPE_MP4S = 160;
    public static final int WMMEDIASUBTYPE_M4S2 = 161;
    public static final int WMMEDIASUBTYPE_P422 = 162;
    public static final int WMMEDIASUBTYPE_MPEG2_VIDEO = 163;
    public static final int WMMEDIASUBTYPE_MSS1 = 164;
    public static final int WMMEDIASUBTYPE_MSS2 = 165;
    public static final int WMMEDIASUBTYPE_PCM = 166;
    public static final int WMMEDIASUBTYPE_WebStream = 167;
    public static final int WMMEDIASUBTYPE_WMAudio_Lossless = 168;
    public static final int WMMEDIASUBTYPE_WMAudioV2 = 169;
    public static final int WMMEDIASUBTYPE_WMAudioV7 = 170;
    public static final int WMMEDIASUBTYPE_WMAudioV8 = 171;
    public static final int WMMEDIASUBTYPE_WMAudioV9 = 172;
    public static final int WMMEDIASUBTYPE_WMSP1 = 173;
    public static final int WMMEDIASUBTYPE_WMV1 = 174;
    public static final int WMMEDIASUBTYPE_WMV2 = 175;
    public static final int WMMEDIASUBTYPE_WMV3 = 176;
    public static final int WMMEDIASUBTYPE_WMVA = 177;
    public static final int WMMEDIASUBTYPE_WMVP = 178;
    public static final int WMMEDIASUBTYPE_WVP2 = 179;
    public static final int WMMEDIATYPE_Audio = 180;
    public static final int WMMEDIATYPE_FileTransfer = 181;
    public static final int WMMEDIATYPE_Image = 182;
    public static final int WMMEDIATYPE_Script = 183;
    public static final int WMMEDIATYPE_Text = 184;
    public static final int WMMEDIATYPE_Video = 185;
    public static final int WMSCRIPTTYPE_TwoStrings = 186;
    public static final int GUID_NULL = -1;
    public static final int VX_BIT_ERROR_RATE = 8;
    public static final int VX_INTERLACE = 9;
    public static final int VX_COPY_PROTECT = 10;
    public static final int VX_ASPECT_X = 11;
    public static final int VX_ASPECT_Y = 12;
    public static final int VX_CTRL = 13;
    public static final int VX_PROFILE = 14;
    public static final int VX_LEVEL = 15;
    public static final int VX_FLAGS = 16;
    public static final int AX_FORMAT_TAG = 18;
    public static final int AX_BLOCK_ALIGN = 23;
    public static final int AX_CH_MASK = 24;
    public static final int AX_SUBFORMAT = 25;
    public static final int AX_SPB = 26;
    public static final int AX_VBPS = 27;
    private int[] a;
    private String[] a;
    String a;
    String b;
    private String c;
    int a;
    int b;
    int c;
    int d;
    int e;
    int f;
    int g;
    int h;
    int i;
    int j = -1;
    private int k = -1;
    private int l;
    private int m;
    float a;
    private byte[] a = 25.0f;

    public DSMediaType() {
    }

    public DSMediaType(int n2, int n3, int n4) {
        this.a = n2;
        this.b = n3;
        this.c = n4;
        this.a = DSEnvironment.getMediaMajorTypeString(n2);
        this.b = DSEnvironment.getMediaSubTypeString(n3);
        this.c = DSEnvironment.b(n2, n4);
    }

    public DSMediaType copy() {
        DSMediaType dSMediaType = new DSMediaType(this.a, this.b, this.c);
        if (this.a != 1) {
            dSMediaType.setWidth(this.d);
            dSMediaType.setHeight(this.e);
            dSMediaType.setBitRate(this.getBitRate());
            dSMediaType.setBitDepth(this.i == 0 ? 24 : this.i);
        } else {
            dSMediaType.setNumChannels(this.g);
            dSMediaType.setSampleRate(this.h);
            dSMediaType.setBitRate(this.getBitRate());
            dSMediaType.setBitDepth(this.i);
        }
        dSMediaType.setFrameTime(this.f);
        dSMediaType.setFrameRate(this.a);
        dSMediaType.setDataSize(this.k);
        dSMediaType.setFlags(this.m);
        try {
            byte[] byArray = new byte[this.getFormatBlock().length];
            System.arraycopy(this.getFormatBlock(), 0, byArray, 0, this.getFormatBlock().length);
            dSMediaType.setFormatBlock(byArray);
        }
        catch (Exception exception) {}
        return dSMediaType;
    }

    public boolean compare(DSMediaType dSMediaType, int n2) {
        if (this.a != dSMediaType.a || this.b != dSMediaType.b || this.c != dSMediaType.c) {
            return false;
        }
        if (this.a != 1) {
            if (dSMediaType.getWidth() != this.getWidth()) {
                return false;
            }
            if (dSMediaType.getHeight() != this.getHeight()) {
                return false;
            }
            if (dSMediaType.getBitDepth() != this.getBitDepth()) {
                return false;
            }
            if (dSMediaType.getFrameTime() != this.getFrameTime()) {
                return false;
            }
        } else {
            if (dSMediaType.getNumChannels() != this.getNumChannels()) {
                return false;
            }
            if (dSMediaType.getSampleRate() != this.getSampleRate()) {
                return false;
            }
            if (dSMediaType.getBitRate() != this.getBitRate()) {
                return false;
            }
            if (dSMediaType.getBitDepth() != this.getBitDepth()) {
                return false;
            }
        }
        if (n2 == 0) {
            return true;
        }
        if (dSMediaType.getFrameRate() != this.getFrameRate()) {
            return false;
        }
        if (dSMediaType.getDataSize() != this.getDataSize()) {
            return false;
        }
        if (dSMediaType.getFlags() != this.getFlags()) {
            return false;
        }
        if (n2 == 1) {
            return true;
        }
        return true;
    }

    static DSMediaType a(String stringArray) {
        stringArray = stringArray.split(",");
        DSMediaType dSMediaType = new DSMediaType(1, 0, 0);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            try {
                if (stringArray[i2].toLowerCase().indexOf("hz") != -1) {
                    dSMediaType.setSampleRate(Integer.valueOf(stringArray[i2].trim().substring(0, stringArray[i2].trim().indexOf(" ")).trim()));
                    continue;
                }
                if (stringArray[i2].toLowerCase().indexOf("bits") != -1) {
                    dSMediaType.setSampleSize(Integer.valueOf(stringArray[i2].trim().substring(0, stringArray[i2].trim().indexOf(" ")).trim()));
                    continue;
                }
                if (stringArray[i2].toLowerCase().indexOf("ch") != -1) {
                    dSMediaType.setNumChannels(Integer.valueOf(stringArray[i2].trim().substring(0, stringArray[i2].trim().indexOf(" ")).trim()));
                    continue;
                }
                if (stringArray[i2].toLowerCase().indexOf("bps") == -1) continue;
                dSMediaType.setBitRate(Integer.valueOf(stringArray[i2].trim().substring(0, stringArray[i2].trim().indexOf(" ")).trim()));
                continue;
            }
            catch (Exception exception) {}
        }
        return dSMediaType;
    }

    public String getMajorTypeString() {
        return this.a;
    }

    public String getSubTypeString() {
        if (this.a != 1 || this.b <= 2 || this.b >= 80) {
            return this.b;
        }
        return DSEnvironment.a(this.b);
    }

    public int getMajorType() {
        return this.a;
    }

    public int getSubType() {
        if (this.a != 1 || this.b <= 2 || this.b >= 80) {
            return this.b;
        }
        return DSEnvironment.a(this.b);
    }

    public int getFormatType() {
        return this.c;
    }

    public void setMajorType(int n2) {
        this.a = n2;
        this.a = DSEnvironment.getMediaMajorTypeString(this.a);
    }

    public void setSubType(int n2) {
        this.b = n2;
        this.b = DSEnvironment.getMediaSubTypeString(this.b);
    }

    public void setFormatType(int n2) {
        this.c = n2;
        this.c = DSEnvironment.b(this.a, this.c);
    }

    public int getWidth() {
        return this.d;
    }

    public void setWidth(int n2) {
        this.d = n2;
    }

    public int getHeight() {
        return this.e;
    }

    public void setHeight(int n2) {
        this.e = n2;
    }

    public int getBitDepth() {
        if (this.a == 1 && this.b == 255 && this.i < 0) {
            return 16;
        }
        return this.i;
    }

    public void setBitDepth(int n2) {
        this.i = n2;
    }

    public int getSampleSize() {
        return this.i;
    }

    public void setSampleSize(int n2) {
        this.i = n2;
    }

    public int getBitRate() {
        return this.j;
    }

    public void setBitRate(int n2) {
        this.j = n2;
    }

    public float getFrameRate() {
        return this.a;
    }

    public void setFrameRate(float f2) {
        this.a = f2;
        if (this.getMajorType() != 1 && this.f <= 0) {
            this.f = (int)(1000.0f / f2);
        }
    }

    public int getFrameTime() {
        if (this.f == 0) {
            if (this.a == 1) {
                if (this.b == 255) {
                    return 23;
                }
                return 27;
            }
            return 40;
        }
        return this.f;
    }

    public void setFrameTime(int n2) {
        this.f = n2;
        if (this.getMajorType() == 0 && this.a <= 0.0f || this.a == 25.0f) {
            this.a = 1000.0f / (float)n2;
        }
    }

    public int getNumChannels() {
        return this.g;
    }

    public void setNumChannels(int n2) {
        this.g = n2;
    }

    public int getSampleRate() {
        return this.h;
    }

    public void setSampleRate(int n2) {
        this.h = n2;
    }

    public void setFlags(int n2) {
        this.m = n2;
    }

    public int getFlags() {
        return this.m;
    }

    public String toString() {
        if (this.a.equals("Video")) {
            return new String(this.a + ", " + this.getSubTypeString() + ", width: " + this.d + ", height: " + this.e + ", bitDepth: " + this.getBitDepth() + ", fps: " + this.a);
        }
        if (this.a.equals("Audio")) {
            return new String(this.a + ", " + this.getSubTypeString() + ", ch.: " + this.g + ", hz: " + this.h + ", bits: " + this.getBitDepth() + ". bps: " + this.getBitRate());
        }
        if (!this.a.equals("unknown")) {
            return new String(this.a + ", " + this.getSubTypeString());
        }
        return "DSMediaType - unknown major type";
    }

    public String getDisplayString() {
        if (this.a.equals("Video")) {
            return new String(this.b + ", " + this.d + " * " + this.e + ", " + this.i + " bits" + "");
        }
        if (this.a.equals("Audio")) {
            return new String(this.g + "ch., " + (float)this.h / 1000.0f + "khz, " + (this.i > 0 ? this.i + "bit, " : "") + (this.j > 0 ? this.j + "bps, " : "") + "");
        }
        if (!this.a.equals("unknown")) {
            return new String(this.a + ", " + this.b + "");
        }
        return "DSMediaType - unknown major type";
    }

    public String dump() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("MajorType: " + this.a + "\n");
        stringBuffer.append("SubType: " + this.getSubTypeString() + "\n");
        stringBuffer.append("FormatType: " + this.c + "\n");
        if (this.a == 0) {
            stringBuffer.append("Width: " + this.getWidth() + "\n");
            stringBuffer.append("Height: " + this.getHeight() + "\n");
            if (this.getBitDepth() > 0) {
                stringBuffer.append("BitDepth: " + this.getBitDepth() + "\n");
            }
            stringBuffer.append("FrameRate: " + this.getFrameRate() + "\n");
            if (this.getBitRate() > 0) {
                stringBuffer.append("BitRate: " + this.getBitRate() + "\n");
            }
        } else if (this.a == 1) {
            stringBuffer.append("SampleRate: " + this.getSampleRate() + "\n");
            stringBuffer.append("Channels: " + this.getNumChannels() + "\n");
            if (this.getBitDepth() > 0) {
                stringBuffer.append("BitDepth: " + this.getBitDepth() + "\n");
            }
            if (this.getBitRate() > 0) {
                stringBuffer.append("BitRate: " + this.getBitRate() + "\n");
            }
        } else if ((this.a == 2 || this.a == 3) && this.c >= 1) {
            stringBuffer.append("Width: " + this.getWidth() + "\n");
            stringBuffer.append("Height: " + this.getHeight() + "\n");
            if (this.getBitDepth() > 0) {
                stringBuffer.append("BitDepth: " + this.getBitDepth() + "\n");
            }
            stringBuffer.append("FrameRate: " + this.getFrameRate() + "\n");
            if (this.getBitRate() > 0) {
                stringBuffer.append("BitRate: " + this.getBitRate() + "\n");
            }
        }
        for (int i2 = 8; i2 < 27; ++i2) {
            if (this.getExtendedField(i2) == 0) continue;
            stringBuffer.append(this.a[i2] + ": " + this.getExtendedField(i2) + "\n");
        }
        if (this.getFormatBlockSize() > 0) {
            try {
                PrintStream printStream = DSJUtils.a();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DSJUtils.a(new PrintStream(byteArrayOutputStream));
                DSJUtils.dump("format block: ", this.getFormatBlock());
                stringBuffer.append(new String(byteArrayOutputStream.toByteArray()));
                DSJUtils.a(printStream);
            }
            catch (Exception exception) {}
        }
        return stringBuffer.toString();
    }

    public void configureVideoType(int n2, int n3, int n4, float f2) {
        if (this.a == 1) {
            return;
        }
        this.e = n3;
        this.d = n2;
        this.i = n4 < 0 ? 24 : n4;
        this.a = f2 <= 0.0f ? 25.0f : f2;
        this.f = (int)(1000.0f / f2);
    }

    public void configureAudioType(int n2, int n3, int n4, int n5) {
        if (this.a != 1) {
            return;
        }
        this.h = n2;
        this.i = n3;
        this.g = n4;
        this.j = n5;
    }

    public void setDataSize(int n2) {
        this.k = n2;
    }

    public int getDataSize() {
        if (this.a == 0 && this.b <= 20) {
            return this.d * this.e * this.i;
        }
        return this.k;
    }

    public void setFormatBlock(byte[] byArray) {
        this.a = byArray;
        this.l = byArray.length;
    }

    public int getFormatBlockSize() {
        return this.l;
    }

    public byte[] getFormatBlock() {
        if (this.a != null) {
            return this.a;
        }
        return new byte[22];
    }

    public void setExtendedField(int n2, int n3) {
        this.a[n2] = n3;
    }

    public int getExtendedField(int n2) {
        if (n2 < 0 || n2 > this.a.length) {
            return -1;
        }
        return this.a[n2];
    }

    int[] toIntArray() {
        int[] nArray = new int[12];
        int[] nArray2 = nArray;
        nArray[0] = this.a;
        nArray2[1] = this.b;
        nArray2[2] = this.getFormatType();
        switch (this.a) {
            case 0: 
            case 2: {
                nArray2[3] = this.getWidth();
                nArray2[4] = this.getHeight();
                nArray2[5] = this.getBitDepth();
                nArray2[6] = this.f == 0 ? (int)(1000.0f / this.getFrameRate()) : this.f;
                nArray2[7] = this.getDataSize();
                nArray2[8] = this.getBitRate();
                nArray2[9] = (int)(this.getFrameRate() * 100.0f);
                break;
            }
            case 1: {
                nArray2[3] = this.getSampleRate();
                nArray2[4] = this.getNumChannels();
                nArray2[5] = this.getBitDepth() < 0 ? 16 : this.getBitDepth();
                nArray2[6] = this.getFrameTime();
                nArray2[7] = this.getDataSize() <= 0 ? this.getSampleRate() : this.getDataSize();
                nArray2[8] = this.getBitRate();
            }
        }
        nArray2[10] = this.l;
        nArray2[11] = this.getFormatType() == 1 || this.getFormatType() == 3 ? this.getExtendedField(9) << 4 | this.getFlags() : this.getFlags();
        return nArray2;
    }

    public void dumpFormatBlock(boolean bl) {
        if (this.a == null) {
            return;
        }
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            if (bl) {
                System.out.print(Long.toHexString(this.a[i2] & 0xFF) + " ");
            } else {
                System.out.print(this.a[i2] + " ");
            }
            if ((i2 + 1) % 8 != 0) continue;
            System.out.println();
        }
    }

    final void a(byte[] byArray) {
        int n2;
        int n3;
        block23: {
            n3 = 0;
            n2 = 0;
            try {
                if (this.getMajorType() == 0 || this.getMajorType() == 2 || this.getMajorType() == 3) {
                    long l2 = 400000L;
                    try {
                        l2 = DSJUtils.readLong_LE(byArray, 40);
                        if (l2 <= 255L && l2 > 0L) {
                            l2 = (int)(1.0E7f / (float)l2);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    switch (this.getFormatType()) {
                        case 0: 
                        case 2: {
                            this.setWidth(DSJUtils.readInt_LE(byArray, 52));
                            this.setHeight(DSJUtils.readInt_LE(byArray, 56));
                            this.setBitRate(DSJUtils.readInt_LE(byArray, 32));
                            this.setFrameTime((int)((float)l2 / 10000.0f));
                            this.setFrameRate(1000.0f / ((float)l2 / 10000.0f));
                            this.setBitDepth(DSJUtils.readShort_LE(byArray, 62));
                            this.setExtendedField(8, DSJUtils.readInt_LE(byArray, 36));
                            n3 = byArray.length - 88;
                            n2 = 88;
                            break block23;
                        }
                        case 1: {
                            this.setWidth(DSJUtils.readInt_LE(byArray, 76));
                            this.setHeight(DSJUtils.readInt_LE(byArray, 80));
                            this.setBitDepth(DSJUtils.readShort_LE(byArray, 86));
                            this.setBitRate(DSJUtils.readInt_LE(byArray, 32));
                            this.setExtendedField(8, DSJUtils.readInt_LE(byArray, 36));
                            this.setFrameTime((int)((float)l2 / 10000.0f));
                            this.setFrameRate(1000.0f / ((float)l2 / 10000.0f));
                            this.setExtendedField(8, DSJUtils.readInt_LE(byArray, 36));
                            this.setExtendedField(9, DSJUtils.readInt_LE(byArray, 48));
                            this.setExtendedField(10, DSJUtils.readInt_LE(byArray, 52));
                            this.setExtendedField(11, DSJUtils.readInt_LE(byArray, 56));
                            this.setExtendedField(12, DSJUtils.readInt_LE(byArray, 60));
                            this.setExtendedField(13, DSJUtils.readInt_LE(byArray, 64));
                            n3 = byArray.length - 112;
                            n2 = 112;
                            break block23;
                        }
                        case 3: {
                            this.setWidth(DSJUtils.readInt_LE(byArray, 76));
                            this.setHeight(DSJUtils.readInt_LE(byArray, 80));
                            this.setBitDepth(DSJUtils.readShort_LE(byArray, 86));
                            this.setBitRate(DSJUtils.readInt_LE(byArray, 32));
                            this.setFrameTime((int)((float)l2 / 10000.0f));
                            this.setFrameRate(1000.0f / ((float)l2 / 10000.0f));
                            this.setExtendedField(8, DSJUtils.readInt_LE(byArray, 36));
                            this.setExtendedField(9, DSJUtils.readInt_LE(byArray, 48));
                            this.setExtendedField(10, DSJUtils.readInt_LE(byArray, 52));
                            this.setExtendedField(11, DSJUtils.readInt_LE(byArray, 56));
                            this.setExtendedField(12, DSJUtils.readInt_LE(byArray, 60));
                            this.setExtendedField(13, DSJUtils.readInt_LE(byArray, 64));
                            this.setExtendedField(14, DSJUtils.readInt_LE(byArray, 120));
                            this.setExtendedField(15, DSJUtils.readInt_LE(byArray, 124));
                            this.setExtendedField(16, DSJUtils.readInt_LE(byArray, 128));
                            n3 = DSJUtils.readInt_LE(byArray, 116);
                            n2 = 132;
                            if (!DSJUtils.MPEGStart(byArray, 132)) {
                                DSJUtils.MPEGStart(byArray, 133);
                            }
                            if (this.getExtendedField(14) == 0) {
                                int n4 = 128;
                                while (n4 < byArray.length - 4 && !DSJUtils.MPEGStart(byArray, n4++)) {
                                }
                                if (n4 < byArray.length - 4 && (byArray[n4 += 2] & 0xF) == 7) {
                                    this.setExtendedField(14, byArray[n4 + 1]);
                                    this.setExtendedField(15, byArray[n4 + 3]);
                                } else {
                                    break;
                                }
                            } else {
                                break;
                            }
                        }
                    }
                    break block23;
                }
                if (this.getMajorType() == 1) {
                    if (this.c == 1155551043) {
                        this.setNumChannels(DSJUtils.readInt_LE(byArray, 20));
                        this.setSampleRate(DSJUtils.readInt_LE(byArray, 4));
                    }
                    if (this.c == 1809709694) {
                        this.setNumChannels(DSJUtils.readInt_LE(byArray, 0));
                        this.setSampleRate(DSJUtils.readInt_LE(byArray, 4));
                    } else {
                        this.setNumChannels(DSJUtils.readShort_LE(byArray, 2));
                        this.setSampleRate(DSJUtils.readInt_LE(byArray, 4));
                        this.setBitRate(DSJUtils.readInt_LE(byArray, 8) << 3);
                        this.setBitDepth(DSJUtils.readShort_LE(byArray, 14));
                        this.setExtendedField(18, DSJUtils.readShort_LE(byArray, 0));
                        this.setExtendedField(23, DSJUtils.readShort_LE(byArray, 12));
                        n3 = DSJUtils.readShort_LE(byArray, 16);
                        n2 = 18;
                        if (n3 >= 22) {
                            this.setExtendedField(24, DSJUtils.readShort_LE(byArray, 22));
                            this.setExtendedField(25, DSJUtils.readInt_LE(byArray, 28));
                            this.setExtendedField(26, DSJUtils.readShort_LE(byArray, 24));
                            this.setExtendedField(27, DSJUtils.readShort_LE(byArray, 26));
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (n3 > 0 && n3 < byArray.length) {
            int n5 = this.getMajorType() == 1 ? 0 : 16;
            byte[] byArray2 = new byte[n3 + n5];
            try {
                System.arraycopy(byArray, n2, byArray2, n5, n3);
                this.setFormatBlock(byArray2);
                return;
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                exception.printStackTrace();
            }
        }
    }
}

