/*
 * Decompiled with CFR 0.152.
 */
package de.humatic.dsj.sink;

import de.humatic.dsj.DSEnvironment;
import de.humatic.dsj.DSFilterInfo;
import de.humatic.dsj.DSFiltergraph;
import de.humatic.dsj.sink.Sink;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NetworkSink
extends Sink {
    DSFiltergraph dsfg;
    String localAddress;
    String pushServerURL;
    String userName;
    String passWord;
    int maxClients = 5;
    int port;
    DSFilterInfo wmProfile;
    public static final int WM_NET = 0;
    public static final int WM_PUSH = 1;
    public static final int DSHOW = 2;

    public NetworkSink(int n2) {
        this.majorType = n2;
    }

    public void start() {
    }

    public void close() {
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public int getPort() {
        return this.port;
    }

    public static NetworkSink fromXML(String object, String string) {
        Node node = null;
        Object object2 = DSEnvironment.getXMLSetup().getDocumentElement().getElementsByTagName("modules").item(0);
        object2 = ((Element)object2).getElementsByTagName("sinkmodules").item(0);
        object2 = ((Element)object2).getElementsByTagName("module");
        for (int i2 = 0; i2 < object2.getLength(); ++i2) {
            if (!((Element)object2.item(i2)).getAttribute("name").equalsIgnoreCase((String)object)) continue;
            node = object2.item(i2);
            break;
        }
        if (node == null) {
            return null;
        }
        NetworkSink networkSink = new NetworkSink(1);
        new NetworkSink(1).path = string;
        networkSink.subType = 1;
        object = ((Element)node).getElementsByTagName("audioencoder").item(0);
        if (object != null) {
            networkSink.setAudioEncoder(DSFilterInfo.filterInfoForCLSID(((Element)object).getAttribute("clsid")));
        }
        if ((object = ((Element)node).getElementsByTagName("videoencoder").item(0)) != null) {
            networkSink.setVideoEncoder(DSFilterInfo.filterInfoForCLSID(((Element)object).getAttribute("clsid")));
        }
        if ((object = ((Element)node).getElementsByTagName("muxer").item(0)) != null) {
            networkSink.setMultiplexer(DSFilterInfo.filterInfoForCLSID(((Element)object).getAttribute("clsid")));
        }
        if ((object = ((Element)node).getElementsByTagName("filewriter").item(0)) != null) {
            networkSink.setStreamWriter(DSFilterInfo.filterInfoForCLSID(((Element)object).getAttribute("clsid")));
        }
        return networkSink;
    }

    public void setStreamWriter(DSFilterInfo dSFilterInfo) {
        this.writer = dSFilterInfo == null ? DSFilterInfo.doNotRender() : dSFilterInfo;
    }

    public DSFilterInfo getStreamWriterInfo() {
        return this.writer;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("NetworkSink: ");
        stringBuffer.append(this.path);
        stringBuffer.append("\n");
        try {
            stringBuffer.append(this.audioEncoder.getName());
            stringBuffer.append("\n");
        }
        catch (NullPointerException nullPointerException) {}
        try {
            stringBuffer.append(this.videoEncoder.getName());
            stringBuffer.append("\n");
        }
        catch (NullPointerException nullPointerException) {}
        try {
            stringBuffer.append(this.muxer.getName());
            stringBuffer.append("\n");
        }
        catch (NullPointerException nullPointerException) {}
        try {
            stringBuffer.append(this.writer.getName());
        }
        catch (NullPointerException nullPointerException) {}
        return stringBuffer.toString();
    }
}

