/*
 * Decompiled with CFR 0.152.
 */
package de.humatic.dsj.xml;

import de.humatic.dsj.DSJException;
import de.humatic.dsj.DSJUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class XMLUtils {
    private static int a = 0;

    public static String getAttValue(Element element, String string) {
        try {
            return element.getAttribute(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean getAttValue_bool(Element element, String string) {
        try {
            return new Boolean(element.getAttribute(string));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static byte getAttValue_byte(Element element, String string) {
        try {
            return new Byte(element.getAttribute(string));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static int getAttValue_int(Element element, String string) {
        try {
            return new Integer(element.getAttribute(string));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static float getAttValue_float(Element element, String string) {
        try {
            return new Float(element.getAttribute(string)).floatValue();
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }

    public static int[] getAttValue_intArray(Element element, String string, int n2) {
        int[] nArray = null;
        try {
            String[] stringArray = element.getAttribute(string).split(",");
            if (element.getAttribute(string).length() == 0 | stringArray.length == 0) {
                return new int[n2];
            }
            nArray = new int[stringArray.length];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                try {
                    nArray[i2] = new Integer(stringArray[i2]);
                    continue;
                }
                catch (Exception exception) {
                    nArray[i2] = 0;
                }
            }
        }
        catch (Exception exception) {
            return new int[n2];
        }
        return nArray;
    }

    public static Element createElement(Node node, String object) {
        object = node.getOwnerDocument().createElement((String)object);
        node.appendChild((Node)object);
        return object;
    }

    public static Element createElement(Document node, Node node2, String string) {
        node = node.createElement(string);
        node2.appendChild(node);
        return node;
    }

    public static Element createElement(Node node, String string, int n2) {
        node = XMLUtils.createElement(node.getOwnerDocument(), node, string);
        if (n2 != -1) {
            node.setAttribute("id", String.valueOf(n2));
        }
        return node;
    }

    public static Element getElement(Node node, String string, int n2, boolean bl) {
        NodeList nodeList = ((Element)node).getElementsByTagName(string);
        Element element = null;
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            element = (Element)nodeList.item(i2);
            if (n2 != -1 && Integer.valueOf(element.getAttribute("id")) != n2) continue;
            return element;
        }
        if (!bl) {
            return null;
        }
        Element element2 = XMLUtils.createElement(node.getOwnerDocument(), node, string);
        if (n2 != -1) {
            element2.setAttribute("id", String.valueOf(n2));
        }
        return element2;
    }

    public static Element getElementByName(Node node, String string, String string2, boolean bl) {
        NodeList nodeList = ((Element)node).getElementsByTagName(string);
        Element element = null;
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            element = (Element)nodeList.item(i2);
            if (string2 != null && !element.getAttribute("name").equalsIgnoreCase(string2)) continue;
            return element;
        }
        if (!bl) {
            return null;
        }
        Element element2 = XMLUtils.createElement(node.getOwnerDocument(), node, string);
        if (string != null) {
            element2.setAttribute("name", string2);
        }
        return element2;
    }

    public static void removeElement(Node node, String string, int n2, boolean bl) {
        NodeList nodeList = ((Element)node).getElementsByTagName(string);
        Element element = null;
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            element = (Element)nodeList.item(i2);
            if (n2 != -1 && Integer.valueOf(element.getAttribute("id")) != n2) continue;
            node.removeChild(element);
            break;
        }
        if (bl && ((Element)node).getElementsByTagName(string).getLength() > 0) {
            node.getParentNode().removeChild(node);
        }
    }

    public static void copyNode(Node node, boolean bl) {
        Element element = (Element)node.cloneNode(true);
        node.getParentNode().insertBefore(element, bl ? null : node.getNextSibling());
    }

    public static Node getContainerNode(Node node, String string, boolean bl) {
        Node node2 = ((Element)node).getElementsByTagName(string).item(0);
        if (!bl) {
            return node2;
        }
        if (node2 != null) {
            return node2;
        }
        return XMLUtils.createElement(node, string);
    }

    public Node getSubNode(Document object, String stringArray, int n2) {
        int n3;
        Object object2 = null;
        stringArray = stringArray.split("/");
        Node node = null;
        Node node2 = null;
        try {
            object2 = object.getElementsByTagName(stringArray[0]);
            node2 = (Element)object2.item(0);
            for (n3 = 1; n3 < stringArray.length; ++n3) {
                if (node2.getElementsByTagName(stringArray[n3]).getLength() == 0) {
                    return XMLUtils.createElement(node2, stringArray[n3], n2);
                }
                object2 = node2.getElementsByTagName(stringArray[n3]);
                node2 = (Element)object2.item(0);
            }
            for (int i2 = 0; i2 < object2.getLength(); ++i2) {
                node2 = (Element)object2.item(i2);
                try {
                    if (n2 < 0 || new Integer(node2.getAttribute("id")) != n2) continue;
                    node = object2.item(i2);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    return object2.item(0);
                }
            }
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        try {
            if (node == null) {
                node = XMLUtils.createElement(node2.getParentNode(), stringArray[n3 - 1], n2);
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return node;
    }

    public static void removeAtPath(Node node, String stringArray, int n2) {
        try {
            stringArray = stringArray.split("/");
            Node node2 = null;
            if (n2 < 0) {
                node2 = node;
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    node2 = XMLUtils.getContainerNode(node2, stringArray[i2], false);
                }
            } else {
                for (int i3 = 0; i3 < stringArray.length - 1; ++i3) {
                    node = XMLUtils.getContainerNode(node, stringArray[i3], true);
                }
                NodeList nodeList = ((Element)node).getElementsByTagName(stringArray[stringArray.length - 1]);
                for (int i4 = 0; i4 < nodeList.getLength(); ++i4) {
                    if (XMLUtils.getAttValue_int((Element)nodeList.item(i4), "id") != n2) continue;
                    node2 = nodeList.item(i4);
                    break;
                }
            }
            if (node2 != null) {
                node2.getParentNode().removeChild(node2);
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static Document getXMLSetup(String object) {
        try {
            if (!new URL((String)object).getProtocol().substring(0, 4).equalsIgnoreCase("file")) {
                return XMLUtils.a((String)object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            File file = new File((String)object);
            if (!file.exists() && ((String)object).equalsIgnoreCase("dsj.xml")) {
                file = new File(System.getProperty("user.home"), "dsj.xml");
                object = System.getProperty("user.home") + File.separator + "dsj.xml";
            }
            if (!file.exists()) {
                String string = "/";
                if (((String)object).indexOf(string) < 0) {
                    string = File.separator;
                }
                if (((String)object).indexOf(string) > 0) {
                    object = new File(((String)object).substring(0, ((String)object).lastIndexOf(string)));
                    ((File)object).mkdirs();
                }
                file.createNewFile();
                object = new FileOutputStream(file);
                string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<dsj>\n   <DSMovie/>\n   <DSDvd/>\n   <DSDVCam/>\n   <DSCapture/>\n   <DSGraph/>\n   <DSBDAGraph>\n      <channellist file=\"\"/>\n   </DSBDAGraph>\n   <DSStreamBufferGraph/>\n   <DSHDVTape/>\n   <preferences/>\n</dsj>";
                ((FileOutputStream)object).write(string.getBytes());
                ((OutputStream)object).flush();
                ((FileOutputStream)object).close();
            }
            return XMLUtils.buildDocument(file);
        }
        catch (Exception exception) {
            return XMLUtils.getXMLSetup(System.getProperty("user.home"));
        }
    }

    public static Document buildDocument(File object) {
        try {
            if (((File)object).getName().indexOf("dsj.xml") != -1 && a++ <= 1) {
                DSJUtils.logln(5, "loading setup from: " + ((File)object).getAbsolutePath());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object object2 = null;
        object2 = null;
        Document document = null;
        try {
            object2 = DocumentBuilderFactory.newInstance();
            object2 = ((DocumentBuilderFactory)object2).newDocumentBuilder();
            document = ((DocumentBuilder)object2).parse((File)object);
        }
        catch (SAXParseException sAXParseException) {
            if (((File)object).getName().indexOf(".xgr") != -1) {
                return null;
            }
            object = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<dsj>\n   <DSMovie/>\n   <DSDvd/>\n   <DSDVCam />\n   <DSCapture/>\n   <DSGraph/>\n   <DSBDAGraph>\n      <channellist file=\"\"/>\n   </DSBDAGraph>\n   <DSStreamBufferGraph/>\n   <DSHDVTape/>\n</dsj>";
            document = XMLUtils.buildDocument("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<dsj>\n   <DSMovie/>\n   <DSDvd/>\n   <DSDVCam />\n   <DSCapture/>\n   <DSGraph/>\n   <DSBDAGraph>\n      <channellist file=\"\"/>\n   </DSBDAGraph>\n   <DSStreamBufferGraph/>\n   <DSHDVTape/>\n</dsj>");
        }
        catch (Exception exception) {
            DSJUtils.logErr(0, exception, "Failed to parse xml setup: ");
        }
        return document;
    }

    private static Document a(String object) {
        try {
            object = new URL((String)object);
            object = ((URL)object).openConnection();
            object = ((URLConnection)object).getInputStream();
            byte[] byArray = new byte[8192];
            object = new BufferedInputStream((InputStream)object, byArray.length);
            while (((BufferedInputStream)object).read(byArray, 0, byArray.length) != -1) {
            }
            ((BufferedInputStream)object).close();
            return XMLUtils.buildDocument(new String(byArray).trim());
        }
        catch (Exception exception) {
            System.err.println("Error loading xml setup: " + exception.toString());
            return null;
        }
    }

    public static Document buildDocument(String object) {
        Document document = null;
        try {
            Object object2 = DocumentBuilderFactory.newInstance();
            object2 = ((DocumentBuilderFactory)object2).newDocumentBuilder();
            object = new ByteArrayInputStream(((String)object).getBytes());
            document = ((DocumentBuilder)object2).parse(new InputSource(new InputStreamReader((InputStream)object)));
        }
        catch (Exception exception) {}
        return document;
    }

    public static void saveDocument(Document object, String object2) throws DSJException {
        try {
            if (!object.hasChildNodes()) {
                throw new DSJException("Document is empty", -41);
            }
            object = new DOMSource((Node)object);
            StreamResult streamResult = null;
            object2 = new File((String)object2).getAbsoluteFile();
            streamResult = new StreamResult((File)object2);
            object2 = TransformerFactory.newInstance().newTransformer();
            ((Transformer)object2).setOutputProperty("indent", "yes");
            ((Transformer)object2).transform((Source)object, streamResult);
            return;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            return;
        }
        catch (TransformerException transformerException) {
            return;
        }
    }
}

