/*
 * Decompiled with CFR 0.152.
 */
package fer.lss.lecto;

import fer.lss.lecto.LeCToTests;
import fer.lss.lecto.gui.LeCToMainFrame;
import fer.lss.lecto.gui.locale.LeCToLocale;
import fer.lss.lecto.model.os.OperatingSystem;
import fer.lss.lecto.model.psu.PlayerSetUp;
import fer.lss.lecto.services.MessagesService;
import fer.lss.lecto.services.libraries.LibrariesService;
import fer.lss.lecto.services.usersettings.UserPresetService;
import fer.lss.lecto.services.usersettings.UserSettingsService;
import fer.lss.lecto.services.usersettings.model.UserSettings;
import java.awt.EventQueue;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class LeCTo {
    public static OperatingSystem operatingSystem;

    public static void main(String[] args) {
        String osName = System.getProperty("os.name");
        operatingSystem = OperatingSystem.resolve(osName);
        if (operatingSystem != null) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                ToolTipManager.sharedInstance().setInitialDelay(0);
                ToolTipManager.sharedInstance().setDismissDelay(200000);
                LibrariesService.loadLibraries();
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(null, MessagesService.getString("LeCTo.errorLibrariesLoading"), MessagesService.getString("LeCTo.infoMessage"), 0, new ImageIcon(LeCTo.class.getResource("/images/logo.png")));
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                // empty catch block
            }
            try {
                UserSettingsService.load();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            LeCTo.setUserDefaultValues();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        UserPresetService.initLecture();
                        PlayerSetUp.initWithDefaultValues();
                        LeCToMainFrame frame = new LeCToMainFrame();
                        frame.setVisible(true);
                        LeCToTests.test();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            });
        } else {
            JOptionPane.showMessageDialog(null, MessagesService.getString("LeCTo.errorOSNotSupported"), MessagesService.getString("LeCTo.infoMessage"), 0, new ImageIcon(LeCTo.class.getResource("/images/logo.png")));
        }
    }

    private static void setUserDefaultValues() {
        LeCToLocale leCToLocale = UserSettings.getLeCToLocale();
        if (leCToLocale != null) {
            MessagesService.setLocale(leCToLocale);
        }
    }
}

