/*
 * Decompiled with CFR 0.152.
 */
package fer.lss.lecto.constants;

import fer.lss.lecto.utils.FilesUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class WindowsConstants {
    public static String LECTO_ROOT = WindowsConstants.getLeCToRoot();
    public static String LECTO_FILES_LOCATION = String.valueOf(LECTO_ROOT) + "ProgramData" + File.separator + "LeCTo";
    public static String LECTO_USER_PROPERTIES_NAME = "User_Configuration.properties";
    public static String FILES_TEMP_FOLDER = LECTO_ROOT;
    public static String LECTO_LAST_CONFIGURATION_LOCATION = String.valueOf(LECTO_FILES_LOCATION) + File.separator + "LastConfiguration";
    public static String LECTO_LAST_CONFIGURATION_ENCODER_FILE_NAME_PREFIX = "encoder";
    public static String LECTO_LAST_CONFIGURATION_ENCODER_FILE_NAME_SUFIX = ".properties";
    public static String LECTO_USER_PROFILES_LOCATION = String.valueOf(LECTO_FILES_LOCATION) + File.separator + "UserProfiles";
    public static String LECTO_USER_PROFILE_ENCODER_FILE_NAME_PREFIX = "encoder";
    public static String LECTO_USER_PROFILE_ENCODER_FILE_NAME_SUFIX = ".properties";
    public static String LECTO_LANGUAGES_FOLDER_LOCATION = String.valueOf(LECTO_FILES_LOCATION) + File.separator + "Languages";
    public static String LECTO_VIDEOS_FOLDER_LOCATION = WindowsConstants.getLectoVideoLocation();
    public static String LECTO_PROPERTIES_NAME = "LeCTo";
    public static String DIRECT_SHOW_JAVA_FILE_NAME = "dsj.dll";
    public static String LIBVLC_FILE_NAME = "libvlc.dll";
    public static String LIBVLC_CORE_FILE_NAME = "libvlccore.dll";
    public static List<File> possibleVLCInstallLocations = new ArrayList<File>();

    static {
        possibleVLCInstallLocations.add(new File(String.valueOf(LECTO_ROOT) + File.separator + "Program Files" + File.separator + "VideoLAN" + File.separator + "VLC"));
        possibleVLCInstallLocations.add(new File(String.valueOf(LECTO_ROOT) + File.separator + "Program Files (x86)" + File.separator + "VideoLAN" + File.separator + "VLC"));
    }

    private static String getLeCToRoot() {
        File[] fileArray = File.listRoots();
        int n2 = fileArray.length;
        int n3 = 0;
        while (n3 < n2) {
            File root = fileArray[n3];
            if (root.getPath().equals("C:\\")) {
                return root.getPath();
            }
            String[] fileNames = root.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String fileName) {
                    return fileName.matches("Windows") || fileName.matches("Program Files \\(x86\\)") || fileName.matches("Program Files");
                }
            });
            if (fileNames != null && fileNames.length > 0) {
                return root.getPath();
            }
            ++n3;
        }
        return File.listRoots()[0].getPath();
    }

    private static String getLectoVideoLocation() {
        String locationString = String.valueOf(System.getProperty("user.home")) + File.separator + "Videos" + File.separator + "LeCTo";
        File lectoVideoLocation = new File(locationString);
        if (!lectoVideoLocation.exists()) {
            lectoVideoLocation.mkdirs();
        }
        return locationString;
    }

    public static String FFMPEGPath() {
        File propertiesFile = new File(String.valueOf(LECTO_FILES_LOCATION) + File.separator + LECTO_USER_PROPERTIES_NAME);
        try {
            Properties configurationProperties = FilesUtil.loadPropertiesFromFile(propertiesFile);
            String path = configurationProperties.getProperty("FFMPEGPath");
            return path;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
    }
}

