/*
 * Decompiled with CFR 0.152.
 */
package fer.lss.lecto.encoder.impl;

import fer.lss.lecto.constants.WindowsConstants;
import fer.lss.lecto.encoder.FFMPEGEncoder;
import fer.lss.lecto.model.mediaoptions.MediaOptions;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class EncoderWindows
extends FFMPEGEncoder {
    private Process runningProcess;
    private String ffmpegCommand;

    public EncoderWindows(MediaOptions mediaOptions) {
        super(mediaOptions);
        this.setupFFMPEGCommand();
    }

    private void setupFFMPEGCommand() {
        String videoDeviceName = this.mediaOptions.getVideoInput().getDeviceName();
        String audioDeviceName = this.mediaOptions.getAudioInput().getDeviceName();
        String outputFileName = String.valueOf(this.mediaOptions.getFileFullPath()) + File.separator + this.mediaOptions.getFileName() + ".mp4";
        String ffmpegPath = WindowsConstants.FFMPEGPath();
        this.ffmpegCommand = this.mediaOptions.getHasAudio() != false ? String.valueOf(ffmpegPath) + " -rtbufsize 1500M -f dshow -i video=\"" + videoDeviceName + "\":audio=\"" + audioDeviceName + "\" " + outputFileName : String.valueOf(ffmpegPath) + " -rtbufsize 1500M -f dshow -i video=\"" + videoDeviceName + " " + outputFileName;
        this.ffmpegCommand = String.valueOf(ffmpegPath) + " -rtbufsize 2000M -f dshow -i video=\"screen-capture-recorder\" " + "-r 40 -vcodec libx264 -threads 0 -crf 0 -preset ultrafast -map 0:v:0 " + "C:\\Users\\Jeton\\Videos\\LeCTo\\Desktop.mp4 -y " + "-f dshow -i video=\"HP Webcam\":audio=\"Microphone (High Definition Audio Device)\" " + "-r 40 -vcodec libx264 -threads 0 -crf 0 -preset ultrafast -tune zerolatency -map 1:v:0 -map 1:a:0 " + "C:\\Users\\Jeton\\Videos\\LeCTo\\Lecturer.mp4 -y";
    }

    @Override
    public boolean startEncoding() {
        try {
            final Process proc = this.runningProcess = Runtime.getRuntime().exec(this.ffmpegCommand);
            if (this.getLogFrame() != null) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            BufferedReader processOutput = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                            String line = null;
                            line = processOutput.readLine();
                            while (line != null) {
                                line = processOutput.readLine();
                                if (line == null) continue;
                                EncoderWindows.this.getLogFrame().setLogText(String.valueOf(line) + "\n");
                            }
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                }).start();
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return true;
    }

    @Override
    public void pauseEncoding() {
    }

    @Override
    public void stopEncoding() {
        BufferedWriter processInput = new BufferedWriter(new OutputStreamWriter(this.runningProcess.getOutputStream()));
        String commandToSend = "q";
        try {
            processInput.write(commandToSend);
            processInput.flush();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        BufferedReader processOutput = new BufferedReader(new InputStreamReader(this.runningProcess.getErrorStream()));
        String line = null;
        try {
            line = processOutput.readLine();
            while (line != null) {
                line = processOutput.readLine();
            }
            this.runningProcess.destroyForcibly();
            this.getLogFrame().setLogText("");
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.setupFFMPEGCommand();
    }

    @Override
    public void setFileFullPath(String fileFullPath) {
        super.setFileFullPath(fileFullPath);
        this.setupFFMPEGCommand();
    }

    @Override
    public void setMediaOptions(MediaOptions mediaOptions) {
        super.setMediaOptions(mediaOptions);
        this.setupFFMPEGCommand();
    }
}

