/*
 * Decompiled with CFR 0.152.
 */
package fer.lss.lecto.gui;

import fer.lss.lecto.LeCTo;
import fer.lss.lecto.encoder.FFMPEGEncoder;
import fer.lss.lecto.gui.LeCToMainFrame;
import fer.lss.lecto.gui.SourceConfigurationPanel;
import fer.lss.lecto.gui.locale.ILocale;
import fer.lss.lecto.model.DefaultEncodingParameters;
import fer.lss.lecto.model.Lecture;
import fer.lss.lecto.services.MessagesService;
import fer.lss.lecto.services.encoding.EncodingService;
import fer.lss.lecto.services.usersettings.UserPresetService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LectureEditor
extends JDialog
implements ILocale {
    private static final long serialVersionUID = 1L;
    boolean shouldAddNewPanel = true;
    boolean addingFromNewPanel = false;
    private JTabbedPane tabbedPane;
    private String infoMessage;
    private String warningMessageOneResource;

    public LectureEditor(JFrame parent) {
        super(parent);
        this.createGUI();
        this.setStringValues();
    }

    private void createGUI() {
        this.setResizable(false);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(LectureEditor.class.getResource("/images/favicon32T.png")));
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e2) {
                Lecture.prepareEncoders();
                try {
                    UserPresetService.save();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.setBounds(this.getParent().getX() + 50, this.getParent().getY() + 100, 451, 619);
        this.tabbedPane = new JTabbedPane(1);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        for (FFMPEGEncoder encoder : Lecture.getEncoders()) {
            JPanel contentPanel = this.getContentPanel(encoder);
            this.tabbedPane.add(contentPanel);
        }
        final JPanel addNewSourcePanel = new JPanel();
        addNewSourcePanel.setName("+ ");
        this.tabbedPane.add(addNewSourcePanel);
        this.tabbedPane.addContainerListener(new ContainerListener(){

            @Override
            public void componentRemoved(ContainerEvent e2) {
                LectureEditor.this.shouldAddNewPanel = true;
            }

            @Override
            public void componentAdded(ContainerEvent e2) {
                if (!LectureEditor.this.addingFromNewPanel) {
                    LectureEditor.this.shouldAddNewPanel = true;
                }
            }
        });
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JTabbedPane sourcePane = (JTabbedPane)changeEvent.getSource();
                if (LectureEditor.this.shouldAddNewPanel && sourcePane.getSelectedComponent().equals(addNewSourcePanel)) {
                    LectureEditor.this.shouldAddNewPanel = false;
                    LectureEditor.this.addingFromNewPanel = true;
                    FFMPEGEncoder encoder = new FFMPEGEncoder(DefaultEncodingParameters.getDefaultMediaOptionsWithNoVideoInput(EncodingService.getDefaultDefaultEncodingParameters()));
                    JPanel contentPanel = LectureEditor.this.getContentPanel(encoder);
                    LectureEditor.this.tabbedPane.add((Component)contentPanel, LectureEditor.this.tabbedPane.getComponentCount() - 1);
                    LectureEditor.this.tabbedPane.setSelectedComponent(contentPanel);
                    Lecture.addEncoder(encoder);
                    LectureEditor.this.addingFromNewPanel = false;
                    LectureEditor.this.shouldAddNewPanel = true;
                }
            }
        });
    }

    private JPanel getContentPanel(FFMPEGEncoder encoder) {
        final JPanel contentPanel = new JPanel(new BorderLayout());
        SourceConfigurationPanel configurationPanel = new SourceConfigurationPanel(encoder);
        JButton removeButton = new JButton(MessagesService.getString("LectureEditor.buttonRemoveSource.text"));
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (LectureEditor.this.tabbedPane.getComponentCount() < 3) {
                    JOptionPane.showMessageDialog(null, LectureEditor.this.warningMessageOneResource, LectureEditor.this.infoMessage, 2, new ImageIcon(LeCTo.class.getResource("/images/logo.png")));
                    return;
                }
                LectureEditor.this.shouldAddNewPanel = false;
                Component[] componentArray = contentPanel.getComponents();
                int n2 = componentArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    Component container = componentArray[n3];
                    if (container instanceof SourceConfigurationPanel) {
                        Lecture.removeEncoder(((SourceConfigurationPanel)container).getEncoder());
                    }
                    ++n3;
                }
                LectureEditor.this.tabbedPane.remove(contentPanel);
                LectureEditor.this.tabbedPane.setSelectedIndex(LectureEditor.this.tabbedPane.getComponentCount() - 2);
                LeCToMainFrame.setupSourceLabels();
            }
        });
        JButton saveAndCloseButton = new JButton(MessagesService.getString("LectureEditor.buttonSaveAndCloseAll.text"));
        saveAndCloseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                Lecture.prepareEncoders();
                LeCToMainFrame.setupSourceLabels();
                try {
                    UserPresetService.save();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                JButton button = (JButton)e2.getSource();
                Container parent = button.getParent();
                while (!(parent instanceof JDialog)) {
                    parent = ((JComponent)parent).getParent();
                }
                JDialog frame = (JDialog)parent;
                frame.setVisible(false);
                frame.dispose();
            }
        });
        contentPanel.add((Component)configurationPanel, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.add((Component)removeButton, "East");
        buttonPanel.add((Component)saveAndCloseButton, "West");
        contentPanel.add((Component)buttonPanel, "South");
        contentPanel.setName(encoder.toString());
        return contentPanel;
    }

    @Override
    public void setStringValues() {
        this.setTitle(MessagesService.getString("LectureEditor.this.title"));
        this.warningMessageOneResource = new String(MessagesService.getString("LectureEditor.warningMessage.oneResourceMin"));
        this.infoMessage = new String(MessagesService.getString("LectureEditor.infoMessage"));
        this.renameRemoveButtons();
    }

    private void renameRemoveButtons() {
        Component[] componentArray = this.tabbedPane.getComponents();
        int n2 = componentArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Component contentPanel = componentArray[n3];
            Component[] componentArray2 = ((JPanel)contentPanel).getComponents();
            int n4 = componentArray2.length;
            int n5 = 0;
            while (n5 < n4) {
                Component component = componentArray2[n5];
                if (component instanceof JButton) {
                    JButton button = (JButton)component;
                    button.setText(MessagesService.getString("LectureEditor.buttonRemoveSource.text"));
                }
                ++n5;
            }
            ++n3;
        }
    }
}

