/*
 * Decompiled with CFR 0.152.
 */
package fer.lss.lecto.gui.locale;

import java.awt.Image;
import java.io.File;
import java.util.Locale;
import javax.swing.ImageIcon;

public class LeCToLocale {
    private Locale locale;
    private String iconPath;
    private LeCToLocaleType leCToLocaleType;
    private File customLocaleMessagesPropertiesFile;

    public LeCToLocale(Locale locale, String iconPath, LeCToLocaleType leCToLocaleType) {
        this.locale = locale;
        this.iconPath = iconPath;
        this.leCToLocaleType = leCToLocaleType;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public ImageIcon getImageIcon() {
        ImageIcon icon = null;
        switch (this.leCToLocaleType) {
            case CUSTOM: {
                icon = new ImageIcon(this.iconPath);
                break;
            }
            case DEFAULT: {
                icon = new ImageIcon(this.getClass().getResource("/images/icons/locale/" + this.locale.toString() + ".png"));
            }
        }
        if (icon != null) {
            Image img = icon.getImage();
            Image newImg = img.getScaledInstance(16, 16, 4);
            icon = new ImageIcon(newImg);
        }
        return icon;
    }

    public String getIconPath() {
        switch (this.leCToLocaleType) {
            case CUSTOM: {
                return this.iconPath;
            }
            case DEFAULT: {
                return "/images/icons/locale/" + this.locale.toString() + ".png";
            }
        }
        return null;
    }

    public void setIconPath(String iconPath) {
        this.iconPath = iconPath;
    }

    public LeCToLocaleType getLeCToLocaleType() {
        return this.leCToLocaleType;
    }

    public void setLeCToLocaleType(LeCToLocaleType leCToLocaleType) {
        this.leCToLocaleType = leCToLocaleType;
    }

    public File getCustomLocaleMessagesPropertiesFile() {
        return this.customLocaleMessagesPropertiesFile;
    }

    public void setCustomLocaleMessagesPropertiesFile(File customLocaleMessagesPropertiesFile) {
        this.customLocaleMessagesPropertiesFile = customLocaleMessagesPropertiesFile;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.iconPath == null ? 0 : this.iconPath.hashCode());
        result = 31 * result + (this.leCToLocaleType == null ? 0 : this.leCToLocaleType.hashCode());
        result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LeCToLocale other = (LeCToLocale)obj;
        if (this.iconPath == null ? other.iconPath != null : !this.iconPath.equals(other.iconPath)) {
            return false;
        }
        if (this.leCToLocaleType != other.leCToLocaleType) {
            return false;
        }
        return !(this.locale == null ? other.locale != null : !this.locale.equals(other.locale));
    }

    public static enum LeCToLocaleType {
        DEFAULT,
        CUSTOM;

    }
}

