/*
 * Decompiled with CFR 0.152.
 */
package fer.lss.lecto.gui.translate;

import fer.lss.lecto.LeCTo;
import fer.lss.lecto.gui.locale.ILocale;
import fer.lss.lecto.gui.locale.LeCToLocale;
import fer.lss.lecto.gui.translate.LanguagePanel;
import fer.lss.lecto.services.MessagesService;
import fer.lss.lecto.services.translate.TranslateService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class DeleteLanguagesDialog
extends JDialog
implements ILocale {
    private static final long serialVersionUID = 1L;
    private final JPanel contentPanel = new JPanel();
    private JFrame parent;
    private JScrollPane scrollPane;
    private JCheckBox selectDeselectAll;
    private JButton deleteButton;
    private JButton cancelButton;
    private List<LanguagePanel> languagePanels;
    private String deleteSuccessMessage;

    public DeleteLanguagesDialog(JFrame parent) {
        super(parent);
        this.parent = parent;
        this.selectDeselectAll = new JCheckBox();
        this.deleteButton = new JButton();
        this.cancelButton = new JButton();
        this.languagePanels = new ArrayList<LanguagePanel>();
        this.setStringValues();
        this.createGUI();
    }

    private void createGUI() {
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setBounds(this.parent.getX() + 100, this.parent.getY() + 100, 195, 313);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setLayout(new GridLayout(MessagesService.getAvailableLocales().size() + MessagesService.getCustomLocales().size() + 1, 1));
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        for (LeCToLocale locale : MessagesService.getCustomLocales()) {
            this.languagePanels.add(new LanguagePanel(locale));
        }
        this.selectDeselectAll.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                for (LanguagePanel languagePanel : DeleteLanguagesDialog.this.languagePanels) {
                    languagePanel.setSelected(DeleteLanguagesDialog.this.selectDeselectAll.isSelected());
                }
            }
        });
        this.contentPanel.add(this.selectDeselectAll);
        for (LanguagePanel languagePanel : this.languagePanels) {
            this.contentPanel.add(languagePanel);
        }
        this.scrollPane = new JScrollPane(this.contentPanel);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DeleteLanguagesDialog.this.deleteLanguages();
                DeleteLanguagesDialog.this.dispose();
            }
        });
        buttonPane.add(this.deleteButton);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                DeleteLanguagesDialog.this.dispose();
            }
        });
        buttonPane.add(this.cancelButton);
    }

    protected void deleteLanguages() {
        int deleteCount = 0;
        for (LanguagePanel languagePanel : this.languagePanels) {
            if (!languagePanel.isSelected().booleanValue()) continue;
            TranslateService.deleteLanguageFiles(languagePanel.getLeCToLocale());
            ++deleteCount;
        }
        JOptionPane.showMessageDialog(null, String.valueOf(deleteCount) + " " + this.deleteSuccessMessage, MessagesService.getString("DeleteLanguagesDialog.info"), -1, new ImageIcon(LeCTo.class.getResource("/images/logo.png")));
    }

    @Override
    public void setStringValues() {
        this.setTitle(MessagesService.getString("DeleteLanguagesDialog.this.title.text"));
        this.selectDeselectAll.setText(MessagesService.getString("DeleteLanguagesDialog.selectDeselectAll.text"));
        this.deleteButton.setText(MessagesService.getString("DeleteLanguagesDialog.deleteButton.text"));
        this.cancelButton.setText(MessagesService.getString("DeleteLanguagesDialog.cancelButton.text"));
        this.deleteSuccessMessage = MessagesService.getString("DeleteLanguagesDialog.deleteSuccessMessage.text");
    }
}

