/*
 * Decompiled with CFR 0.152.
 */
package fer.lss.lecto.model;

import fer.lss.lecto.LeCTo;
import fer.lss.lecto.encoder.FFMPEGEncoder;
import fer.lss.lecto.encoder.FFMPEGSummoner;
import fer.lss.lecto.encoder.impl.EncoderLinux;
import fer.lss.lecto.encoder.impl.EncoderMacOSX;
import fer.lss.lecto.encoder.impl.EncoderWindows;
import fer.lss.lecto.model.DefaultEncodingParameters;
import fer.lss.lecto.model.LectureState;
import fer.lss.lecto.model.mediaoptions.MediaOptions;
import fer.lss.lecto.services.encoding.EncodingService;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class Lecture {
    private static List<FFMPEGEncoder> encoders = new ArrayList<FFMPEGEncoder>();
    private static Calendar encodingStartTime;
    private static Calendar encodingEndTime;
    private static LectureState lectureState;
    private static long lectureDurationInSeconds;
    private static DefaultEncodingParameters encodingParameters;
    private static FFMPEGSummoner summoner;

    public static FFMPEGSummoner getSummoner() {
        if (summoner == null) {
            summoner = new FFMPEGSummoner(encoders);
        }
        return summoner;
    }

    public static void setSummoner(FFMPEGSummoner summoner) {
        Lecture.summoner = summoner;
    }

    public static void prepareEncoders() {
        Lecture.setLectureState(LectureState.IDLE);
        Lecture.deleteEmptyEncoders();
        Lecture.renameOutputFilesIfThereAreDuplicates();
        Lecture.getSummoner().setEncoders(encoders);
    }

    public static void startEncoding() {
        if (Lecture.getLectureState().equals((Object)LectureState.IDLE)) {
            Lecture.setEncodingStartTime(Calendar.getInstance());
        }
        Lecture.setLectureState(LectureState.ENCODING_IS_STARTING);
        Lecture.getSummoner().startEncoding();
        Lecture.setLectureState(LectureState.ENCODING);
    }

    public static void pauseEncoding() throws IOException {
        summoner.pauseEncoding();
        Lecture.setLectureState(LectureState.PAUSED);
    }

    public static boolean stopEncoding() throws IOException {
        if (!Lecture.getLectureState().equals((Object)LectureState.ENCODING) && !Lecture.getLectureState().equals((Object)LectureState.PAUSED)) {
            return false;
        }
        Lecture.setLectureState(LectureState.ENCODING_IS_STOPPING);
        summoner.stopEncoding();
        Lecture.setEncodingEndTime(Calendar.getInstance());
        Lecture.setLectureState(LectureState.STOPPED);
        return true;
    }

    public static void release() {
        for (FFMPEGEncoder encoder : encoders) {
            encoder.releaseResources();
        }
        encoders = new ArrayList<FFMPEGEncoder>();
        Lecture.setLectureDurationInSeconds(0L);
        Lecture.setLectureState(LectureState.IDLE);
    }

    public static void setDefaultParameters(DefaultEncodingParameters defaultEncodingParameters) {
        encodingParameters = defaultEncodingParameters;
        Lecture.release();
        MediaOptions mediaOptionsCamera = DefaultEncodingParameters.getDefaultMediaOptionsForCamera(defaultEncodingParameters);
        FFMPEGEncoder encoder = new FFMPEGEncoder(mediaOptionsCamera);
        MediaOptions mediaOptionsScreen = DefaultEncodingParameters.getDefaultMediaOptionsForScreen(defaultEncodingParameters);
        FFMPEGEncoder screenEncoder = new FFMPEGEncoder(mediaOptionsScreen);
        switch (LeCTo.operatingSystem.getFamily()) {
            case WINDOWS: {
                encoder = new EncoderWindows(mediaOptionsCamera);
                screenEncoder = new EncoderWindows(mediaOptionsScreen);
                break;
            }
            case LINUX: {
                encoder = new EncoderLinux(mediaOptionsCamera);
                screenEncoder = new EncoderLinux(mediaOptionsScreen);
                break;
            }
            case MAC: {
                encoder = new EncoderMacOSX(mediaOptionsCamera);
                screenEncoder = new EncoderMacOSX(mediaOptionsScreen);
            }
        }
        Lecture.addEncoder(encoder);
        if (EncodingService.canEncodeDesktop().booleanValue()) {
            Lecture.addEncoder(screenEncoder);
        }
        Lecture.prepareEncoders();
    }

    private static void renameOutputFilesIfThereAreDuplicates() {
        boolean[] alreadyChecked = new boolean[encoders.size()];
        int i2 = 0;
        while (i2 < encoders.size()) {
            if (!alreadyChecked[i2]) {
                alreadyChecked[i2] = true;
                ArrayList<FFMPEGEncoder> encodersToRename = new ArrayList<FFMPEGEncoder>();
                FFMPEGEncoder encoder = encoders.get(i2);
                encodersToRename.add(encoder);
                int j2 = i2;
                while (j2 < encoders.size()) {
                    FFMPEGEncoder possibleDuplicateEncoder = Lecture.getEncoders().get(j2);
                    if (!alreadyChecked[j2] && encoder.getMediaOptions().getFileFullName().equals(possibleDuplicateEncoder.getMediaOptions().getFileFullName())) {
                        alreadyChecked[j2] = true;
                        encodersToRename.add(possibleDuplicateEncoder);
                    }
                    ++j2;
                }
                Lecture.renameEncoders(encodersToRename);
            }
            ++i2;
        }
        Lecture.attachTimeStampToOutputFileNamesIfNeeded();
    }

    private static void renameEncoders(List<FFMPEGEncoder> encodersToRename) {
        if (encodersToRename.size() > 1) {
            int i2 = 1;
            while (i2 < encodersToRename.size()) {
                FFMPEGEncoder en = encodersToRename.get(i2);
                en.setName(String.valueOf(en.getName()) + "_" + (i2 + 1));
                ++i2;
            }
        }
    }

    private static void attachTimeStampToOutputFileNamesIfNeeded() {
        SimpleDateFormat df = new SimpleDateFormat("MM-dd_HH-mm");
        for (FFMPEGEncoder encoder : encoders) {
            File currentFolder = new File(encoder.getMediaOptions().getFileFullPath());
            if (!Lecture.folderAlreadyContainsThisFileName(currentFolder, encoder.getMediaOptions().getFileNameWithExtension())) continue;
            if (encoder.getName().contains("_")) {
                String[] tokens = encoder.getName().split("_", 2);
                encoder.setName(encoder.getName().replace(tokens[1], df.format(new Date())));
                continue;
            }
            encoder.setName(String.valueOf(encoder.getName()) + "_" + df.format(new Date()));
        }
    }

    private static boolean folderAlreadyContainsThisFileName(File folder, final String name) {
        String[] fileNames = folder.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String fileName) {
                return fileName.equals(name);
            }
        });
        return fileNames.length > 0;
    }

    private static void deleteEmptyEncoders() {
        ArrayList<FFMPEGEncoder> encodersToDelete = new ArrayList<FFMPEGEncoder>();
        for (FFMPEGEncoder encoder : encoders) {
            if (encoder.getMediaOptions().getHasVideo().booleanValue() || encoder.getMediaOptions().getHasAudio().booleanValue()) continue;
            encodersToDelete.add(encoder);
        }
        Lecture.removeEncoders(encodersToDelete);
    }

    public static DefaultEncodingParameters getEncodingParameters() {
        return encodingParameters;
    }

    public static void addEncoder(FFMPEGEncoder encoder) {
        encoders.add(encoder);
    }

    public static void removeEncoder(FFMPEGEncoder encoder) {
        encoders.remove(encoder);
    }

    public static void removeEncoders(List<FFMPEGEncoder> encodersToDelete) {
        encoders.removeAll(encodersToDelete);
    }

    public static List<FFMPEGEncoder> getEncoders() {
        return encoders;
    }

    public static void setEncoders(List<FFMPEGEncoder> encoders) {
        Lecture.encoders = encoders;
    }

    public static Calendar getEncodingStartTime() {
        return encodingStartTime;
    }

    public static void setEncodingStartTime(Calendar encodingStartTime) {
        Lecture.encodingStartTime = encodingStartTime;
    }

    public static Calendar getEncodingEndTime() {
        return encodingEndTime;
    }

    public static void setEncodingEndTime(Calendar encodingEndTime) {
        Lecture.encodingEndTime = encodingEndTime;
    }

    public static LectureState getLectureState() {
        return lectureState;
    }

    public static void setLectureState(LectureState lectureState) {
        Lecture.lectureState = lectureState;
    }

    public static long getLectureDurationInSeconds() {
        switch (lectureState) {
            case ENCODING: {
                Lecture.updateLectureDuration();
                return lectureDurationInSeconds;
            }
        }
        return lectureDurationInSeconds;
    }

    public static void setLectureDurationInSeconds(long lectureDurationInSeconds) {
        Lecture.lectureDurationInSeconds = lectureDurationInSeconds;
    }

    private static void updateLectureDuration() {
        Lecture.setLectureDurationInSeconds(lectureDurationInSeconds + 1L);
    }
}

