/*
 * Decompiled with CFR 0.152.
 */
package fer.lss.lecto.services.encoding.impl;

import fer.lss.lecto.LeCTo;
import fer.lss.lecto.constants.MacOSXConstants;
import fer.lss.lecto.constants.WindowsConstants;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class FFMPEGDeviceProvider {
    private static String ffmpeg_output;

    private static void executeCommand(String command) {
        if (ffmpeg_output == null) {
            StringBuilder s2 = new StringBuilder();
            try {
                Process p2 = Runtime.getRuntime().exec(command);
                BufferedReader input = null;
                input = command.contains("arecord") ? new BufferedReader(new InputStreamReader(p2.getInputStream())) : new BufferedReader(new InputStreamReader(p2.getErrorStream()));
                String line = null;
                while ((line = input.readLine()) != null) {
                    s2.append(line);
                    s2.append('\n');
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            ffmpeg_output = s2.toString();
        }
    }

    public static String getAvailableVideoDevicesString() {
        switch (LeCTo.operatingSystem.getFamily()) {
            case WINDOWS: {
                String path = WindowsConstants.FFMPEGPath();
                FFMPEGDeviceProvider.executeCommand(String.valueOf(path) + " -list_devices true -f dshow -i dummy");
                String deviceString = null;
                while (ffmpeg_output == null) {
                }
                deviceString = ffmpeg_output;
                int startIndex = deviceString.indexOf("DirectShow video devices");
                int endIndex = deviceString.indexOf("DirectShow audio devices");
                return deviceString.substring(startIndex, endIndex);
            }
            case MAC: {
                String path = MacOSXConstants.FFMPEGPath();
                FFMPEGDeviceProvider.executeCommand(String.valueOf(path) + " -f avfoundation -list_devices true -i \"\"");
                String deviceString = null;
                while (ffmpeg_output == null) {
                }
                deviceString = ffmpeg_output;
                int startIndex = deviceString.indexOf("AVFoundation video devices:");
                int endIndex = deviceString.indexOf("AVFoundation audio devices:");
                return deviceString.substring(startIndex, endIndex);
            }
        }
        return null;
    }

    public static String getAvailableAudioDevicesString() {
        switch (LeCTo.operatingSystem.getFamily()) {
            case WINDOWS: {
                String path = WindowsConstants.FFMPEGPath();
                FFMPEGDeviceProvider.executeCommand(String.valueOf(path) + " -list_devices true -f dshow -i dummy");
                String deviceString = null;
                while (ffmpeg_output == null) {
                }
                deviceString = ffmpeg_output;
                int startIndex = deviceString.indexOf("DirectShow audio devices");
                int endIndex = deviceString.lastIndexOf("dummy");
                return deviceString.substring(startIndex, endIndex);
            }
            case MAC: {
                String path = MacOSXConstants.FFMPEGPath();
                FFMPEGDeviceProvider.executeCommand(String.valueOf(path) + " -f avfoundation -list_devices true -i \"\"");
                String deviceString = null;
                while (ffmpeg_output == null) {
                }
                deviceString = ffmpeg_output;
                int startIndex = deviceString.indexOf("AVFoundation audio devices:");
                int endIndex = deviceString.lastIndexOf("\"");
                return deviceString.substring(startIndex, endIndex);
            }
            case LINUX: {
                FFMPEGDeviceProvider.executeCommand("arecord -l");
                while (ffmpeg_output == null) {
                }
                String devicesString = ffmpeg_output;
                return ffmpeg_output;
            }
        }
        return null;
    }
}

