/*
 * Decompiled with CFR 0.152.
 */
package fer.lss.lecto.services.usersettings;

import fer.lss.lecto.LeCTo;
import fer.lss.lecto.constants.LinuxConstants;
import fer.lss.lecto.constants.MacOSXConstants;
import fer.lss.lecto.constants.WindowsConstants;
import fer.lss.lecto.encoder.FFMPEGEncoder;
import fer.lss.lecto.services.MessagesService;
import fer.lss.lecto.services.usersettings.model.UserSettings;
import fer.lss.lecto.utils.FilesUtil;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class UserSettingsService {
    public static Map<String, List<String>> audioCodecsForContainer;
    public static Map<String, List<String>> videoCodecsForContainer;
    public static List<String> containers;
    public static List<String> resolutions;
    public static List<String> framerates;
    public static List<String> videoBitrates;
    public static List<String> audioBitrates;
    public static List<String> audioSamplingRates;
    public static List<String> presets;
    private static String filePath;
    private static String propertiesName;

    public static void addEncoderToPauseList(FFMPEGEncoder ffmpegEncoder, String partIdentifier) throws IOException {
        File pauseFile = new File(String.valueOf(filePath) + File.separator + ffmpegEncoder.getMediaOptions().getFileName() + "Pause.txt");
        if (!pauseFile.exists()) {
            pauseFile.createNewFile();
        }
        String outputFileName = String.valueOf(ffmpegEncoder.getMediaOptions().getFileFullPath()) + File.separator + ffmpegEncoder.getMediaOptions().getFileName() + partIdentifier + "." + ffmpegEncoder.getMediaOptions().getContainer();
        PrintWriter pw = new PrintWriter(new FileOutputStream(pauseFile, true));
        pw.append("file '" + outputFileName + "'" + System.getProperty("line.separator"));
        pw.close();
    }

    public static void deletePauseListForEncoder(FFMPEGEncoder ffmpegEncoder) throws IOException {
        List<String> lines = Files.readAllLines(Paths.get(String.valueOf(filePath) + File.separator + ffmpegEncoder.getMediaOptions().getFileName() + "Pause.txt", new String[0]), Charset.defaultCharset());
        int i2 = 0;
        while (i2 < lines.size()) {
            String[] tokens = lines.get(i2).split(" ");
            File videoFile = new File(tokens[1].replace("'", ""));
            videoFile.delete();
            ++i2;
        }
        File pauseFile = new File(String.valueOf(filePath) + File.separator + ffmpegEncoder.getMediaOptions().getFileName() + "Pause.txt");
        pauseFile.delete();
    }

    public static String getPauseFilePathForEncoder(FFMPEGEncoder ffmpegEncoder) {
        return String.valueOf(filePath) + File.separator + ffmpegEncoder.getMediaOptions().getFileName() + "Pause.txt";
    }

    public static void load() throws IOException {
        switch (LeCTo.operatingSystem.getFamily()) {
            case WINDOWS: {
                filePath = WindowsConstants.LECTO_FILES_LOCATION;
                propertiesName = WindowsConstants.LECTO_USER_PROPERTIES_NAME;
                break;
            }
            case LINUX: {
                filePath = LinuxConstants.LECTO_FILES_LOCATION;
                propertiesName = "User_Configuration.properties";
                break;
            }
            case MAC: {
                filePath = MacOSXConstants.LECTO_FILES_LOCATION;
                propertiesName = "User_Configuration.properties";
                break;
            }
            default: {
                return;
            }
        }
        File propertiesLocation = new File(filePath);
        propertiesLocation.mkdirs();
        final File propertiesFile = new File(String.valueOf(filePath) + File.separator + propertiesName);
        if (!propertiesFile.exists()) {
            File containerFile = new File(String.valueOf(filePath) + File.separator + "containers.txt");
            FilesUtil.copyResourceToFile("/containers.txt", containerFile);
            File resolutionsFile = new File(String.valueOf(filePath) + File.separator + "resolutions.txt");
            FilesUtil.copyResourceToFile("/resolutions.txt", resolutionsFile);
            File otherFile = new File(String.valueOf(filePath) + File.separator + "other.txt");
            FilesUtil.copyResourceToFile("/other.txt", otherFile);
            JEditorPane content = UserSettingsService.getFFMPEgConfigurationDialogContent();
            ArrayList<JButton> options = new ArrayList<JButton>();
            JButton browseButton = new JButton(MessagesService.getString("UserSettingsService.browseButtonText"));
            browseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    File file;
                    JFileChooser fc = new JFileChooser();
                    fc.setFileSelectionMode(2);
                    fc.setFileHidingEnabled(false);
                    fc.setDialogTitle(MessagesService.getString("UserSettingsService.browseButtonText"));
                    int returnVal = fc.showOpenDialog(null);
                    if (returnVal == 0 && (file = fc.getSelectedFile()).exists()) {
                        try {
                            propertiesFile.createNewFile();
                            Properties configurationProperties = FilesUtil.loadPropertiesFromFile(propertiesFile);
                            configurationProperties.setProperty("FFMPEGPath", file.getAbsolutePath());
                            FilesUtil.savePropertiesToFile(configurationProperties, propertiesFile);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        JButton browseButton = (JButton)e2.getSource();
                        JPanel pane = (JPanel)browseButton.getParent();
                        Component[] componentArray = pane.getComponents();
                        int n2 = componentArray.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            Component comp = componentArray[n3];
                            if (comp.getClass() == JButton.class && !comp.equals(browseButton)) {
                                JButton doneButton = (JButton)comp;
                                doneButton.setVisible(true);
                            }
                            ++n3;
                        }
                        JOptionPane.showMessageDialog(null, String.valueOf(MessagesService.getString("UserSettingsService.FFMPEGConfigured")) + file.getAbsolutePath(), MessagesService.getString("LeCTo.infoMessage"), -1, new ImageIcon(LeCTo.class.getResource("/images/logo.png")));
                    }
                }
            });
            JButton doneButton = new JButton(MessagesService.getString("UserSettingsService.doneButtonText"));
            doneButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    Window[] windows;
                    Window[] windowArray = windows = Window.getWindows();
                    int n2 = windows.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        JDialog dialog;
                        Window window = windowArray[n3];
                        if (window instanceof JDialog && (dialog = (JDialog)window).getContentPane().getComponentCount() == 1 && dialog.getContentPane().getComponent(0) instanceof JOptionPane) {
                            dialog.dispose();
                        }
                        ++n3;
                    }
                }
            });
            options.add(browseButton);
            doneButton.setVisible(false);
            options.add(doneButton);
            JOptionPane.showOptionDialog(null, content, MessagesService.getString("LeCTo.infoMessage"), 0, 0, new ImageIcon(LeCTo.class.getResource("/images/logo.png")), options.toArray(), 0);
        }
        Properties leCToProperties = FilesUtil.loadPropertiesFromFile(propertiesFile);
        UserSettings.fillFromProperties(leCToProperties);
        UserSettingsService.setupContainerSettings();
        UserSettingsService.setupResolutionSettings();
        UserSettingsService.setupOtherSettings();
    }

    private static JEditorPane getFFMPEgConfigurationDialogContent() {
        JLabel label = new JLabel();
        Font font = label.getFont();
        StringBuffer style = new StringBuffer("font-family:" + font.getFamily() + ";");
        style.append("font-weight:" + (font.isBold() ? "bold" : "normal") + ";");
        style.append("font-size:" + font.getSize() + "pt;");
        JEditorPane ep = new JEditorPane("text/html", "<html><body style=\"" + style + "\">" + MessagesService.getString("UserSettingsService.configureFFMPEG") + "</body></html>");
        ep.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e2) {
                if (e2.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED) && Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(e2.getURL().toURI());
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    catch (URISyntaxException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        ep.setEditable(false);
        ep.setBackground(label.getBackground());
        return ep;
    }

    public static void save() throws IOException {
        File propertiesFile = new File(String.valueOf(filePath) + File.separator + propertiesName);
        Properties properties = UserSettings.getPropertiesInstanceForFile(propertiesFile);
        FilesUtil.savePropertiesToFile(properties, propertiesFile);
    }

    public static void setupContainerSettings() throws IOException {
        audioCodecsForContainer = new HashMap<String, List<String>>();
        videoCodecsForContainer = new HashMap<String, List<String>>();
        containers = new ArrayList<String>();
        List<String> lines = Files.readAllLines(Paths.get(String.valueOf(filePath) + File.separator + "containers.txt", new String[0]), Charset.defaultCharset());
        for (String line : lines) {
            List<String> existingVideoCodecs;
            String[] components = line.split(";");
            String container = null;
            List<String> existingAudioCodecs = audioCodecsForContainer.get(container);
            if (existingAudioCodecs == null) {
                existingAudioCodecs = new ArrayList<String>();
            }
            if ((existingVideoCodecs = videoCodecsForContainer.get(container)) == null) {
                existingVideoCodecs = new ArrayList<String>();
            }
            int i2 = 0;
            while (i2 < components.length) {
                int j2;
                String[] separate;
                String equality = components[i2];
                String[] equalityComp = equality.split("=");
                if (equalityComp[0].equals("c")) {
                    container = equalityComp[1];
                }
                if (equalityComp[0].equals("a")) {
                    String audioCodecs = equalityComp[1];
                    separate = audioCodecs.split(",");
                    j2 = 0;
                    while (j2 < separate.length) {
                        if (!existingAudioCodecs.contains(separate[j2])) {
                            existingAudioCodecs.add(separate[j2]);
                        }
                        ++j2;
                    }
                    audioCodecsForContainer.put(container, existingAudioCodecs);
                }
                if (equalityComp[0].equals("v")) {
                    String videoCodecs = equalityComp[1];
                    separate = videoCodecs.split(",");
                    j2 = 0;
                    while (j2 < separate.length) {
                        if (!existingVideoCodecs.contains(separate[j2])) {
                            existingVideoCodecs.add(separate[j2]);
                        }
                        ++j2;
                    }
                    videoCodecsForContainer.put(container, existingVideoCodecs);
                }
                ++i2;
            }
            if (containers.contains(container)) continue;
            containers.add(container);
        }
    }

    public static void setupResolutionSettings() throws IOException {
        resolutions = Files.readAllLines(Paths.get(String.valueOf(filePath) + File.separator + "resolutions.txt", new String[0]), Charset.defaultCharset());
    }

    public static void setupOtherSettings() throws IOException {
        List<String> lines = Files.readAllLines(Paths.get(String.valueOf(filePath) + File.separator + "other.txt", new String[0]), Charset.defaultCharset());
        videoBitrates = new ArrayList<String>();
        framerates = new ArrayList<String>();
        audioBitrates = new ArrayList<String>();
        audioSamplingRates = new ArrayList<String>();
        presets = new ArrayList<String>();
        for (String line : lines) {
            int i2;
            String[] commaTokens;
            String[] equalityTokens = line.split("=");
            if (equalityTokens[0].equals("video_bitrate")) {
                commaTokens = equalityTokens[1].split(",");
                i2 = 0;
                while (i2 < commaTokens.length) {
                    videoBitrates.add(commaTokens[i2]);
                    ++i2;
                }
            }
            if (equalityTokens[0].equals("audio_bitrate")) {
                commaTokens = equalityTokens[1].split(",");
                i2 = 0;
                while (i2 < commaTokens.length) {
                    audioBitrates.add(commaTokens[i2]);
                    ++i2;
                }
            }
            if (equalityTokens[0].equals("video_framerate")) {
                commaTokens = equalityTokens[1].split(",");
                i2 = 0;
                while (i2 < commaTokens.length) {
                    framerates.add(commaTokens[i2]);
                    ++i2;
                }
            }
            if (equalityTokens[0].equals("audio_sampling_rate")) {
                commaTokens = equalityTokens[1].split(",");
                i2 = 0;
                while (i2 < commaTokens.length) {
                    audioSamplingRates.add(commaTokens[i2]);
                    ++i2;
                }
            }
            if (!equalityTokens[0].equals("preset")) continue;
            commaTokens = equalityTokens[1].split(",");
            i2 = 0;
            while (i2 < commaTokens.length) {
                presets.add(commaTokens[i2]);
                ++i2;
            }
        }
    }

    public static String getContainerFilePath() {
        return String.valueOf(filePath) + File.separator + "containers.txt";
    }

    public static String getResolutionFilePath() {
        return String.valueOf(filePath) + File.separator + "resolutions.txt";
    }

    public static String getOtherFilePath() {
        return String.valueOf(filePath) + File.separator + "other.txt";
    }

    public static void refreshData() {
        try {
            UserSettingsService.setupContainerSettings();
            UserSettingsService.setupResolutionSettings();
            UserSettingsService.setupOtherSettings();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }
}

