/*
 * Decompiled with CFR 0.152.
 */
package javax.help.event;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventListener;

public class EventListenerList
implements Serializable {
    private static final Object[] NULL_ARRAY = new Object[0];
    protected transient Object[] listenerList = NULL_ARRAY;

    public Object[] getListenerList() {
        return this.listenerList;
    }

    public int getListenerCount() {
        return this.listenerList.length / 2;
    }

    public int getListenerCount(Class clazz) {
        int n2 = 0;
        Object[] objectArray = this.listenerList;
        for (int i2 = 0; i2 < objectArray.length; i2 += 2) {
            if (clazz != (Class)objectArray[i2]) continue;
            ++n2;
        }
        return n2;
    }

    public synchronized void add(Class clazz, EventListener eventListener) {
        if (eventListener == null || clazz == null) {
            throw new IllegalArgumentException("Listener " + eventListener + " is null");
        }
        if (!clazz.isInstance(eventListener)) {
            throw new IllegalArgumentException("Listener " + eventListener + " is not of type " + clazz);
        }
        if (this.listenerList == NULL_ARRAY) {
            this.listenerList = new Object[]{clazz, eventListener};
        } else {
            int n2 = this.listenerList.length;
            Object[] objectArray = new Object[n2 + 2];
            System.arraycopy(this.listenerList, 0, objectArray, 0, n2);
            objectArray[n2] = clazz;
            objectArray[n2 + 1] = eventListener;
            this.listenerList = objectArray;
        }
    }

    public synchronized void remove(Class clazz, EventListener eventListener) {
        if (eventListener == null || clazz == null) {
            throw new IllegalArgumentException("Listener " + eventListener + " is null");
        }
        if (!clazz.isInstance(eventListener)) {
            throw new IllegalArgumentException("Listener " + eventListener + " is not of type " + clazz);
        }
        int n2 = -1;
        for (int i2 = this.listenerList.length - 2; i2 >= 0; i2 -= 2) {
            if (this.listenerList[i2] != clazz || this.listenerList[i2 + 1] != eventListener) continue;
            n2 = i2;
            break;
        }
        if (n2 != -1) {
            Object[] objectArray = new Object[this.listenerList.length - 2];
            System.arraycopy(this.listenerList, 0, objectArray, 0, n2);
            if (n2 < objectArray.length) {
                System.arraycopy(this.listenerList, n2 + 2, objectArray, n2, objectArray.length - n2);
            }
            this.listenerList = objectArray.length == 0 ? NULL_ARRAY : objectArray;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Object[] objectArray = this.listenerList;
        objectOutputStream.defaultWriteObject();
        for (int i2 = 0; i2 < objectArray.length; i2 += 2) {
            Class clazz = (Class)objectArray[i2];
            EventListener eventListener = (EventListener)objectArray[i2 + 1];
            if (eventListener == null || !(eventListener instanceof Serializable)) continue;
            objectOutputStream.writeObject(clazz.getName());
            objectOutputStream.writeObject(eventListener);
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        this.listenerList = NULL_ARRAY;
        objectInputStream.defaultReadObject();
        while (null != (object = objectInputStream.readObject())) {
            EventListener eventListener = (EventListener)objectInputStream.readObject();
            this.add(Class.forName((String)object), eventListener);
        }
    }

    public String toString() {
        Object[] objectArray = this.listenerList;
        String string = "EventListenerList: ";
        string = string + objectArray.length / 2 + " listeners: ";
        for (int i2 = 0; i2 <= objectArray.length - 2; i2 += 2) {
            string = string + " type " + ((Class)objectArray[i2]).getName();
            string = string + " listener " + objectArray[i2 + 1];
        }
        return string;
    }
}

