/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.impl;

import com.sun.java.help.impl.MyBufferedReader;
import com.sun.java.help.impl.ScanBuffer;
import com.sun.java.help.impl.TagProperties;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

public abstract class DocumentParser {
    static final char EOF = '\uffff';
    protected Reader source;
    int readOffset;
    ScanBuffer buffer;
    ScanBuffer escapeBuffer;
    ScanBuffer documentSource;
    boolean shouldCacheSource;
    Hashtable entities;
    int defaultCharBufferSize = 8192;
    char[] cb = new char[this.defaultCharBufferSize];
    int mySize = 0;
    int myCount = 0;

    public DocumentParser(InputStream inputStream) {
        this.source = new MyBufferedReader(new InputStreamReader(inputStream));
        this.init();
    }

    public DocumentParser(Reader reader) {
        this.source = reader instanceof MyBufferedReader ? reader : new MyBufferedReader(reader);
        this.init();
    }

    public void setInput(Reader reader) {
        this.source = reader instanceof MyBufferedReader ? reader : new MyBufferedReader(reader);
    }

    public void setInput(InputStream inputStream, String string) throws UnsupportedEncodingException {
        if (inputStream == null) {
            this.source = null;
            return;
        }
        this.source = new MyBufferedReader(new InputStreamReader(inputStream, string));
    }

    public void setShouldCacheSource(boolean bl) {
        this.shouldCacheSource = bl;
    }

    public String getDocumentSource() {
        if (!this.shouldCacheSource) {
            return null;
        }
        int n2 = 0 == this.documentSource.length() ? 0 : this.documentSource.length() - 1;
        return new String(this.documentSource.buf, 0, n2) + "\n";
    }

    public void parse() throws IOException {
        int n2 = 65535;
        this.buffer.clear();
        if (this.source != null) {
            n2 = this.readChar();
        }
        while (n2 != 65535) {
            if (n2 == 38) {
                n2 = this.parseEscape();
                continue;
            }
            if (n2 == 60) {
                this.buffer.flush(this);
                n2 = this.parseTag();
                continue;
            }
            if (this.buffer.buflen >= this.buffer.buf.length) {
                char[] cArray = new char[this.buffer.buf.length * this.buffer.scale];
                System.arraycopy(this.buffer.buf, 0, cArray, 0, this.buffer.buf.length);
                this.buffer.buf = cArray;
            }
            if (n2 != 13) {
                this.buffer.buf[this.buffer.buflen++] = n2;
            }
            if (this.myCount >= this.mySize) {
                try {
                    this.mySize = this.source.read(this.cb, 0, this.defaultCharBufferSize);
                    if (this.mySize < 0) break;
                    if (this.mySize == 0) {
                        System.err.println(" DocumentParser::parse() !!!ERROR !!! source.read(...) == 0");
                        break;
                    }
                    this.myCount = 0;
                }
                catch (CharConversionException charConversionException) {
                    throw charConversionException;
                }
                catch (IOException iOException) {
                    break;
                }
            }
            if (this.shouldCacheSource) {
                this.documentSource.add(this.cb[this.myCount]);
            }
            n2 = this.cb[this.myCount++];
        }
        this.buffer.flush(this);
    }

    public void parseText() throws IOException {
        this.tag("PRE", null, false, false);
        this.buffer.clear();
        char c2 = this.readChar();
        while (c2 != '\uffff') {
            this.buffer.add(c2);
            c2 = this.readChar();
        }
        this.buffer.flush(this);
    }

    protected void callFlush(char[] cArray, int n2, int n3) {
        this.flush(cArray, n2, n3);
    }

    protected abstract void flush(char[] var1, int var2, int var3);

    protected abstract void comment(String var1);

    protected abstract void tag(String var1, TagProperties var2, boolean var3, boolean var4);

    protected abstract void pi(String var1, String var2);

    protected abstract void doctype(String var1, String var2, String var3);

    protected abstract String documentAttribute(String var1);

    protected abstract void errorString(String var1);

    private void init() {
        this.buffer = new ScanBuffer(8192, 4);
        this.escapeBuffer = new ScanBuffer(8192, 4);
        this.documentSource = new ScanBuffer(8192, 4);
        this.readOffset = 0;
    }

    protected void findCloseAngleForComment(char c2) throws IOException {
        this.buffer.add(c2);
        while ((c2 = this.readChar()) != '>') {
            this.buffer.add(c2);
        }
        this.buffer.add(c2);
        this.comment(this.buffer.extract(0));
        this.buffer.clear();
    }

    protected char handleCommentOrDoctype(char c2) throws IOException {
        this.buffer.add(c2);
        int n2 = this.buffer.length();
        c2 = this.scanIdentifier(c2);
        String string = this.buffer.extract(n2);
        if (!string.equals("DOCTYPE")) {
            this.findCloseAngleForComment(c2);
            return this.readChar();
        }
        c2 = this.skipWhite(c2);
        n2 = this.buffer.length();
        c2 = this.scanIdentifier(c2);
        String string2 = this.buffer.extract(n2);
        if ((c2 = this.skipWhite(c2)) == '>') {
            this.buffer.clear();
            return this.readChar();
        }
        n2 = this.buffer.length();
        c2 = this.scanIdentifier(c2);
        string = this.buffer.extract(n2);
        String string3 = null;
        String string4 = null;
        if (string.equals("SYSTEM")) {
            c2 = this.skipWhite(c2);
            n2 = this.buffer.length();
            c2 = this.scanQuotedString(c2);
            string4 = this.buffer.extract(n2);
            this.doctype(string2, null, string4);
            if (c2 != '>') {
                this.findCloseAngleForComment(c2);
            }
            this.buffer.clear();
            return this.readChar();
        }
        if (string.equals("PUBLIC")) {
            c2 = this.skipWhite(c2);
            n2 = this.buffer.length();
            c2 = this.scanQuotedString(c2);
            string3 = this.buffer.extract(n2);
            c2 = this.skipWhite(c2);
            n2 = this.buffer.length();
            c2 = this.scanQuotedString(c2);
            string4 = this.buffer.extract(n2);
            this.doctype(string2, string3, string4);
            if (c2 != '>') {
                this.findCloseAngleForComment(c2);
            }
            this.buffer.clear();
            return this.readChar();
        }
        if (c2 != '>') {
            this.findCloseAngleForComment(c2);
        }
        this.findCloseAngleForComment(c2);
        this.doctype(string2, null, null);
        this.buffer.clear();
        return this.readChar();
    }

    protected void setXmlEntities(TagProperties tagProperties) {
    }

    protected char parseTag() throws IOException {
        boolean bl;
        boolean bl2;
        int n2;
        this.buffer.clear();
        boolean bl3 = false;
        char c2 = '<';
        this.buffer.add('<');
        c2 = this.readChar();
        if (c2 == '!') {
            n2 = 0;
            this.buffer.add('!');
            c2 = this.readChar();
            if (c2 != '-') {
                return this.handleCommentOrDoctype(c2);
            }
            this.buffer.add(c2);
            c2 = this.readChar();
            if (c2 != '-') {
                this.findCloseAngleForComment(c2);
                return this.readChar();
            }
            this.buffer.add(c2);
            n2 = this.buffer.length();
            int n3 = 0;
            while (true) {
                if ((c2 = this.readChar()) == '\uffff') {
                    this.commentEOFError(n2);
                    break;
                }
                if (c2 != '-') {
                    this.buffer.add(c2);
                    continue;
                }
                while (c2 == '-') {
                    this.buffer.add(c2);
                    ++n3;
                    c2 = this.readChar();
                }
                if (c2 == '\uffff') {
                    this.commentEOFError(n2);
                    break;
                }
                this.buffer.add(c2);
                if (n3 >= 2 && c2 == '>') {
                    this.comment(this.buffer.extract(0));
                    this.buffer.clear();
                    return this.readChar();
                }
                n3 = 0;
            }
        }
        if (c2 == '?') {
            n2 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            this.buffer.add('?');
            while ((c2 = this.readChar()) != '\"' && c2 != ' ' && c2 != '\t' && c2 != '\n' && c2 != '>') {
                this.buffer.add(c2);
                stringBuffer.append(c2);
            }
            if (!stringBuffer.toString().equals("xml")) {
                this.buffer.clear();
                while ((c2 = this.readChar()) != '?' && c2 != '\uffff') {
                    this.buffer.add(c2);
                }
                if (c2 == '\uffff') {
                    this.eofError();
                    return this.readChar();
                }
                c2 = this.readChar();
                if (c2 != '>' && c2 != '\uffff') {
                    this.buffer.add('?');
                    this.buffer.add(c2);
                }
                if (c2 == '\uffff') {
                    this.eofError();
                    return this.readChar();
                }
                this.pi(stringBuffer.toString(), this.buffer.extract(0));
                return this.readChar();
            }
            stringBuffer = null;
            c2 = this.readChar();
            TagProperties tagProperties = null;
            while (true) {
                String string;
                if ((c2 = this.skipWhite(c2)) == '\uffff') {
                    this.eofError();
                    return c2;
                }
                if (c2 == '?') break;
                int n4 = this.buffer.length();
                c2 = this.scanIdentifier(c2);
                if (n4 == this.buffer.length()) {
                    this.error("Expecting an attribute");
                    this.skipToCloseAngle(c2);
                    return this.readChar();
                }
                String string2 = this.buffer.extract(n4);
                c2 = this.skipWhite(c2);
                if (tagProperties == null) {
                    tagProperties = new TagProperties();
                }
                if (c2 == '=') {
                    int n5;
                    this.buffer.add(c2);
                    c2 = this.readChar();
                    c2 = this.skipWhite(c2);
                    if (c2 == '?' || c2 == '<') {
                        string = "";
                    } else if (c2 == '\"') {
                        this.buffer.add(c2);
                        n5 = this.buffer.length();
                        while (true) {
                            if ((c2 = this.readChar()) == '\uffff') {
                                this.eofError();
                                return c2;
                            }
                            if (c2 == '\"') break;
                            if (c2 == '&') {
                                c2 = this.parseEscape();
                            }
                            this.buffer.add(c2);
                        }
                        string = this.buffer.extract(n5);
                        this.buffer.add(c2);
                        c2 = this.readChar();
                    } else {
                        n5 = this.buffer.length();
                        this.buffer.add(c2);
                        while (true) {
                            if ((c2 = this.readChar()) == '\uffff') {
                                this.eofError();
                                return c2;
                            }
                            if (c2 == 34 || c2 == 32 || c2 == 9 || c2 == 10 || c2 == '?') break;
                            if (c2 == '&') {
                                c2 = this.parseEscape();
                            }
                            this.buffer.add(c2);
                        }
                        string = this.buffer.extract(n5);
                    }
                } else {
                    string = "true";
                }
                tagProperties.put(string2, string);
            }
            c2 = this.readChar();
            if (c2 == '\uffff') {
                this.eofError();
                return this.readChar();
            }
            c2 = this.skipWhite(c2);
            this.buffer.add(c2);
            if (c2 == '>') {
                this.setXmlEntities(tagProperties);
                this.buffer.clear();
                return this.readChar();
            }
            this.error("Expecting ?>");
            this.skipToCloseAngle(c2);
            return this.readChar();
        }
        if ((c2 = this.skipWhite(c2)) == '\uffff') {
            this.eofError();
            return c2;
        }
        if (c2 == '/') {
            this.buffer.add(c2);
            c2 = this.skipWhite(this.readChar());
            bl2 = true;
            bl = false;
        } else {
            bl2 = false;
            bl = false;
        }
        int n6 = this.buffer.length();
        c2 = this.scanIdentifier(c2);
        String string = this.buffer.extract(n6);
        TagProperties tagProperties = null;
        while (true) {
            String string3;
            if ((c2 = this.skipWhite(c2)) == '\uffff') {
                this.eofError();
                return c2;
            }
            if (c2 == '>') break;
            if (c2 == '/') {
                this.buffer.add(c2);
                c2 = this.readChar();
                if (c2 == '>') {
                    bl2 = true;
                    bl = true;
                    break;
                }
                this.error("Expecting />");
                this.skipToCloseAngle(c2);
                return this.readChar();
            }
            if (c2 == '<') {
                this.tag(string, tagProperties, bl2, false);
                this.buffer.clear();
                return '<';
            }
            n6 = this.buffer.length();
            c2 = this.scanIdentifier(c2);
            if (n6 == this.buffer.length()) {
                this.error("Expecting an attribute (2)");
                this.skipToCloseAngle(c2);
                return this.readChar();
            }
            String string4 = this.buffer.extract(n6);
            c2 = this.skipWhite(c2);
            if (tagProperties == null) {
                tagProperties = new TagProperties();
            }
            if (c2 == '=') {
                int n7;
                this.buffer.add(c2);
                c2 = this.readChar();
                c2 = this.skipWhite(c2);
                if (c2 == '>' || c2 == '<') {
                    string3 = "";
                } else if (c2 == '\"') {
                    this.buffer.add(c2);
                    n7 = this.buffer.length();
                    while (true) {
                        if ((c2 = this.readChar()) == '\uffff') {
                            this.eofError();
                            return c2;
                        }
                        if (c2 == '\"') break;
                        if (c2 == '&') {
                            c2 = this.parseEscape();
                        }
                        this.buffer.add(c2);
                    }
                    string3 = this.buffer.extract(n7);
                    this.buffer.add(c2);
                    c2 = this.readChar();
                } else {
                    n7 = this.buffer.length();
                    this.buffer.add(c2);
                    while (true) {
                        if ((c2 = this.readChar()) == '\uffff') {
                            this.eofError();
                            return c2;
                        }
                        if (c2 == 34 || c2 == 32 || c2 == 9 || c2 == 10 || c2 == '>') break;
                        if (c2 == '&') {
                            c2 = this.parseEscape();
                        }
                        this.buffer.add(c2);
                    }
                    string3 = this.buffer.extract(n7);
                }
            } else {
                string3 = "true";
            }
            tagProperties.put(string4, string3);
        }
        this.tag(string, tagProperties, bl2, bl);
        this.buffer.clear();
        return this.readChar();
    }

    protected char parseEscape() throws IOException {
        char c2;
        block17: {
            int n2;
            block18: {
                block19: {
                    block15: {
                        block16: {
                            n2 = this.buffer.length();
                            this.buffer.add('&');
                            c2 = this.readChar();
                            if (c2 == '\uffff') {
                                this.generateError(n2);
                                return c2;
                            }
                            if (c2 != '#') break block16;
                            int n3 = 0;
                            while (true) {
                                if ((c2 = this.readChar()) == '\uffff') {
                                    this.generateError(n2);
                                    return c2;
                                }
                                if (c2 == ';') {
                                    c2 = '\u0000';
                                    break;
                                }
                                if (!Character.isDigit(c2)) {
                                    if (n3 > 0) break;
                                    this.error("Expecting a digit");
                                    this.generateError(n2);
                                    return c2;
                                }
                                this.buffer.add(c2);
                                n3 = n3 * 10 + Character.digit(c2, 10);
                            }
                            this.buffer.reset(n2);
                            this.buffer.add((char)n3);
                            break block17;
                        }
                        if (!Character.isLowerCase(c2) && !Character.isUpperCase(c2)) break block18;
                        if (this.entities == null) {
                            this.initEntities();
                        }
                        this.escapeBuffer.clear();
                        this.escapeBuffer.add(c2);
                        do {
                            this.buffer.add(c2);
                            c2 = this.readChar();
                            if (c2 == '\uffff') {
                                this.generateError(n2);
                                return c2;
                            }
                            if (!Character.isLowerCase(c2) && !Character.isUpperCase(c2)) break block15;
                            this.escapeBuffer.add(c2);
                        } while (this.entities.get(this.escapeBuffer.extract(0)) == null);
                        c2 = this.readChar();
                        if (c2 == ';') {
                            c2 = '\u0000';
                        }
                        break block19;
                    }
                    if (c2 == ';') {
                        c2 = '\u0000';
                    } else {
                        this.error("Expecting a letter");
                        this.generateError(n2);
                        return c2;
                    }
                }
                String string = this.escapeBuffer.extract(0);
                this.buffer.reset(n2);
                Character c3 = (Character)this.entities.get(string);
                if (c3 != null) {
                    return c3.charValue();
                }
                String string2 = this.documentAttribute(string);
                if (string2 != null) {
                    for (int i2 = 0; i2 < string2.length(); ++i2) {
                        this.buffer.add(string2.charAt(i2));
                    }
                }
                break block17;
            }
            this.error("Expecting a letter o");
            this.generateError(n2);
            return c2;
        }
        if (c2 != '\u0000') {
            return c2;
        }
        return this.readChar();
    }

    protected void initEntities() {
        this.entities = new Hashtable();
        this.entities.put("quot", new Character('\"'));
        this.entities.put("amp", new Character('&'));
        this.entities.put("gt", new Character('>'));
        this.entities.put("lt", new Character('<'));
        this.entities.put("nbsp", new Character('\u00a0'));
        this.entities.put("copy", new Character('\u00a9'));
        this.entities.put("Agrave", new Character('\u00c0'));
        this.entities.put("Aacute", new Character('\u00c1'));
        this.entities.put("Acirc", new Character('\u00c2'));
        this.entities.put("Atilde", new Character('\u00c3'));
        this.entities.put("Auml", new Character('\u00c4'));
        this.entities.put("Aring", new Character('\u00c5'));
        this.entities.put("AElig", new Character('\u00c6'));
        this.entities.put("Ccedil", new Character('\u00c7'));
        this.entities.put("Egrave", new Character('\u00c8'));
        this.entities.put("Eacute", new Character('\u00c9'));
        this.entities.put("Ecirc", new Character('\u00ca'));
        this.entities.put("Euml", new Character('\u00cb'));
        this.entities.put("Igrave", new Character('\u00cc'));
        this.entities.put("Iacute", new Character('\u00cd'));
        this.entities.put("Icirc", new Character('\u00ce'));
        this.entities.put("Iuml", new Character('\u00cf'));
        this.entities.put("Ntilde", new Character('\u00d1'));
        this.entities.put("Ograve", new Character('\u00d2'));
        this.entities.put("Oacute", new Character('\u00d3'));
        this.entities.put("Ocirc", new Character('\u00d4'));
        this.entities.put("Otilde", new Character('\u00d5'));
        this.entities.put("Ouml", new Character('\u00d6'));
        this.entities.put("Oslash", new Character('\u00d8'));
        this.entities.put("Ugrave", new Character('\u00d9'));
        this.entities.put("Uacute", new Character('\u00da'));
        this.entities.put("Ucirc", new Character('\u00db'));
        this.entities.put("Uuml", new Character('\u00dc'));
        this.entities.put("Yacute", new Character('\u00dd'));
        this.entities.put("THORN", new Character('\u00de'));
        this.entities.put("szlig", new Character('\u00df'));
        this.entities.put("agrave", new Character('\u00e0'));
        this.entities.put("aacute", new Character('\u00e1'));
        this.entities.put("acirc", new Character('\u00e2'));
        this.entities.put("atilde", new Character('\u00e3'));
        this.entities.put("auml", new Character('\u00e4'));
        this.entities.put("aring", new Character('\u00e5'));
        this.entities.put("aelig", new Character('\u00e6'));
        this.entities.put("ccedil", new Character('\u00e7'));
        this.entities.put("egrave", new Character('\u00e8'));
        this.entities.put("eacute", new Character('\u00e9'));
        this.entities.put("ecirc", new Character('\u00ea'));
        this.entities.put("euml", new Character('\u00eb'));
        this.entities.put("igrave", new Character('\u00ec'));
        this.entities.put("iacute", new Character('\u00ed'));
        this.entities.put("icirc", new Character('\u00ee'));
        this.entities.put("iuml", new Character('\u00ef'));
        this.entities.put("eth", new Character('\u00f0'));
        this.entities.put("ntilde", new Character('\u00f1'));
        this.entities.put("ograve", new Character('\u00f2'));
        this.entities.put("oacute", new Character('\u00f3'));
        this.entities.put("ocirc", new Character('\u00f4'));
        this.entities.put("otilde", new Character('\u00f5'));
        this.entities.put("ouml", new Character('\u00f6'));
        this.entities.put("oslash", new Character('\u00f8'));
        this.entities.put("ugrave", new Character('\u00f9'));
        this.entities.put("uacute", new Character('\u00fa'));
        this.entities.put("ucirc", new Character('\u00fb'));
        this.entities.put("uuml", new Character('\u00fc'));
        this.entities.put("yacute", new Character('\u00fd'));
        this.entities.put("thorn", new Character('\u00fe'));
        this.entities.put("yuml", new Character('\u00ff'));
    }

    protected char scanIdentifier(char c2) throws IOException {
        while (c2 == '_' || c2 == ':' || c2 >= '0' && c2 <= '9' || Character.isLetter(c2)) {
            if (this.buffer.buflen >= this.buffer.buf.length) {
                char[] cArray = new char[this.buffer.buf.length * this.buffer.scale];
                System.arraycopy(this.buffer.buf, 0, cArray, 0, this.buffer.buf.length);
                this.buffer.buf = cArray;
            }
            this.buffer.buf[this.buffer.buflen++] = c2;
            if (this.myCount >= this.mySize) {
                try {
                    this.mySize = this.source.read(this.cb, 0, this.defaultCharBufferSize);
                    if (this.mySize < 0) break;
                    if (this.mySize == 0) {
                        System.err.println(" DocumentParser::scanIdentifier() !!!ERROR !!! source.read(...) == 0");
                        break;
                    }
                    this.myCount = 0;
                }
                catch (CharConversionException charConversionException) {
                    throw charConversionException;
                }
                catch (IOException iOException) {
                    break;
                }
            }
            if (this.shouldCacheSource) {
                this.documentSource.add(this.cb[this.myCount]);
            }
            c2 = this.cb[this.myCount++];
        }
        return c2;
    }

    protected char scanQuotedString(char c2) throws IOException {
        if ((c2 = this.skipWhite(c2)) == '\"') {
            while ((c2 = this.readChar()) != '\"' && c2 != '>') {
                this.buffer.add(c2);
            }
            return this.readChar();
        }
        if (c2 == '\'') {
            while ((c2 = this.readChar()) != '\'' && c2 != '>') {
                this.buffer.add(c2);
            }
            return this.readChar();
        }
        return c2;
    }

    protected char skipWhite(char c2) throws IOException {
        while (c2 == ' ' || c2 == '\r' || c2 == '\t' || c2 == '\n') {
            if (this.buffer.buflen >= this.buffer.buf.length) {
                char[] cArray = new char[this.buffer.buf.length * this.buffer.scale];
                System.arraycopy(this.buffer.buf, 0, cArray, 0, this.buffer.buf.length);
                this.buffer.buf = cArray;
            }
            this.buffer.buf[this.buffer.buflen++] = c2;
            if (this.myCount >= this.mySize) {
                try {
                    this.mySize = this.source.read(this.cb, 0, this.defaultCharBufferSize);
                    if (this.mySize < 0) break;
                    if (this.mySize == 0) {
                        System.err.println(" DocumentParser::parse() !!!ERROR !!! source.read(...) == 0");
                        break;
                    }
                    this.myCount = 0;
                }
                catch (CharConversionException charConversionException) {
                    throw charConversionException;
                }
                catch (IOException iOException) {
                    break;
                }
            }
            if (this.shouldCacheSource) {
                this.documentSource.add(this.cb[this.myCount]);
            }
            c2 = this.cb[this.myCount++];
        }
        return c2;
    }

    protected char readChar() throws IOException {
        if (this.myCount >= this.mySize) {
            try {
                this.mySize = this.source.read(this.cb, 0, this.defaultCharBufferSize);
                if (this.mySize < 0) {
                    return '\uffff';
                }
                if (this.mySize == 0) {
                    System.err.println(" DocumentParser::readChar() !!!ERROR !!! source.read(...) == 0");
                    return '\uffff';
                }
                this.myCount = 0;
            }
            catch (CharConversionException charConversionException) {
                throw charConversionException;
            }
            catch (IOException iOException) {
                return '\uffff';
            }
        }
        if (this.shouldCacheSource) {
            this.documentSource.add(this.cb[this.myCount]);
        }
        return this.cb[this.myCount++];
    }

    protected void skipToCloseAngle(char c2) throws IOException {
        while (true) {
            if (this.buffer.buflen >= this.buffer.buf.length) {
                char[] cArray = new char[this.buffer.buf.length * this.buffer.scale];
                System.arraycopy(this.buffer.buf, 0, cArray, 0, this.buffer.buf.length);
                this.buffer.buf = cArray;
            }
            this.buffer.buf[this.buffer.buflen++] = c2;
            if (c2 == '>') break;
            if (this.myCount >= this.mySize) {
                try {
                    this.mySize = this.source.read(this.cb, 0, this.defaultCharBufferSize);
                    if (this.mySize < 0) break;
                    if (this.mySize == 0) {
                        System.err.println(" DocumentParser::skipToCloseAngle() !!!ERROR !!! source.read(...) == 0");
                        break;
                    }
                    this.myCount = 0;
                }
                catch (CharConversionException charConversionException) {
                    throw charConversionException;
                }
                catch (IOException iOException) {
                    break;
                }
            }
            c2 = this.cb[this.myCount++];
        }
        this.generateError(0);
    }

    protected void generateError(int n2) {
        String string = this.buffer.extract(n2);
        this.buffer.reset(n2);
        this.buffer.flush(this);
        this.errorString(string);
    }

    protected void commentEOFError(int n2) {
        this.eofError();
    }

    protected void eofError() {
        this.error("Unexpected end of file");
        this.generateError(0);
    }

    void error(String string) {
        System.err.println("DocumentParser Error: " + string);
    }
}

