/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import java.io.PrintStream;

class IntegerArray {
    private int[] _array;
    private int _size;
    private int _free = 0;
    private static final int InitialSize = 128;

    public IntegerArray() {
        this._size = 128;
        this._array = new int[128];
    }

    public IntegerArray(int n2) {
        this._size = n2;
        this._array = new int[this._size];
    }

    public void clear() {
        this._free = 0;
    }

    public int at(int n2) {
        return this._array[n2];
    }

    public void add(int n2) {
        if (this._free == this._size) {
            this.growArray(this._size * 2);
        }
        this._array[this._free++] = n2;
    }

    private void growArray(int n2) {
        this._size = n2;
        int[] nArray = new int[this._size];
        System.arraycopy(this._array, 0, nArray, 0, this._free);
        this._array = nArray;
    }

    public int popLast() {
        return this._array[--this._free];
    }

    public int cardinality() {
        return this._free;
    }

    public void toDifferences(IntegerArray integerArray) {
        if (integerArray._size < this._size) {
            integerArray.growArray(this._size);
        }
        if ((integerArray._free = this._free) > 0) {
            integerArray._array[0] = this._array[0];
            for (int i2 = 1; i2 < this._free; ++i2) {
                integerArray._array[i2] = this._array[i2] - this._array[i2 - 1];
            }
        }
    }

    public int indexOf(int n2) {
        int n3 = 0;
        int n4 = this._free;
        while (n3 <= n4) {
            int n5 = (n3 + n4) / 2;
            if (this._array[n5] < n2) {
                n3 = n5 + 1;
                continue;
            }
            if (n2 < this._array[n5]) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -1;
    }

    public void print(PrintStream printStream) {
        for (int i2 = 0; i2 < this._free - 1; ++i2) {
            printStream.print(this._array[i2]);
            printStream.print(' ');
        }
        printStream.println(this._array[this._free - 1]);
    }
}

