/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.Rule;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class LiteMorph {
    protected static Vector variants;
    protected static Hashtable rulesTable;
    protected static Hashtable blockedVariants;
    protected static Hashtable exceptions;
    private static final boolean debugFlag = false;

    public LiteMorph() {
        this.initialize();
    }

    public static LiteMorph getMorph() {
        return null;
    }

    protected abstract void initialize();

    protected void initialize(String[] stringArray) {
        if (exceptions == null || stringArray == null) {
            return;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i2], " ");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                String string2 = (String)exceptions.get(string);
                if (string2 == null) {
                    exceptions.put(string, stringArray[i2]);
                    continue;
                }
                exceptions.put(string, string2 + " " + stringArray[i2]);
            }
        }
    }

    public synchronized String[] variantsOf(String string) {
        variants = new Vector();
        blockedVariants = new Hashtable();
        blockedVariants.put(string, string);
        this.morphWord(string, 0);
        blockedVariants = null;
        Object[] objectArray = new String[variants.size()];
        variants.copyInto(objectArray);
        variants = null;
        return objectArray;
    }

    protected void morphWord(String string, int n2) {
        LiteMorph.debug(" analyzing: " + string + " at depth " + n2);
        if (n2 > 2) {
            return;
        }
        String string2 = (String)exceptions.get(string);
        if (string2 == null) {
            string2 = "";
        }
        if (string2.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
            while (stringTokenizer.hasMoreTokens()) {
                this.addVariant(stringTokenizer.nextToken());
            }
            LiteMorph.debug("   " + string + ": found match in exceptions -- " + string2 + ", at depth " + n2);
            return;
        }
        if (string.indexOf("-") >= 0) {
            return;
        }
        Rule[] ruleArray = null;
        int n3 = 0;
        Enumeration enumeration = rulesTable.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (!string.endsWith(string3) || string3.equals("default")) continue;
            ruleArray = (Rule[])rulesTable.get(string3);
            n3 = string3.length();
            break;
        }
        if (ruleArray == null) {
            ruleArray = (Rule[])rulesTable.get("default");
            n3 = 0;
        }
        for (int i2 = 0; i2 < ruleArray.length; ++i2) {
            LiteMorph.debug("  " + string + ": trying rule: " + ruleArray[i2] + ", at depth " + n2);
            String[] stringArray = ruleArray[i2].match(string, n2, n3);
            if (stringArray.length <= 0) continue;
            LiteMorph.debug("  " + string + ": found match for: " + ruleArray[i2] + ", at depth " + n2);
            this.addVariant(string);
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                this.addVariant(stringArray[i3]);
            }
            break;
        }
    }

    private void addVariant(String string) {
        if (blockedVariants.get(string) == null) {
            variants.addElement(string);
            blockedVariants.put(string, string);
        }
    }

    protected static Rule r(String string, String string2, LiteMorph liteMorph) {
        return new Rule(string, string2, liteMorph);
    }

    private static void debug(String string) {
    }
}

