/*
 * Decompiled with CFR 0.152.
 */
package de.humatic.dsj.rc;

import de.humatic.dsj.DSFiltergraph;
import de.humatic.dsj.DSJException;
import de.humatic.dsj.rc.D3D9Controls;
import de.humatic.dsj.rc.DSRendererControls;
import de.humatic.dsj.rc.DirectDrawControls;
import de.humatic.dsj.rc.EVRControls;
import de.humatic.dsj.rc.J2DControls;
import de.humatic.dsj.rc.VMRControls;
import java.awt.Color;
import java.awt.image.BufferedImage;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class RendererControls {
    DSFiltergraph a;
    int[] a;
    public static final int CONTRAST = 0;
    public static final int BRIGHTNESS = 1;
    public static final int HUE = 2;
    public static final int SATURATION = 3;
    public static int IMG = 1;
    public static final int DDR = 0;
    public static final int D3D9 = 1;
    public static final int J2D = 2;
    public static final int VMR = 32;
    public static final int NVR = 64;
    public static final int EVR = 128;
    public int type;
    int a = new int[8];

    RendererControls() {
    }

    RendererControls(DSFiltergraph dSFiltergraph) {
        this.a = dSFiltergraph;
    }

    public static RendererControls getControls(DSFiltergraph dSFiltergraph) {
        int n2 = dSFiltergraph.getOutFlags() & 0xFF;
        RendererControls rendererControls = null;
        if (!dSFiltergraph.hasMediaOfType(0)) {
            rendererControls = new J2DControls(dSFiltergraph);
        } else {
            switch (n2) {
                case 0: {
                    rendererControls = new DirectDrawControls(dSFiltergraph);
                    break;
                }
                case 1: {
                    rendererControls = new D3D9Controls(dSFiltergraph);
                    break;
                }
                case 2: {
                    rendererControls = new J2DControls(dSFiltergraph);
                    break;
                }
                case 32: {
                    rendererControls = new VMRControls(dSFiltergraph);
                    break;
                }
                case 16: 
                case 64: {
                    rendererControls = new DSRendererControls(dSFiltergraph);
                    break;
                }
                case 144: {
                    rendererControls = new EVRControls(dSFiltergraph);
                    break;
                }
                default: {
                    throw new DSJException("Renderer has no controls", -505);
                }
            }
        }
        return rendererControls;
    }

    public void setFlags(int n2) {
    }

    public int getFlags() {
        return this.a;
    }

    public synchronized boolean setOverlayImage(BufferedImage bufferedImage, int[] nArray, Color color, float f2) throws DSJException {
        return false;
    }

    public void setOutputRect(int n2, int n3, int n4, int n5, int n6) throws DSJException {
    }

    public void displayResized(int n2, int n3, int n4, int n5) {
    }

    public int[] getRendererStatistics() throws DSJException {
        return null;
    }

    native boolean nativeSetOverlay(long var1, DSFiltergraph var3, byte[] var4, int[] var5, long var6, float var8, int var9, int var10);

    native int controlRenderer(long var1, int var3, int[] var4);
}

