/*
 * Decompiled with CFR 0.152.
 */
package de.humatic.dsj.util;

import de.humatic.dsj.DSJException;
import de.humatic.dsj.DSJUtils;
import de.humatic.dsj.util.Atom;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class AtomParser {
    private File a;
    private RandomAccessFile a;
    public static String[] ftypes = new String[]{"3g2a", "3ge6", "3gg6", "3gp4", "3gp5", "3gp6", "3gr6", "3gs6", "CAEP", "CDes", "M4A ", "M4B ", "M4P ", "M4V ", "MPPI", "ROSS", "avc1", "caqv", "da0a", "da0b", "da1a", "da1b", "da2a", "da2b", "da3a", "da3b", "dmb1", "dv1a", "dv1b", "dv2a", "dv2b", "dv3a", "dv3b", "dvr1", "dvt1", "isc2", "iso2", "iso3", "iso4", "isom", "mj2s", "mjp2", "mp21", "mp41", "mp42", "mp71", "niko", "odcf", "opf2", "opx2", "pana", "qt  ", "sdv "};

    private AtomParser(String string) {
    }

    private AtomParser(String string, File file) throws IOException {
        this.a = file;
        this.a = new RandomAccessFile(this.a, "r");
    }

    public static AtomParser createForType(String string) throws DSJException {
        if (AtomParser.a(string)) {
            return new AtomParser(string);
        }
        throw new DSJException("AtomParser - undefined type: " + string, -5);
    }

    public static AtomParser createForFile(File file) throws IOException {
        Object object = new FileInputStream(file);
        byte[] byArray = new byte[12];
        ((FileInputStream)object).read(byArray);
        ((FileInputStream)object).close();
        object = DSJUtils.toFCC_BE(DSJUtils.readInt(byArray, 8));
        int n2 = ((String)object).length();
        if (((String)object).length() < 4) {
            while (n2 < 4) {
                object = (String)object + " ";
                ++n2;
            }
        }
        if (AtomParser.a((String)object)) {
            return new AtomParser((String)object, file);
        }
        throw new DSJException("AtomParser - undefined type: " + (String)object, -5);
    }

    private static boolean a(String string) {
        for (int i2 = 0; i2 < ftypes.length; ++i2) {
            if (!string.equalsIgnoreCase(ftypes[i2])) continue;
            return true;
        }
        return false;
    }

    public void close() {
        if (this.a != null) {
            try {
                this.a.close();
            }
            catch (Exception exception) {}
            this.a = null;
        }
    }

    protected void finalize() {
        if (this.a != null) {
            try {
                this.a.close();
            }
            catch (Exception exception) {}
            this.a = null;
        }
    }

    public Atom getAtom(String string, byte[] byArray, int n2) {
        int n3 = DSJUtils.findFCC(byArray, n2, string, true);
        if (n3 < 0) {
            return null;
        }
        n2 = DSJUtils.readInt(byArray, n3 - 4);
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n3 - 4, byArray2, 0, n2);
        return new Atom(null, n3, n2, string, byArray2);
    }

    public Atom getAtom(String string, int n2) throws Exception {
        if (this.a == null) {
            throw new NullPointerException();
        }
        int n3 = 0;
        this.a.seek(n2);
        Object object = null;
        object = null;
        while (n3 == 0 && (n3 = AtomParser.a(this.a) - 8) >= 0) {
            int n4;
            int n5 = AtomParser.a(this.a);
            if (n3 > 16384 && n5 != DSJUtils.subTypeFromFCC("free", true)) {
                if (AtomParser.b(DSJUtils.toFCC_BE(n5))) {
                    object = new byte[16384];
                    for (n4 = 0; n4 < 16384; n4 += this.a.read((byte[])object, n4, 16384 - n4)) {
                    }
                    Atom atom = this.getAtom(string, new Atom(null, 0, 16384, n5, (byte[])object));
                    object = atom;
                    if (atom != null) {
                        return object;
                    }
                    n3 -= 16384;
                }
                object = "data not read".getBytes();
                this.a.skipBytes(n3);
            } else {
                object = new byte[n3];
                while (n4 < n3) {
                    n4 += this.a.read((byte[])object, n4, n3 - n4);
                }
            }
            if (DSJUtils.toFCC_BE(n5).equalsIgnoreCase(string)) {
                this.a.close();
                return new Atom(null, n2, n3 + 8, n5, (byte[])object);
            }
            Atom atom = new Atom(null, n2, n3 + 8, n5, (byte[])object);
            object = atom;
            if (atom.isContainer()) {
                Atom atom2 = this.getAtom(string, (Atom)object);
                object = atom2;
                if (atom2 != null) {
                    return object;
                }
            }
            n3 = (long)(n2 += n3 + 8) >= this.a.length() ? 1 : 0;
        }
        return null;
    }

    public Atom getAtom(String string, Atom atom) {
        int n2;
        String string2;
        if (atom.getType() == DSJUtils.subTypeFromFCC("stsd", true) && ((string2 = string).equalsIgnoreCase("gama") || string2.equalsIgnoreCase("fiel") || string2.equalsIgnoreCase("mjpt") || string2.equalsIgnoreCase("mjht") || string2.equalsIgnoreCase("esds") || string2.equalsIgnoreCase("pasp") || string2.equalsIgnoreCase("colr") || string2.equalsIgnoreCase("clap"))) {
            Atom atom2 = atom;
            string2 = string;
            int n3 = DSJUtils.findFCC_BE(atom2.getData(), string2);
            if (n3 < 0) {
                return null;
            }
            int n4 = DSJUtils.readInt(atom2.getData(), n3 - 4);
            byte[] byArray = new byte[n4 - 8];
            System.arraycopy(atom2.getData(), n3 + 4, byArray, 0, n4 - 8);
            return new Atom(atom2, n3 - 4, n4 - 8, DSJUtils.subTypeFromFCC(string2), byArray);
        }
        byte[] byArray = atom.getData();
        Atom atom3 = null;
        for (int i2 = 0; i2 < byArray.length && (n2 = DSJUtils.readInt(byArray, i2) - 8) >= 0; i2 += n2 + 8) {
            int n5 = DSJUtils.readInt(byArray, i2 + 4);
            Object object = null;
            if (n2 > 16384) {
                if (AtomParser.b(DSJUtils.toFCC_BE(n5))) {
                    object = new byte[Math.min(16384, byArray.length - (i2 + 8))];
                    System.arraycopy(byArray, i2 + 8, object, 0, ((byte[])object).length);
                    object = ((AtomParser)((Object)atom2)).getAtom(string, new Atom(atom, 0, ((byte[])object).length, n5, (byte[])object));
                    if (object != null) {
                        return object;
                    }
                    return null;
                }
                object = "data not read".getBytes();
            } else {
                object = new byte[n2];
                System.arraycopy(byArray, i2 + 8, object, 0, n2);
            }
            object = new Atom(atom, i2, n2 + 8, n5, (byte[])object);
            if (!DSJUtils.toFCC_BE(n5).equalsIgnoreCase(string)) continue;
            return object;
        }
        return atom3;
    }

    public void dump() throws Exception {
        if (this.a == null) {
            throw new NullPointerException();
        }
        int n2 = 0;
        int n3 = 0;
        while (n2 == 0 && (n2 = AtomParser.a(this.a) - 8) >= 0) {
            int n4 = AtomParser.a(this.a);
            byte[] byArray = null;
            if (n2 > 65536 && n4 != DSJUtils.subTypeFromFCC("free", true)) {
                byArray = "    skip".getBytes();
                this.a.skipBytes(n2);
            } else {
                byArray = new byte[n2];
                for (int i2 = 0; i2 < n2; i2 += this.a.read(byArray, i2, n2 - i2)) {
                }
            }
            Atom atom = new Atom(null, n3, n2 + 8, n4, byArray);
            DSJUtils.logln(atom.toString());
            if (atom.isContainer()) {
                this.a(atom, 1);
            }
            n2 = (long)(n3 += n2 + 8) >= this.a.length() ? 1 : 0;
        }
    }

    public void dump(byte[] byArray, int n2) throws Exception {
        int n3 = 0;
        while (n3 == 0 && (n3 = DSJUtils.readInt(byArray, n2) - 8) >= 0) {
            int n4 = DSJUtils.readInt(byArray, n2 + 4);
            byte[] byArray2 = null;
            if (n3 > 65536 || n3 > byArray.length) {
                byArray2 = "    skip".getBytes();
            } else {
                byArray2 = new byte[n3];
                System.arraycopy(byArray, n2 + 8, byArray2, 0, n3);
            }
            Atom atom = new Atom(null, n2, n3 + 8, n4, byArray2);
            DSJUtils.logln(atom.toString());
            if (atom.isContainer()) {
                this.a(atom, 1);
            }
            n3 = (n2 += n3 + 8) >= byArray.length ? 1 : 0;
        }
    }

    public void dump(Atom atom) {
        this.a(atom, 0);
    }

    private void a(Atom atom, int n2) {
        int n3;
        byte[] byArray = atom.getData();
        for (int i2 = 0; i2 < byArray.length && (n3 = DSJUtils.readInt(byArray, i2) - 8) >= 0; i2 += n3 + 8) {
            int n4 = DSJUtils.readInt(byArray, i2 + 4);
            byte[] byArray2 = null;
            if (n3 > 65536) {
                byArray2 = "data not read".getBytes();
            } else {
                byArray2 = new byte[n3];
                System.arraycopy(byArray, i2 + 8, byArray2, 0, n3);
            }
            Atom atom2 = new Atom(atom, i2, n3 + 8, n4, byArray2);
            for (int i3 = 0; i3 < n2; ++i3) {
                DSJUtils.log("   ");
            }
            DSJUtils.logln(atom2.toString());
            if (!atom2.isContainer()) continue;
            this.a(atom2, n2 + 1);
        }
    }

    private static int a(RandomAccessFile randomAccessFile) {
        try {
            int n2 = 0;
            for (int i2 = 0; i2 < 4; ++i2) {
                int n3 = randomAccessFile.read();
                n2 |= n3 << 8 * (3 - i2);
            }
            return n2;
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    private static boolean b(String string) {
        return string.equalsIgnoreCase("moov") || string.equalsIgnoreCase("clip") || string.equalsIgnoreCase("dinf") || string.equalsIgnoreCase("edts") || string.equalsIgnoreCase("matt") || string.equalsIgnoreCase("mdia") || string.equalsIgnoreCase("minf") || string.equalsIgnoreCase("tapt") || string.equalsIgnoreCase("stbl") || string.equalsIgnoreCase("trak") || string.equalsIgnoreCase("udta") || string.equalsIgnoreCase("mvex") || string.equalsIgnoreCase("moof") || string.equalsIgnoreCase("traf") || string.equalsIgnoreCase("mfra") || string.equalsIgnoreCase("meta") || string.equalsIgnoreCase("ipro") || string.equalsIgnoreCase("sinf") || string.equalsIgnoreCase("iinf") || string.equalsIgnoreCase("ilst") || string.equalsIgnoreCase("free");
    }
}

