/*
 * Decompiled with CFR 0.152.
 */
package fer.lss.lecto.encoder;

import fer.lss.lecto.LeCTo;
import fer.lss.lecto.constants.LinuxConstants;
import fer.lss.lecto.constants.MacOSXConstants;
import fer.lss.lecto.constants.WindowsConstants;
import fer.lss.lecto.encoder.FFMPEGEncoder;
import fer.lss.lecto.gui.LeCToLogFrame;
import fer.lss.lecto.gui.LeCToMainFrame;
import fer.lss.lecto.model.Lecture;
import fer.lss.lecto.model.LectureState;
import fer.lss.lecto.model.mediaoptions.VideoDeviceType;
import fer.lss.lecto.model.os.OperatingSystemFamily;
import fer.lss.lecto.services.MessagesService;
import fer.lss.lecto.services.usersettings.UserSettingsService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.JOptionPane;

public class FFMPEGSummoner
implements Callable<Boolean>,
Runnable {
    protected LeCToLogFrame logFrame;
    protected LeCToMainFrame mainFrame;
    protected List<FFMPEGEncoder> encoders;
    private Process runningProcess;
    private String ffmpegCommand;
    private String ffmpegPath;
    private int pauseCounter;

    public FFMPEGSummoner(List<FFMPEGEncoder> encoders) {
        this.encoders = encoders;
        this.pauseCounter = 0;
        this.setupFFMPEGCommand();
    }

    public LeCToMainFrame getMainFrame() {
        return this.mainFrame;
    }

    public void setMainFrame(LeCToMainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    private void setupFFMPEGCommand() {
        if (LeCTo.operatingSystem.getFamily() == OperatingSystemFamily.MAC) {
            return;
        }
        this.ffmpegCommand = new String();
        switch (LeCTo.operatingSystem.getFamily()) {
            case WINDOWS: {
                this.ffmpegPath = WindowsConstants.FFMPEGPath();
                break;
            }
            case LINUX: {
                this.ffmpegPath = LinuxConstants.FFMPEGPath();
                break;
            }
            case MAC: {
                this.ffmpegPath = MacOSXConstants.FFMPEGPath();
            }
        }
        StringBuilder sb = new StringBuilder(this.ffmpegPath);
        for (FFMPEGEncoder ffmpegEncoder : this.encoders) {
            if (!ffmpegEncoder.getMediaOptions().getHasVideo().booleanValue() && !ffmpegEncoder.getMediaOptions().getHasAudio().booleanValue()) continue;
            String outputFileName = String.valueOf(ffmpegEncoder.getMediaOptions().getFileFullPath()) + File.separator + ffmpegEncoder.getMediaOptions().getFileName() + "part" + this.pauseCounter + "." + ffmpegEncoder.getMediaOptions().getContainer();
            String videoInput = ffmpegEncoder.getMediaOptions().getVideoInput().getDeviceName();
            String audioInput = ffmpegEncoder.getMediaOptions().getAudioInput().getDeviceName();
            switch (LeCTo.operatingSystem.getFamily()) {
                case WINDOWS: {
                    sb.append(" -f dshow -i ");
                    if (ffmpegEncoder.getMediaOptions().getHasVideo().booleanValue()) {
                        sb.append("video=\"" + videoInput + "\"");
                        if (ffmpegEncoder.getMediaOptions().getHasAudio().booleanValue()) {
                            sb.append(":");
                        }
                    }
                    if (ffmpegEncoder.getMediaOptions().getHasAudio().booleanValue()) {
                        sb.append("audio=\"" + audioInput + "\"");
                    }
                    sb.append(" -threads 0 -preset " + ffmpegEncoder.getMediaOptions().getPreset() + " -tune zerolatency");
                    sb.append(" -b:v " + ffmpegEncoder.getMediaOptions().getVB() + "k");
                    sb.append(" -c:v " + ffmpegEncoder.getMediaOptions().getVideoCodec());
                    sb.append(" -r " + ffmpegEncoder.getMediaOptions().getFps());
                    if (ffmpegEncoder.getMediaOptions().getVideoCodec().contains("264")) {
                        sb.append(" -crf " + ffmpegEncoder.getMediaOptions().getCrf());
                    }
                    sb.append(" -vf scale=" + ffmpegEncoder.getMediaOptions().getResolution());
                    if (!ffmpegEncoder.getMediaOptions().getHasAudio().booleanValue()) break;
                    sb.append(" -b:a " + ffmpegEncoder.getMediaOptions().getAB() + "k");
                    sb.append(" -c:a " + ffmpegEncoder.getMediaOptions().getAudioCodec());
                    float samplingRate = new Float(ffmpegEncoder.getMediaOptions().getSamplingRate()).floatValue() * 1000.0f;
                    Integer intRate = new Float(samplingRate).intValue();
                    sb.append(" -ar " + intRate);
                    break;
                }
                case LINUX: {
                    if (ffmpegEncoder.getMediaOptions().getHasVideo().booleanValue()) {
                        if (ffmpegEncoder.getMediaOptions().getVideoInput().getVideoDeviceType() == VideoDeviceType.DESKTOP) {
                            sb.append(" -f x11grab -i :0.0");
                        } else {
                            sb.append(" -f video4linux2 -i /dev/" + ffmpegEncoder.getMediaOptions().getVideoInput().getDeviceName());
                        }
                    }
                    if (ffmpegEncoder.getMediaOptions().getHasAudio().booleanValue()) {
                        sb.append(" -f alsa -i hw:0," + ffmpegEncoder.getMediaOptions().getAudioInput().getDeviceIndex());
                    }
                    sb.append(" -preset " + ffmpegEncoder.getMediaOptions().getPreset());
                    sb.append(" -vcodec " + ffmpegEncoder.getMediaOptions().getVideoCodec());
                    sb.append(" -b:v " + ffmpegEncoder.getMediaOptions().getVB() + "k");
                    sb.append(" -r " + ffmpegEncoder.getMediaOptions().getFps());
                    if (ffmpegEncoder.getMediaOptions().getVideoCodec().contains("264")) {
                        sb.append(" -crf " + ffmpegEncoder.getMediaOptions().getCrf());
                    }
                    sb.append(" -video_size " + ffmpegEncoder.getMediaOptions().getResolution());
                    if (!ffmpegEncoder.getMediaOptions().getHasAudio().booleanValue()) break;
                    sb.append(" -b:a " + ffmpegEncoder.getMediaOptions().getAB() + "k");
                    sb.append(" -c:a " + ffmpegEncoder.getMediaOptions().getAudioCodec());
                    float samplingRate = new Float(ffmpegEncoder.getMediaOptions().getSamplingRate()).floatValue() * 1000.0f;
                    Integer intRate = new Float(samplingRate).intValue();
                    sb.append(" -ar " + intRate);
                }
            }
            if (ffmpegEncoder.getMediaOptions().getHasVideo().booleanValue()) {
                sb.append(" -map " + this.encoders.indexOf(ffmpegEncoder));
            }
            if (ffmpegEncoder.getMediaOptions().getHasAudio().booleanValue()) {
                sb.append(" -map " + this.encoders.indexOf(ffmpegEncoder));
            }
            sb.append(" -strict -2 -y \"" + outputFileName + "\"");
        }
        this.ffmpegCommand = sb.toString();
        System.out.println(this.ffmpegCommand);
    }

    public List<FFMPEGEncoder> getEncoders() {
        return this.encoders;
    }

    public void setEncoders(List<FFMPEGEncoder> encoders) {
        this.encoders = encoders;
        this.setupFFMPEGCommand();
    }

    public LeCToLogFrame getLogFrame() {
        return this.logFrame;
    }

    public void setLogFrame(LeCToLogFrame logFrame) {
        this.logFrame = logFrame;
    }

    @Override
    public void run() {
        this.startEncoding();
    }

    @Override
    public Boolean call() throws Exception {
        return this.startEncoding();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean startEncoding() {
        if (this.pauseCounter > 0) {
            this.mainFrame.setResumeStatus();
        }
        if (LeCTo.operatingSystem.getFamily() == OperatingSystemFamily.MAC) {
            for (final FFMPEGEncoder ffmpegEncoder : this.encoders) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ffmpegEncoder.startEncoding();
                    }
                }).start();
            }
            return true;
        } else {
            this.setupFFMPEGCommand();
            if (this.ffmpegCommand.length() == 0) {
                return false;
            }
            try {
                for (FFMPEGEncoder ffmpegEncoder : this.encoders) {
                    UserSettingsService.addEncoderToPauseList(ffmpegEncoder, "part" + this.pauseCounter);
                }
                String[] splitted = this.ffmpegCommand.split(" ");
                final Process proc = this.runningProcess = Runtime.getRuntime().exec(splitted);
                if (this.getLogFrame() == null) return true;
                this.getLogFrame().setLogText("Executing command: " + this.ffmpegCommand + "\n");
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            BufferedReader processOutput = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                            String line = null;
                            line = processOutput.readLine();
                            while (line != null) {
                                line = processOutput.readLine();
                                if (line == null) continue;
                                if (line.contains("buffer")) {
                                    FFMPEGSummoner.this.mainFrame.setBufferOverLoadStatus();
                                }
                                if (line.contains("error") || line.contains("Error")) {
                                    JOptionPane.showMessageDialog(null, MessagesService.getString("FFMPEGSummoner.errorMessage.text"));
                                    FFMPEGSummoner.this.runningProcess.destroyForcibly();
                                    Lecture.setLectureState(LectureState.IDLE);
                                    FFMPEGSummoner.this.mainFrame.setEmptyStatus();
                                    FFMPEGSummoner.this.mainFrame.resetLecture();
                                    break;
                                }
                                FFMPEGSummoner.this.getLogFrame().setLogText(String.valueOf(line) + "\n");
                            }
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                }).start();
                return true;
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void pauseEncoding() throws IOException {
        this.mainFrame.setPauseStatus();
        if (LeCTo.operatingSystem.getFamily() == OperatingSystemFamily.MAC) {
            for (final FFMPEGEncoder ffmpegEncoder : this.encoders) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ffmpegEncoder.pauseEncoding();
                    }
                }).start();
            }
            return;
        }
        ++this.pauseCounter;
        BufferedWriter processInput = new BufferedWriter(new OutputStreamWriter(this.runningProcess.getOutputStream()));
        String commandToSend = "q";
        try {
            processInput.write(commandToSend);
            processInput.flush();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        BufferedReader processOutput = new BufferedReader(new InputStreamReader(this.runningProcess.getErrorStream()));
        String line = null;
        try {
            line = processOutput.readLine();
            while (line != null) {
                line = processOutput.readLine();
            }
            this.runningProcess.destroyForcibly();
            if (this.getLogFrame() == null) return;
            this.getLogFrame().setLogText("");
            return;
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    public void stopEncoding() throws IOException {
        this.mainFrame.setGeneratingStatus();
        if (LeCTo.operatingSystem.getFamily() == OperatingSystemFamily.MAC) {
            for (final FFMPEGEncoder ffmpegEncoder : this.encoders) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ffmpegEncoder.stopEncoding();
                    }
                }).start();
            }
        } else {
            if (this.runningProcess.isAlive()) {
                BufferedWriter processInput = new BufferedWriter(new OutputStreamWriter(this.runningProcess.getOutputStream()));
                String commandToSend = "q";
                try {
                    processInput.write(commandToSend);
                    processInput.flush();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                BufferedReader processOutput = new BufferedReader(new InputStreamReader(this.runningProcess.getErrorStream()));
                String line = null;
                try {
                    line = processOutput.readLine();
                    while (line != null) {
                        line = processOutput.readLine();
                    }
                    this.runningProcess.destroyForcibly();
                    if (this.getLogFrame() != null) {
                        this.getLogFrame().setLogText("");
                    }
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
            this.pauseCounter = 0;
            final StringBuilder concatenateCommand = new StringBuilder(this.ffmpegPath);
            for (FFMPEGEncoder ffmpegEncoder : this.encoders) {
                String pauseFilePath = UserSettingsService.getPauseFilePathForEncoder(ffmpegEncoder);
                String outputFile = String.valueOf(ffmpegEncoder.getMediaOptions().getFileFullPath()) + File.separator + ffmpegEncoder.getMediaOptions().getFileName() + "." + ffmpegEncoder.getMediaOptions().getContainer();
                concatenateCommand.append(" -f concat -i " + pauseFilePath + " -c copy");
                if (ffmpegEncoder.getMediaOptions().getHasVideo().booleanValue()) {
                    concatenateCommand.append(" -map " + this.encoders.indexOf(ffmpegEncoder));
                }
                if (ffmpegEncoder.getMediaOptions().getHasAudio().booleanValue()) {
                    concatenateCommand.append(" -map " + this.encoders.indexOf(ffmpegEncoder));
                }
                concatenateCommand.append(" \"" + outputFile + "\" -y");
            }
            System.out.println("concat command " + concatenateCommand);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Process proc = Runtime.getRuntime().exec(concatenateCommand.toString());
                        BufferedReader processOutput = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                        String line = null;
                        line = processOutput.readLine();
                        while (line != null) {
                            System.out.println("concat: " + line);
                            line = processOutput.readLine();
                        }
                        for (FFMPEGEncoder ffmpegEncoder : FFMPEGSummoner.this.encoders) {
                            UserSettingsService.deletePauseListForEncoder(ffmpegEncoder);
                        }
                        FFMPEGSummoner.this.mainFrame.resetLecture();
                        FFMPEGSummoner.this.mainFrame.setEmptyStatus();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }).start();
        }
    }

    public boolean isRecording() {
        return false;
    }

    public void releaseResources() {
    }
}

