/*
 * Decompiled with CFR 0.152.
 */
package fer.lss.lecto.gui.psu;

import fer.lss.lecto.filters.ExtensionFileFilter;
import fer.lss.lecto.gui.locale.ILocale;
import fer.lss.lecto.gui.psu.EditorMode;
import fer.lss.lecto.model.psu.PlayerSetUp;
import fer.lss.lecto.model.psu.Video;
import fer.lss.lecto.services.MessagesService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class VideoEditor
extends JDialog
implements ILocale {
    private static final long serialVersionUID = 1L;
    private final JPanel contentPanel = new JPanel();
    private JTextField textFieldTitle;
    private JTextField textFieldUri;
    private JCheckBox chckbxOnTop;
    private JCheckBox chckbxResizeable;
    private JCheckBox chckbxAutoOn;
    private JSpinner spinnerWidth;
    private JSpinner spinnerHeight;
    private JSpinner spinnerLocationX;
    private JSpinner spinnerLocationY;
    private Video video;
    private EditorMode editorMode;
    private Boolean save = false;
    private Boolean cancel = true;
    private JDialog parent;
    private JLabel lblTitle;
    private JLabel lblFileUri;
    private JButton buttonAddVideoFile;
    private String chooseVideoMessage;
    private JPanel panelSize;
    private JLabel labelSizeWidth;
    private JLabel labelSizeHeight;
    private JPanel panelPosition;
    private JLabel labelPositionX;
    private JLabel labelPositionY;
    private JButton saveButton;
    private JButton cancelButton;

    public VideoEditor(Video video, JDialog parent, EditorMode editorMode) {
        this.parent = parent;
        this.video = video.clone();
        this.editorMode = editorMode;
        this.chckbxOnTop = new JCheckBox();
        this.chckbxResizeable = new JCheckBox();
        this.chckbxAutoOn = new JCheckBox();
        this.lblTitle = new JLabel();
        this.lblFileUri = new JLabel();
        this.buttonAddVideoFile = new JButton();
        this.panelSize = new JPanel();
        this.labelSizeWidth = new JLabel();
        this.labelSizeHeight = new JLabel();
        this.panelPosition = new JPanel();
        this.labelPositionX = new JLabel();
        this.labelPositionY = new JLabel();
        this.saveButton = new JButton();
        this.cancelButton = new JButton();
        this.textFieldTitle = new JTextField();
        this.textFieldUri = new JTextField();
        this.spinnerWidth = new JSpinner();
        this.spinnerHeight = new JSpinner();
        this.spinnerLocationX = new JSpinner();
        this.spinnerLocationY = new JSpinner();
        this.fillFields();
        this.createGUI();
        this.setStringValues();
    }

    private void fillFields() {
        this.chckbxOnTop.setSelected(this.video.getOnTop());
        this.chckbxResizeable.setSelected(this.video.getResizable());
        this.chckbxAutoOn.setSelected(this.video.getAutoOn());
        this.textFieldTitle.setText(this.video.getTitle());
        this.textFieldUri.setText(this.video.getUri());
        this.spinnerWidth.setValue(this.video.getSizeWidth());
        this.spinnerHeight.setValue(this.video.getSizeHeight());
        this.spinnerLocationX.setValue(this.video.getLocationX());
        this.spinnerLocationY.setValue(this.video.getLocationY());
    }

    private void createGUI() {
        this.setResizable(false);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setDefaultCloseOperation(2);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(VideoEditor.class.getResource("/images/favicon.png")));
        this.setBounds(this.parent.getX() + 50, this.parent.getY() + 100, 407, 350);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(null);
        this.lblTitle.setBounds(12, 13, 52, 16);
        this.contentPanel.add(this.lblTitle);
        this.chckbxOnTop.setBounds(12, 38, 110, 25);
        this.chckbxOnTop.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                VideoEditor.this.video.setOnTop(VideoEditor.this.chckbxOnTop.isSelected());
            }
        });
        this.contentPanel.add(this.chckbxOnTop);
        this.chckbxResizeable.setBounds(120, 40, 110, 25);
        this.chckbxResizeable.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                VideoEditor.this.video.setResizable(VideoEditor.this.chckbxResizeable.isSelected());
            }
        });
        this.contentPanel.add(this.chckbxResizeable);
        this.chckbxAutoOn.setBounds(228, 40, 160, 25);
        this.chckbxAutoOn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                VideoEditor.this.video.setAutoOn(VideoEditor.this.chckbxAutoOn.isSelected());
            }
        });
        this.contentPanel.add(this.chckbxAutoOn);
        this.textFieldTitle.setBounds(70, 10, 202, 25);
        this.textFieldTitle.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e2) {
                this.textFieldFileNameChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e2) {
                this.textFieldFileNameChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e2) {
            }

            private void textFieldFileNameChanged() {
                VideoEditor.this.video.setTitle(VideoEditor.this.textFieldTitle.getText());
            }
        });
        this.contentPanel.add(this.textFieldTitle);
        this.textFieldTitle.setColumns(10);
        this.lblFileUri.setBounds(12, 78, 70, 14);
        this.contentPanel.add(this.lblFileUri);
        this.textFieldUri.setColumns(10);
        this.textFieldUri.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e2) {
                this.textFieldFileNameChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e2) {
                this.textFieldFileNameChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e2) {
            }

            private void textFieldFileNameChanged() {
                VideoEditor.this.video.setUri(VideoEditor.this.textFieldUri.getText());
            }
        });
        this.textFieldUri.setBounds(94, 73, 178, 25);
        this.contentPanel.add(this.textFieldUri);
        this.buttonAddVideoFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                JFileChooser fc = new JFileChooser();
                ExtensionFileFilter filter1 = new ExtensionFileFilter("Flash Video", new String[]{"flv"});
                fc.setFileFilter(filter1);
                fc.setDialogTitle(VideoEditor.this.chooseVideoMessage);
                int returnVal = fc.showOpenDialog(VideoEditor.this);
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    VideoEditor.this.textFieldUri.setText(file.getAbsolutePath());
                }
            }
        });
        this.buttonAddVideoFile.setBounds(284, 73, 91, 25);
        this.contentPanel.add(this.buttonAddVideoFile);
        this.panelSize.setLayout(null);
        this.panelSize.setBounds(12, 171, 366, 54);
        this.contentPanel.add(this.panelSize);
        this.labelSizeWidth.setBounds(12, 19, 60, 20);
        this.panelSize.add(this.labelSizeWidth);
        this.labelSizeHeight.setBounds(190, 19, 60, 20);
        this.panelSize.add(this.labelSizeHeight);
        this.spinnerWidth.setBounds(110, 19, 63, 20);
        this.spinnerWidth.setModel(new SpinnerNumberModel(this.video.getSizeWidth(), new Integer(0), null, new Integer(1)));
        this.spinnerWidth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e2) {
                VideoEditor.this.video.setSizeWidth((Integer)VideoEditor.this.spinnerWidth.getValue());
            }
        });
        this.panelSize.add(this.spinnerWidth);
        this.spinnerHeight.setBounds(279, 19, 63, 20);
        this.spinnerHeight.setModel(new SpinnerNumberModel(this.video.getSizeHeight(), new Integer(0), null, new Integer(1)));
        this.spinnerHeight.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e2) {
                VideoEditor.this.video.setSizeHeight((Integer)VideoEditor.this.spinnerHeight.getValue());
            }
        });
        this.panelSize.add(this.spinnerHeight);
        this.panelPosition.setLayout(null);
        this.panelPosition.setBounds(12, 106, 366, 54);
        this.contentPanel.add(this.panelPosition);
        this.labelPositionX.setBounds(10, 22, 90, 14);
        this.panelPosition.add(this.labelPositionX);
        this.labelPositionY.setBounds(190, 21, 90, 17);
        this.panelPosition.add(this.labelPositionY);
        this.spinnerLocationX.setBounds(110, 20, 63, 20);
        this.spinnerLocationX.setModel(new SpinnerNumberModel(this.video.getLocationX(), new Integer(0), null, new Integer(1)));
        this.spinnerLocationX.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e2) {
                VideoEditor.this.video.setLocationX((Integer)VideoEditor.this.spinnerLocationX.getValue());
            }
        });
        this.panelPosition.add(this.spinnerLocationX);
        this.spinnerLocationY.setBounds(279, 20, 63, 20);
        this.spinnerLocationY.setModel(new SpinnerNumberModel(this.video.getLocationY(), new Integer(0), null, new Integer(1)));
        this.spinnerLocationY.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e2) {
                VideoEditor.this.video.setLocationY((Integer)VideoEditor.this.spinnerLocationY.getValue());
            }
        });
        this.panelPosition.add(this.spinnerLocationY);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                switch (VideoEditor.this.editorMode) {
                    case ADD_NEW: {
                        PlayerSetUp.addVideo(VideoEditor.this.video);
                        VideoEditor.this.save = true;
                        break;
                    }
                    case EDIT: {
                        PlayerSetUp.updateVideo(VideoEditor.this.video);
                        VideoEditor.this.save = true;
                    }
                }
                VideoEditor.this.dispose();
            }
        });
        buttonPane.add(this.saveButton);
        this.getRootPane().setDefaultButton(this.saveButton);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                VideoEditor.this.cancel = true;
                VideoEditor.this.dispose();
            }
        });
        buttonPane.add(this.cancelButton);
    }

    public Boolean getSave() {
        return this.save;
    }

    public void setSave(Boolean save) {
        this.save = save;
    }

    public Boolean getCancel() {
        return this.cancel;
    }

    public void setCancel(Boolean cancel) {
        this.cancel = cancel;
    }

    @Override
    public void setStringValues() {
        this.setTitle(MessagesService.getString("VideoEditor.this.title"));
        this.panelSize.setBorder(new TitledBorder(null, MessagesService.getString("VideoEditor.panelSize.border.text"), 4, 2, null, null));
        this.chooseVideoMessage = new String(MessagesService.getString("VideoEditor.chooseVideoMessage.text"));
        this.panelPosition.setBorder(new TitledBorder(null, MessagesService.getString("VideoEditor.panelPosition.border.text"), 4, 2, null, null));
        this.chckbxOnTop.setText(MessagesService.getString("VideoEditor.chckbxOnTop.text"));
        this.chckbxResizeable.setText(MessagesService.getString("VideoEditor.resizable.text"));
        this.chckbxAutoOn.setText(MessagesService.getString("VideoEditor.chckbxAutoOn.text"));
        this.lblTitle.setText(String.valueOf(MessagesService.getString("VideoEditor.lblTitle.text")) + ":");
        this.lblFileUri.setText(String.valueOf(MessagesService.getString("VideoEditor.lblFileUri.text")) + ":");
        this.buttonAddVideoFile.setText(MessagesService.getString("VideoEditor.buttonAddVideoFile.text"));
        this.labelSizeWidth.setText(String.valueOf(MessagesService.getString("VideoEditor.labelSizeWidth.text")) + ":");
        this.labelSizeHeight.setText(String.valueOf(MessagesService.getString("VideoEditor.labelSizeHeight.text")) + ":");
        this.labelPositionX.setText(String.valueOf(MessagesService.getString("VideoEditor.labelPositionX.text")) + ":");
        this.labelPositionY.setText(String.valueOf(MessagesService.getString("VideoEditor.labelPositionY.text")) + ":");
        this.saveButton.setText(MessagesService.getString("VideoEditor.saveButton.text"));
        this.cancelButton.setText(MessagesService.getString("VideoEditor.cancelButton.text"));
    }
}

