/*
 * Decompiled with CFR 0.152.
 */
package fer.lss.lecto.gui.translate;

import fer.lss.lecto.LeCTo;
import fer.lss.lecto.gui.locale.ILocale;
import fer.lss.lecto.gui.locale.LeCToLocale;
import fer.lss.lecto.gui.translate.LanguagePanel;
import fer.lss.lecto.services.MessagesService;
import fer.lss.lecto.services.translate.TranslateService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class ExportLanguagesDialog
extends JDialog
implements ILocale {
    private static final long serialVersionUID = 1L;
    private final JPanel contentPanel = new JPanel();
    private JFrame parent;
    private JScrollPane scrollPane;
    private JCheckBox selectDeselectAll;
    private JButton exportButton;
    private JButton cancelButton;
    private List<LanguagePanel> languagePanels;
    private String chooseDestionationFolder;
    private String exportSuccessMessage;
    private String exportFailMessage;

    public ExportLanguagesDialog(JFrame parent) {
        super(parent);
        this.parent = parent;
        this.selectDeselectAll = new JCheckBox();
        this.exportButton = new JButton();
        this.cancelButton = new JButton();
        this.languagePanels = new ArrayList<LanguagePanel>();
        this.setStringValues();
        this.createGUI();
    }

    private void createGUI() {
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setBounds(this.parent.getX() + 100, this.parent.getY() + 100, 195, 313);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setLayout(new GridLayout(MessagesService.getAvailableLocales().size() + MessagesService.getCustomLocales().size() + 1, 1));
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        for (LeCToLocale locale : MessagesService.getAvailableLocales()) {
            this.languagePanels.add(new LanguagePanel(locale));
        }
        for (LeCToLocale locale : MessagesService.getCustomLocales()) {
            this.languagePanels.add(new LanguagePanel(locale));
        }
        this.selectDeselectAll.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                for (LanguagePanel languagePanel : ExportLanguagesDialog.this.languagePanels) {
                    languagePanel.setSelected(ExportLanguagesDialog.this.selectDeselectAll.isSelected());
                }
            }
        });
        this.contentPanel.add(this.selectDeselectAll);
        for (LanguagePanel languagePanel : this.languagePanels) {
            this.contentPanel.add(languagePanel);
        }
        this.scrollPane = new JScrollPane(this.contentPanel);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ExportLanguagesDialog.this.exportLanguages();
                ExportLanguagesDialog.this.dispose();
            }
        });
        buttonPane.add(this.exportButton);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ExportLanguagesDialog.this.dispose();
            }
        });
        buttonPane.add(this.cancelButton);
    }

    protected void exportLanguages() {
        File folder;
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        fc.setDialogTitle(this.chooseDestionationFolder);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0 && (folder = fc.getSelectedFile()).exists()) {
            int exportSuccessCount = 0;
            for (LanguagePanel languagePanel : this.languagePanels) {
                if (!languagePanel.isSelected().booleanValue()) continue;
                try {
                    TranslateService.exportLanguageToLLPZipFile(languagePanel.getLeCToLocale(), folder);
                    ++exportSuccessCount;
                }
                catch (IOException e2) {
                    JOptionPane.showMessageDialog(null, String.valueOf(this.exportFailMessage) + " " + languagePanel.getLocale().getLanguage(), MessagesService.getString("ExportLanguagesDialog.error"), 0, new ImageIcon(LeCTo.class.getResource("/images/logo.png")));
                    e2.printStackTrace();
                }
            }
            JOptionPane.showMessageDialog(null, String.valueOf(exportSuccessCount) + " " + this.exportSuccessMessage, MessagesService.getString("ExportLanguagesDialog.info"), -1, new ImageIcon(LeCTo.class.getResource("/images/logo.png")));
        }
    }

    @Override
    public void setStringValues() {
        this.setTitle(MessagesService.getString("ExportLanguagesDialog.this.title.text"));
        this.selectDeselectAll.setText(MessagesService.getString("ExportLanguagesDialog.selectDeselectAll.text"));
        this.exportButton.setText(MessagesService.getString("ExportLanguagesDialog.exportButton.text"));
        this.cancelButton.setText(MessagesService.getString("ExportLanguagesDialog.cancelButton.text"));
        this.chooseDestionationFolder = MessagesService.getString("ExportLanguagesDialog.chooseDestionationFolder.text");
        this.exportSuccessMessage = MessagesService.getString("ExportLanguagesDialog.exportSuccessMessage.text");
        this.exportFailMessage = MessagesService.getString("ExportLanguagesDialog.exportFailMessage.text");
    }
}

