/*
 * Decompiled with CFR 0.152.
 */
package fer.lss.lecto.gui.userprofiles;

import fer.lss.lecto.LeCTo;
import fer.lss.lecto.gui.locale.ILocale;
import fer.lss.lecto.gui.userprofiles.ProfilePanel;
import fer.lss.lecto.services.MessagesService;
import fer.lss.lecto.services.usersettings.UserProfilesService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class DeleteProfilesDialog
extends JDialog
implements ILocale {
    private static final long serialVersionUID = 1L;
    private final JPanel contentPanel = new JPanel();
    private JFrame parent;
    private JScrollPane scrollPane;
    private JCheckBox selectDeselectAll;
    private JButton deleteButton;
    private JButton cancelButton;
    private List<ProfilePanel> profilePanels;
    private String deleteSuccessMessage;

    public DeleteProfilesDialog(JFrame parent) {
        super(parent);
        this.parent = parent;
        this.selectDeselectAll = new JCheckBox();
        this.deleteButton = new JButton();
        this.cancelButton = new JButton();
        this.profilePanels = new ArrayList<ProfilePanel>();
        this.setStringValues();
        this.createGUI();
    }

    private void createGUI() {
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setBounds(this.parent.getX() + 100, this.parent.getY() + 100, 195, 313);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setLayout(new GridLayout(UserProfilesService.getProfileNames().size() + 1, 1));
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        for (String profileName : UserProfilesService.getProfileNames()) {
            this.profilePanels.add(new ProfilePanel(profileName));
        }
        this.selectDeselectAll.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                for (ProfilePanel profilePanel : DeleteProfilesDialog.this.profilePanels) {
                    profilePanel.setSelected(DeleteProfilesDialog.this.selectDeselectAll.isSelected());
                }
            }
        });
        this.contentPanel.add(this.selectDeselectAll);
        for (ProfilePanel profilePanel : this.profilePanels) {
            this.contentPanel.add(profilePanel);
        }
        this.scrollPane = new JScrollPane(this.contentPanel);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DeleteProfilesDialog.this.deleteProfiles();
                DeleteProfilesDialog.this.dispose();
            }
        });
        buttonPane.add(this.deleteButton);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                DeleteProfilesDialog.this.dispose();
            }
        });
        buttonPane.add(this.cancelButton);
    }

    protected void deleteProfiles() {
        int deleteCount = 0;
        for (ProfilePanel profilePanel : this.profilePanels) {
            if (!profilePanel.isSelected().booleanValue()) continue;
            UserProfilesService.deleteProfileFiles(profilePanel.getProfileName());
            ++deleteCount;
        }
        JOptionPane.showMessageDialog(null, String.valueOf(deleteCount) + " " + this.deleteSuccessMessage, MessagesService.getString("DeleteProfilesDialog.info"), -1, new ImageIcon(LeCTo.class.getResource("/images/logo.png")));
    }

    @Override
    public void setStringValues() {
        this.setTitle(MessagesService.getString("DeleteProfilesDialog.this.title.text"));
        this.selectDeselectAll.setText(MessagesService.getString("DeleteProfilesDialog.selectDeselectAll.text"));
        this.deleteButton.setText(MessagesService.getString("DeleteProfilesDialog.deleteButton.text"));
        this.cancelButton.setText(MessagesService.getString("DeleteProfilesDialog.cancelButton.text"));
        this.deleteSuccessMessage = MessagesService.getString("DeleteProfilesDialog.deleteSuccessMessage.text");
    }
}

