/*
 * Decompiled with CFR 0.152.
 */
package fer.lss.lecto.gui.userprofiles;

import fer.lss.lecto.LeCTo;
import fer.lss.lecto.gui.locale.ILocale;
import fer.lss.lecto.services.MessagesService;
import fer.lss.lecto.services.usersettings.UserProfilesService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class SaveProfileDialog
extends JDialog
implements ILocale {
    private static final long serialVersionUID = 1L;
    private final JPanel contentPanel = new JPanel();
    private JFrame parent;
    private JButton saveButton;
    private JButton cancelButton;
    private JLabel lblProfileName;
    private JTextField textFieldProfileName;
    private String succesMessage;
    private String errorMessage;
    private Boolean save;

    public SaveProfileDialog(JFrame parent) {
        super(parent);
        this.parent = parent;
        this.save = false;
        this.saveButton = new JButton();
        this.cancelButton = new JButton();
        this.lblProfileName = new JLabel();
        this.textFieldProfileName = new JTextField();
        this.setStringValues();
        this.createGUI();
    }

    private void createGUI() {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(SaveProfileDialog.class.getResource("/images/favicon32T.png")));
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setBounds(this.parent.getX() + 100, this.parent.getY() + 100, 285, 140);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add(this.contentPanel);
        this.contentPanel.setLayout(null);
        this.lblProfileName.setBounds(23, 26, 95, 17);
        this.contentPanel.add(this.lblProfileName);
        this.textFieldProfileName.setBounds(137, 24, 122, 20);
        this.contentPanel.add(this.textFieldProfileName);
        this.textFieldProfileName.setColumns(10);
        JPanel buttonPane = new JPanel();
        buttonPane.setBounds(0, 98, 396, 33);
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SaveProfileDialog.this.saveProfile();
                SaveProfileDialog.this.dispose();
            }
        });
        buttonPane.add(this.saveButton);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                SaveProfileDialog.this.dispose();
            }
        });
        buttonPane.add(this.cancelButton);
    }

    private void saveProfile() {
        try {
            UserProfilesService.saveCurrentSettingsToProfile(this.textFieldProfileName.getText());
            JOptionPane.showMessageDialog(null, this.succesMessage, MessagesService.getString("SaveProfileDialog.info"), -1, new ImageIcon(LeCTo.class.getResource("/images/logo.png")));
        }
        catch (IOException e2) {
            JOptionPane.showMessageDialog(null, this.errorMessage, MessagesService.getString("SaveProfileDialog.info"), -1, new ImageIcon(LeCTo.class.getResource("/images/logo.png")));
        }
    }

    public Boolean getSave() {
        return this.save;
    }

    @Override
    public void setStringValues() {
        this.cancelButton.setText(MessagesService.getString("SaveProfileDialog.cancelButton.text"));
        this.saveButton.setText(MessagesService.getString("SaveProfileDialog.saveButton.text"));
        this.setTitle(MessagesService.getString("SaveProfileDialog.this.title"));
        this.errorMessage = MessagesService.getString("SaveProfileDialog.errorMessage");
        this.succesMessage = MessagesService.getString("SaveProfileDialog.successMessage");
        this.lblProfileName.setText(String.valueOf(MessagesService.getString("SaveProfileDialog.lblProfileName.text")) + ":");
    }
}

