/*
 * Decompiled with CFR 0.152.
 */
package fer.lss.lecto.model.psu;

import fer.lss.lecto.model.psu.AdditionalLectureContent;
import fer.lss.lecto.model.psu.ContentChangeEvent;
import fer.lss.lecto.model.psu.Navigation;
import fer.lss.lecto.model.psu.PSUDefaultValues;
import fer.lss.lecto.model.psu.Video;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class PlayerSetUp {
    private static List<Video> videos = new ArrayList<Video>();
    private static ContentChangeEvent cce;
    private static Navigation navigation;
    private static List<AdditionalLectureContent> alcs;

    static {
        alcs = new ArrayList<AdditionalLectureContent>();
    }

    public static void init() {
        videos = new ArrayList<Video>();
        cce = new ContentChangeEvent();
        navigation = new Navigation();
        alcs = new ArrayList<AdditionalLectureContent>();
    }

    public static void initWithDefaultValues() {
        videos = PSUDefaultValues.getDefaultVideos();
        alcs = PSUDefaultValues.getDefaultALCs();
        cce = PSUDefaultValues.getDefaultCCE();
        navigation = PSUDefaultValues.getDefaultNavigation();
    }

    public static void removeVideo(Video video) {
        videos.remove(video);
    }

    public static void addVideo(Video video) {
        videos.add(video);
    }

    public static void updateVideo(Video video) {
        videos.remove(video);
        videos.add(video);
    }

    public static void removeALC(AdditionalLectureContent alc) {
        alcs.remove(alc);
    }

    public static void addALC(AdditionalLectureContent alc) {
        alcs.add(alc);
    }

    public static void updateALC(AdditionalLectureContent alc) {
        alcs.remove(alc);
        alcs.add(alc);
    }

    public static List<Video> getVideos() {
        return videos;
    }

    public static void setVideos(List<Video> videos) {
        PlayerSetUp.videos = videos;
    }

    public static ContentChangeEvent getCce() {
        return cce;
    }

    public static void setCce(ContentChangeEvent cce) {
        PlayerSetUp.cce = cce;
    }

    public static Navigation getNavigation() {
        return navigation;
    }

    public static void setNavigation(Navigation navigation) {
        PlayerSetUp.navigation = navigation;
    }

    public static List<AdditionalLectureContent> getAlcs() {
        return alcs;
    }

    public static void setAlcs(List<AdditionalLectureContent> alcs) {
        PlayerSetUp.alcs = alcs;
    }

    public static void createXMLRepresentationToFileLocation(File file) {
        try {
            DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element root = doc.createElement("psu");
            doc.appendChild(root);
            PlayerSetUp.appendVideos(doc, root);
            PlayerSetUp.appendCCE(doc, root);
            PlayerSetUp.appendNavigation(doc, root);
            PlayerSetUp.appendALCs(doc, root);
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(file);
            DOMSource source = new DOMSource(doc);
            trans.transform(source, result);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private static void appendALCs(Document doc, Element root) {
        for (AdditionalLectureContent alc : alcs) {
            Element alcElement = doc.createElement("alc");
            root.appendChild(alcElement);
            Element window = doc.createElement("window");
            alcElement.appendChild(window);
            Element title = doc.createElement("title");
            window.appendChild(title);
            Text titleText = doc.createTextNode(alc.getTitle());
            title.appendChild(titleText);
            Element size = doc.createElement("size");
            window.appendChild(size);
            Element width = doc.createElement("width");
            size.appendChild(width);
            Text widthText = doc.createTextNode(alc.getSizeWidth().toString());
            width.appendChild(widthText);
            Element height = doc.createElement("height");
            size.appendChild(height);
            Text heightText = doc.createTextNode(alc.getSizeHeight().toString());
            height.appendChild(heightText);
            Element resizable = doc.createElement("resizable");
            window.appendChild(resizable);
            Text resizableText = doc.createTextNode(alc.getResizable().toString());
            resizable.appendChild(resizableText);
            Element onTop = doc.createElement("ontop");
            window.appendChild(onTop);
            Text onTopText = doc.createTextNode(alc.getOnTop().toString());
            onTop.appendChild(onTopText);
            Element location = doc.createElement("location");
            window.appendChild(location);
            Element positionX = doc.createElement("positionX");
            location.appendChild(positionX);
            Text locationXText = doc.createTextNode(alc.getLocationX().toString());
            positionX.appendChild(locationXText);
            Element positionY = doc.createElement("positionY");
            location.appendChild(positionY);
            Text locationYText = doc.createTextNode(alc.getLocationY().toString());
            positionY.appendChild(locationYText);
            Element autoOn = doc.createElement("autoOn");
            window.appendChild(autoOn);
            Text autoOnText = doc.createTextNode(alc.getAutoOn().toString());
            autoOn.appendChild(autoOnText);
            Element uri = doc.createElement("uri");
            alcElement.appendChild(uri);
            Text uriText = doc.createTextNode(alc.getUri());
            uri.appendChild(uriText);
        }
    }

    private static void appendNavigation(Document doc, Element root) {
        Element navigation = doc.createElement("navigation");
        root.appendChild(navigation);
        Element window = doc.createElement("window");
        navigation.appendChild(window);
        Element title = doc.createElement("title");
        window.appendChild(title);
        Text titleText = doc.createTextNode(PlayerSetUp.getNavigation().getTitle());
        title.appendChild(titleText);
        Element size = doc.createElement("size");
        window.appendChild(size);
        Element width = doc.createElement("width");
        size.appendChild(width);
        Text widthText = doc.createTextNode(PlayerSetUp.getNavigation().getSizeWidth().toString());
        width.appendChild(widthText);
        Element height = doc.createElement("height");
        size.appendChild(height);
        Text heightText = doc.createTextNode(PlayerSetUp.getNavigation().getSizeHeight().toString());
        height.appendChild(heightText);
        Element resizable = doc.createElement("resizable");
        window.appendChild(resizable);
        Text resizableText = doc.createTextNode(PlayerSetUp.getNavigation().getResizable().toString());
        resizable.appendChild(resizableText);
        Element onTop = doc.createElement("ontop");
        window.appendChild(onTop);
        Text onTopText = doc.createTextNode(PlayerSetUp.getNavigation().getOnTop().toString());
        onTop.appendChild(onTopText);
        Element location = doc.createElement("location");
        window.appendChild(location);
        Element positionX = doc.createElement("positionX");
        location.appendChild(positionX);
        Text locationXText = doc.createTextNode(PlayerSetUp.getNavigation().getLocationX().toString());
        positionX.appendChild(locationXText);
        Element positionY = doc.createElement("positionY");
        location.appendChild(positionY);
        Text locationYText = doc.createTextNode(PlayerSetUp.getNavigation().getLocationY().toString());
        positionY.appendChild(locationYText);
        Element autoOn = doc.createElement("autoOn");
        window.appendChild(autoOn);
        Text autoOnText = doc.createTextNode(PlayerSetUp.getNavigation().getAutoOn().toString());
        autoOn.appendChild(autoOnText);
    }

    private static void appendCCE(Document doc, Element root) {
        Element cce = doc.createElement("cce");
        root.appendChild(cce);
        Element uri = doc.createElement("uri");
        cce.appendChild(uri);
        Text uriText = doc.createTextNode(PlayerSetUp.getCce().getUri());
        uri.appendChild(uriText);
    }

    private static void appendVideos(Document doc, Element root) {
        for (Video video : videos) {
            Element videoElement = doc.createElement("video");
            root.appendChild(videoElement);
            Element window = doc.createElement("window");
            videoElement.appendChild(window);
            Element title = doc.createElement("title");
            window.appendChild(title);
            Text titleText = doc.createTextNode(video.getTitle());
            title.appendChild(titleText);
            Element size = doc.createElement("size");
            window.appendChild(size);
            Element width = doc.createElement("width");
            size.appendChild(width);
            Text widthText = doc.createTextNode(video.getSizeWidth().toString());
            width.appendChild(widthText);
            Element height = doc.createElement("height");
            size.appendChild(height);
            Text heightText = doc.createTextNode(video.getSizeHeight().toString());
            height.appendChild(heightText);
            Element resizable = doc.createElement("resizable");
            window.appendChild(resizable);
            Text resizableText = doc.createTextNode(video.getResizable().toString());
            resizable.appendChild(resizableText);
            Element onTop = doc.createElement("ontop");
            window.appendChild(onTop);
            Text onTopText = doc.createTextNode(video.getOnTop().toString());
            onTop.appendChild(onTopText);
            Element location = doc.createElement("location");
            window.appendChild(location);
            Element positionX = doc.createElement("positionX");
            location.appendChild(positionX);
            Text locationXText = doc.createTextNode(video.getLocationX().toString());
            positionX.appendChild(locationXText);
            Element positionY = doc.createElement("positionY");
            location.appendChild(positionY);
            Text locationYText = doc.createTextNode(video.getLocationY().toString());
            positionY.appendChild(locationYText);
            Element autoOn = doc.createElement("autoOn");
            window.appendChild(autoOn);
            Text autoOnText = doc.createTextNode(video.getAutoOn().toString());
            autoOn.appendChild(autoOnText);
            Element uri = doc.createElement("uri");
            videoElement.appendChild(uri);
            Text uriText = doc.createTextNode(video.getUri());
            uri.appendChild(uriText);
        }
    }
}

