/*
 * Decompiled with CFR 0.152.
 */
package fer.lss.lecto.services;

import fer.lss.lecto.gui.locale.LeCToLocale;
import fer.lss.lecto.services.translate.TranslateService;
import fer.lss.lecto.utils.FilesUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;

public class MessagesService {
    private static List<LeCToLocale> availableLocales = new ArrayList<LeCToLocale>();
    private static List<LeCToLocale> customLocales;
    private static Locale LOCALE;
    private static ResourceBundle RESOURCE_BUNDLE;

    static {
        availableLocales.add(new LeCToLocale(new Locale("en", "US"), "/images/icons/locale/en_US.png", LeCToLocale.LeCToLocaleType.DEFAULT));
        customLocales = TranslateService.getCustomLocales();
        LOCALE = availableLocales.get(0).getLocale();
        RESOURCE_BUNDLE = MessagesService.loadBundle();
    }

    private MessagesService() {
    }

    private static ResourceBundle loadBundle() {
        return ResourceBundle.getBundle("messages.messages", LOCALE);
    }

    public static String getString(String key) {
        try {
            ResourceBundle bundle = RESOURCE_BUNDLE == null ? MessagesService.loadBundle() : RESOURCE_BUNDLE;
            return bundle.getString(key);
        }
        catch (MissingResourceException e2) {
            return "!" + key + "!";
        }
    }

    public static void setLocale(LeCToLocale leCToLocale) {
        Locale locale = leCToLocale.getLocale();
        LeCToLocale.LeCToLocaleType localeType = leCToLocale.getLeCToLocaleType();
        File customLocalePropertiesFile = leCToLocale.getCustomLocaleMessagesPropertiesFile();
        switch (localeType) {
            case DEFAULT: {
                LOCALE = locale;
                RESOURCE_BUNDLE = MessagesService.loadBundle();
                break;
            }
            case CUSTOM: {
                LOCALE = locale;
                try {
                    final Properties props = FilesUtil.loadPropertiesFromFile(customLocalePropertiesFile);
                    Vector<String> propKeys = new Vector<String>();
                    for (Object key : props.keySet()) {
                        propKeys.add(key.toString());
                    }
                    final Enumeration keys = propKeys.elements();
                    RESOURCE_BUNDLE = new ResourceBundle(){

                        @Override
                        protected Object handleGetObject(String key) {
                            return props.get(key);
                        }

                        @Override
                        public Enumeration<String> getKeys() {
                            return keys;
                        }
                    };
                }
                catch (IOException iOException) {}
                break;
            }
            default: {
                LOCALE = locale;
                RESOURCE_BUNDLE = MessagesService.loadBundle();
            }
        }
    }

    public static Locale getLocale() {
        return LOCALE;
    }

    public static List<LeCToLocale> getAvailableLocales() {
        return availableLocales;
    }

    public static Properties getDefaultProperties() {
        Properties props = new Properties();
        for (String key : RESOURCE_BUNDLE.keySet()) {
            props.setProperty(key, RESOURCE_BUNDLE.getString(key));
        }
        return props;
    }

    public static Properties getProperties(Locale locale) {
        Properties props = new Properties();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("messages.messages", locale);
        for (String key : resourceBundle.keySet()) {
            props.setProperty(key, resourceBundle.getString(key));
        }
        return props;
    }

    public static List<LeCToLocale> getCustomLocales() {
        return customLocales;
    }

    public static void addCustomLocale(LeCToLocale leCToLocale) {
        customLocales.add(leCToLocale);
    }

    public static void removeCustomLocale(LeCToLocale leCToLocale) {
        customLocales.remove(leCToLocale);
    }
}

