/*
 * Decompiled with CFR 0.152.
 */
package fer.lss.lecto.services.encoding;

import fer.lss.lecto.LeCTo;
import fer.lss.lecto.model.DefaultEncodingParameters;
import fer.lss.lecto.model.mediaoptions.AudioDevice;
import fer.lss.lecto.model.mediaoptions.VideoCodec;
import fer.lss.lecto.model.mediaoptions.VideoDevice;
import fer.lss.lecto.services.MessagesService;
import fer.lss.lecto.services.encoding.impl.EncodingServiceLinux;
import fer.lss.lecto.services.encoding.impl.EncodingServiceMacOSX;
import fer.lss.lecto.services.encoding.impl.EncodingServiceWindows;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class EncodingService {
    public static DefaultEncodingParameters getDefaultDefaultEncodingParameters() {
        return DefaultEncodingParameters.HIGH;
    }

    public static List<VideoDevice> getAvailableVideoInputs() {
        ArrayList<VideoDevice> videoInputs = new ArrayList<VideoDevice>();
        switch (LeCTo.operatingSystem.getFamily()) {
            case WINDOWS: {
                videoInputs.addAll(EncodingServiceWindows.getAvailableCameraDevices());
                return videoInputs;
            }
            case LINUX: {
                videoInputs.addAll(EncodingServiceLinux.getAvailableCameraDevices());
                return videoInputs;
            }
            case MAC: {
                videoInputs.addAll(EncodingServiceMacOSX.getAvailableCameraDevices());
                return videoInputs;
            }
        }
        return null;
    }

    public static List<VideoCodec> getVideoCodecs() {
        ArrayList<VideoCodec> codecs = new ArrayList<VideoCodec>();
        codecs.add(new VideoCodec("MPEG-4 Part 14", "mp4"));
        return codecs;
    }

    public static VideoCodec getDefaultVideoCodec() {
        return EncodingService.getVideoCodecs().get(0);
    }

    public static boolean canUseSameVideoInputForMultipleInstancesAtTheSameTime() {
        switch (LeCTo.operatingSystem.getFamily()) {
            case WINDOWS: {
                return false;
            }
            case LINUX: {
                return false;
            }
            case MAC: {
                return true;
            }
        }
        return false;
    }

    public static List<VideoDevice> getAvailableCameraDevices() {
        switch (LeCTo.operatingSystem.getFamily()) {
            case WINDOWS: {
                return EncodingServiceWindows.getAvailableCameraDevices();
            }
            case LINUX: {
                return EncodingServiceLinux.getAvailableCameraDevices();
            }
            case MAC: {
                return EncodingServiceMacOSX.getAvailableCameraDevices();
            }
        }
        return null;
    }

    public static VideoDevice getDefaultCameraDevice() {
        switch (LeCTo.operatingSystem.getFamily()) {
            case WINDOWS: {
                return EncodingServiceWindows.getDefaultCameraDevice();
            }
            case LINUX: {
                return EncodingServiceLinux.getDefaultCameraDevice();
            }
            case MAC: {
                return EncodingServiceMacOSX.getDefaultCameraDevice();
            }
        }
        return null;
    }

    public static String getCameraDeviceMrl() {
        switch (LeCTo.operatingSystem.getFamily()) {
            case WINDOWS: {
                return EncodingServiceWindows.getCameraDeviceMrl();
            }
            case LINUX: {
                return EncodingServiceLinux.getCameraDeviceMrl();
            }
            case MAC: {
                return EncodingServiceMacOSX.getCameraDeviceMrl();
            }
        }
        return null;
    }

    public static String getCameraDeviceDefaultOutputFileName() {
        return MessagesService.getString("EncodingService.lecturer.text");
    }

    public static String getCameraDeviceDefaultOutputFilePath() {
        switch (LeCTo.operatingSystem.getFamily()) {
            case WINDOWS: {
                return EncodingServiceWindows.getCameraDeviceDefaultOutputFilePath();
            }
            case LINUX: {
                return EncodingServiceLinux.getCameraDeviceDefaultOutputFilePath();
            }
            case MAC: {
                return EncodingServiceMacOSX.getCameraDeviceDefaultOutputFilePath();
            }
        }
        return null;
    }

    public static VideoDevice getEmptyVideoSource() {
        switch (LeCTo.operatingSystem.getFamily()) {
            case WINDOWS: {
                return EncodingServiceWindows.getEmptyVideoSource();
            }
            case LINUX: {
                return EncodingServiceLinux.getEmptyVideoSource();
            }
            case MAC: {
                return EncodingServiceMacOSX.getEmptyVideoSource();
            }
        }
        return null;
    }

    public static boolean canEncodeAudioWithCamera() {
        switch (LeCTo.operatingSystem.getFamily()) {
            case WINDOWS: {
                return true;
            }
            case LINUX: {
                return true;
            }
            case MAC: {
                return true;
            }
        }
        return false;
    }

    public static boolean canUseSameAudioInputForMultipleInstancesAtTheSameTime() {
        switch (LeCTo.operatingSystem.getFamily()) {
            case WINDOWS: {
                return true;
            }
            case LINUX: {
                return false;
            }
            case MAC: {
                return false;
            }
        }
        return false;
    }

    public static Boolean canEncodeAudio() {
        switch (LeCTo.operatingSystem.getFamily()) {
            case WINDOWS: {
                return true;
            }
            case LINUX: {
                return true;
            }
            case MAC: {
                return true;
            }
        }
        return false;
    }

    public static List<AudioDevice> getAvailableAudioDevices() {
        switch (LeCTo.operatingSystem.getFamily()) {
            case WINDOWS: {
                return EncodingServiceWindows.getAvailableAudioDevices();
            }
            case LINUX: {
                return EncodingServiceLinux.getAvailableAudioDevices();
            }
            case MAC: {
                return EncodingServiceMacOSX.getAvailableAudioDevices();
            }
        }
        return null;
    }

    public static AudioDevice getDefaultAudioDevice() {
        switch (LeCTo.operatingSystem.getFamily()) {
            case WINDOWS: {
                return EncodingServiceWindows.getDefaultAudioDevice();
            }
            case LINUX: {
                return EncodingServiceLinux.getDefaultAudioDevice();
            }
            case MAC: {
                return EncodingServiceMacOSX.getDefaultAudioDevice();
            }
        }
        return null;
    }

    public static AudioDevice getEmptyAudioSource() {
        switch (LeCTo.operatingSystem.getFamily()) {
            case WINDOWS: {
                return EncodingServiceWindows.getEmptyAudioSource();
            }
            case LINUX: {
                return EncodingServiceLinux.getEmptyAudioSource();
            }
            case MAC: {
                return EncodingServiceMacOSX.getEmptyAudioSource();
            }
        }
        return null;
    }

    public static Boolean canEncodeDesktop() {
        switch (LeCTo.operatingSystem.getFamily()) {
            case WINDOWS: {
                return true;
            }
            case LINUX: {
                return true;
            }
            case MAC: {
                return true;
            }
        }
        return false;
    }

    public static String getScreenMrl() {
        return "screen://";
    }

    public static VideoDevice getScreenDevice() {
        switch (LeCTo.operatingSystem.getFamily()) {
            case WINDOWS: {
                return EncodingServiceWindows.getDefaultScreenDevice();
            }
            case LINUX: {
                return EncodingServiceLinux.getDefaultScreenDevice();
            }
            case MAC: {
                return EncodingServiceMacOSX.getDefaultScreenDevice();
            }
        }
        return null;
    }

    public static String getScreenDefaultOutputFileName() {
        return "Desktop";
    }

    public static String getScreenDefaultOutputFilePath() {
        switch (LeCTo.operatingSystem.getFamily()) {
            case WINDOWS: {
                return EncodingServiceWindows.getScreenDefaultOutputFilePath();
            }
            case LINUX: {
                return EncodingServiceLinux.getScreenDefaultOutputFilePath();
            }
            case MAC: {
                return EncodingServiceMacOSX.getScreenDefaultOutputFilePath();
            }
        }
        return null;
    }

    public static boolean canEncodeAudioWithScreen() {
        switch (LeCTo.operatingSystem.getFamily()) {
            case WINDOWS: {
                return true;
            }
            case LINUX: {
                return true;
            }
            case MAC: {
                return true;
            }
        }
        return false;
    }

    public static String getMouseIconPath() throws IOException {
        switch (LeCTo.operatingSystem.getFamily()) {
            case WINDOWS: {
                return EncodingServiceWindows.getMouseIconPath();
            }
        }
        return null;
    }
}

