/*
 * Decompiled with CFR 0.152.
 */
package fer.lss.lecto.services.libraries.impl;

import de.humatic.dsj.DSEnvironment;
import fer.lss.lecto.constants.LeCToConstants;
import fer.lss.lecto.constants.WindowsConstants;
import fer.lss.lecto.exceptions.VLCInstallationFolderNotFoundException;
import fer.lss.lecto.services.MessagesService;
import fer.lss.lecto.utils.FilesUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JFileChooser;

public abstract class LibrariesServiceWindows {
    public static void clearAllLibraries() {
    }

    public static void loadLibraries() throws IOException {
    }

    private static void loadVLCLibraries() throws IOException {
        String vlcInstallationPath = LibrariesServiceWindows.getVLCInstallationFolder();
        System.setProperty("jna.library.path", vlcInstallationPath != null ? vlcInstallationPath : "");
    }

    private static String getVLCInstallationFolder() throws IOException {
        Properties leCToProperties;
        String vlcInstallLocation;
        String filePath = WindowsConstants.LECTO_FILES_LOCATION;
        String propertiesName = WindowsConstants.LECTO_PROPERTIES_NAME;
        File propertiesFile = new File(String.valueOf(filePath) + File.separator + propertiesName + ".properties");
        if (!propertiesFile.exists()) {
            propertiesFile.createNewFile();
        }
        if ((vlcInstallLocation = (leCToProperties = FilesUtil.loadPropertiesFromFile(propertiesFile)).getProperty(LeCToConstants.VLC_INSTALLATION_LOCATION_PROPERTY)) == null && (vlcInstallLocation = LibrariesServiceWindows.resolveVLCInstallation()) != null) {
            leCToProperties.setProperty(LeCToConstants.VLC_INSTALLATION_LOCATION_PROPERTY, vlcInstallLocation);
            FileOutputStream out = new FileOutputStream(propertiesFile);
            leCToProperties.store(out, null);
            out.close();
        }
        return vlcInstallLocation;
    }

    public static String resolveVLCInstallation() {
        String vlcInstallationPath;
        block2: {
            vlcInstallationPath = null;
            try {
                vlcInstallationPath = LibrariesServiceWindows.findVLCInstallationFolderPath();
            }
            catch (VLCInstallationFolderNotFoundException e2) {
                File folder;
                JFileChooser fc = new JFileChooser();
                fc.setDialogTitle(MessagesService.getString("LibrariesServiceWindows.selectVLCInstallationFolder"));
                fc.setFileSelectionMode(1);
                int returnVal = fc.showOpenDialog(null);
                if (returnVal != 0 || !(folder = fc.getSelectedFile()).exists()) break block2;
                vlcInstallationPath = folder.getAbsolutePath();
            }
        }
        return vlcInstallationPath;
    }

    private static String findVLCInstallationFolderPath() throws VLCInstallationFolderNotFoundException {
        for (File file : WindowsConstants.possibleVLCInstallLocations) {
            String[] fileNames;
            if (!file.exists() || (fileNames = file.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String fileName) {
                    return fileName.matches(WindowsConstants.LIBVLC_FILE_NAME) || fileName.matches(WindowsConstants.LIBVLC_CORE_FILE_NAME);
                }
            })).length != 2) continue;
            return file.getAbsolutePath();
        }
        throw new VLCInstallationFolderNotFoundException(null);
    }

    private static void loadDirectShowJava() throws IOException {
        String filePath = WindowsConstants.LECTO_FILES_LOCATION;
        String fileName = WindowsConstants.DIRECT_SHOW_JAVA_FILE_NAME;
        File file = new File(String.valueOf(filePath) + "/" + fileName);
        if (!file.exists()) {
            System.out.println("File does not exist, loading it from resources");
            file = FilesUtil.copyResourceToFile("/windowslibraries", fileName, filePath);
        }
        DSEnvironment.setDLLPath(file.getAbsolutePath());
    }

    public static void deleteLibraries() {
        String filePath = WindowsConstants.LECTO_FILES_LOCATION;
        String propertiesName = WindowsConstants.LECTO_PROPERTIES_NAME;
        File propertiesFile = new File(String.valueOf(filePath) + File.separator + propertiesName + ".properties");
        propertiesFile.delete();
    }
}

