/*
 * Decompiled with CFR 0.152.
 */
package fer.lss.lecto.services.usersettings;

import fer.lss.lecto.LeCTo;
import fer.lss.lecto.constants.LinuxConstants;
import fer.lss.lecto.constants.MacOSXConstants;
import fer.lss.lecto.constants.WindowsConstants;
import fer.lss.lecto.encoder.FFMPEGEncoder;
import fer.lss.lecto.model.DefaultEncodingParameters;
import fer.lss.lecto.model.Lecture;
import fer.lss.lecto.model.mediaoptions.AudioDevice;
import fer.lss.lecto.model.mediaoptions.EncodingType;
import fer.lss.lecto.model.mediaoptions.MediaOptions;
import fer.lss.lecto.model.mediaoptions.VideoDevice;
import fer.lss.lecto.services.encoding.EncodingService;
import fer.lss.lecto.utils.FilesUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Properties;

public class UserPresetService {
    public static void initLecture() {
        String propertiesNamePrefix;
        String filePath;
        Lecture.release();
        switch (LeCTo.operatingSystem.getFamily()) {
            case WINDOWS: {
                filePath = WindowsConstants.LECTO_LAST_CONFIGURATION_LOCATION;
                propertiesNamePrefix = WindowsConstants.LECTO_LAST_CONFIGURATION_ENCODER_FILE_NAME_PREFIX;
                break;
            }
            case LINUX: {
                filePath = LinuxConstants.LECTO_LAST_CONFIGURATION_LOCATION;
                propertiesNamePrefix = LinuxConstants.LECTO_LAST_CONFIGURATION_ENCODER_FILE_NAME_PREFIX;
                break;
            }
            case MAC: {
                filePath = MacOSXConstants.LECTO_LAST_CONFIGURATION_LOCATION;
                propertiesNamePrefix = MacOSXConstants.LECTO_LAST_CONFIGURATION_ENCODER_FILE_NAME_PREFIX;
                break;
            }
            default: {
                return;
            }
        }
        File presetPropertiesLocation = new File(filePath);
        presetPropertiesLocation.mkdirs();
        File[] encodersPropertiesFiles = presetPropertiesLocation.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(propertiesNamePrefix);
            }
        });
        if (encodersPropertiesFiles.length == 0) {
            Lecture.setDefaultParameters(EncodingService.getDefaultDefaultEncodingParameters());
            return;
        }
        File[] fileArray = encodersPropertiesFiles;
        int n2 = encodersPropertiesFiles.length;
        int n3 = 0;
        while (n3 < n2) {
            block10: {
                File encoderPropertiesFile = fileArray[n3];
                try {
                    Properties encoderProperties = FilesUtil.loadPropertiesFromFile(encoderPropertiesFile);
                    MediaOptions mediaOptions = UserPresetService.getMediaOptions(encoderProperties);
                    if (mediaOptions != null) {
                        FFMPEGEncoder encoder = new FFMPEGEncoder(mediaOptions);
                        Lecture.addEncoder(encoder);
                        break block10;
                    }
                    Lecture.setDefaultParameters(EncodingService.getDefaultDefaultEncodingParameters());
                    return;
                }
                catch (IOException e2) {
                    Lecture.setDefaultParameters(EncodingService.getDefaultDefaultEncodingParameters());
                    e2.printStackTrace();
                    return;
                }
            }
            ++n3;
        }
        Lecture.prepareEncoders();
    }

    public static MediaOptions getMediaOptions(Properties encoderProperties) {
        String fileName;
        String fileFullPath;
        String videoInputDeviceIdentifier;
        String container;
        MediaOptions mediaOptions = null;
        String encodingType = encoderProperties.getProperty("encodingType");
        if (encodingType != null) {
            if (encodingType.equals(EncodingType.CAMERA.toString())) {
                mediaOptions = DefaultEncodingParameters.getDefaultMediaOptionsForCamera(EncodingService.getDefaultDefaultEncodingParameters());
            } else if (encodingType.equals(EncodingType.DESKTOP.toString())) {
                mediaOptions = DefaultEncodingParameters.getDefaultMediaOptionsForScreen(EncodingService.getDefaultDefaultEncodingParameters());
            } else if (encodingType.equals(EncodingType.AUDIO_ONLY_OR_NONE.toString())) {
                mediaOptions = DefaultEncodingParameters.getDefaultMediaOptionsWithNoVideoInput(EncodingService.getDefaultDefaultEncodingParameters());
            } else {
                return null;
            }
        }
        if ((container = encoderProperties.getProperty("container")) != null) {
            mediaOptions.setContainer(container);
        }
        if ((videoInputDeviceIdentifier = encoderProperties.getProperty("videoInputDeviceIdentifier")) != null) {
            boolean found = false;
            for (VideoDevice videoDevice : EncodingService.getAvailableVideoInputs()) {
                if (!videoInputDeviceIdentifier.equals(videoDevice.getDeviceName())) continue;
                mediaOptions.setVideoInput(videoDevice);
                found = true;
                break;
            }
            if (!found) {
                return null;
            }
        } else {
            return null;
        }
        String audioInputDeviceIdentifier = encoderProperties.getProperty("audioInputDeviceIdentifier");
        if (audioInputDeviceIdentifier != null) {
            boolean found = false;
            for (AudioDevice audioInput : EncodingService.getAvailableAudioDevices()) {
                if (!audioInputDeviceIdentifier.equals(audioInput.getDeviceName())) continue;
                mediaOptions.setAudioInput(audioInput);
                found = true;
                break;
            }
            if (!found) {
                mediaOptions.setAudioInput(EncodingService.getEmptyAudioSource());
            }
        } else {
            return null;
        }
        if (mediaOptions.getHasVideo().booleanValue()) {
            String preset;
            String resolution;
            String crf;
            String videoCodecIdentifier;
            String fps;
            String vB = encoderProperties.getProperty("videoBitrate");
            if (vB != null) {
                mediaOptions.setVB(vB);
            }
            if ((fps = encoderProperties.getProperty("videoFps")) != null) {
                mediaOptions.setFps(fps);
            }
            if ((videoCodecIdentifier = encoderProperties.getProperty("videoCodecIdentifier")) != null) {
                mediaOptions.setVideoCodec(videoCodecIdentifier);
            }
            if ((crf = encoderProperties.getProperty("crf")) != null) {
                mediaOptions.setCrf(crf);
            }
            if ((resolution = encoderProperties.getProperty("resolution")) != null) {
                mediaOptions.setResolution(resolution);
            }
            if ((preset = encoderProperties.getProperty("ffmpeg_preset")) != null) {
                mediaOptions.setPreset(preset);
            }
        }
        if (mediaOptions.getHasAudio().booleanValue()) {
            String samplingRate;
            String audioCodec;
            String aB2 = encoderProperties.getProperty("audioBitrate");
            if (aB2 != null) {
                mediaOptions.setAB(aB2);
            }
            if ((audioCodec = encoderProperties.getProperty("audioCodecIdentifier")) != null) {
                mediaOptions.setAudioCodec(audioCodec);
            }
            if ((samplingRate = encoderProperties.getProperty("samplingRate")) != null) {
                mediaOptions.setSamplingRate(samplingRate);
            }
        }
        if ((fileFullPath = encoderProperties.getProperty("fileFullPath")) != null) {
            mediaOptions.setFileFullPath(fileFullPath);
        }
        if ((fileName = encoderProperties.getProperty("fileName")) != null) {
            mediaOptions.setFileName(fileName);
        }
        return mediaOptions;
    }

    public static void save() throws IOException {
        String propertiesNameSufix;
        String propertiesNamePrefix;
        String filePath;
        switch (LeCTo.operatingSystem.getFamily()) {
            case WINDOWS: {
                filePath = WindowsConstants.LECTO_LAST_CONFIGURATION_LOCATION;
                propertiesNamePrefix = WindowsConstants.LECTO_LAST_CONFIGURATION_ENCODER_FILE_NAME_PREFIX;
                propertiesNameSufix = WindowsConstants.LECTO_LAST_CONFIGURATION_ENCODER_FILE_NAME_SUFIX;
                break;
            }
            case LINUX: {
                filePath = LinuxConstants.LECTO_LAST_CONFIGURATION_LOCATION;
                propertiesNamePrefix = LinuxConstants.LECTO_LAST_CONFIGURATION_ENCODER_FILE_NAME_PREFIX;
                propertiesNameSufix = LinuxConstants.LECTO_LAST_CONFIGURATION_ENCODER_FILE_NAME_SUFIX;
                break;
            }
            case MAC: {
                filePath = MacOSXConstants.LECTO_LAST_CONFIGURATION_LOCATION;
                propertiesNamePrefix = MacOSXConstants.LECTO_LAST_CONFIGURATION_ENCODER_FILE_NAME_PREFIX;
                propertiesNameSufix = MacOSXConstants.LECTO_LAST_CONFIGURATION_ENCODER_FILE_NAME_SUFIX;
                break;
            }
            default: {
                return;
            }
        }
        File presetPropertiesLocation = new File(filePath);
        presetPropertiesLocation.mkdirs();
        File[] fileArray = presetPropertiesLocation.listFiles();
        int n2 = fileArray.length;
        int n3 = 0;
        while (n3 < n2) {
            File propsFile = fileArray[n3];
            propsFile.delete();
            ++n3;
        }
        UserPresetService.savePreset(propertiesNamePrefix, propertiesNameSufix, presetPropertiesLocation);
    }

    public static void savePreset(String propertiesNamePrefix, String propertiesNameSufix, File presetPropertiesLocation) throws IOException {
        int i2 = 0;
        while (i2 < Lecture.getEncoders().size()) {
            MediaOptions mediaOptions = Lecture.getEncoders().get(i2).getMediaOptions();
            File propsFile = new File(String.valueOf(presetPropertiesLocation.getAbsolutePath()) + File.separator + propertiesNamePrefix + i2 + propertiesNameSufix);
            Properties props = new Properties();
            props.setProperty("encodingType", mediaOptions.getEncodingType().toString());
            props.setProperty("videoInputDeviceIdentifier", mediaOptions.getVideoInput().getDeviceName());
            props.setProperty("audioInputDeviceIdentifier", mediaOptions.getAudioInput().getDeviceName());
            props.setProperty("container", mediaOptions.getContainer());
            if (mediaOptions.getHasVideo().booleanValue()) {
                props.setProperty("videoBitrate", mediaOptions.getVB());
                props.setProperty("videoFps", mediaOptions.getFps());
                props.setProperty("videoCodecIdentifier", mediaOptions.getVideoCodec());
                props.setProperty("crf", mediaOptions.getCrf());
                props.setProperty("resolution", mediaOptions.getResolution());
                props.setProperty("ffmpeg_preset", mediaOptions.getPreset());
            }
            if (mediaOptions.getHasAudio().booleanValue()) {
                props.setProperty("audioBitrate", mediaOptions.getAB());
                props.setProperty("audioCodecIdentifier", mediaOptions.getAudioCodec());
                props.setProperty("samplingRate", mediaOptions.getSamplingRate());
            }
            props.setProperty("fileFullPath", mediaOptions.getFileFullPath());
            props.setProperty("fileName", mediaOptions.getFileName());
            FilesUtil.savePropertiesToFile(props, propsFile);
            ++i2;
        }
    }
}

