/*
 * Decompiled with CFR 0.152.
 */
package fer.lss.lecto.services.usersettings;

import fer.lss.lecto.LeCTo;
import fer.lss.lecto.constants.LeCToConstants;
import fer.lss.lecto.constants.LinuxConstants;
import fer.lss.lecto.constants.MacOSXConstants;
import fer.lss.lecto.constants.WindowsConstants;
import fer.lss.lecto.encoder.FFMPEGEncoder;
import fer.lss.lecto.exceptions.FailedToInitLectureWithProfileException;
import fer.lss.lecto.model.Lecture;
import fer.lss.lecto.model.mediaoptions.MediaOptions;
import fer.lss.lecto.services.encoding.EncodingService;
import fer.lss.lecto.services.usersettings.UserPresetService;
import fer.lss.lecto.utils.FilesUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class UserProfilesService {
    public static void saveCurrentSettingsToProfile(String profileName) throws IOException {
        String presetPath;
        String profilesPath;
        switch (LeCTo.operatingSystem.getFamily()) {
            case WINDOWS: {
                profilesPath = WindowsConstants.LECTO_USER_PROFILES_LOCATION;
                presetPath = WindowsConstants.LECTO_LAST_CONFIGURATION_LOCATION;
                break;
            }
            case LINUX: {
                profilesPath = LinuxConstants.LECTO_USER_PROFILES_LOCATION;
                presetPath = LinuxConstants.LECTO_LAST_CONFIGURATION_LOCATION;
                break;
            }
            case MAC: {
                profilesPath = MacOSXConstants.LECTO_USER_PROFILES_LOCATION;
                presetPath = MacOSXConstants.LECTO_LAST_CONFIGURATION_LOCATION;
                break;
            }
            default: {
                return;
            }
        }
        File profileFileLocation = new File(String.valueOf(profilesPath) + File.separator + profileName);
        profileFileLocation.mkdirs();
        File presetFileLocation = new File(presetPath);
        File[] fileArray = presetFileLocation.listFiles();
        int n2 = fileArray.length;
        int n3 = 0;
        while (n3 < n2) {
            File file = fileArray[n3];
            File encoderFile = new File(profileFileLocation + File.separator + file.getName());
            if (!encoderFile.exists()) {
                encoderFile.createNewFile();
            }
            FilesUtil.copyFile(file, encoderFile);
            ++n3;
        }
    }

    public static List<String> getProfileNames() {
        String[] profileNamesArray;
        String profilesPath;
        ArrayList<String> profileNames = new ArrayList<String>();
        switch (LeCTo.operatingSystem.getFamily()) {
            case WINDOWS: {
                profilesPath = WindowsConstants.LECTO_USER_PROFILES_LOCATION;
                break;
            }
            case LINUX: {
                profilesPath = LinuxConstants.LECTO_USER_PROFILES_LOCATION;
                break;
            }
            case MAC: {
                profilesPath = MacOSXConstants.LECTO_USER_PROFILES_LOCATION;
                break;
            }
            default: {
                return profileNames;
            }
        }
        File profilesFilesLocation = new File(profilesPath);
        profilesFilesLocation.mkdirs();
        String[] stringArray = profileNamesArray = profilesFilesLocation.list();
        int n2 = profileNamesArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String name = stringArray[n3];
            profileNames.add(name);
            ++n3;
        }
        return profileNames;
    }

    public static void initLectureWithPofile(final String profileName) throws FailedToInitLectureWithProfileException {
        String propertiesNamePrefix;
        String profilesPath;
        switch (LeCTo.operatingSystem.getFamily()) {
            case WINDOWS: {
                profilesPath = WindowsConstants.LECTO_USER_PROFILES_LOCATION;
                propertiesNamePrefix = WindowsConstants.LECTO_USER_PROFILE_ENCODER_FILE_NAME_PREFIX;
                break;
            }
            case LINUX: {
                profilesPath = LinuxConstants.LECTO_USER_PROFILES_LOCATION;
                propertiesNamePrefix = LinuxConstants.LECTO_USER_PROFILE_ENCODER_FILE_NAME_PREFIX;
                break;
            }
            case MAC: {
                profilesPath = MacOSXConstants.LECTO_USER_PROFILES_LOCATION;
                propertiesNamePrefix = MacOSXConstants.LECTO_USER_PROFILE_ENCODER_FILE_NAME_PREFIX;
                break;
            }
            default: {
                return;
            }
        }
        File profilesFilesLocation = new File(profilesPath);
        profilesFilesLocation.mkdirs();
        File[] profilesFolders = profilesFilesLocation.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.equals(profileName);
            }
        });
        if (profilesFolders.length == 1) {
            File[] encodersPropertiesFiles = profilesFolders[0].listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(propertiesNamePrefix);
                }
            });
            if (encodersPropertiesFiles.length == 0) {
                Lecture.setDefaultParameters(EncodingService.getDefaultDefaultEncodingParameters());
                return;
            }
            Lecture.release();
            File[] fileArray = encodersPropertiesFiles;
            int n2 = encodersPropertiesFiles.length;
            int n3 = 0;
            while (n3 < n2) {
                block11: {
                    File encoderPropertiesFile = fileArray[n3];
                    try {
                        Properties encoderProperties = FilesUtil.loadPropertiesFromFile(encoderPropertiesFile);
                        MediaOptions mediaOptions = UserPresetService.getMediaOptions(encoderProperties);
                        if (mediaOptions != null) {
                            FFMPEGEncoder encoder = new FFMPEGEncoder(mediaOptions);
                            Lecture.addEncoder(encoder);
                            break block11;
                        }
                        throw new FailedToInitLectureWithProfileException("");
                    }
                    catch (IOException e2) {
                        throw new FailedToInitLectureWithProfileException("");
                    }
                }
                ++n3;
            }
            Lecture.prepareEncoders();
        }
    }

    private static File getProfileFolder(final String profileName) {
        String profilesPath;
        switch (LeCTo.operatingSystem.getFamily()) {
            case WINDOWS: {
                profilesPath = WindowsConstants.LECTO_USER_PROFILES_LOCATION;
                break;
            }
            case LINUX: {
                profilesPath = LinuxConstants.LECTO_USER_PROFILES_LOCATION;
                break;
            }
            case MAC: {
                profilesPath = MacOSXConstants.LECTO_USER_PROFILES_LOCATION;
                break;
            }
            default: {
                return null;
            }
        }
        File profilesFilesLocation = new File(profilesPath);
        profilesFilesLocation.mkdirs();
        File[] profiles = profilesFilesLocation.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.equals(profileName);
            }
        });
        if (profiles.length == 1) {
            return profiles[0];
        }
        return null;
    }

    public static void exportProfileToLUPZipFile(String profileName, File location) throws Exception {
        File profileFolder = UserProfilesService.getProfileFolder(profileName);
        if (profileFolder == null) {
            throw new Exception();
        }
        File outFile = new File(String.valueOf(location.getAbsolutePath()) + File.separator + profileName + LeCToConstants.LECTO_USER_PROFILE_PACK_FILE_EXTENSION);
        FilesUtil.createZipArchiveFromFiles(outFile, profileFolder.listFiles());
    }

    public static void deleteProfileFiles(String profileName) {
        File profileFolder = UserProfilesService.getProfileFolder(profileName);
        if (profileFolder != null) {
            File[] fileArray = profileFolder.listFiles();
            int n2 = fileArray.length;
            int n3 = 0;
            while (n3 < n2) {
                File file = fileArray[n3];
                file.delete();
                ++n3;
            }
            profileFolder.delete();
        }
    }

    public static void imporProfileFromLPPZIPArchive(File leCToProfilePack) throws IOException {
        File outFile;
        String profileFolderName = leCToProfilePack.getName().substring(0, leCToProfilePack.getName().indexOf(LeCToConstants.LECTO_USER_PROFILE_PACK_FILE_EXTENSION));
        switch (LeCTo.operatingSystem.getFamily()) {
            case WINDOWS: {
                outFile = new File(String.valueOf(WindowsConstants.LECTO_USER_PROFILES_LOCATION) + File.separator + profileFolderName);
                break;
            }
            case LINUX: {
                outFile = new File(String.valueOf(LinuxConstants.LECTO_USER_PROFILES_LOCATION) + File.separator + profileFolderName);
                break;
            }
            case MAC: {
                outFile = new File(String.valueOf(MacOSXConstants.LECTO_USER_PROFILES_LOCATION) + File.separator + profileFolderName);
                break;
            }
            default: {
                return;
            }
        }
        outFile.mkdirs();
        FilesUtil.extractFromZipArchiveToFile(leCToProfilePack, outFile);
    }
}

