/*
 * Decompiled with CFR 0.152.
 */
package fer.lss.lecto.services.usersettings.model;

import fer.lss.lecto.gui.locale.LeCToLocale;
import fer.lss.lecto.services.translate.TranslateService;
import fer.lss.lecto.utils.FilesUtil;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class UserSettings {
    private static LeCToLocale leCToLocale;

    private static void release() {
        leCToLocale = null;
    }

    public static void fillFromProperties(Properties leCToProperties) {
        UserSettings.release();
        String localeString = leCToProperties.getProperty("localeString");
        if (localeString != null) {
            leCToLocale = TranslateService.getLeCToCustomLocale(localeString);
        }
    }

    public static Properties getPropertiesInstanceForFile(File propertiesFile) {
        Properties props = null;
        try {
            props = FilesUtil.loadPropertiesFromFile(propertiesFile);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        if (leCToLocale != null) {
            props.setProperty("localeString", leCToLocale.getLocale().toString());
        }
        return props;
    }

    public static LeCToLocale getLeCToLocale() {
        return leCToLocale;
    }

    public static void setLeCToLocale(LeCToLocale leCToLocale) {
        UserSettings.leCToLocale = leCToLocale;
    }
}

