/*
 * Decompiled with CFR 0.152.
 */
package fer.lss.lecto.utils;

import fer.lss.lecto.services.libraries.impl.LibrariesServiceWindows;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class FilesUtil {
    public static File copyResourceToFile(String inPath, String name, String outPath) throws IOException {
        InputStream in = LibrariesServiceWindows.class.getResourceAsStream(String.valueOf(inPath) + "/" + name);
        File fileOut = new File(String.valueOf(outPath) + System.getProperty("file.separator") + name);
        FileOutputStream out = FileUtils.openOutputStream(fileOut);
        IOUtils.copy(in, (OutputStream)out);
        in.close();
        ((OutputStream)out).close();
        return fileOut;
    }

    public static File copyResourceToFile(String fullInPath, File fileOut) throws IOException {
        InputStream in = LibrariesServiceWindows.class.getResourceAsStream(fullInPath);
        FileOutputStream out = FileUtils.openOutputStream(fileOut);
        IOUtils.copy(in, (OutputStream)out);
        in.close();
        ((OutputStream)out).close();
        return fileOut;
    }

    public static void copyFile(File inPath, File outFile) throws IOException {
        FileInputStream in = new FileInputStream(inPath);
        FileOutputStream out = FileUtils.openOutputStream(outFile);
        IOUtils.copy((InputStream)in, (OutputStream)out);
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public static Properties loadPropertiesFromFile(File propsFile) throws IOException {
        Properties props = new Properties();
        FileInputStream fis = new FileInputStream(propsFile);
        props.load(fis);
        fis.close();
        return props;
    }

    public static void savePropertiesToFile(Properties properties, File propertiesFile) throws IOException {
        if (!propertiesFile.exists()) {
            propertiesFile.createNewFile();
        }
        FileOutputStream out = new FileOutputStream(propertiesFile);
        properties.store(out, null);
        out.close();
    }

    public static void extractFromZipArchiveToFile(File inZipFile, File outFile) throws IOException {
        ZipFile zipFile = new ZipFile(inZipFile);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            int len;
            ZipEntry entry = entries.nextElement();
            InputStream in = zipFile.getInputStream(entry);
            String outFilename = String.valueOf(outFile.getAbsolutePath()) + File.separator + entry.getName();
            FileOutputStream out = new FileOutputStream(outFilename);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((OutputStream)out).close();
            in.close();
        }
    }

    public static void createZipArchiveFromFiles(File outFile, File[] files) throws IOException {
        byte[] buf = new byte[1024];
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(outFile));
        int i2 = 0;
        while (i2 < files.length) {
            int len;
            FileInputStream in = new FileInputStream(files[i2]);
            out.putNextEntry(new ZipEntry(files[i2].getName()));
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.closeEntry();
            in.close();
            ++i2;
        }
        out.close();
    }

    public static void createZipArchive(File outFile, File propertiesFile, File iconFile) throws IOException {
        File[] files = new File[]{propertiesFile, iconFile};
        byte[] buf = new byte[1024];
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(outFile));
        int i2 = 0;
        while (i2 < files.length) {
            int len;
            FileInputStream in = new FileInputStream(files[i2]);
            out.putNextEntry(new ZipEntry(files[i2].getName()));
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.closeEntry();
            in.close();
            ++i2;
        }
        out.close();
    }
}

