/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.beansbinding;

import java.util.ArrayList;
import java.util.StringTokenizer;

abstract class PropertyPath {
    private PropertyPath() {
    }

    public abstract int length();

    public abstract String get(int var1);

    public String getLast() {
        return this.get(this.length() - 1);
    }

    public abstract String toString();

    public static PropertyPath createPropertyPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path must be non-null");
        }
        StringTokenizer tokenizer = new StringTokenizer(path, ".");
        ArrayList<String> list = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        int size = list.size();
        if (size == 0) {
            throw new IllegalArgumentException("path must be non-empty");
        }
        if (list.size() == 1) {
            return new SinglePropertyPath((String)list.get(0));
        }
        String[] multi = new String[list.size()];
        return new MultiPropertyPath(list.toArray(multi));
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (o2 instanceof PropertyPath) {
            PropertyPath oPath = (PropertyPath)o2;
            int length = this.length();
            if (length != oPath.length()) {
                return false;
            }
            int i2 = 0;
            if (i2 < length) {
                return this.get(i2).equals(oPath.get(i2));
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        int length = this.length();
        for (int i2 = 0; i2 < length; ++i2) {
            result = 37 * result + this.get(i2).hashCode();
        }
        return result;
    }

    static final class MultiPropertyPath
    extends PropertyPath {
        private final String[] path;

        public MultiPropertyPath(String[] path) {
            this.path = path;
            for (int i2 = 0; i2 < path.length; ++i2) {
                path[i2] = path[i2].intern();
            }
            assert (path.length > 0);
        }

        public int length() {
            return this.path.length;
        }

        public String get(int index) {
            return this.path[index];
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.path[0]);
            for (int i2 = 1; i2 < this.path.length; ++i2) {
                builder.append('.');
                builder.append(this.path[i2]);
            }
            return builder.toString();
        }
    }

    static final class SinglePropertyPath
    extends PropertyPath {
        private final String path;

        public SinglePropertyPath(String path) {
            this.path = path.intern();
        }

        public int length() {
            return 1;
        }

        public String get(int index) {
            if (index == 0) {
                return this.path;
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public String getLast() {
            return this.path;
        }

        public String toString() {
            return this.path;
        }
    }
}

