/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.impl;

import com.sun.java.help.impl.HeaderParser;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLConnection;

public final class XmlReader
extends Reader {
    private boolean closed;
    private InputStreamReader in;
    private InputStream raw;
    private byte[] buffer;
    private boolean isASCII;
    private boolean isLatin1;
    private int offset;
    private int length;
    private char nextChar;
    private int switchover;
    private String encodingAssigned;
    private static boolean debug = false;

    public static Reader createReader(URLConnection uRLConnection) throws IOException {
        String string = XmlReader.getEncodingFromContentType(uRLConnection.getContentType());
        if (string == null) {
            return XmlReader.createReader(uRLConnection.getInputStream());
        }
        return XmlReader.createReader(uRLConnection.getInputStream(), string);
    }

    private static String getEncodingFromContentType(String string) {
        XmlReader.debug("type=" + string);
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf(";");
        if (n2 > -1) {
            String string2 = string.substring(n2);
            if ((string = string.substring(0, n2).trim()).compareTo("text/xml") == 0) {
                return XmlReader.getCharsetFromContentTypeParameters(string2);
            }
        }
        return null;
    }

    private static String getCharsetFromContentTypeParameters(String string) {
        String string2 = null;
        try {
            int n2 = string.indexOf(59);
            if (n2 > -1 && n2 < string.length() - 1) {
                string = string.substring(n2 + 1);
            }
            if (string.length() > 0) {
                HeaderParser headerParser = new HeaderParser(string);
                string2 = headerParser.findValue("charset");
                return string2;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            System.err.println("Indexer.getCharsetFromContentTypeParameters failed on: " + string);
            exception.printStackTrace();
        }
        return string2;
    }

    public static Reader createReader(InputStream inputStream) throws IOException {
        return new XmlReader(inputStream);
    }

    public static Reader createReader(InputStream inputStream, String string) throws IOException {
        if (string == null) {
            return new XmlReader(inputStream);
        }
        if ("UTF-16".equalsIgnoreCase(string) || "ISO-106460-UCS-2".equalsIgnoreCase(string)) {
            string = "Unicode";
        } else {
            if ("UTF-8".equalsIgnoreCase(string)) {
                return new XmlReader(inputStream, "UTF-8");
            }
            if ("EUC-JP".equalsIgnoreCase(string)) {
                string = "EUCJIS";
            } else {
                if (XmlReader.isAsciiName(string)) {
                    return new XmlReader(inputStream, "US-ASCII");
                }
                if (XmlReader.isLatinName(string)) {
                    return new XmlReader(inputStream, "ISO-8859-1");
                }
            }
        }
        return new InputStreamReader(inputStream, string);
    }

    private XmlReader(InputStream inputStream, String string) throws IOException {
        this.buffer = new byte[8192];
        this.length = 0;
        this.raw = inputStream;
        if ("US-ASCII".equals(string)) {
            this.setASCII();
        } else if ("ISO-8859-1".equals(string)) {
            this.setLatin1();
        } else {
            if (!"UTF-8".equals(string)) {
                throw new UnsupportedEncodingException(string);
            }
            this.setUTF8();
        }
    }

    private static boolean isAsciiName(String string) {
        return "US-ASCII".equalsIgnoreCase(string) || "ASCII".equalsIgnoreCase(string);
    }

    private static boolean isLatinName(String string) {
        return "ISO-8859-1".equalsIgnoreCase(string) || "Latin1".equalsIgnoreCase(string) || "8859_1".equalsIgnoreCase(string);
    }

    private void setASCII() {
        this.encodingAssigned = "US-ASCII";
        this.isASCII = true;
        this.isLatin1 = false;
        this.offset = 0;
    }

    private void setLatin1() {
        this.encodingAssigned = "ISO-8859-1";
        this.isASCII = false;
        this.isLatin1 = true;
        this.offset = 0;
    }

    private void setUTF8() {
        this.encodingAssigned = "UTF-8";
        this.isASCII = false;
        this.isLatin1 = false;
        this.offset = 0;
    }

    public String getEncoding() {
        return this.encodingAssigned;
    }

    private XmlReader(InputStream inputStream) throws IOException {
        this.raw = inputStream;
        this.switchover = -1;
        this.buffer = new byte[8192];
        this.length = 0;
        this.offset = 0;
        this.isLatin1 = true;
        int n2 = this.read();
        block0 : switch (n2) {
            case 0: {
                n2 = this.read();
                if (n2 == 60 && (n2 = this.read()) == 0 && (n2 = this.read()) == 63) {
                    this.setSwitchover("UnicodeBig");
                    return;
                }
                throw new UnsupportedEncodingException("UCS-4 (?)");
            }
            case 60: {
                n2 = this.read();
                switch (n2) {
                    default: {
                        break block0;
                    }
                    case 0: {
                        if (this.read() == 63 && this.read() == 0) {
                            this.setSwitchover("UnicodeLittle");
                            return;
                        }
                        throw new UnsupportedEncodingException("UCS-4");
                    }
                    case 63: 
                }
                if (this.read() != 120 || this.read() != 109 || this.read() != 108 || this.read() != 32) break;
                this.guessEncoding();
                return;
            }
            case 254: {
                n2 = this.read();
                if (n2 != 255) break;
                this.setSwitchover("UnicodeBig");
                this.offset = 2;
                return;
            }
            case 255: {
                n2 = this.read();
                if (n2 != 254) break;
                this.setSwitchover("UnicodeLittle");
                this.offset = 2;
                return;
            }
            case -1: {
                return;
            }
        }
        this.setUTF8();
    }

    private void setSwitchover(String string) throws IOException {
        this.switchover = this.offset;
        this.encodingAssigned = string;
        this.offset = 0;
    }

    private void doSwitchover() throws IOException {
        if (this.offset != this.switchover) {
            throw new InternalError();
        }
        this.in = new InputStreamReader(this.raw, this.encodingAssigned);
        this.buffer = null;
        this.switchover = -1;
    }

    private void guessEncoding() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = null;
        String string = null;
        boolean bl = false;
        char c2 = '\u0000';
        boolean bl2 = false;
        block0: for (int i2 = 0; i2 < 100; ++i2) {
            int n2 = this.read();
            if (n2 == -1) {
                this.setASCII();
                return;
            }
            if (Character.isWhitespace((char)n2)) continue;
            if (n2 == 63) {
                bl2 = true;
            } else if (bl2) {
                if (n2 == 62) break;
                bl2 = false;
            }
            if (string == null || !bl) {
                if (stringBuffer2 == null) {
                    if (Character.isWhitespace((char)n2)) continue;
                    stringBuffer2 = stringBuffer;
                    stringBuffer.setLength(0);
                    stringBuffer.append((char)n2);
                    bl = false;
                    continue;
                }
                if (Character.isWhitespace((char)n2)) {
                    string = stringBuffer2.toString();
                    continue;
                }
                if (n2 == 61) {
                    if (string == null) {
                        string = stringBuffer2.toString();
                    }
                    bl = true;
                    stringBuffer2 = null;
                    c2 = '\u0000';
                    continue;
                }
                stringBuffer2.append((char)n2);
                continue;
            }
            if (Character.isWhitespace((char)n2)) continue;
            if (n2 == 34 || n2 == 39) {
                if (c2 == '\u0000') {
                    c2 = (char)n2;
                    stringBuffer.setLength(0);
                    continue;
                }
                if (n2 == c2) {
                    if ("encoding".equals(string)) {
                        String string2 = stringBuffer.toString();
                        for (i2 = 0; i2 < string2.length(); ++i2) {
                            n2 = string2.charAt(i2);
                            if (!(n2 >= 65 && n2 <= 90 || n2 >= 97 && n2 <= 122) && (i2 <= 0 || n2 != 45 && (n2 < 48 || n2 > 57) && n2 != 46 && n2 != 95)) break block0;
                        }
                        if (XmlReader.isAsciiName(string2)) {
                            this.setASCII();
                            return;
                        }
                        if (XmlReader.isLatinName(string2)) {
                            this.setLatin1();
                            return;
                        }
                        if ("UTF-8".equalsIgnoreCase(string2) || "UTF8".equalsIgnoreCase(string2)) break;
                        if ("EUC-JP".equalsIgnoreCase(string2)) {
                            string2 = "EUCJIS";
                        }
                        this.setSwitchover(string2);
                        return;
                    }
                    string = null;
                    continue;
                }
            }
            stringBuffer.append((char)n2);
        }
        this.setUTF8();
    }

    private char utf8char() throws IOException {
        int n2;
        int n3;
        char c2;
        block12: {
            if (this.nextChar != '\u0000') {
                char c3 = this.nextChar;
                this.nextChar = '\u0000';
                return c3;
            }
            c2 = (char)this.buffer[this.offset];
            if ((c2 & 0x80) == 0) {
                ++this.offset;
                return c2;
            }
            if (this.isASCII) {
                throw new CharConversionException("Not US-ASCII:  0x" + Integer.toHexString(c2 & 0xFF));
            }
            n3 = this.offset;
            try {
                if ((this.buffer[n3] & 0xE0) == 192) {
                    n2 = (this.buffer[n3++] & 0x1F) << 6;
                    c2 = (char)(n2 += this.buffer[n3++] & 0x3F);
                    n2 = 0;
                    break block12;
                }
                if ((this.buffer[n3] & 0xF0) == 224) {
                    n2 = (this.buffer[n3++] & 0xF) << 12;
                    n2 += (this.buffer[n3++] & 0x3F) << 6;
                    c2 = (char)(n2 += this.buffer[n3++] & 0x3F);
                    n2 = 0;
                    break block12;
                }
                if ((this.buffer[n3] & 0xF8) == 240) {
                    n2 = (this.buffer[n3++] & 7) << 18;
                    n2 += (this.buffer[n3++] & 0x3F) << 12;
                    n2 += (this.buffer[n3++] & 0x3F) << 6;
                    n2 += this.buffer[n3++] & 0x3F;
                    c2 = (char)(55296 + ((n2 -= 65536) >> 10));
                    n2 = 56320 + (n2 & 0x3FF);
                    break block12;
                }
                throw new CharConversionException("Illegal XML character 0x" + Integer.toHexString(this.buffer[this.offset] & 0xFF));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                c2 = '\u0000';
                n2 = 0;
            }
        }
        if (n3 > this.length) {
            System.arraycopy(this.buffer, this.offset, this.buffer, 0, this.length - this.offset);
            this.length -= this.offset;
            this.offset = 0;
            n3 = this.raw.read(this.buffer, this.length, this.buffer.length - this.length);
            if (n3 < 0) {
                throw new CharConversionException("Partial UTF-8 char");
            }
            this.length += n3;
            return this.utf8char();
        }
        ++this.offset;
        while (this.offset < n3) {
            if ((this.buffer[this.offset] & 0xC0) != 128) {
                throw new CharConversionException("Malformed UTF-8 char");
            }
            ++this.offset;
        }
        this.nextChar = (char)n2;
        return c2;
    }

    public int read(char[] cArray, int n2, int n3) throws IOException {
        int n4;
        if (this.closed) {
            return -1;
        }
        if (this.switchover > 0 && this.offset == this.switchover) {
            this.doSwitchover();
        }
        if (this.in != null) {
            return this.in.read(cArray, n2, n3);
        }
        if (this.offset >= this.length) {
            this.offset = 0;
            this.length = this.raw.read(this.buffer, 0, this.buffer.length);
        }
        if (this.length <= 0) {
            return -1;
        }
        if (this.encodingAssigned == null || this.isLatin1) {
            for (n4 = 0; n4 < n3 && this.offset < this.length; ++n4) {
                cArray[n2++] = (char)(this.buffer[this.offset++] & 0xFF);
            }
        } else {
            for (n4 = 0; n4 < n3 && this.offset < this.length; ++n4) {
                cArray[n2++] = this.utf8char();
            }
        }
        return n4;
    }

    public int read() throws IOException {
        if (this.closed) {
            return -1;
        }
        if (this.switchover > 0 && this.offset == this.switchover) {
            this.doSwitchover();
        }
        if (this.in != null) {
            return this.in.read();
        }
        if (this.offset >= this.length) {
            if (this.encodingAssigned == null) {
                if (this.length == this.buffer.length) {
                    throw new InternalError("too much peekahead");
                }
                int n2 = this.raw.read(this.buffer, this.offset, 1);
                if (n2 <= 0) {
                    return -1;
                }
                this.length += n2;
            } else {
                this.offset = 0;
                this.length = this.raw.read(this.buffer, 0, this.buffer.length);
                if (this.length <= 0) {
                    return -1;
                }
            }
        }
        if (this.isLatin1 || this.encodingAssigned == null) {
            return this.buffer[this.offset++] & 0xFF;
        }
        return this.utf8char();
    }

    public boolean markSupported() {
        return this.in != null && this.in.markSupported();
    }

    public void mark(int n2) throws IOException {
        if (this.in != null) {
            this.in.mark(n2);
        }
    }

    public void reset() throws IOException {
        if (this.in != null) {
            this.in.reset();
        }
    }

    public long skip(long l2) throws IOException {
        if (l2 < 0L) {
            return 0L;
        }
        if (this.in != null) {
            return this.in.skip(l2);
        }
        long l3 = this.length - this.offset;
        if (l3 >= l2) {
            this.offset += (int)l2;
            return l2;
        }
        this.offset = (int)((long)this.offset + l3);
        return l3 + this.raw.skip(l2 - l3);
    }

    public boolean ready() throws IOException {
        if (this.in != null) {
            return this.in.ready();
        }
        return this.length > this.offset || this.raw.available() != 0;
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.in != null) {
            this.in.close();
        } else {
            this.raw.close();
        }
        this.closed = true;
    }

    private static void debug(String string) {
        if (debug) {
            System.out.println("XmlReader: " + string);
        }
    }
}

