/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.ByteArrayDecompressor;
import com.sun.java.help.search.CompressorIterator;
import com.sun.java.help.search.ConceptData;
import com.sun.java.help.search.Decompressor;
import com.sun.java.help.search.RoleFiller;

class ConceptGroupGenerator
implements CompressorIterator {
    private static final int NConceptsInGroup = 16;
    private static final int BitsInLabel = 4;
    private int _last;
    private ConceptData[] _table;
    private Decompressor _bits;
    private int _k1;
    private final int _k2 = 4;
    private ConceptData _cData;

    public ConceptGroupGenerator() {
        this._k1 = 0;
        this._table = new ConceptData[16];
        this._last = 0;
        this._bits = null;
    }

    public ConceptGroupGenerator(byte[] byArray, int n2, int n3) {
        this._k1 = n3;
        this._table = new ConceptData[16];
        this._last = 0;
        this._bits = new ByteArrayDecompressor(byArray, n2);
    }

    public void init(byte[] byArray, int n2, int n3) {
        this._k1 = n3;
        this._bits = new ByteArrayDecompressor(byArray, n2);
        this._last = 0;
        for (int i2 = 0; i2 < 16; ++i2) {
            this._table[i2] = null;
        }
    }

    public void addTerms(int n2, ConceptData conceptData) {
        this._table[n2] = conceptData;
    }

    public int decodeConcepts(int n2, int n3, int[] nArray) throws Exception {
        return this._bits.ascendingDecode(n2, n3, nArray);
    }

    public int position() {
        return this._last;
    }

    public void value(int n2) {
        this._last += n2;
    }

    boolean next() throws Exception {
        try {
            while (this._bits.readNext(this._k1, this)) {
                this._cData = this._table[this._bits.read(4)];
                if (this._cData == null) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(this._bits);
            System.err.println(this._table);
            throw exception;
        }
    }

    public void generateFillers(RoleFiller[] roleFillerArray) {
        this._cData.generateFillers(roleFillerArray, this._last);
    }
}

