/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.ConceptData;
import com.sun.java.help.search.Location;
import com.sun.java.help.search.Query;
import java.io.PrintStream;

class RoleFiller {
    static int Threshold = 300;
    private ConceptData _conceptData;
    private byte _fixedRole;
    private short _filled;
    private int _begin;
    private int _end;
    private int _limit;
    private RoleFiller _next;
    private RoleFiller[] _fillers;
    public static final RoleFiller STOP = new RoleFiller();

    private RoleFiller() {
    }

    public RoleFiller(int n2, ConceptData conceptData, int n3, int n4, int n5) {
        this._conceptData = conceptData;
        this._fixedRole = (byte)n3;
        this._filled = (short)(1 << this._fixedRole);
        this._begin = n4;
        this._end = this._begin + conceptData.getConceptLength();
        this._limit = n5;
        this._next = null;
        this._fillers = new RoleFiller[n2];
        this._fillers[n3] = this;
    }

    public void print(PrintStream printStream) {
        printStream.println(this._begin + ", " + this._end);
    }

    void makeQueryHit(Query query, int n2, int n3, double d2) {
        if (query.goodEnough(d2)) {
            int[] nArray = query.getConceptArrayOfNewHit(d2, new Location(n3, this._begin, this._end));
            for (int i2 = 0; i2 < n2; ++i2) {
                nArray[i2] = (this._filled & 1 << i2) != 0 ? this._fillers[i2].getConcept() : 0;
            }
        }
    }

    boolean isHit() {
        return this._filled > 1 << this._fixedRole;
    }

    double getScore() {
        return this._conceptData.getScore();
    }

    int getConcept() {
        return this._conceptData.getConcept();
    }

    RoleFiller next() {
        return this._next;
    }

    void use(RoleFiller[] roleFillerArray, int n2) {
        if (roleFillerArray[n2] != null) {
            RoleFiller roleFiller = roleFillerArray[n2];
            roleFillerArray[n2] = this;
            this._next = roleFiller;
            while (roleFiller._limit >= this._begin) {
                if (this._fixedRole != roleFiller._fixedRole) {
                    if ((roleFiller._filled & 1 << this._fixedRole) == 0) {
                        roleFiller._filled = (short)(roleFiller._filled | 1 << this._fixedRole);
                        roleFiller._fillers[this._fixedRole] = this;
                        roleFiller._end = this._end;
                    } else {
                        roleFiller.considerReplacementWith(this);
                    }
                }
                if (roleFiller._next != null) {
                    roleFiller = roleFiller._next;
                    continue;
                }
                return;
            }
        } else {
            roleFillerArray[n2] = this;
        }
    }

    private void considerReplacementWith(RoleFiller roleFiller) {
        byte by = roleFiller._fixedRole;
        if (roleFiller.getScore() > this._fillers[by].getScore()) {
            this._fillers[by] = roleFiller;
        }
    }

    private double penalty(Query query, int n2) {
        int n3 = this._end - this._begin + 1;
        double d2 = query.lookupPenalty(this._filled);
        for (int i2 = 0; i2 < n2; ++i2) {
            if ((this._filled & 1 << i2) == 0) continue;
            d2 += this._fillers[i2]._conceptData.getPenalty();
            n3 -= this._fillers[i2]._conceptData.getConceptLength() + 1;
            if (this._filled >> i2 + 1 == 0) continue;
            for (int i3 = i2 + 1; i3 < n2; ++i3) {
                if ((this._filled & 1 << i3) == 0 || this._fillers[i3]._begin >= this._begin) continue;
                d2 += query.getOutOufOrderPenalty();
            }
        }
        return d2 + (double)n3 * query.getGapPenalty();
    }

    public void scoreList(Query query, int n2) {
        int n3 = query.getNColumns();
        RoleFiller roleFiller = this;
        double d2 = roleFiller.penalty(query, n3);
        RoleFiller roleFiller2 = roleFiller._next;
        while (roleFiller2 != null) {
            if (roleFiller2._end < roleFiller._begin) {
                roleFiller.makeQueryHit(query, n3, n2, d2);
                roleFiller = roleFiller2;
                d2 = roleFiller.penalty(query, n3);
            } else {
                double d3 = roleFiller2.penalty(query, n3);
                if (d3 <= d2) {
                    d2 = d3;
                    roleFiller = roleFiller2;
                }
            }
            roleFiller2 = roleFiller2._next;
        }
        roleFiller.makeQueryHit(query, n3, n2, d2);
    }
}

