/*
 * Decompiled with CFR 0.152.
 */
package de.humatic.dsj.sink;

import de.humatic.dsj.DSEnvironment;
import de.humatic.dsj.DSFilterInfo;
import de.humatic.dsj.DSJException;
import de.humatic.dsj.sink.Sink;
import java.io.File;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FileSink
extends Sink {
    public static final int MP4 = 0;
    public static final int OGG = 1;
    public static final int MKV = 2;
    public static final int WEBM = 3;
    public static final int WAV = 4;

    public FileSink(String string) {
        this.path = string;
        try {
            if (!new File(new File(this.path).getAbsoluteFile().getParent()).exists()) {
                new File(new File(this.path).getAbsoluteFile().getParent()).mkdirs();
            }
        }
        catch (Exception exception) {
            throw new DSJException("failed to create parent directory", -40);
        }
        this.majorType = 2;
        this.subType = 2;
    }

    public static FileSink fromXML(String object, String string) {
        Node node = null;
        Object object2 = DSEnvironment.getXMLSetup().getDocumentElement().getElementsByTagName("modules").item(0);
        object2 = ((Element)object2).getElementsByTagName("sinkmodules").item(0);
        object2 = ((Element)object2).getElementsByTagName("module");
        for (int i2 = 0; i2 < object2.getLength(); ++i2) {
            if (!((Element)object2.item(i2)).getAttribute("name").equalsIgnoreCase((String)object)) continue;
            node = object2.item(i2);
            break;
        }
        if (node == null) {
            return null;
        }
        FileSink fileSink = new FileSink(string);
        object = ((Element)node).getElementsByTagName("audioencoder").item(0);
        if (object != null) {
            fileSink.setAudioEncoder(DSFilterInfo.filterInfoForCLSID(((Element)object).getAttribute("clsid")));
        }
        if (object != null && (fileSink.getAudioEncoderInfo().getName().equalsIgnoreCase("none") || fileSink.getAudioEncoderInfo().getName().equalsIgnoreCase("ACM Wrapper"))) {
            fileSink.setAudioEncoder(DSFilterInfo.filterInfoForName(((Element)object).getAttribute("name")));
        }
        if ((object = ((Element)node).getElementsByTagName("videoencoder").item(0)) != null) {
            fileSink.setVideoEncoder(DSFilterInfo.filterInfoForCLSID(((Element)object).getAttribute("clsid")));
        }
        if (object != null && (fileSink.getVideoEncoderInfo().getName().equalsIgnoreCase("none") || fileSink.getVideoEncoderInfo().getName().equalsIgnoreCase("ICM Wrapper"))) {
            fileSink.setVideoEncoder(DSFilterInfo.filterInfoForName(((Element)object).getAttribute("name")));
        }
        if ((object = ((Element)node).getElementsByTagName("muxer").item(0)) != null) {
            fileSink.setMultiplexer(DSFilterInfo.filterInfoForCLSID(((Element)object).getAttribute("clsid")));
        }
        if (object != null && fileSink.getMultiplexerInfo().getName().equalsIgnoreCase("none")) {
            fileSink.setMultiplexer(DSFilterInfo.filterInfoForName(((Element)object).getAttribute("name")));
        }
        if ((object = ((Element)node).getElementsByTagName("filewriter").item(0)) != null) {
            fileSink.setFileWriter(DSFilterInfo.filterInfoForCLSID(((Element)object).getAttribute("clsid")));
        }
        if (object != null && fileSink.getWriterInfo().getName().equalsIgnoreCase("none")) {
            fileSink.setFileWriter(DSFilterInfo.filterInfoForName(((Element)object).getAttribute("name")));
        }
        return fileSink;
    }

    public static FileSink forType(int n2, String string) throws DSJException {
        FileSink fileSink = null;
        DSFilterInfo dSFilterInfo = null;
        dSFilterInfo = null;
        dSFilterInfo = null;
        switch (n2) {
            case 0: {
                fileSink = new FileSink(string);
                dSFilterInfo = DSFilterInfo.filterInfoForName("3ivx D4 Media Muxer");
                if (dSFilterInfo == null) {
                    throw new DSJException("MP4Sink, 3ivX filters not found", -10);
                }
                fileSink.setMultiplexer(dSFilterInfo);
                dSFilterInfo = DSFilterInfo.filterInfoForName("3ivx D4 Audio Encoder");
                if (dSFilterInfo == null) {
                    throw new DSJException("MP4Sink, 3ivX filters not found", -10);
                }
                fileSink.setAudioEncoder(dSFilterInfo);
                dSFilterInfo = DSFilterInfo.filterInfoForName("3ivx D4 Video Encoder");
                if (dSFilterInfo == null) {
                    throw new DSJException("MP4Sink, 3ivX filters not found", -10);
                }
                fileSink.setVideoEncoder(dSFilterInfo);
                break;
            }
            case 1: {
                fileSink = new FileSink(string);
                dSFilterInfo = DSFilterInfo.filterInfoForCLSID("{1F3EFFE4-0E70-47C7-9C48-05EB99E20011}");
                if (dSFilterInfo == null) {
                    throw new DSJException("OggSink, filters not found", -10);
                }
                fileSink.setMultiplexer(dSFilterInfo);
                dSFilterInfo = DSFilterInfo.filterInfoForCLSID("{5C94FE86-B93B-467F-BFC3-BD6C91416F9B}");
                if (dSFilterInfo == null) {
                    throw new DSJException("OggSink, filters not found", -10);
                }
                fileSink.setAudioEncoder(dSFilterInfo);
                dSFilterInfo = DSFilterInfo.filterInfoForCLSID("{5C769985-C3E1-4F95-BEE7-1101C465F5FC}");
                if (dSFilterInfo == null) {
                    throw new DSJException("OggSink, filters not found", -10);
                }
                fileSink.setVideoEncoder(dSFilterInfo);
                fileSink.setFileWriter(null);
                break;
            }
            case 2: {
                fileSink = new FileSink(string.indexOf(".mkv") < 0 ? string.substring(0, string.indexOf(".")) + "mkv" : string);
                dSFilterInfo = DSFilterInfo.filterInfoForCLSID("{1E1299A2-9D42-4F12-8791-D79E376F4143}");
                if (dSFilterInfo == null) {
                    throw new DSJException("MKVSink, filters not found", -10);
                }
                fileSink.setMultiplexer(dSFilterInfo);
                fileSink.flags |= 8;
                break;
            }
            case 3: {
                fileSink = new FileSink(string.indexOf(".webm") < 0 ? string.substring(0, string.indexOf(".")) + "webm" : string);
                dSFilterInfo = DSFilterInfo.filterInfoForCLSID("{ED3110F0-5211-11DF-94AF-0026B977EEAA}");
                if (dSFilterInfo == null) {
                    throw new DSJException("WebMSink, muxer not found", -10);
                }
                fileSink.setMultiplexer(dSFilterInfo);
                dSFilterInfo = DSFilterInfo.filterInfoForCLSID("{5C94FE86-B93B-467F-BFC3-BD6C91416F9B}");
                if (dSFilterInfo == null) {
                    throw new DSJException("WebMSink, Vorbis encoder not found", -10);
                }
                fileSink.setAudioEncoder(dSFilterInfo);
                dSFilterInfo = DSFilterInfo.filterInfoForCLSID("{ED3110F5-5211-11DF-94AF-0026B977EEAA}");
                if (dSFilterInfo == null) {
                    throw new DSJException("WebMSink, VP8 encoder not found", -10);
                }
                fileSink.setVideoEncoder(dSFilterInfo);
                break;
            }
            case 4: {
                fileSink = new FileSink(string);
                fileSink.setMultiplexer(new DSFilterInfo("Wav Muxer", "{564A75B1-B81C-46ea-9C45-7281108AA9C5}"));
            }
        }
        return fileSink;
    }

    public void setFileWriter(DSFilterInfo dSFilterInfo) {
        this.writer = dSFilterInfo == null ? DSFilterInfo.doNotRender() : dSFilterInfo;
    }

    public void setTargetFile(String string) {
        this.path = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FileSink: ");
        stringBuffer.append(this.path);
        stringBuffer.append("\n");
        try {
            stringBuffer.append(this.audioEncoder.getName());
            stringBuffer.append("\n");
        }
        catch (NullPointerException nullPointerException) {}
        try {
            stringBuffer.append(this.videoEncoder.getName());
            stringBuffer.append("\n");
        }
        catch (NullPointerException nullPointerException) {}
        try {
            stringBuffer.append(this.muxer.getName());
            stringBuffer.append("\n");
        }
        catch (NullPointerException nullPointerException) {}
        try {
            stringBuffer.append(this.writer.getName());
        }
        catch (NullPointerException nullPointerException) {}
        return stringBuffer.toString();
    }
}

