/*
 * Decompiled with CFR 0.152.
 */
package fer.lss.lecto.encoder.impl;

import fer.lss.lecto.constants.MacOSXConstants;
import fer.lss.lecto.encoder.FFMPEGEncoder;
import fer.lss.lecto.model.mediaoptions.MediaOptions;
import fer.lss.lecto.services.usersettings.UserSettingsService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class EncoderMacOSX
extends FFMPEGEncoder {
    private Process runningProcess;
    private String ffmpegCommand;
    private int pauseCounter = 0;

    public EncoderMacOSX(MediaOptions mediaOptions) {
        super(mediaOptions);
        this.setupFFMPEGCommand();
    }

    private void setupFFMPEGCommand() {
        String ffmpegPath = MacOSXConstants.FFMPEGPath();
        if (!this.mediaOptions.getHasVideo().booleanValue()) {
            return;
        }
        String outputFileName = String.valueOf(this.getMediaOptions().getFileFullPath()) + File.separator + this.getMediaOptions().getFileName() + "part" + this.pauseCounter + "." + this.getMediaOptions().getContainer();
        String videoIndex = this.getMediaOptions().getVideoInput().getDeviceIndex();
        String audioIndex = this.getMediaOptions().getAudioInput().getDeviceIndex();
        StringBuilder sb = new StringBuilder(ffmpegPath);
        sb.append(" -f avfoundation -vsync 2 -i " + videoIndex);
        if (this.getMediaOptions().getHasAudio().booleanValue()) {
            sb.append(":" + audioIndex);
        } else {
            sb.append(":");
        }
        sb.append(" " + outputFileName + " -y");
        this.ffmpegCommand = sb.toString();
        System.out.println(this.ffmpegCommand);
    }

    @Override
    public boolean startEncoding() {
        this.setupFFMPEGCommand();
        if (!this.mediaOptions.getHasVideo().booleanValue()) {
            return false;
        }
        try {
            UserSettingsService.addEncoderToPauseList(this, "part" + this.pauseCounter);
            this.runningProcess = Runtime.getRuntime().exec(this.ffmpegCommand);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return true;
    }

    @Override
    public void pauseEncoding() {
        ++this.pauseCounter;
        BufferedWriter processInput = new BufferedWriter(new OutputStreamWriter(this.runningProcess.getOutputStream()));
        String commandToSend = "q";
        try {
            processInput.write(commandToSend);
            processInput.flush();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        BufferedReader processOutput = new BufferedReader(new InputStreamReader(this.runningProcess.getErrorStream()));
        String line = null;
        try {
            line = processOutput.readLine();
            while (line != null) {
                line = processOutput.readLine();
            }
            this.runningProcess.destroyForcibly();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    @Override
    public void stopEncoding() {
        if (this.runningProcess.isAlive()) {
            BufferedWriter processInput = new BufferedWriter(new OutputStreamWriter(this.runningProcess.getOutputStream()));
            String commandToSend = "q";
            try {
                processInput.write(commandToSend);
                processInput.flush();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            BufferedReader processOutput = new BufferedReader(new InputStreamReader(this.runningProcess.getErrorStream()));
            String line = null;
            try {
                line = processOutput.readLine();
                while (line != null) {
                    line = processOutput.readLine();
                }
                this.runningProcess.destroyForcibly();
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
        }
        this.pauseCounter = 0;
        StringBuilder concatenateCommand = new StringBuilder(MacOSXConstants.FFMPEGPath());
        String pauseFilePath = UserSettingsService.getPauseFilePathForEncoder(this);
        String outputFile = String.valueOf(this.getMediaOptions().getFileFullPath()) + File.separator + this.getMediaOptions().getFileName() + "." + this.getMediaOptions().getContainer();
        concatenateCommand.append(" -f concat -i " + pauseFilePath + " -c copy");
        concatenateCommand.append(" " + outputFile + " -y");
        System.out.println("concat command " + concatenateCommand);
        try {
            Process proc = Runtime.getRuntime().exec(concatenateCommand.toString());
            BufferedReader processOutput = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            String line = null;
            line = processOutput.readLine();
            while (line != null) {
                System.out.println("concat: " + line);
                line = processOutput.readLine();
            }
            UserSettingsService.deletePauseListForEncoder(this);
        }
        catch (IOException e4) {
            e4.printStackTrace();
        }
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.setupFFMPEGCommand();
    }

    @Override
    public void setFileFullPath(String fileFullPath) {
        super.setFileFullPath(fileFullPath);
        this.setupFFMPEGCommand();
    }

    @Override
    public void setMediaOptions(MediaOptions mediaOptions) {
        super.setMediaOptions(mediaOptions);
        this.setupFFMPEGCommand();
    }
}

