/*
 * Decompiled with CFR 0.152.
 */
package fer.lss.lecto.gui;

import fer.lss.lecto.gui.locale.ILocale;
import fer.lss.lecto.services.MessagesService;
import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.net.URL;
import javax.help.HelpSet;
import javax.help.JHelp;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class LeCToHelpFrame
extends JFrame
implements ILocale {
    private static final long serialVersionUID = 1L;
    private JPanel contentPane;
    private int thisFrameWidth = 500;
    private int thisFrameHeight = 500;
    private JHelp helpViewer;

    public LeCToHelpFrame() {
        this.setStringValues();
        this.createGUI();
        this.createHelpView();
    }

    private void createGUI() {
        this.setModalExclusionType(Dialog.ModalExclusionType.NO_EXCLUDE);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Double screenWidth = screenSize.getWidth();
        this.setBounds(screenWidth.intValue() - this.thisFrameWidth - 100, 100, this.thisFrameWidth, this.thisFrameHeight);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(LeCToHelpFrame.class.getResource("/images/favicon32T.png")));
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.setContentPane(this.contentPane);
    }

    private void createHelpView() {
        this.helpViewer = null;
        try {
            ClassLoader cl = LeCToHelpFrame.class.getClassLoader();
            URL url = HelpSet.findHelpSet(cl, "help/LeCToHelp/jhelpset.hs");
            this.helpViewer = new JHelp(new HelpSet(cl, url));
        }
        catch (Exception e2) {
            System.err.println("API Help Set not found");
        }
        this.contentPane.add(this.helpViewer);
    }

    public void setViewingId(String id) {
        this.helpViewer.setCurrentID(id);
    }

    @Override
    public void setStringValues() {
        this.setTitle(MessagesService.getString("LeCToHelpFrame.this.title"));
    }
}

