/*
 * Decompiled with CFR 0.152.
 */
package fer.lss.lecto.gui;

import fer.lss.lecto.LeCTo;
import fer.lss.lecto.LeCToGlobalState;
import fer.lss.lecto.encoder.FFMPEGEncoder;
import fer.lss.lecto.exceptions.FailedToInitLectureWithProfileException;
import fer.lss.lecto.filters.ExtensionFileFilter;
import fer.lss.lecto.gui.AboutDialog;
import fer.lss.lecto.gui.LeCToLogFrame;
import fer.lss.lecto.gui.LectureEditor;
import fer.lss.lecto.gui.locale.ILocale;
import fer.lss.lecto.gui.locale.LeCToLocale;
import fer.lss.lecto.gui.psu.PSUEditor;
import fer.lss.lecto.gui.translate.DeleteLanguagesDialog;
import fer.lss.lecto.gui.translate.ExportLanguagesDialog;
import fer.lss.lecto.gui.translate.LeCToTranslateDialog;
import fer.lss.lecto.gui.userprofiles.DeleteProfilesDialog;
import fer.lss.lecto.gui.userprofiles.ExportProfilesDialog;
import fer.lss.lecto.gui.userprofiles.SaveProfileDialog;
import fer.lss.lecto.model.DefaultEncodingParameters;
import fer.lss.lecto.model.Lecture;
import fer.lss.lecto.model.LectureState;
import fer.lss.lecto.services.ContentChangeEventService;
import fer.lss.lecto.services.HelpService;
import fer.lss.lecto.services.MessagesService;
import fer.lss.lecto.services.encoding.EncodingService;
import fer.lss.lecto.services.libraries.LibrariesService;
import fer.lss.lecto.services.translate.TranslateService;
import fer.lss.lecto.services.usersettings.UserPresetService;
import fer.lss.lecto.services.usersettings.UserProfilesService;
import fer.lss.lecto.services.usersettings.UserSettingsService;
import fer.lss.lecto.services.usersettings.model.UserSettings;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.xml.sax.SAXException;

public class LeCToMainFrame
extends JFrame
implements ILocale {
    private static final long serialVersionUID = 1L;
    private final JFrame thisFrame = this;
    private static JPanel contentPane;
    private static JLabel labelRecordingDuration;
    private static JButton btnStop;
    private static JButton btnRecord;
    private static ButtonGroup buttonGroupRecordingParameters;
    private static JMenu mnSettings;
    private static JMenu mnSettings_1;
    private static JMenu mnPresets;
    private static JMenu mnProfiles;
    private static JMenu mnProfileEdit;
    private static ButtonGroup buttonGroupUserProfiles;
    private JMenuItem mntmSaveProfile = null;
    private static JMenuItem mntmExportProfiles;
    private static JMenuItem mntmImportProfiles;
    private static JMenuItem mntmDeleteProfiles;
    private static JMenu mnPublish;
    private static JMenuItem menuGeneratePSU;
    private static JMenu mnHelp;
    private static JMenu mnHelp_1;
    private static JMenuItem mntmHelp;
    private static JMenuItem mntmAbout;
    private String leCToErrorMessage;
    private static JMenuBar menuBar;
    private static JMenuBar menuBar_1;
    private static ButtonGroup buttonGroupLocales;
    private String associateWithCCEMessage;
    private String chooseLanguagePacks;
    private String chooseProfilePacks;
    private String languageImportSuccessMessage;
    private String languageImportErrorMessage;
    private String profileImportSuccessMessage;
    private String profileImportErrorMessage;
    private static JMenu mnLocale;
    private static JMenuItem mntmTranslate;
    private static JMenuItem mntmImportLanguages;
    private static JMenuItem mntmExportLanguages;
    private static JMenuItem mntmLanguageDelete;
    private static JMenuItem mntmLog;
    private static ActionListener mntmTranslateActionListener;
    private static ActionListener mntmImportLanguagesActionListener;
    private static ActionListener mntmExportLanguagesActionListener;
    private static ActionListener mntmLanguageDeleteActionListener;
    private static JMenu mnLanguageEdit;
    private static JButton btnPause;
    private static JCheckBox chckbxMinimizeOnRecord;
    private static JButton btnLiveLog;
    private static JLabel lblCurrentSources;
    private static JButton btnConfigureSource;
    private static JLabel lblSource1;
    private static JLabel lblSource2;
    private static JLabel lblSource3;
    private static JLabel lblDots;
    private static LeCToLogFrame logFrame;
    private static Thread lectureDurationTimeThread;
    private JMenu mnFileEdit;
    private JMenuItem mntmEncoding;
    private JMenuItem mntmOther;
    private JMenuItem mntmResolutions;
    private JLabel lblStatus;
    private static Rectangle btnConfigureSourcesRect;

    static {
        labelRecordingDuration = null;
        btnStop = null;
        btnRecord = null;
        buttonGroupRecordingParameters = null;
        mnSettings = null;
        mnPresets = null;
        mnProfiles = null;
        mnProfileEdit = null;
        buttonGroupUserProfiles = null;
        mntmExportProfiles = null;
        mntmImportProfiles = null;
        mntmDeleteProfiles = null;
        mnPublish = null;
        menuGeneratePSU = null;
        mnHelp = null;
        mntmHelp = null;
        mntmAbout = null;
        menuBar = null;
        buttonGroupLocales = null;
        mnLocale = null;
        mntmTranslate = null;
        mntmImportLanguages = null;
        mntmExportLanguages = null;
        mntmLanguageDelete = null;
        mntmLog = null;
        mnLanguageEdit = null;
        btnPause = new JButton();
        chckbxMinimizeOnRecord = new JCheckBox();
        btnLiveLog = new JButton();
        lblCurrentSources = new JLabel();
        btnConfigureSource = new JButton();
        lblSource1 = new JLabel();
        lblSource2 = new JLabel();
        lblSource3 = new JLabel();
        lblDots = new JLabel("...");
    }

    public LeCToMainFrame() {
        buttonGroupRecordingParameters = new ButtonGroup();
        menuBar_1 = new JMenuBar();
        mnSettings_1 = new JMenu();
        mnPresets = new JMenu();
        mnProfiles = new JMenu();
        mnProfileEdit = new JMenu();
        buttonGroupUserProfiles = new ButtonGroup();
        this.mntmSaveProfile = new JMenuItem();
        mntmExportProfiles = new JMenuItem();
        mntmImportProfiles = new JMenuItem();
        mntmDeleteProfiles = new JMenuItem();
        mnPublish = new JMenu();
        menuGeneratePSU = new JMenuItem();
        mnHelp_1 = new JMenu();
        mntmAbout = new JMenuItem();
        mntmHelp = new JMenuItem();
        mnLocale = new JMenu();
        mntmTranslate = new JMenuItem();
        mntmImportLanguages = new JMenuItem();
        mntmExportLanguages = new JMenuItem();
        btnStop = new JButton();
        btnRecord = new JButton();
        contentPane = new JPanel();
        this.leCToErrorMessage = new String();
        mnLanguageEdit = new JMenu();
        mntmLanguageDelete = new JMenuItem();
        mntmLog = new JMenuItem();
        this.createGUI();
        this.initLanguageActionListeners();
        this.initUserProfilesActionListeners();
        logFrame = new LeCToLogFrame(Lecture.getSummoner());
        Lecture.getSummoner().setLogFrame(logFrame);
        Lecture.getSummoner().setMainFrame(this);
        this.setStringValues();
    }

    private void initUserProfilesActionListeners() {
        this.mntmSaveProfile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SaveProfileDialog dialog = new SaveProfileDialog(LeCToMainFrame.this);
                dialog.setVisible(true);
                LeCToMainFrame.this.fillUserProfilesMenu();
            }
        });
        mntmImportProfiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser fc = new JFileChooser();
                ExtensionFileFilter filter1 = new ExtensionFileFilter("LeCTo Profile Pack", new String[]{"lpp"});
                fc.setFileFilter(filter1);
                fc.setDialogTitle(LeCToMainFrame.this.chooseProfilePacks);
                fc.setMultiSelectionEnabled(true);
                int returnVal = fc.showOpenDialog(LeCToMainFrame.this);
                if (returnVal == 0) {
                    File[] files = fc.getSelectedFiles();
                    LeCToMainFrame.this.importProfiles(files);
                }
            }
        });
        mntmExportProfiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ExportProfilesDialog exportProfilesDialog = new ExportProfilesDialog(LeCToMainFrame.this);
                exportProfilesDialog.setVisible(true);
            }
        });
        mntmDeleteProfiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DeleteProfilesDialog deleteProfilesDialog = new DeleteProfilesDialog(LeCToMainFrame.this);
                deleteProfilesDialog.setVisible(true);
                LeCToMainFrame.this.fillUserProfilesMenu();
            }
        });
    }

    private void initLanguageActionListeners() {
        mntmTranslateActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LeCToTranslateDialog dialog = new LeCToTranslateDialog(LeCToMainFrame.this);
                dialog.setVisible(true);
                if (dialog.getSave().booleanValue()) {
                    LeCToMainFrame.this.fillLanguagesMenu();
                }
            }
        };
        mntmImportLanguagesActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser fc = new JFileChooser();
                ExtensionFileFilter filter1 = new ExtensionFileFilter("LeCTo Language Pack", new String[]{"llp"});
                fc.setFileFilter(filter1);
                fc.setDialogTitle(LeCToMainFrame.this.chooseLanguagePacks);
                fc.setMultiSelectionEnabled(true);
                int returnVal = fc.showOpenDialog(LeCToMainFrame.this);
                if (returnVal == 0) {
                    File[] files = fc.getSelectedFiles();
                    LeCToMainFrame.this.importLanguages(files);
                }
            }
        };
        mntmExportLanguagesActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ExportLanguagesDialog exportLanguagesDialog = new ExportLanguagesDialog(LeCToMainFrame.this);
                exportLanguagesDialog.setVisible(true);
            }
        };
        mntmLanguageDeleteActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                System.out.println("Action per del");
                DeleteLanguagesDialog deleteLanguagesDialog = new DeleteLanguagesDialog(LeCToMainFrame.this);
                deleteLanguagesDialog.setVisible(true);
                LeCToMainFrame.this.fillLanguagesMenu();
            }
        };
        mntmTranslate.addActionListener(mntmTranslateActionListener);
        mntmImportLanguages.addActionListener(mntmImportLanguagesActionListener);
        mntmExportLanguages.addActionListener(mntmExportLanguagesActionListener);
        mntmLanguageDelete.addActionListener(mntmLanguageDeleteActionListener);
    }

    private void createGUI() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                LibrariesService.clearAllLibraries();
                try {
                    UserSettingsService.save();
                }
                catch (IOException e1) {
                    System.out.println("ERROR USER SAVING");
                }
            }
        });
        this.setResizable(false);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(LeCToMainFrame.class.getResource("/images/favicon32T.png")));
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 529, 272);
        this.setJMenuBar(menuBar_1);
        menuBar_1.add(mnSettings_1);
        mnPresets.setIcon(new ImageIcon(LeCToMainFrame.class.getResource("/images/icons/presets.png")));
        mnSettings_1.add(mnPresets);
        mnLocale.setIcon(new ImageIcon(LeCToMainFrame.class.getResource("/images/icons/languages.png")));
        this.fillLanguagesMenu();
        mnSettings_1.add(mnLocale);
        this.mnFileEdit = new JMenu("");
        mnSettings_1.add(this.mnFileEdit);
        this.mntmEncoding = new JMenuItem("");
        this.mntmEncoding.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Desktop.getDesktop().open(new File(UserSettingsService.getContainerFilePath()));
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        });
        this.mnFileEdit.add(this.mntmEncoding);
        this.mntmResolutions = new JMenuItem("");
        this.mntmResolutions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                try {
                    Desktop.getDesktop().open(new File(UserSettingsService.getResolutionFilePath()));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.mnFileEdit.add(this.mntmResolutions);
        this.mntmOther = new JMenuItem("");
        this.mntmOther.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                try {
                    Desktop.getDesktop().open(new File(UserSettingsService.getOtherFilePath()));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.mnFileEdit.add(this.mntmOther);
        menuBar_1.add(mnPublish);
        menuGeneratePSU.setIcon(new ImageIcon(LeCToMainFrame.class.getResource("/images/icons/publish.png")));
        menuGeneratePSU.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PSUEditor dialog = new PSUEditor(LeCToMainFrame.this);
                dialog.setVisible(true);
            }
        });
        mnPublish.add(menuGeneratePSU);
        menuBar_1.add(mnHelp_1);
        mntmHelp.setIcon(new ImageIcon(LeCToMainFrame.class.getResource("/images/icons/help.png")));
        mntmHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                HelpService.showHelpFrame(null);
            }
        });
        mnHelp_1.add(mntmHelp);
        mntmAbout.setIcon(new ImageIcon(LeCToMainFrame.class.getResource("/images/icons/about.png")));
        mntmAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                AboutDialog aboutDialog = new AboutDialog(LeCToMainFrame.this.thisFrame);
                aboutDialog.setVisible(true);
            }
        });
        mnHelp_1.add(mntmAbout);
        mntmLog = new JMenuItem();
        mntmLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (logFrame.isVisible()) {
                    return;
                }
                logFrame.setVisible(true);
            }
        });
        mnHelp_1.add(mntmLog);
        contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        contentPane.setBackground(UIManager.getColor("InternalFrame.inactiveTitleGradient"));
        this.setContentPane(contentPane);
        contentPane.setLayout(null);
        btnStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                LeCToMainFrame.this.stop();
            }
        });
        btnStop.setIcon(new ImageIcon(LeCToMainFrame.class.getResource("/images/buttonStop.png")));
        btnStop.setBounds(146, 96, 52, 52);
        contentPane.add(btnStop);
        btnRecord.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LeCToMainFrame.this.record();
                if (chckbxMinimizeOnRecord.isSelected()) {
                    LeCToMainFrame.this.setState(1);
                }
            }
        });
        btnRecord.setIcon(new ImageIcon(LeCToMainFrame.class.getResource("/images/buttonRecord.png")));
        btnRecord.setBounds(22, 96, 52, 52);
        contentPane.add(btnRecord);
        labelRecordingDuration = new JLabel(LeCToMainFrame.parseRecordingTime(0L));
        labelRecordingDuration.setFont(new Font("Courier New", 1, 30));
        labelRecordingDuration.setHorizontalAlignment(0);
        labelRecordingDuration.setBounds(22, 48, 176, 24);
        contentPane.add(labelRecordingDuration);
        btnPause = new JButton();
        btnPause.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (Lecture.getLectureState() == LectureState.ENCODING) {
                    try {
                        Lecture.pauseEncoding();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        btnPause.setIcon(new ImageIcon(LeCToMainFrame.class.getResource("/images/buttonPause.png")));
        btnPause.setToolTipText(null);
        btnPause.setBounds(82, 96, 52, 52);
        contentPane.add(btnPause);
        chckbxMinimizeOnRecord = new JCheckBox();
        chckbxMinimizeOnRecord.setFont(new Font("Segoe UI", 0, 12));
        chckbxMinimizeOnRecord.setBackground(UIManager.getColor("InternalFrame.inactiveTitleGradient"));
        chckbxMinimizeOnRecord.setBounds(51, 175, 147, 23);
        contentPane.add(chckbxMinimizeOnRecord);
        btnLiveLog = new JButton();
        btnLiveLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
            }
        });
        JSeparator separator = new JSeparator();
        separator.setOrientation(1);
        separator.setBounds(221, 18, 2, 179);
        contentPane.add(separator);
        lblCurrentSources = new JLabel();
        lblCurrentSources.setFont(new Font("Segoe UI", 0, 12));
        lblCurrentSources.setBounds(260, 18, 114, 24);
        contentPane.add(lblCurrentSources);
        btnConfigureSource = new JButton();
        btnConfigureSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (Lecture.getLectureState().equals((Object)LectureState.IDLE)) {
                    UserSettingsService.refreshData();
                    if (logFrame != null) {
                        logFrame.setVisible(false);
                    }
                    LeCToGlobalState.USER_CLICKED_LECTURE_EDITING = true;
                    LectureEditor lectureEditor = new LectureEditor(LeCToMainFrame.this.thisFrame);
                    lectureEditor.setVisible(true);
                }
            }
        });
        btnConfigureSource.setFont(new Font("Segoe UI", 0, 12));
        btnConfigureSource.setBounds(329, 175, 108, 23);
        btnConfigureSourcesRect = btnConfigureSource.getBounds();
        contentPane.add(btnConfigureSource);
        lblSource1 = new JLabel();
        lblSource1.setFont(new Font("Segoe UI", 0, 12));
        lblSource1.setBounds(259, 48, 242, 30);
        contentPane.add(lblSource1);
        lblSource2 = new JLabel();
        lblSource2.setFont(new Font("Segoe UI", 0, 12));
        lblSource2.setBounds(259, 83, 242, 30);
        contentPane.add(lblSource2);
        lblSource3 = new JLabel();
        lblSource3.setFont(new Font("Segoe UI", 0, 12));
        lblSource3.setBounds(259, 122, 242, 30);
        contentPane.add(lblSource3);
        lblDots = new JLabel("...");
        lblDots.setHorizontalAlignment(0);
        lblDots.setFont(new Font("Segoe UI", 0, 12));
        lblDots.setBounds(259, 151, 242, 24);
        contentPane.add(lblDots);
        this.lblStatus = new JLabel("");
        this.lblStatus.setHorizontalAlignment(0);
        this.lblStatus.setForeground(Color.RED);
        this.lblStatus.setBounds(10, 18, 201, 14);
        contentPane.add(this.lblStatus);
        LeCToMainFrame.setupSourceLabels();
    }

    public static void setupSourceLabels() {
        switch (Lecture.getEncoders().size()) {
            case 0: {
                lblSource1.setVisible(false);
                lblSource2.setVisible(false);
                lblSource3.setVisible(false);
                break;
            }
            case 1: {
                lblSource1.setVisible(true);
                lblSource2.setVisible(false);
                lblSource3.setVisible(false);
                btnConfigureSource.setBounds((int)Math.round(btnConfigureSourcesRect.getX()), (int)Math.round(btnConfigureSourcesRect.getY()) - 84, (int)Math.round(btnConfigureSourcesRect.getWidth()), (int)Math.round(btnConfigureSourcesRect.getHeight()));
                break;
            }
            case 2: {
                lblSource1.setVisible(true);
                lblSource2.setVisible(true);
                lblSource3.setVisible(false);
                btnConfigureSource.setBounds((int)Math.round(btnConfigureSourcesRect.getX()), (int)Math.round(btnConfigureSourcesRect.getY()) - 54, (int)Math.round(btnConfigureSourcesRect.getWidth()), (int)Math.round(btnConfigureSourcesRect.getHeight()));
                break;
            }
            case 3: {
                lblSource1.setVisible(true);
                lblSource2.setVisible(true);
                lblSource3.setVisible(true);
                btnConfigureSource.setBounds((int)Math.round(btnConfigureSourcesRect.getX()), (int)Math.round(btnConfigureSourcesRect.getY()) - 24, (int)Math.round(btnConfigureSourcesRect.getWidth()), (int)Math.round(btnConfigureSourcesRect.getHeight()));
            }
        }
        int i2 = 0;
        while (i2 < Lecture.getEncoders().size()) {
            FFMPEGEncoder encoder = Lecture.getEncoders().get(i2);
            if (i2 == 0) {
                if (encoder.getMediaOptions().getHasAudio().booleanValue()) {
                    lblSource1.setText("<html>1. " + encoder.getMediaOptions().getVideoInput().getDeviceName() + " + " + encoder.getMediaOptions().getAudioInput().getDeviceName() + "</html>");
                } else {
                    lblSource1.setText("<html>1. " + encoder.getMediaOptions().getVideoInput().getDeviceName() + "</html>");
                }
            }
            if (i2 == 1) {
                if (encoder.getMediaOptions().getHasAudio().booleanValue()) {
                    lblSource2.setText("<html>2. " + encoder.getMediaOptions().getVideoInput().getDeviceName() + " + " + encoder.getMediaOptions().getAudioInput().getDeviceName() + "</html>");
                } else {
                    lblSource2.setText("<html>2. " + encoder.getMediaOptions().getVideoInput().getDeviceName() + "</html>");
                }
            }
            if (i2 == 2) {
                if (encoder.getMediaOptions().getHasAudio().booleanValue()) {
                    lblSource3.setText("<html>3. " + encoder.getMediaOptions().getVideoInput().getDeviceName() + " + " + encoder.getMediaOptions().getAudioInput().getDeviceName() + "</html>");
                } else {
                    lblSource3.setText("<html>3. " + encoder.getMediaOptions().getVideoInput().getDeviceName() + "</html>");
                }
            }
            ++i2;
        }
        if (Lecture.getEncoders().size() > 3) {
            lblDots.setVisible(true);
            btnConfigureSource.setBounds((int)Math.round(btnConfigureSourcesRect.getX()), (int)Math.round(btnConfigureSourcesRect.getY()), (int)Math.round(btnConfigureSourcesRect.getWidth()), (int)Math.round(btnConfigureSourcesRect.getHeight()));
        } else {
            lblDots.setVisible(false);
        }
    }

    private void deselectAllUserProfileRadioButtons() {
        buttonGroupUserProfiles.clearSelection();
    }

    private void deselectAllDefaultPresetsRadioButtons() {
        buttonGroupRecordingParameters.clearSelection();
    }

    private void fillUserProfilesMenu() {
        buttonGroupUserProfiles = new ButtonGroup();
        mnProfiles.removeAll();
        for (final String profileName : UserProfilesService.getProfileNames()) {
            JRadioButtonMenuItem radioButtonMenuItem = new JRadioButtonMenuItem(profileName);
            radioButtonMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    try {
                        UserProfilesService.initLectureWithPofile(profileName);
                        LeCToMainFrame.setupSourceLabels();
                        LeCToMainFrame.this.deselectAllDefaultPresetsRadioButtons();
                    }
                    catch (FailedToInitLectureWithProfileException e2) {
                        JOptionPane.showMessageDialog(null, MessagesService.getString("LeCToMainFrame.initLectureWithProfileFailed"), LeCToMainFrame.this.leCToErrorMessage, 0, new ImageIcon(this.getClass().getResource("/images/logo.png")));
                        LeCToMainFrame.this.deselectAllUserProfileRadioButtons();
                        UserPresetService.initLecture();
                    }
                    LeCToMainFrame.this.updateGUI();
                }
            });
            buttonGroupUserProfiles.add(radioButtonMenuItem);
            mnProfiles.add(radioButtonMenuItem);
        }
        mnProfileEdit.add(this.mntmSaveProfile);
        mnProfileEdit.add(mntmImportProfiles);
        mnProfileEdit.add(mntmExportProfiles);
        mnProfileEdit.add(mntmDeleteProfiles);
        mnProfiles.add(mnProfileEdit);
    }

    private void fillLanguagesMenu() {
        JRadioButtonMenuItem localeMenuItem;
        buttonGroupLocales = new ButtonGroup();
        mnLocale.removeAll();
        for (final LeCToLocale leCTolocale : MessagesService.getAvailableLocales()) {
            localeMenuItem = new JRadioButtonMenuItem(leCTolocale.getLocale().getCountry());
            mnLocale.add(localeMenuItem);
            localeMenuItem.setIcon(leCTolocale.getImageIcon());
            buttonGroupLocales.add(localeMenuItem);
            if (leCTolocale.getLocale().equals(MessagesService.getLocale())) {
                localeMenuItem.setSelected(true);
            }
            localeMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    MessagesService.setLocale(leCTolocale);
                    LeCToMainFrame.this.setStringValues();
                    UserSettings.setLeCToLocale(leCTolocale);
                    if (!LeCToGlobalState.USER_CLICKED_LECTURE_EDITING) {
                        Lecture.setDefaultParameters(EncodingService.getDefaultDefaultEncodingParameters());
                    }
                }
            });
        }
        for (final LeCToLocale leCToLocale : MessagesService.getCustomLocales()) {
            localeMenuItem = new JRadioButtonMenuItem(leCToLocale.getLocale().getCountry());
            mnLocale.add(localeMenuItem);
            localeMenuItem.setIcon(leCToLocale.getImageIcon());
            buttonGroupLocales.add(localeMenuItem);
            if (leCToLocale.getLocale().equals(MessagesService.getLocale())) {
                localeMenuItem.setSelected(true);
            }
            localeMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    MessagesService.setLocale(leCToLocale);
                    LeCToMainFrame.this.setStringValues();
                    UserSettings.setLeCToLocale(leCToLocale);
                    if (!LeCToGlobalState.USER_CLICKED_LECTURE_EDITING) {
                        Lecture.setDefaultParameters(EncodingService.getDefaultDefaultEncodingParameters());
                    }
                }
            });
        }
        mnLocale.add(mnLanguageEdit);
        mnLanguageEdit.add(mntmTranslate);
        mnLanguageEdit.add(mntmImportLanguages);
        mnLanguageEdit.add(mntmExportLanguages);
        mnLanguageEdit.add(mntmLanguageDelete);
    }

    private void importProfiles(File[] profileFiles) {
        int importSuccessCount = 0;
        File[] fileArray = profileFiles;
        int n2 = profileFiles.length;
        int n3 = 0;
        while (n3 < n2) {
            File leCToProfilePack = fileArray[n3];
            try {
                UserProfilesService.imporProfileFromLPPZIPArchive(leCToProfilePack);
                ++importSuccessCount;
            }
            catch (IOException e2) {
                JOptionPane.showMessageDialog(null, this.profileImportErrorMessage, this.leCToErrorMessage, 0, new ImageIcon(LeCTo.class.getResource("/images/logo.png")));
                e2.printStackTrace();
            }
            ++n3;
        }
        JOptionPane.showMessageDialog(null, String.valueOf(importSuccessCount) + " " + this.profileImportSuccessMessage, MessagesService.getString("LeCToMainFrame.this.infoMessage"), -1, new ImageIcon(LeCTo.class.getResource("/images/logo.png")));
        this.fillUserProfilesMenu();
        LeCToMainFrame.setupSourceLabels();
    }

    private void importLanguages(File[] languageFiles) {
        int importSuccessCount = 0;
        File[] fileArray = languageFiles;
        int n2 = languageFiles.length;
        int n3 = 0;
        while (n3 < n2) {
            File leCToLanguagePack = fileArray[n3];
            try {
                TranslateService.importLangugeFromLLPZIPArchive(leCToLanguagePack);
                ++importSuccessCount;
            }
            catch (IOException e2) {
                JOptionPane.showMessageDialog(null, this.languageImportErrorMessage, this.leCToErrorMessage, 0, new ImageIcon(LeCTo.class.getResource("/images/logo.png")));
                e2.printStackTrace();
            }
            ++n3;
        }
        JOptionPane.showMessageDialog(null, String.valueOf(importSuccessCount) + " " + this.languageImportSuccessMessage, MessagesService.getString("LeCToMainFrame.this.infoMessage"), -1, new ImageIcon(LeCTo.class.getResource("/images/logo.png")));
        this.fillLanguagesMenu();
    }

    private void record() {
        if (Lecture.getLectureState().equals((Object)LectureState.IDLE) || Lecture.getLectureState().equals((Object)LectureState.PAUSED)) {
            Thread startEncodersThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    LeCToMainFrame.this.beginTimerUpdating();
                    Lecture.startEncoding();
                }
            });
            startEncodersThread.start();
        }
    }

    private void stop() {
        if (Lecture.getLectureState().equals((Object)LectureState.ENCODING) || Lecture.getLectureState().equals((Object)LectureState.PAUSED)) {
            Thread stopEncodersThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    System.out.println("Encoding is stopping");
                    try {
                        Lecture.stopEncoding();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    System.out.println("Encoding stopped");
                    LeCToMainFrame.this.updateGUI();
                }
            });
            stopEncodersThread.start();
        }
    }

    public void resetLecture() {
        Lecture.setDefaultParameters(EncodingService.getDefaultDefaultEncodingParameters());
        UserPresetService.initLecture();
        this.updateGUI();
    }

    private static String parseRecordingTime(long recordingDurationInSeconds) {
        int hours = (int)recordingDurationInSeconds / 3600;
        int minutes = (int)recordingDurationInSeconds % 3600 / 60;
        int seconds = (int)recordingDurationInSeconds % 3600 % 60;
        DecimalFormat format = new DecimalFormat("00");
        return String.valueOf(format.format(hours)) + ":" + format.format(minutes) + ":" + format.format(seconds);
    }

    public void setPauseStatus() {
        this.lblStatus.setVisible(true);
        this.lblStatus.setText(MessagesService.getString("FFMPEGSummoner.pauseMessage.text"));
    }

    public void setResumeStatus() {
        this.lblStatus.setVisible(true);
        this.lblStatus.setText(MessagesService.getString("FFMPEGSummoner.resumeMessage.text"));
    }

    public void setGeneratingStatus() {
        this.lblStatus.setVisible(true);
        this.lblStatus.setText(MessagesService.getString("FFMPEGSummoner.generatingMessage.text"));
    }

    public void setEmptyStatus() {
        this.lblStatus.setVisible(false);
    }

    public void setBufferOverLoadStatus() {
        this.lblStatus.setText(MessagesService.getString("FFMPEGSummoner.ffmpegWarningMessage.text"));
    }

    private void updateGUI() {
        switch (Lecture.getLectureState()) {
            case ENCODING: {
                break;
            }
            case PAUSED: {
                break;
            }
            case STOPPED: {
                break;
            }
            case IDLE: {
                labelRecordingDuration.setText(LeCToMainFrame.parseRecordingTime(0L));
            }
        }
    }

    private void beginTimerUpdating() {
        if (lectureDurationTimeThread == null) {
            lectureDurationTimeThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        switch (Lecture.getLectureState()) {
                            case ENCODING: {
                                try {
                                    Thread.sleep(1000L);
                                    labelRecordingDuration.setText(LeCToMainFrame.parseRecordingTime(Lecture.getLectureDurationInSeconds()));
                                }
                                catch (InterruptedException e2) {
                                    e2.printStackTrace();
                                }
                                break;
                            }
                            case STOPPED: {
                                break;
                            }
                            case ENCODING_IS_STOPPING: {
                                return;
                            }
                            case PAUSED: {
                                try {
                                    Thread.sleep(500L);
                                    break;
                                }
                                catch (InterruptedException e3) {
                                    e3.printStackTrace();
                                }
                            }
                        }
                    }
                }
            });
            lectureDurationTimeThread.start();
        }
    }

    private void associateLectureWithCCEFile() {
        if (Lecture.getLectureState().equals((Object)LectureState.STOPPED)) {
            JFileChooser fileChooser = new JFileChooser();
            ExtensionFileFilter filter1 = new ExtensionFileFilter("Content Change Event", new String[]{"cce"});
            fileChooser.setFileFilter(filter1);
            fileChooser.setDialogTitle(this.associateWithCCEMessage);
            int retval = fileChooser.showOpenDialog(this.thisFrame);
            if (retval == 0) {
                File cceFile = fileChooser.getSelectedFile();
                try {
                    ContentChangeEventService.associateCCEFileWithCurrentLecture(cceFile, Lecture.getEncodingStartTime());
                }
                catch (SAXException e2) {
                    e2.printStackTrace();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                catch (ParserConfigurationException e4) {
                    e4.printStackTrace();
                }
                catch (ParseException e5) {
                    e5.printStackTrace();
                }
                catch (TransformerFactoryConfigurationError e6) {
                    e6.printStackTrace();
                }
                catch (TransformerException e7) {
                    e7.printStackTrace();
                }
            }
        }
    }

    private void setPresetsRadioButtonItems() {
        buttonGroupRecordingParameters = new ButtonGroup();
        mnPresets.removeAll();
        DefaultEncodingParameters lectureParameters = Lecture.getEncodingParameters();
        DefaultEncodingParameters.updatePresetNames();
        DefaultEncodingParameters[] defaultEncodingParametersArray = DefaultEncodingParameters.values();
        int n2 = defaultEncodingParametersArray.length;
        int n3 = 0;
        while (n3 < n2) {
            DefaultEncodingParameters encodingParameters = defaultEncodingParametersArray[n3];
            final JRadioButtonMenuItem radioButtonMenuItem = new JRadioButtonMenuItem(DefaultEncodingParameters.getPresetName(encodingParameters));
            radioButtonMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Lecture.setDefaultParameters(DefaultEncodingParameters.getDefaultEncodingParametersByPresetName(radioButtonMenuItem.getText()));
                    LeCToMainFrame.this.deselectAllUserProfileRadioButtons();
                    LeCToMainFrame.this.updateGUI();
                }
            });
            if (encodingParameters.equals((Object)lectureParameters)) {
                radioButtonMenuItem.setSelected(true);
            }
            buttonGroupRecordingParameters.add(radioButtonMenuItem);
            mnPresets.add(radioButtonMenuItem);
            ++n3;
        }
        this.fillUserProfilesMenu();
        mnPresets.add(mnProfiles);
    }

    @Override
    public void setStringValues() {
        this.setTitle(MessagesService.getString("LeCToMainFrame.this.title"));
        btnStop.setToolTipText(MessagesService.getString("LeCToMainFrame.btnStop.toolTipText"));
        btnRecord.setToolTipText(MessagesService.getString("LeCToMainFrame.btnRecord.toolTipText"));
        btnPause.setToolTipText(MessagesService.getString("LeCToMainFrame.btnPause.toolTipText"));
        this.associateWithCCEMessage = new String(MessagesService.getString("LeCToMainFrame.associateWithCCEMessage.text"));
        mnSettings_1.setText(MessagesService.getString("LeCToMainFrame.mnSettings.text"));
        mnPresets.setText(MessagesService.getString("LeCToMainFrame.mnPresets.text"));
        mnProfiles.setText(MessagesService.getString("LeCToMainFrame.mnProfiles.text"));
        mnProfileEdit.setText(MessagesService.getString("LeCToMainFrame.mnProfileEdit.text"));
        this.mntmSaveProfile.setText(MessagesService.getString("LeCToMainFrame.mntmSaveProfile.text"));
        this.mntmSaveProfile.setToolTipText(MessagesService.getString("LeCToMainFrame.mntmSaveProfile.tooltipText"));
        mntmExportProfiles.setText(MessagesService.getString("LeCToMainFrame.mntmExportProfiles.text"));
        mntmImportProfiles.setText(MessagesService.getString("LeCToMainFrame.mntmImportProfiles.text"));
        mntmDeleteProfiles.setText(MessagesService.getString("LeCToMainFrame.mntmDeleteProfiles.text"));
        mnSettings_1.setText(MessagesService.getString("LeCToMainFrame.mnSettings.text"));
        mnPublish.setText(MessagesService.getString("LeCToMainFrame.mnPublish.text"));
        menuGeneratePSU.setText(MessagesService.getString("LeCToMainFrame.menuGeneratePSU.text"));
        mnHelp_1.setText(MessagesService.getString("LeCToMainFrame.mnHelp.text"));
        mntmHelp.setText(MessagesService.getString("LeCToMainFrame.mntmHelp.text"));
        mntmAbout.setText(MessagesService.getString("LeCToMainFrame.mntmAbout.text"));
        mnSettings_1.setText(MessagesService.getString("LeCToMainFrame.mnSettings.text"));
        mntmAbout.setText(MessagesService.getString("LeCToMainFrame.mntmAbout.text"));
        mnLocale.setText(MessagesService.getString("LeCToMainFrame.mnLocale.text"));
        this.chooseLanguagePacks = MessagesService.getString("LeCToMainFrame.chooseLanguagePacks.text");
        this.chooseProfilePacks = MessagesService.getString("LeCToMainFrame.chooseProfilePacks.text");
        chckbxMinimizeOnRecord.setText(MessagesService.getString("LeCToMainFrame.chckbxMinimizeOnRecord.text"));
        btnLiveLog.setText(MessagesService.getString("LeCToMainFrame.btnLiveLog.text"));
        btnConfigureSource.setText(MessagesService.getString("LeCToMainFrame.btnConfigureSource.text"));
        lblCurrentSources.setText(MessagesService.getString("LeCToMainFrame.lblCurrentSources.text"));
        mnLanguageEdit.setText(MessagesService.getString("LeCToMainFrame.mnLanguageEdit.text"));
        mntmLanguageDelete.setText(MessagesService.getString("LeCToMainFrame.mnLanguageDelete.text"));
        this.mnFileEdit.setText(MessagesService.getString("LeCToMainFrame.mnProfileEdit.text"));
        this.mntmEncoding.setText(MessagesService.getString("LeCToMainFrame.mntmEncoding.text"));
        this.mntmResolutions.setText(MessagesService.getString("LeCToMainFrame.mntmResolutions.text"));
        this.mntmOther.setText(MessagesService.getString("LeCToMainFrame.mntmOther.text"));
        mntmTranslate.setText(MessagesService.getString("LeCToMainFrame.mntmTranslate.text"));
        mntmImportLanguages.setText(MessagesService.getString("LeCToMainFrame.mntmImportLanguages.text"));
        mntmExportLanguages.setText(MessagesService.getString("LeCToMainFrame.mntmExportLanguages.text"));
        mntmLog.setText(MessagesService.getString("LeCToMainFrame.btnLiveLog.text"));
        this.leCToErrorMessage = new String(MessagesService.getString("LeCToMainFrame.this.errorMessage"));
        this.languageImportSuccessMessage = MessagesService.getString("LeCToMainFrame.languageImportSuccessMessage");
        this.languageImportErrorMessage = MessagesService.getString("LeCToMainFrame.languageImportErrorMessage");
        this.profileImportSuccessMessage = MessagesService.getString("LeCToMainFrame.profileImportSuccessMessage");
        this.profileImportErrorMessage = MessagesService.getString("LeCToMainFrame.profileImportErrorMessage");
        this.setPresetsRadioButtonItems();
    }
}

