/*
 * Decompiled with CFR 0.152.
 */
package fer.lss.lecto.gui;

import fer.lss.lecto.encoder.FFMPEGEncoder;
import fer.lss.lecto.gui.LeCToMainFrame;
import fer.lss.lecto.gui.locale.ILocale;
import fer.lss.lecto.model.DefaultEncodingParameters;
import fer.lss.lecto.model.Lecture;
import fer.lss.lecto.model.mediaoptions.AudioDevice;
import fer.lss.lecto.model.mediaoptions.EncodingType;
import fer.lss.lecto.model.mediaoptions.VideoDevice;
import fer.lss.lecto.services.MessagesService;
import fer.lss.lecto.services.encoding.EncodingService;
import fer.lss.lecto.services.usersettings.UserSettingsService;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SourceConfigurationPanel
extends JPanel
implements ILocale {
    private static final long serialVersionUID = 6186875227231880705L;
    private FFMPEGEncoder encoder;
    private JTextField textFieldFileName;
    private JTextField textFieldFileLocation;
    private JComboBox comboBoxVideoSources;
    private static JComboBox comboBoxAudioSources;
    private boolean videoSourcesProgrammaticallyChanging;
    private boolean audioSourcesProgrammaticallyChanging;
    private JComboBox comboBoxVideoBitrate;
    private JComboBox comboBoxFrameRate;
    private JComboBox comboBoxAudioBitrate;
    private JComboBox comboBoxAudioSamplingRate;
    private JButton btnChangeFileLocation;
    private JPanel panelVideoConfigration;
    private JPanel panelAudioConfiguration;
    private JLabel lblFileName;
    private JLabel lblVideoBitrate;
    private JLabel lblFramesPerSecond;
    private JLabel lblVideoInput;
    private JLabel lblAudioInput;
    private JLabel lblAudioBitrate;
    private JLabel lblFileLocation;
    private String warningMessageVideoSourceAlreadyUsed;
    private String warningMessageAudioSourceAlreadyUsed;
    private String infoMessage;
    private JLabel lblVideoCodec;
    private JComboBox comboBoxVideoCodecs;
    private JCheckBox chckBxAudioSourceEnabled;
    private JLabel lblAudioCodec;
    private JComboBox comboBoxAudioCodecs;
    private JLabel lblSamplingRate;
    private JComboBox comboBoxFileType;
    private JLabel lblResolution;
    private JComboBox comboBoxResolution;
    private JCheckBox chckBxVideoSourceEnabled;
    private JLabel lblCrf;
    private JSpinner spinnerCrf;
    private JComboBox comboBoxPresets;
    private JLabel lblPresets;

    public SourceConfigurationPanel(FFMPEGEncoder encoder) {
        this.encoder = encoder;
        this.textFieldFileName = new JTextField();
        this.textFieldFileLocation = new JTextField();
        this.comboBoxVideoSources = new JComboBox();
        comboBoxAudioSources = new JComboBox();
        this.comboBoxVideoCodecs = new JComboBox();
        this.comboBoxAudioBitrate = new JComboBox();
        this.comboBoxAudioSamplingRate = new JComboBox();
        this.comboBoxVideoBitrate = new JComboBox();
        this.comboBoxFrameRate = new JComboBox();
        this.btnChangeFileLocation = new JButton();
        this.panelVideoConfigration = new JPanel();
        this.panelAudioConfiguration = new JPanel();
        this.lblFileName = new JLabel();
        this.lblVideoBitrate = new JLabel();
        this.lblFramesPerSecond = new JLabel();
        this.lblVideoInput = new JLabel();
        this.lblAudioInput = new JLabel();
        this.lblAudioBitrate = new JLabel();
        this.lblFileLocation = new JLabel();
        this.lblVideoCodec = new JLabel();
        this.createGUI();
        this.fillFields();
        this.setStringValues();
    }

    private void createGUI() {
        this.setLayout(null);
        this.textFieldFileName.setBounds(126, 33, 210, 25);
        this.textFieldFileName.setText(this.encoder.getName());
        this.add(this.textFieldFileName);
        this.textFieldFileName.setColumns(10);
        this.lblFileName.setBounds(20, 38, 96, 14);
        this.add(this.lblFileName);
        this.btnChangeFileLocation.setBounds(346, 80, 94, 25);
        this.add(this.btnChangeFileLocation);
        this.lblFileLocation.setBounds(20, 85, 96, 14);
        this.add(this.lblFileLocation);
        this.textFieldFileLocation.setEnabled(true);
        this.textFieldFileLocation.setEditable(false);
        this.textFieldFileLocation.setText(this.encoder.getFileFullPath());
        this.textFieldFileLocation.setBounds(126, 80, 210, 25);
        this.add(this.textFieldFileLocation);
        this.textFieldFileLocation.setColumns(10);
        this.panelVideoConfigration.setBounds(10, 117, 430, 227);
        this.add(this.panelVideoConfigration);
        this.panelVideoConfigration.setLayout(null);
        this.comboBoxVideoBitrate.setBounds(154, 143, 65, 23);
        this.panelVideoConfigration.add(this.comboBoxVideoBitrate);
        this.lblVideoBitrate.setBounds(28, 143, 118, 23);
        this.panelVideoConfigration.add(this.lblVideoBitrate);
        this.comboBoxFrameRate.setBounds(367, 143, 51, 23);
        this.panelVideoConfigration.add(this.comboBoxFrameRate);
        this.lblFramesPerSecond.setBounds(228, 143, 128, 23);
        this.panelVideoConfigration.add(this.lblFramesPerSecond);
        this.lblVideoInput.setBounds(28, 43, 96, 20);
        this.panelVideoConfigration.add(this.lblVideoInput);
        this.lblVideoCodec.setBounds(231, 91, 84, 20);
        this.panelVideoConfigration.add(this.lblVideoCodec);
        this.comboBoxVideoCodecs.setBounds(322, 90, 96, 23);
        this.panelVideoConfigration.add(this.comboBoxVideoCodecs);
        this.comboBoxVideoSources.setBounds(134, 42, 265, 23);
        this.panelVideoConfigration.add(this.comboBoxVideoSources);
        this.lblResolution = new JLabel();
        this.lblResolution.setToolTipText(null);
        this.lblResolution.setBounds(28, 90, 77, 23);
        this.panelVideoConfigration.add(this.lblResolution);
        this.comboBoxResolution = new JComboBox();
        this.comboBoxResolution.setBounds(108, 90, 111, 23);
        this.panelVideoConfigration.add(this.comboBoxResolution);
        this.chckBxVideoSourceEnabled = new JCheckBox();
        this.chckBxVideoSourceEnabled.setBounds(6, 7, 128, 23);
        this.panelVideoConfigration.add(this.chckBxVideoSourceEnabled);
        this.lblCrf = new JLabel();
        this.lblCrf.setToolTipText(null);
        this.lblCrf.setText("CRF:");
        this.lblCrf.setBounds(281, 185, 43, 23);
        this.panelVideoConfigration.add(this.lblCrf);
        this.spinnerCrf = new JSpinner();
        this.spinnerCrf.setBounds(334, 185, 65, 23);
        this.panelVideoConfigration.add(this.spinnerCrf);
        this.comboBoxPresets = new JComboBox();
        this.comboBoxPresets.setBounds(122, 186, 96, 23);
        this.panelVideoConfigration.add(this.comboBoxPresets);
        this.lblPresets = new JLabel();
        this.lblPresets.setToolTipText(null);
        this.lblPresets.setText("Presets:");
        this.lblPresets.setBounds(28, 186, 90, 20);
        this.panelVideoConfigration.add(this.lblPresets);
        this.panelAudioConfiguration.setBounds(10, 355, 430, 174);
        this.add(this.panelAudioConfiguration);
        this.panelAudioConfiguration.setLayout(null);
        this.lblAudioInput.setBounds(28, 52, 96, 17);
        this.panelAudioConfiguration.add(this.lblAudioInput);
        comboBoxAudioSources.setBounds(134, 49, 284, 23);
        this.panelAudioConfiguration.add(comboBoxAudioSources);
        this.comboBoxAudioBitrate.setBounds(352, 91, 66, 23);
        this.lblAudioBitrate.setBounds(200, 91, 142, 23);
        this.panelAudioConfiguration.add(this.lblAudioBitrate);
        this.panelAudioConfiguration.add(this.comboBoxAudioBitrate);
        this.chckBxAudioSourceEnabled = new JCheckBox();
        this.chckBxAudioSourceEnabled.setBounds(6, 7, 118, 23);
        this.panelAudioConfiguration.add(this.chckBxAudioSourceEnabled);
        this.lblAudioCodec = new JLabel();
        this.lblAudioCodec.setToolTipText(null);
        this.lblAudioCodec.setBounds(28, 93, 73, 19);
        this.panelAudioConfiguration.add(this.lblAudioCodec);
        this.comboBoxAudioCodecs = new JComboBox();
        this.comboBoxAudioCodecs.setBounds(119, 91, 63, 23);
        this.panelAudioConfiguration.add(this.comboBoxAudioCodecs);
        this.lblSamplingRate = new JLabel();
        this.lblSamplingRate.setToolTipText(null);
        this.lblSamplingRate.setBounds(28, 135, 154, 19);
        this.panelAudioConfiguration.add(this.lblSamplingRate);
        this.comboBoxAudioSamplingRate = new JComboBox();
        this.comboBoxAudioSamplingRate.setBounds(192, 132, 66, 23);
        this.panelAudioConfiguration.add(this.comboBoxAudioSamplingRate);
        this.comboBoxFileType = new JComboBox();
        this.comboBoxFileType.setBounds(348, 34, 92, 23);
        this.add(this.comboBoxFileType);
    }

    private void fillFields() {
        String container2;
        for (AudioDevice audioSource : EncodingService.getAvailableAudioDevices()) {
            comboBoxAudioSources.addItem(audioSource);
            if (!audioSource.equals(this.encoder.getMediaOptions().getAudioInput())) continue;
            System.out.println("Postavljam audio");
            comboBoxAudioSources.setSelectedItem(audioSource);
        }
        for (VideoDevice videoSource : EncodingService.getAvailableVideoInputs()) {
            this.comboBoxVideoSources.addItem(videoSource);
            if (!videoSource.equals(this.encoder.getMediaOptions().getVideoInput())) continue;
            System.out.println("Postavljam video");
            this.comboBoxVideoSources.setSelectedItem(videoSource);
        }
        this.setEnabledAudioAndVideoOptions();
        for (String container2 : UserSettingsService.containers) {
            this.comboBoxFileType.addItem(container2);
        }
        container2 = UserSettingsService.containers.get(0);
        if (this.encoder.getMediaOptions().getContainer() != null) {
            container2 = this.encoder.getMediaOptions().getContainer();
        }
        List<String> videoCodecs = UserSettingsService.videoCodecsForContainer.get(container2);
        List<String> audioCodecs = UserSettingsService.audioCodecsForContainer.get(container2);
        this.comboBoxFileType.setSelectedItem(container2);
        this.comboBoxVideoCodecs.removeAllItems();
        this.comboBoxAudioCodecs.removeAllItems();
        this.comboBoxAudioBitrate.removeAllItems();
        this.comboBoxAudioSamplingRate.removeAllItems();
        this.comboBoxVideoBitrate.removeAllItems();
        this.comboBoxFrameRate.removeAllItems();
        for (String videoString : videoCodecs) {
            this.comboBoxVideoCodecs.addItem(videoString);
        }
        if (this.encoder.getMediaOptions().getVideoCodec() != null) {
            this.comboBoxVideoCodecs.setSelectedItem(this.encoder.getMediaOptions().getVideoCodec());
        } else {
            this.comboBoxVideoCodecs.setSelectedItem(videoCodecs.get(0));
        }
        if (((String)this.comboBoxVideoCodecs.getSelectedItem()).contains("264") || ((String)this.comboBoxVideoCodecs.getSelectedItem()).contains("265")) {
            this.spinnerCrf.setVisible(true);
            this.lblCrf.setVisible(true);
            this.lblPresets.setVisible(true);
            this.comboBoxPresets.setVisible(true);
        } else {
            this.spinnerCrf.setVisible(false);
            this.lblCrf.setVisible(false);
            this.lblPresets.setVisible(false);
            this.comboBoxPresets.setVisible(false);
        }
        for (String audioString : audioCodecs) {
            this.comboBoxAudioCodecs.addItem(audioString);
        }
        if (this.encoder.getMediaOptions().getAudioCodec() != null) {
            this.comboBoxAudioCodecs.setSelectedItem(this.encoder.getMediaOptions().getAudioCodec());
        } else {
            this.comboBoxAudioCodecs.setSelectedItem(audioCodecs.get(0));
        }
        for (String resolution : UserSettingsService.resolutions) {
            this.comboBoxResolution.addItem(resolution);
        }
        if (this.encoder.getMediaOptions().getResolution() != null) {
            this.comboBoxResolution.setSelectedItem(this.encoder.getMediaOptions().getResolution());
        } else {
            this.comboBoxResolution.setSelectedItem(UserSettingsService.resolutions.get(0));
        }
        Integer crf = null;
        crf = this.encoder.getMediaOptions().getCrf() != null ? new Integer(this.encoder.getMediaOptions().getCrf()) : new Integer(DefaultEncodingParameters.getCrf(EncodingService.getDefaultDefaultEncodingParameters()));
        for (String string : UserSettingsService.framerates) {
            this.comboBoxFrameRate.addItem(string);
        }
        if (this.encoder.getMediaOptions().getFps() != null) {
            this.comboBoxFrameRate.setSelectedItem(this.encoder.getMediaOptions().getFps());
        } else {
            this.comboBoxFrameRate.setSelectedItem(UserSettingsService.framerates.get(0));
        }
        for (String string : UserSettingsService.audioBitrates) {
            this.comboBoxAudioBitrate.addItem(string);
        }
        if (this.encoder.getMediaOptions().getAB() != null) {
            this.comboBoxAudioBitrate.setSelectedItem(this.encoder.getMediaOptions().getAB());
        } else {
            this.comboBoxAudioBitrate.setSelectedItem(UserSettingsService.audioBitrates.get(0));
        }
        for (String string : UserSettingsService.audioSamplingRates) {
            this.comboBoxAudioSamplingRate.addItem(string);
        }
        if (this.encoder.getMediaOptions().getSamplingRate() != null) {
            this.comboBoxAudioSamplingRate.setSelectedItem(this.encoder.getMediaOptions().getSamplingRate());
        } else {
            this.comboBoxAudioSamplingRate.setSelectedItem(UserSettingsService.audioSamplingRates.get(0));
        }
        for (String string : UserSettingsService.videoBitrates) {
            this.comboBoxVideoBitrate.addItem(string);
        }
        if (this.encoder.getMediaOptions().getVB() != null) {
            this.comboBoxVideoBitrate.setSelectedItem(this.encoder.getMediaOptions().getVB());
        } else {
            this.comboBoxVideoBitrate.setSelectedItem(UserSettingsService.videoBitrates.get(0));
        }
        for (String string : UserSettingsService.presets) {
            this.comboBoxPresets.addItem(string);
        }
        if (this.encoder.getMediaOptions().getPreset() != null) {
            this.comboBoxPresets.setSelectedItem(this.encoder.getMediaOptions().getPreset());
        } else {
            this.comboBoxPresets.setSelectedItem(UserSettingsService.presets.get(0));
        }
        this.spinnerCrf.setModel(new SpinnerNumberModel(crf, new Integer(DefaultEncodingParameters.getCrfMinValue()), new Integer(DefaultEncodingParameters.getCrfMaxValue()), new Integer(1)));
        this.textFieldFileName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e2) {
                this.textFieldFileNameChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e2) {
                this.textFieldFileNameChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e2) {
            }

            private void textFieldFileNameChanged() {
                if (SourceConfigurationPanel.this.getParent().getParent() instanceof JTabbedPane) {
                    JTabbedPane tabbedPane = (JTabbedPane)SourceConfigurationPanel.this.getParent().getParent();
                    int tabsCount = tabbedPane.getTabCount();
                    int i2 = 0;
                    while (i2 < tabsCount) {
                        Component tabComponenet = tabbedPane.getComponentAt(i2);
                        if (tabComponenet instanceof JPanel) {
                            Component[] componentArray = ((JPanel)tabComponenet).getComponents();
                            int n2 = componentArray.length;
                            int n3 = 0;
                            while (n3 < n2) {
                                Component component = componentArray[n3];
                                if (component.equals(SourceConfigurationPanel.this)) {
                                    SourceConfigurationPanel.this.encoder.setName(SourceConfigurationPanel.this.textFieldFileName.getText());
                                    tabbedPane.setTitleAt(i2, SourceConfigurationPanel.this.textFieldFileName.getText());
                                }
                                ++n3;
                            }
                        }
                        ++i2;
                    }
                }
            }
        });
        this.btnChangeFileLocation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser fc = new JFileChooser();
                fc.setFileSelectionMode(1);
                int returnVal = fc.showOpenDialog(SourceConfigurationPanel.this);
                if (returnVal == 0) {
                    File folder = fc.getSelectedFile();
                    if (folder.exists()) {
                        SourceConfigurationPanel.this.encoder.setFileFullPath(folder.getAbsolutePath());
                        SourceConfigurationPanel.this.textFieldFileLocation.setText(folder.getAbsolutePath());
                    } else {
                        switch (SourceConfigurationPanel.this.encoder.getMediaOptions().getEncodingType()) {
                            case CAMERA: {
                                fc.setSelectedFile(new File(EncodingService.getCameraDeviceDefaultOutputFilePath()));
                                break;
                            }
                            case DESKTOP: {
                                fc.setSelectedFile(new File(EncodingService.getScreenDefaultOutputFilePath()));
                            }
                        }
                    }
                }
            }
        });
        this.chckBxVideoSourceEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (SourceConfigurationPanel.this.chckBxVideoSourceEnabled.isSelected()) {
                    SourceConfigurationPanel.this.comboBoxVideoCodecs.setEnabled(true);
                    SourceConfigurationPanel.this.comboBoxResolution.setEnabled(true);
                    SourceConfigurationPanel.this.comboBoxVideoSources.setEnabled(true);
                    SourceConfigurationPanel.this.spinnerCrf.setEnabled(true);
                    SourceConfigurationPanel.this.comboBoxFrameRate.setEnabled(true);
                    SourceConfigurationPanel.this.comboBoxVideoBitrate.setEnabled(true);
                    SourceConfigurationPanel.this.encoder.getMediaOptions().setHasVideo(true);
                    SourceConfigurationPanel.this.encoder.getMediaOptions().setVideoInput(EncodingService.getDefaultCameraDevice());
                    SourceConfigurationPanel.this.comboBoxPresets.setEnabled(true);
                } else {
                    SourceConfigurationPanel.this.comboBoxVideoCodecs.setEnabled(false);
                    SourceConfigurationPanel.this.comboBoxResolution.setEnabled(false);
                    SourceConfigurationPanel.this.comboBoxVideoSources.setEnabled(false);
                    SourceConfigurationPanel.this.spinnerCrf.setEnabled(false);
                    SourceConfigurationPanel.this.comboBoxFrameRate.setEnabled(false);
                    SourceConfigurationPanel.this.comboBoxVideoBitrate.setEnabled(false);
                    SourceConfigurationPanel.this.encoder.getMediaOptions().setHasVideo(false);
                    SourceConfigurationPanel.this.encoder.getMediaOptions().setVideoInput(EncodingService.getEmptyVideoSource());
                    SourceConfigurationPanel.this.comboBoxPresets.setEnabled(false);
                }
            }
        });
        this.chckBxAudioSourceEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (SourceConfigurationPanel.this.chckBxAudioSourceEnabled.isSelected()) {
                    SourceConfigurationPanel.this.comboBoxAudioCodecs.setEnabled(true);
                    comboBoxAudioSources.setEnabled(true);
                    SourceConfigurationPanel.this.comboBoxAudioBitrate.setEnabled(true);
                    SourceConfigurationPanel.this.comboBoxAudioSamplingRate.setEnabled(true);
                    SourceConfigurationPanel.this.encoder.getMediaOptions().setHasAudio(true);
                    SourceConfigurationPanel.this.encoder.getMediaOptions().setAudioInput(EncodingService.getDefaultAudioDevice());
                } else {
                    SourceConfigurationPanel.this.comboBoxAudioCodecs.setEnabled(false);
                    comboBoxAudioSources.setEnabled(false);
                    SourceConfigurationPanel.this.comboBoxAudioBitrate.setEnabled(false);
                    SourceConfigurationPanel.this.comboBoxAudioSamplingRate.setEnabled(false);
                    SourceConfigurationPanel.this.encoder.getMediaOptions().setHasAudio(false);
                    SourceConfigurationPanel.this.encoder.getMediaOptions().setAudioInput(EncodingService.getEmptyAudioSource());
                }
            }
        });
        this.comboBoxVideoSources.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                System.out.println("Video event");
                if (!SourceConfigurationPanel.this.videoSourcesProgrammaticallyChanging) {
                    System.out.println("Video manually");
                    VideoDevice newSelectedInputSource = (VideoDevice)SourceConfigurationPanel.this.comboBoxVideoSources.getSelectedItem();
                    VideoDevice currentInputSource = SourceConfigurationPanel.this.encoder.getMediaOptions().getVideoInput();
                    boolean newIsScreen = newSelectedInputSource.equals(EncodingService.getScreenDevice());
                    boolean currentIsScreen = currentInputSource.equals(EncodingService.getScreenDevice());
                    if (!newIsScreen && !currentIsScreen) {
                        SourceConfigurationPanel.this.encoder.getMediaOptions().setVideoInput(newSelectedInputSource);
                    } else if (currentIsScreen && !newIsScreen) {
                        SourceConfigurationPanel.this.encoder.setMediaOptions(DefaultEncodingParameters.getDefaultMediaOptionsWithNoVideoInput(EncodingService.getDefaultDefaultEncodingParameters()));
                        SourceConfigurationPanel.this.encoder.getMediaOptions().setVideoInput(newSelectedInputSource);
                    } else if (!currentIsScreen && newIsScreen) {
                        SourceConfigurationPanel.this.encoder.setMediaOptions(DefaultEncodingParameters.getDefaultMediaOptionsForScreen(EncodingService.getDefaultDefaultEncodingParameters()));
                    }
                    LeCToMainFrame.setupSourceLabels();
                }
            }
        });
        comboBoxAudioSources.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                System.out.println("Audio event");
                System.out.println("Audio event manually");
                AudioDevice newSelectedInputSource = (AudioDevice)comboBoxAudioSources.getSelectedItem();
                SourceConfigurationPanel.this.encoder.getMediaOptions().setAudioInput(newSelectedInputSource);
                LeCToMainFrame.setupSourceLabels();
            }
        });
        this.comboBoxVideoBitrate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SourceConfigurationPanel.this.encoder.getMediaOptions().setVB((String)SourceConfigurationPanel.this.comboBoxVideoBitrate.getSelectedItem());
            }
        });
        this.comboBoxPresets.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SourceConfigurationPanel.this.encoder.getMediaOptions().setPreset((String)SourceConfigurationPanel.this.comboBoxPresets.getSelectedItem());
            }
        });
        this.comboBoxFrameRate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SourceConfigurationPanel.this.encoder.getMediaOptions().setFps((String)SourceConfigurationPanel.this.comboBoxFrameRate.getSelectedItem());
            }
        });
        this.comboBoxAudioBitrate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SourceConfigurationPanel.this.encoder.getMediaOptions().setAB((String)SourceConfigurationPanel.this.comboBoxAudioBitrate.getSelectedItem());
            }
        });
        this.comboBoxAudioSamplingRate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SourceConfigurationPanel.this.encoder.getMediaOptions().setSamplingRate((String)SourceConfigurationPanel.this.comboBoxAudioSamplingRate.getSelectedItem());
            }
        });
        this.comboBoxVideoCodecs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SourceConfigurationPanel.this.encoder.getMediaOptions().setVideoCodec((String)SourceConfigurationPanel.this.comboBoxVideoCodecs.getSelectedItem());
                if (SourceConfigurationPanel.this.comboBoxVideoCodecs.getSelectedItem() != null) {
                    if (((String)SourceConfigurationPanel.this.comboBoxVideoCodecs.getSelectedItem()).contains("264") || ((String)SourceConfigurationPanel.this.comboBoxVideoCodecs.getSelectedItem()).contains("265")) {
                        SourceConfigurationPanel.this.spinnerCrf.setVisible(true);
                        SourceConfigurationPanel.this.lblCrf.setVisible(true);
                        SourceConfigurationPanel.this.lblPresets.setVisible(true);
                        SourceConfigurationPanel.this.comboBoxPresets.setVisible(true);
                    } else {
                        SourceConfigurationPanel.this.spinnerCrf.setVisible(false);
                        SourceConfigurationPanel.this.lblCrf.setVisible(false);
                        SourceConfigurationPanel.this.lblPresets.setVisible(false);
                        SourceConfigurationPanel.this.comboBoxPresets.setVisible(false);
                    }
                }
            }
        });
        this.comboBoxResolution.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SourceConfigurationPanel.this.encoder.getMediaOptions().setResolution((String)SourceConfigurationPanel.this.comboBoxResolution.getSelectedItem());
            }
        });
        this.spinnerCrf.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                SourceConfigurationPanel.this.encoder.getMediaOptions().setCrf(SourceConfigurationPanel.this.spinnerCrf.getValue().toString());
            }
        });
        this.comboBoxAudioCodecs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SourceConfigurationPanel.this.encoder.getMediaOptions().setAudioCodec((String)SourceConfigurationPanel.this.comboBoxAudioCodecs.getSelectedItem());
            }
        });
        this.comboBoxFileType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String container = (String)SourceConfigurationPanel.this.comboBoxFileType.getSelectedItem();
                SourceConfigurationPanel.this.encoder.getMediaOptions().setContainer(container);
                List<String> videoCodecs = UserSettingsService.videoCodecsForContainer.get(container);
                List<String> audioCodecs = UserSettingsService.audioCodecsForContainer.get(container);
                SourceConfigurationPanel.this.comboBoxVideoCodecs.removeAllItems();
                SourceConfigurationPanel.this.comboBoxAudioCodecs.removeAllItems();
                for (String videoString : videoCodecs) {
                    SourceConfigurationPanel.this.comboBoxVideoCodecs.addItem(videoString);
                }
                SourceConfigurationPanel.this.comboBoxVideoCodecs.setSelectedItem(videoCodecs.get(0));
                for (String audioString : audioCodecs) {
                    SourceConfigurationPanel.this.comboBoxAudioCodecs.addItem(audioString);
                }
                SourceConfigurationPanel.this.comboBoxAudioCodecs.setSelectedItem(audioCodecs.get(0));
            }
        });
    }

    private void updateGUI() {
        String audioSamplingRate;
        String audioBitrate;
        String vB;
        String frameRate;
        VideoDevice videoInput;
        this.textFieldFileName.setText(this.encoder.getName());
        AudioDevice audioInput = this.encoder.getMediaOptions().getAudioInput();
        if (audioInput != null) {
            this.audioSourcesProgrammaticallyChanging = true;
            comboBoxAudioSources.setSelectedItem(audioInput);
            this.audioSourcesProgrammaticallyChanging = false;
        }
        if ((videoInput = this.encoder.getMediaOptions().getVideoInput()) != null) {
            this.videoSourcesProgrammaticallyChanging = true;
            this.comboBoxVideoSources.setSelectedItem(videoInput);
            this.videoSourcesProgrammaticallyChanging = false;
        }
        if ((frameRate = this.encoder.getMediaOptions().getFps()) != null) {
            this.comboBoxFrameRate.setSelectedItem(frameRate);
        }
        if ((vB = this.encoder.getMediaOptions().getVB()) != null) {
            this.comboBoxVideoBitrate.setSelectedItem(vB);
        }
        if ((audioBitrate = this.encoder.getMediaOptions().getAB()) != null) {
            this.comboBoxAudioBitrate.setSelectedItem(audioBitrate);
        }
        if ((audioSamplingRate = this.encoder.getMediaOptions().getSamplingRate()) != null) {
            this.comboBoxAudioSamplingRate.setSelectedItem(audioSamplingRate);
        }
        this.printCurrentInputs();
    }

    private void setEnabledAudioAndVideoOptions() {
        this.audioSourcesProgrammaticallyChanging = true;
        this.videoSourcesProgrammaticallyChanging = true;
        if (this.encoder.getMediaOptions().getEncodingType().equals((Object)EncodingType.AUDIO_ONLY_OR_NONE)) {
            this.setVideoOptionsEnabled(false, false);
            this.chckBxVideoSourceEnabled.setSelected(false);
            if (!EncodingService.canEncodeAudio().booleanValue()) {
                this.setAudioOptionsEnabled(false, true);
                this.chckBxAudioSourceEnabled.setSelected(false);
            } else {
                this.setAudioOptionsEnabled(true, true);
                this.chckBxAudioSourceEnabled.setSelected(true);
            }
        }
        if (this.encoder.getMediaOptions().getEncodingType().equals((Object)EncodingType.CAMERA)) {
            if (!EncodingService.canEncodeAudioWithCamera()) {
                this.setAudioOptionsEnabled(false, true);
                this.chckBxAudioSourceEnabled.setSelected(false);
            } else {
                this.setAudioOptionsEnabled(true, true);
                this.chckBxAudioSourceEnabled.setSelected(true);
            }
        }
        if (this.encoder.getMediaOptions().getHasAudio().booleanValue()) {
            this.setAudioOptionsEnabled(true, true);
            this.chckBxAudioSourceEnabled.setSelected(true);
        } else {
            this.setAudioOptionsEnabled(false, false);
            this.chckBxAudioSourceEnabled.setSelected(false);
        }
        if (this.encoder.getMediaOptions().getHasVideo().booleanValue()) {
            this.setVideoOptionsEnabled(true, true);
            this.chckBxVideoSourceEnabled.setSelected(true);
        } else {
            this.setVideoOptionsEnabled(false, false);
            this.chckBxVideoSourceEnabled.setSelected(false);
        }
        this.audioSourcesProgrammaticallyChanging = false;
        this.videoSourcesProgrammaticallyChanging = false;
    }

    private boolean lectureContainsVideoInputSource(VideoDevice newSelectedInputSource) {
        for (FFMPEGEncoder encoder : Lecture.getEncoders()) {
            if (!encoder.getMediaOptions().getVideoInput().equals(newSelectedInputSource)) continue;
            return true;
        }
        return false;
    }

    private boolean lectureContainsAudioInputSource(AudioDevice audioInput) {
        for (FFMPEGEncoder encoder : Lecture.getEncoders()) {
            if (!encoder.getMediaOptions().getAudioInput().equals(audioInput)) continue;
            return true;
        }
        return false;
    }

    private void printCurrentInputs() {
        System.out.println("\nCURRENT INPUTS: ");
        for (FFMPEGEncoder encoder : Lecture.getEncoders()) {
            System.out.println("\t" + encoder.getMediaOptions().getVideoInput());
        }
        System.out.println("\t\tThis encoder: ");
        System.out.println("\t\t\tVIDEO (" + this.encoder.getMediaOptions().getHasVideo() + "):" + this.encoder.getMediaOptions().getVideoInput() + " AUDIO (" + this.encoder.getMediaOptions().getHasAudio() + "):" + this.encoder.getMediaOptions().getAudioInput());
    }

    private void setVideoOptionsEnabled(boolean enabled, boolean affectVideoInput) {
        if (affectVideoInput) {
            this.comboBoxVideoSources.setEnabled(enabled);
        }
        this.comboBoxFrameRate.setEnabled(enabled);
        this.comboBoxVideoBitrate.setEnabled(enabled);
        this.spinnerCrf.setEnabled(enabled);
        this.comboBoxResolution.setEnabled(enabled);
        this.comboBoxVideoCodecs.setEnabled(enabled);
    }

    private void setAudioOptionsEnabled(boolean enabled, boolean affectAudioInput) {
        if (affectAudioInput) {
            comboBoxAudioSources.setEnabled(enabled);
        }
        this.comboBoxAudioBitrate.setEnabled(enabled);
        this.comboBoxAudioSamplingRate.setEnabled(enabled);
        this.comboBoxAudioCodecs.setEnabled(enabled);
        comboBoxAudioSources.setEnabled(enabled);
    }

    public FFMPEGEncoder getEncoder() {
        return this.encoder;
    }

    @Override
    public void setStringValues() {
        this.infoMessage = new String(MessagesService.getString("SourceConfigurationPanel.infoMessage"));
        this.warningMessageVideoSourceAlreadyUsed = new String(MessagesService.getString("SourceConfigurationPanel.warningMessage.videoSourceAlreadyUsed"));
        this.warningMessageAudioSourceAlreadyUsed = new String(MessagesService.getString("SourceConfigurationPanel.warningMessage.audioSourceAlreadyUsed"));
        this.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), MessagesService.getString("SourceConfigurationPanel.encodigConfigurationBorder.text"), 4, 2, null, new Color(0, 0, 0)));
        this.panelVideoConfigration.setBorder(new EtchedBorder(1, null, null));
        this.panelAudioConfiguration.setBorder(new EtchedBorder(1, null, null));
        this.btnChangeFileLocation.setText(MessagesService.getString("SourceConfigurationPanel.btnChangeFileLocation.text"));
        this.lblFileName.setText(String.valueOf(MessagesService.getString("SourceConfigurationPanel.lblFileName.text")) + ":");
        this.lblVideoBitrate.setText(String.valueOf(MessagesService.getString("SourceConfigurationPanel.lblVideoBitrate.text")) + ":");
        this.lblFramesPerSecond.setText(String.valueOf(MessagesService.getString("SourceConfigurationPanel.lblFramesPerSecond.text")) + ":");
        this.lblVideoInput.setText(String.valueOf(MessagesService.getString("SourceConfigurationPanel.lblVideoInput.text")) + ":");
        this.lblAudioInput.setText(String.valueOf(MessagesService.getString("SourceConfigurationPanel.lblAudioInput.text")) + ":");
        this.lblAudioBitrate.setText(String.valueOf(MessagesService.getString("SourceConfigurationPanel.lblAudioBitrate.text")) + ":");
        this.lblFileLocation.setText(String.valueOf(MessagesService.getString("SourceConfigurationPanel.lblFileLocation.text")) + ":");
        this.lblVideoCodec.setText(String.valueOf(MessagesService.getString("SourceConfigurationPanel.lblVideoCodec.text")) + ":");
        this.lblVideoInput.setToolTipText(MessagesService.getString("SourceConfigurationPanel.labelHelpVideoSource.tooltipText"));
        this.lblVideoCodec.setToolTipText(MessagesService.getString("SourceConfigurationPanel.labelHelpVideoCodec.tooltipText"));
        this.lblVideoBitrate.setToolTipText(MessagesService.getString("SourceConfigurationPanel.labelHelpVideoBitrate.tooltipText"));
        this.lblFramesPerSecond.setToolTipText(MessagesService.getString("SourceConfigurationPanel.labelHelpFrameRate.tooltipText"));
        this.lblAudioInput.setToolTipText(MessagesService.getString("SourceConfigurationPanel.labelHelpAudioSource.tooltipText"));
        this.lblAudioBitrate.setToolTipText(MessagesService.getString("SourceConfigurationPanel.labelHelpAudioBitrate.tooltipText"));
        this.lblFileLocation.setToolTipText(MessagesService.getString("SourceConfigurationPanel.labelHelpFileLocation.tooltipText"));
        this.lblFileName.setToolTipText(MessagesService.getString("SourceConfigurationPanel.labelHelpFileName.tooltipText"));
        this.chckBxVideoSourceEnabled.setText(MessagesService.getString("SourceConfigurationPanel.videoConfigurationBorder.text"));
        this.chckBxAudioSourceEnabled.setText(MessagesService.getString("SourceConfigurationPanel.audioConfigurationBorder.text"));
        this.lblResolution.setText(String.valueOf(MessagesService.getString("SourceConfigurationPanel.lblResolution.text")) + ":");
        this.lblAudioCodec.setText(String.valueOf(MessagesService.getString("SourceConfigurationPanel.lblAudioCodec.text")) + ":");
        this.lblSamplingRate.setText(String.valueOf(MessagesService.getString("SourceConfigurationPanel.lblSamplingRate.text")) + ":");
    }
}

