/*
 * Decompiled with CFR 0.152.
 */
package fer.lss.lecto.gui.psu;

import fer.lss.lecto.filters.ExtensionFileFilter;
import fer.lss.lecto.gui.locale.ILocale;
import fer.lss.lecto.gui.psu.ALCEditor;
import fer.lss.lecto.gui.psu.EditorMode;
import fer.lss.lecto.gui.psu.VideoEditor;
import fer.lss.lecto.model.psu.AdditionalLectureContent;
import fer.lss.lecto.model.psu.PSUDefaultValues;
import fer.lss.lecto.model.psu.PlayerSetUp;
import fer.lss.lecto.model.psu.Video;
import fer.lss.lecto.services.MessagesService;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PSUEditor
extends JDialog
implements ILocale {
    private static final long serialVersionUID = 1L;
    private final JPanel contentPanel = new JPanel();
    private JTextField textFieldNavigationTitle;
    private JTextField textFieldCCEFileUri;
    private JSpinner spinnerNavigationWidth;
    private JSpinner spinnerNavigationLocationX;
    private JSpinner spinnerNavigationHeight;
    private JSpinner spinnerNavigationLocationY;
    private JCheckBox chckbxNavigationOnTop;
    private JCheckBox chckbxNavigationAutoOn;
    private JCheckBox chckbxNavigationResizable;
    private DefaultListModel videosListModel;
    private DefaultListModel alcsListModel;
    private JList listVideos;
    private JList listAlcs;
    private JScrollPane scrollPaneALCs;
    private JScrollPane scrollPaneVideos;
    private JFrame parent;
    private JLabel lblNavigationTitle;
    private JPanel panelNavigationSize;
    private JLabel lblNavigationWidth;
    private JLabel lblNavigationHeight;
    private JPanel panelNavigationPosition;
    private JLabel lblLocationX;
    private JLabel lblLocationY;
    private JPanel panelCCE;
    private JLabel lblFileUri;
    private JButton btnCCEAddLocalFile;
    private String chooseCCEFile;
    private String selectPSULocationAndName;
    private JButton btnVideosAddNew;
    private JButton btnVideosEdit;
    private JButton btnVideosRemove;
    private JButton buttonALCAddNew;
    private JButton buttonALCEdit;
    private JButton buttonALCRemove;
    private JButton saveButton;
    private JPanel panelNavigation;
    private JPanel panelVideos;
    private JPanel panelALC;

    public PSUEditor(JFrame parent) {
        this.parent = parent;
        this.spinnerNavigationWidth = new JSpinner();
        this.spinnerNavigationHeight = new JSpinner();
        this.spinnerNavigationLocationX = new JSpinner();
        this.spinnerNavigationLocationY = new JSpinner();
        this.chckbxNavigationOnTop = new JCheckBox();
        this.chckbxNavigationAutoOn = new JCheckBox();
        this.chckbxNavigationResizable = new JCheckBox();
        this.textFieldNavigationTitle = new JTextField();
        this.textFieldCCEFileUri = new JTextField();
        this.videosListModel = new DefaultListModel();
        this.alcsListModel = new DefaultListModel();
        this.listVideos = new JList(this.videosListModel);
        this.listAlcs = new JList(this.alcsListModel);
        this.scrollPaneVideos = new JScrollPane(this.listVideos);
        this.scrollPaneALCs = new JScrollPane(this.listAlcs);
        this.fillFields();
        if (this.listVideos.getModel().getSize() > 0) {
            this.listVideos.setSelectedIndex(0);
        }
        if (this.listAlcs.getModel().getSize() > 0) {
            this.listAlcs.setSelectedIndex(0);
        }
        this.panelNavigation = new JPanel();
        this.lblNavigationTitle = new JLabel();
        this.panelNavigationSize = new JPanel();
        this.lblNavigationWidth = new JLabel();
        this.lblNavigationHeight = new JLabel();
        this.panelNavigationPosition = new JPanel();
        this.lblLocationX = new JLabel();
        this.lblLocationY = new JLabel();
        this.panelCCE = new JPanel();
        this.lblFileUri = new JLabel();
        this.btnCCEAddLocalFile = new JButton();
        this.btnVideosAddNew = new JButton();
        this.btnVideosEdit = new JButton();
        this.btnVideosRemove = new JButton();
        this.buttonALCAddNew = new JButton();
        this.buttonALCEdit = new JButton();
        this.buttonALCRemove = new JButton();
        this.saveButton = new JButton();
        this.panelVideos = new JPanel();
        this.panelALC = new JPanel();
        this.createGUI();
        this.setStringValues();
    }

    private void fillFields() {
        this.spinnerNavigationWidth.setValue(PlayerSetUp.getNavigation().getSizeWidth());
        this.spinnerNavigationHeight.setValue(PlayerSetUp.getNavigation().getSizeHeight());
        this.spinnerNavigationLocationX.setValue(PlayerSetUp.getNavigation().getLocationX());
        this.spinnerNavigationLocationY.setValue(PlayerSetUp.getNavigation().getLocationY());
        this.chckbxNavigationOnTop.setSelected(PlayerSetUp.getNavigation().getOnTop());
        this.chckbxNavigationAutoOn.setSelected(PlayerSetUp.getNavigation().getAutoOn());
        this.chckbxNavigationResizable.setSelected(PlayerSetUp.getNavigation().getResizable());
        this.textFieldNavigationTitle.setText(PlayerSetUp.getNavigation().getTitle());
        this.textFieldCCEFileUri.setText(PlayerSetUp.getCce().getUri());
        for (Video video : PlayerSetUp.getVideos()) {
            this.videosListModel.addElement(video);
        }
        for (AdditionalLectureContent alc : PlayerSetUp.getAlcs()) {
            this.alcsListModel.addElement(alc);
        }
    }

    private void createGUI() {
        this.setResizable(false);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(PSUEditor.class.getResource("/images/favicon32T.png")));
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setDefaultCloseOperation(2);
        this.setBounds(this.parent.getX() + 50, this.parent.getY() + 100, 419, 664);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(null);
        this.panelNavigation.setBounds(10, 11, 385, 208);
        this.contentPanel.add(this.panelNavigation);
        this.panelNavigation.setLayout(null);
        this.lblNavigationTitle.setBounds(10, 22, 76, 21);
        this.panelNavigation.add(this.lblNavigationTitle);
        this.panelNavigationSize.setBounds(10, 145, 366, 54);
        this.panelNavigation.add(this.panelNavigationSize);
        this.panelNavigationSize.setLayout(null);
        this.lblNavigationWidth.setBounds(10, 22, 93, 18);
        this.panelNavigationSize.add(this.lblNavigationWidth);
        this.lblNavigationHeight.setBounds(202, 21, 72, 20);
        this.panelNavigationSize.add(this.lblNavigationHeight);
        this.spinnerNavigationWidth.setBounds(107, 22, 63, 20);
        this.spinnerNavigationWidth.setModel(new SpinnerNumberModel(PlayerSetUp.getNavigation().getSizeWidth(), new Integer(0), null, new Integer(1)));
        this.spinnerNavigationWidth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                PlayerSetUp.getNavigation().setSizeWidth((Integer)PSUEditor.this.spinnerNavigationWidth.getValue());
            }
        });
        this.panelNavigationSize.add(this.spinnerNavigationWidth);
        this.spinnerNavigationHeight.setBounds(295, 22, 63, 20);
        this.spinnerNavigationHeight.setModel(new SpinnerNumberModel(PlayerSetUp.getNavigation().getSizeHeight(), new Integer(0), null, new Integer(1)));
        this.spinnerNavigationHeight.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                PlayerSetUp.getNavigation().setSizeHeight((Integer)PSUEditor.this.spinnerNavigationHeight.getValue());
            }
        });
        this.panelNavigationSize.add(this.spinnerNavigationHeight);
        this.panelNavigationPosition.setLayout(null);
        this.panelNavigationPosition.setBounds(10, 80, 366, 54);
        this.panelNavigation.add(this.panelNavigationPosition);
        this.lblLocationX.setBounds(10, 22, 100, 17);
        this.panelNavigationPosition.add(this.lblLocationX);
        this.lblLocationY.setBounds(193, 22, 92, 17);
        this.panelNavigationPosition.add(this.lblLocationY);
        this.spinnerNavigationLocationX.setBounds(107, 20, 63, 20);
        this.spinnerNavigationLocationX.setModel(new SpinnerNumberModel(PlayerSetUp.getNavigation().getLocationX(), new Integer(0), null, new Integer(1)));
        this.spinnerNavigationLocationX.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                PlayerSetUp.getNavigation().setLocationX((Integer)PSUEditor.this.spinnerNavigationLocationX.getValue());
            }
        });
        this.panelNavigationPosition.add(this.spinnerNavigationLocationX);
        this.spinnerNavigationLocationY.setBounds(295, 20, 63, 20);
        this.spinnerNavigationLocationY.setModel(new SpinnerNumberModel(PlayerSetUp.getNavigation().getLocationY(), new Integer(0), null, new Integer(1)));
        this.spinnerNavigationLocationY.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                PlayerSetUp.getNavigation().setLocationY((Integer)PSUEditor.this.spinnerNavigationLocationY.getValue());
            }
        });
        this.panelNavigationPosition.add(this.spinnerNavigationLocationY);
        this.chckbxNavigationOnTop.setBounds(129, 50, 105, 23);
        this.chckbxNavigationOnTop.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                PlayerSetUp.getNavigation().setOnTop(PSUEditor.this.chckbxNavigationOnTop.isSelected());
            }
        });
        this.panelNavigation.add(this.chckbxNavigationOnTop);
        this.chckbxNavigationAutoOn.setBounds(233, 50, 143, 23);
        this.chckbxNavigationAutoOn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                PlayerSetUp.getNavigation().setAutoOn(PSUEditor.this.chckbxNavigationAutoOn.isSelected());
            }
        });
        this.panelNavigation.add(this.chckbxNavigationAutoOn);
        this.chckbxNavigationResizable.setBounds(10, 50, 117, 23);
        this.chckbxNavigationResizable.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                PlayerSetUp.getNavigation().setResizable(PSUEditor.this.chckbxNavigationResizable.isSelected());
            }
        });
        this.panelNavigation.add(this.chckbxNavigationResizable);
        this.textFieldNavigationTitle.setBounds(104, 18, 178, 25);
        this.textFieldNavigationTitle.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e2) {
                this.textFieldFileNameChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e2) {
                this.textFieldFileNameChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e2) {
            }

            private void textFieldFileNameChanged() {
                PlayerSetUp.getNavigation().setTitle(PSUEditor.this.textFieldNavigationTitle.getText());
            }
        });
        this.panelNavigation.add(this.textFieldNavigationTitle);
        this.textFieldNavigationTitle.setColumns(10);
        this.panelCCE.setBounds(10, 230, 385, 68);
        this.contentPanel.add(this.panelCCE);
        this.panelCCE.setLayout(null);
        this.lblFileUri.setBounds(10, 29, 58, 14);
        this.panelCCE.add(this.lblFileUri);
        this.textFieldCCEFileUri.setColumns(10);
        this.textFieldCCEFileUri.setBounds(86, 22, 190, 25);
        this.textFieldCCEFileUri.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e2) {
                this.textFieldFileNameChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e2) {
                this.textFieldFileNameChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e2) {
            }

            private void textFieldFileNameChanged() {
                PlayerSetUp.getCce().setUri(PSUEditor.this.textFieldCCEFileUri.getText());
            }
        });
        this.panelCCE.add(this.textFieldCCEFileUri);
        this.btnCCEAddLocalFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                JFileChooser fc = new JFileChooser();
                ExtensionFileFilter filter1 = new ExtensionFileFilter("CCE xml", new String[]{"xml"});
                fc.setFileFilter(filter1);
                fc.setDialogTitle(PSUEditor.this.chooseCCEFile);
                int returnVal = fc.showOpenDialog(PSUEditor.this);
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    PSUEditor.this.textFieldCCEFileUri.setText(file.getAbsolutePath());
                }
            }
        });
        this.btnCCEAddLocalFile.setBounds(282, 22, 91, 25);
        this.panelCCE.add(this.btnCCEAddLocalFile);
        this.panelVideos.setBounds(10, 309, 383, 128);
        this.contentPanel.add(this.panelVideos);
        this.panelVideos.setLayout(null);
        this.btnVideosAddNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VideoEditor videoEditor = new VideoEditor(PSUDefaultValues.getDefaultVideo(), PSUEditor.this, EditorMode.ADD_NEW);
                videoEditor.setVisible(true);
                if (videoEditor.getSave().booleanValue()) {
                    PSUEditor.this.videosListModel.removeAllElements();
                    for (Video video : PlayerSetUp.getVideos()) {
                        PSUEditor.this.videosListModel.addElement(video);
                    }
                }
            }
        });
        this.btnVideosAddNew.setBounds(298, 22, 75, 23);
        this.panelVideos.add(this.btnVideosAddNew);
        this.btnVideosEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                int selectedIndex = PSUEditor.this.listVideos.getSelectedIndex();
                if (selectedIndex != -1) {
                    Video selectedVideo = (Video)PSUEditor.this.videosListModel.get(selectedIndex);
                    VideoEditor videoEditor = new VideoEditor(selectedVideo, PSUEditor.this, EditorMode.EDIT);
                    videoEditor.setVisible(true);
                    if (videoEditor.getSave().booleanValue()) {
                        PSUEditor.this.videosListModel.removeAllElements();
                        for (Video video : PlayerSetUp.getVideos()) {
                            PSUEditor.this.videosListModel.addElement(video);
                        }
                    }
                }
            }
        });
        this.btnVideosEdit.setBounds(298, 56, 75, 23);
        this.panelVideos.add(this.btnVideosEdit);
        this.btnVideosRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                int selectedIndex = PSUEditor.this.listVideos.getSelectedIndex();
                if (selectedIndex != -1) {
                    Video selectedVideo = (Video)PSUEditor.this.videosListModel.get(selectedIndex);
                    PlayerSetUp.removeVideo(selectedVideo);
                    PSUEditor.this.videosListModel.removeElement(selectedVideo);
                }
            }
        });
        this.btnVideosRemove.setBounds(298, 91, 75, 23);
        this.panelVideos.add(this.btnVideosRemove);
        this.scrollPaneVideos.setBounds(12, 22, 258, 92);
        this.panelVideos.add(this.scrollPaneVideos);
        this.panelALC.setBounds(10, 448, 383, 128);
        this.contentPanel.add(this.panelALC);
        this.panelALC.setLayout(null);
        this.buttonALCAddNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ALCEditor alcEditor = new ALCEditor(PSUDefaultValues.getDefaultALC(), PSUEditor.this, EditorMode.ADD_NEW);
                alcEditor.setVisible(true);
                if (alcEditor.getSave().booleanValue()) {
                    PSUEditor.this.alcsListModel.removeAllElements();
                    for (AdditionalLectureContent alc : PlayerSetUp.getAlcs()) {
                        PSUEditor.this.alcsListModel.addElement(alc);
                    }
                }
            }
        });
        this.buttonALCAddNew.setBounds(298, 22, 75, 23);
        this.panelALC.add(this.buttonALCAddNew);
        this.buttonALCEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                int selectedIndex = PSUEditor.this.listAlcs.getSelectedIndex();
                if (selectedIndex != -1) {
                    AdditionalLectureContent selectedALC = (AdditionalLectureContent)PSUEditor.this.alcsListModel.get(selectedIndex);
                    ALCEditor alcEditor = new ALCEditor(selectedALC, PSUEditor.this, EditorMode.EDIT);
                    alcEditor.setVisible(true);
                    if (alcEditor.getSave().booleanValue()) {
                        PSUEditor.this.alcsListModel.removeAllElements();
                        for (AdditionalLectureContent alc : PlayerSetUp.getAlcs()) {
                            PSUEditor.this.alcsListModel.addElement(alc);
                        }
                    }
                }
            }
        });
        this.buttonALCEdit.setBounds(298, 56, 75, 23);
        this.panelALC.add(this.buttonALCEdit);
        this.buttonALCRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                int selectedIndex = PSUEditor.this.listAlcs.getSelectedIndex();
                if (selectedIndex != -1) {
                    AdditionalLectureContent selectedALC = (AdditionalLectureContent)PSUEditor.this.alcsListModel.get(selectedIndex);
                    PlayerSetUp.removeALC(selectedALC);
                    PSUEditor.this.alcsListModel.removeElement(selectedALC);
                }
            }
        });
        this.buttonALCRemove.setBounds(298, 90, 75, 23);
        this.panelALC.add(this.buttonALCRemove);
        this.scrollPaneALCs.setBounds(12, 22, 258, 92);
        this.panelALC.add(this.scrollPaneALCs);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                JFileChooser fc = new JFileChooser();
                ExtensionFileFilter filter1 = new ExtensionFileFilter("Player Set Up", new String[]{"xml"});
                fc.setFileFilter(filter1);
                fc.setDialogTitle(PSUEditor.this.selectPSULocationAndName);
                int returnVal = fc.showOpenDialog(PSUEditor.this);
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    file = new File(file.getAbsoluteFile() + ".psu.xml");
                    PlayerSetUp.createXMLRepresentationToFileLocation(file);
                    PSUEditor.this.dispose();
                }
            }
        });
        buttonPane.add(this.saveButton);
        this.getRootPane().setDefaultButton(this.saveButton);
    }

    @Override
    public void setStringValues() {
        this.setTitle(MessagesService.getString("PSUEditor.this.title"));
        this.chooseCCEFile = new String(MessagesService.getString("PSUEditor.message.chooseCCEFile"));
        this.selectPSULocationAndName = new String(MessagesService.getString("PSUEditor.message.selectPSU"));
        this.panelNavigation.setBorder(new TitledBorder(null, MessagesService.getString("PSUEditor.panelNavigation.border.text"), 4, 2, null, null));
        this.panelNavigationSize.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), MessagesService.getString("PSUEditor.panelNavigationSize.border.text"), 4, 2, null, new Color(0, 0, 0)));
        this.panelNavigationPosition.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), MessagesService.getString("PSUEditor.panelNavigationPosition.border.text"), 4, 2, null, new Color(0, 0, 0)));
        this.panelCCE.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), MessagesService.getString("PSUEditor.panelCCE.border.text"), 4, 2, null, new Color(0, 0, 0)));
        this.panelVideos.setBorder(new TitledBorder(null, MessagesService.getString("PSUEditor.panelVideos.border.text"), 4, 2, null, null));
        this.panelALC.setBorder(new TitledBorder(null, MessagesService.getString("PSUEditor.panelALC.border.text"), 4, 2, null, null));
        this.chckbxNavigationAutoOn.setText(MessagesService.getString("PSUEditor.chckbxNavigationAutoOn.text"));
        this.chckbxNavigationOnTop.setText(MessagesService.getString("PSUEditor.chckbxNavigationOnTop.text"));
        this.chckbxNavigationResizable.setText(MessagesService.getString("PSUEditor.chckbxNavigationResizable.text"));
        this.lblNavigationTitle.setText(String.valueOf(MessagesService.getString("PSUEditor.lblNavigationTitle.text")) + ":");
        this.lblNavigationWidth.setText(String.valueOf(MessagesService.getString("PSUEditor.lblNavigationWidth.text")) + ":");
        this.lblNavigationHeight.setText(String.valueOf(MessagesService.getString("PSUEditor.lblNavigationHeight.text")) + ":");
        this.lblLocationX.setText(String.valueOf(MessagesService.getString("PSUEditor.lblLocationX.text")) + ":");
        this.lblLocationY.setText(String.valueOf(MessagesService.getString("PSUEditor.lblLocationY.text")) + ":");
        this.lblFileUri.setText(String.valueOf(MessagesService.getString("PSUEditor.lblFileUri.text")) + ":");
        this.btnCCEAddLocalFile.setText(MessagesService.getString("PSUEditor.btnCCEAddLocalFile.text"));
        this.btnVideosAddNew.setText(MessagesService.getString("PSUEditor.btnVideosAddNew.text"));
        this.btnVideosEdit.setText(MessagesService.getString("PSUEditor.btnVideosEdit.text"));
        this.btnVideosRemove.setText(MessagesService.getString("PSUEditor.btnVideosRemove.text"));
        this.buttonALCAddNew.setText(MessagesService.getString("PSUEditor.buttonALCAddNew.text"));
        this.buttonALCEdit.setText(MessagesService.getString("PSUEditor.buttonALCEdit.text"));
        this.buttonALCRemove.setText(MessagesService.getString("PSUEditor.buttonALCRemove.text"));
        this.saveButton.setText(MessagesService.getString("PSUEditor.saveButton.text"));
    }
}

