/*
 * Decompiled with CFR 0.152.
 */
package fer.lss.lecto.gui.translate;

import fer.lss.lecto.LeCTo;
import fer.lss.lecto.constants.LeCToHelpConstants;
import fer.lss.lecto.gui.locale.ILocale;
import fer.lss.lecto.model.messages.KeyValue;
import fer.lss.lecto.services.HelpService;
import fer.lss.lecto.services.MessagesService;
import fer.lss.lecto.services.translate.TranslateService;
import fer.lss.lecto.utils.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class LeCToTranslateDialog
extends JDialog
implements ILocale {
    private static final long serialVersionUID = 1L;
    private final JPanel translateTablePanel = new JPanel();
    private JFrame parent;
    private Properties translateProperties;
    private JTable keyValueTable;
    private JScrollPane scrollPane;
    private JButton saveButton;
    private Object[] columnNames;
    private Object[][] rowData;
    private JTextField textFieldCountry;
    private JTextField textFieldLanguage;
    private JTextField textFieldIcon;
    private JLabel lblCountry;
    private JLabel lblLanguage;
    private JButton btnAddIconImage;
    private JButton cancelButton;
    private JLabel lblIcon;
    private String warningMessageCancel;
    private String warningMessageSave;
    private JLabel labelEmpty;
    private JLabel labelEmpty2;
    private JLabel lblHelpCountry;
    private JLabel lblHelpLanguage;
    private JLabel lblHelpImage;
    private String infoFlagIconMessage;
    private String languageTranslateSuccess;
    private String languageTranslateError;
    private Boolean save;

    public LeCToTranslateDialog(JFrame parent) {
        super(parent);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(LeCToTranslateDialog.class.getResource("/images/favicon32T.png")));
        this.translateProperties = MessagesService.getDefaultProperties();
        this.parent = parent;
        this.save = false;
        this.lblCountry = new JLabel();
        this.lblLanguage = new JLabel();
        this.lblIcon = new JLabel();
        this.textFieldIcon = new JTextField();
        this.textFieldLanguage = new JTextField();
        this.textFieldCountry = new JTextField();
        this.btnAddIconImage = new JButton();
        this.saveButton = new JButton();
        this.cancelButton = new JButton();
        this.lblHelpImage = new JLabel();
        this.lblHelpCountry = new JLabel();
        this.lblHelpLanguage = new JLabel();
        this.setStringValues();
        this.fillTableData();
        this.keyValueTable = this.createTable(this.columnNames, this.rowData);
        this.keyValueTable.getColumnModel().getColumn(0).setCellRenderer(new VariableRowHeightRenderer());
        this.scrollPane = new JScrollPane(this.keyValueTable);
        this.createGUI();
        this.addHelpLabelsActionListeners();
    }

    private void createGUI() {
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.setBounds(this.parent.getX() + 100, this.parent.getY() + 100, 692, 556);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panelLanguageInfo = new JPanel();
        this.getContentPane().add((Component)panelLanguageInfo, "North");
        panelLanguageInfo.setLayout(new FlowLayout(0, 5, 5));
        panelLanguageInfo.add(this.lblCountry);
        MaxLengthTextDocument countryDocument = new MaxLengthTextDocument(2, CaseType.UPPER_CASE);
        this.textFieldCountry.setDocument(countryDocument);
        this.textFieldCountry.setColumns(2);
        panelLanguageInfo.add(this.textFieldCountry);
        this.lblHelpCountry.setIcon(new ImageIcon(LeCToTranslateDialog.class.getResource("/images/icons/help.png")));
        panelLanguageInfo.add(this.lblHelpCountry);
        this.labelEmpty = new JLabel("          ");
        panelLanguageInfo.add(this.labelEmpty);
        panelLanguageInfo.add(this.lblLanguage);
        MaxLengthTextDocument languageDocument = new MaxLengthTextDocument(2, CaseType.LOWER_CASE);
        this.textFieldLanguage.setDocument(languageDocument);
        this.textFieldLanguage.setColumns(2);
        panelLanguageInfo.add(this.textFieldLanguage);
        this.lblHelpLanguage.setIcon(new ImageIcon(LeCToTranslateDialog.class.getResource("/images/icons/help.png")));
        panelLanguageInfo.add(this.lblHelpLanguage);
        this.labelEmpty2 = new JLabel("          ");
        panelLanguageInfo.add(this.labelEmpty2);
        panelLanguageInfo.add(this.lblIcon);
        panelLanguageInfo.add(this.textFieldIcon);
        this.textFieldIcon.setColumns(10);
        this.btnAddIconImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser fc = new JFileChooser();
                fc.setDialogTitle(LeCToTranslateDialog.this.infoFlagIconMessage);
                int returnVal = fc.showOpenDialog(LeCToTranslateDialog.this);
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    LeCToTranslateDialog.this.textFieldIcon.setText(file.getAbsolutePath());
                }
            }
        });
        panelLanguageInfo.add(this.btnAddIconImage);
        this.lblHelpImage.setIcon(new ImageIcon(LeCToTranslateDialog.class.getResource("/images/icons/help.png")));
        panelLanguageInfo.add(this.lblHelpImage);
        this.translateTablePanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.translateTablePanel, "Center");
        this.translateTablePanel.setLayout(new BorderLayout());
        this.translateTablePanel.add(this.scrollPane);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (LeCToTranslateDialog.this.userIsSureAboutTheDecision(LeCToTranslateDialog.this.warningMessageCancel)) {
                    LeCToTranslateDialog.this.dispose();
                }
            }
        });
        buttonPane.add(this.cancelButton);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (LeCToTranslateDialog.this.validateFields() && LeCToTranslateDialog.this.userIsSureAboutTheDecision(LeCToTranslateDialog.this.warningMessageSave)) {
                    LeCToTranslateDialog.this.save = true;
                    LeCToTranslateDialog.this.saveLanguage();
                    LeCToTranslateDialog.this.dispose();
                }
            }
        });
        buttonPane.add(this.saveButton);
    }

    private void addHelpLabelsActionListeners() {
        this.lblHelpImage.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                HelpService.showHelpFrame(LeCToHelpConstants.TRANSLATE_IMAGE);
            }
        });
        this.lblHelpCountry.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                HelpService.showHelpFrame(LeCToHelpConstants.TRANSLATE_COUNTRY);
            }
        });
        this.lblHelpLanguage.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                HelpService.showHelpFrame(LeCToHelpConstants.TRANSLATE_LANGUAGE);
            }
        });
    }

    private boolean userIsSureAboutTheDecision(String message) {
        int res = JOptionPane.showConfirmDialog(this, message, MessagesService.getString("LeCToTranslateDialog.questionMessage"), 0, 3, new ImageIcon(LeCTo.class.getResource("/images/logo.png")));
        return res == 0;
    }

    private void saveLanguage() {
        this.translateProperties.clear();
        int row = 0;
        while (row < this.keyValueTable.getRowCount()) {
            this.translateProperties.setProperty(this.keyValueTable.getValueAt(row, 0).toString(), this.keyValueTable.getValueAt(row, 1).toString());
            ++row;
        }
        try {
            TranslateService.saveNewLanguage(this.translateProperties, this.textFieldCountry.getText(), this.textFieldLanguage.getText(), this.textFieldIcon.getText());
            JOptionPane.showMessageDialog(null, this.languageTranslateSuccess, MessagesService.getString("LeCToTranslateDialog.questionMessage"), -1, new ImageIcon(LeCTo.class.getResource("/images/logo.png")));
        }
        catch (IOException e2) {
            JOptionPane.showMessageDialog(null, this.languageTranslateError, MessagesService.getString("LeCToTranslateDialog.errorMessage"), -1, new ImageIcon(LeCTo.class.getResource("/images/logo.png")));
            e2.printStackTrace();
        }
    }

    private boolean validateFields() {
        if (this.textFieldCountry.getText().equals("")) {
            this.showFieldNotValidMessage(String.valueOf(MessagesService.getString("LeCToTranslateDialog.field.text")) + " \"" + MessagesService.getString("LeCToTranslateDialog.lblCountry.text") + "\" " + MessagesService.getString("LeCToTranslateDialog.cantBeEmpty.text") + "!");
            return false;
        }
        if (this.textFieldLanguage.getText().equals("")) {
            this.showFieldNotValidMessage(String.valueOf(MessagesService.getString("LeCToTranslateDialog.field.text")) + " \"" + MessagesService.getString("LeCToTranslateDialog.lblLanguage.text") + "\" " + MessagesService.getString("LeCToTranslateDialog.cantBeEmpty.text") + "!");
            return false;
        }
        File iconFile = new File(this.textFieldIcon.getText());
        if (!iconFile.exists()) {
            this.showFieldNotValidMessage(String.valueOf(MessagesService.getString("LeCToTranslateDialog.iconotExists.text")) + "!");
            return false;
        }
        return true;
    }

    private void showFieldNotValidMessage(String message) {
        JOptionPane.showMessageDialog(this, message, MessagesService.getString("LeCToTranslateDialog.warningMessage"), 2, new ImageIcon(LeCTo.class.getResource("/images/logo.png")));
    }

    private JTable createTable(final Object[] columnNames, final Object[][] rowData) {
        JTable table = new JTable(new DefaultTableModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return rowData[rowIndex][columnIndex];
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                rowData[row][column] = aValue;
            }

            @Override
            public int getRowCount() {
                return rowData.length;
            }

            @Override
            public int getColumnCount() {
                return columnNames.length;
            }

            @Override
            public String getColumnName(int col) {
                return columnNames[col].toString();
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col >= 1;
            }
        });
        return table;
    }

    private void fillTableData() {
        ArrayList<KeyValue> propsList = new ArrayList<KeyValue>();
        for (Object key : this.translateProperties.keySet()) {
            propsList.add(new KeyValue(key.toString(), this.translateProperties.get(key).toString()));
        }
        Collections.sort(propsList);
        int size = propsList.size();
        this.rowData = new Object[size][2];
        int keyCounter = 0;
        for (KeyValue keyValue : propsList) {
            this.rowData[keyCounter][0] = keyValue.getKey();
            this.rowData[keyCounter][1] = keyValue.getValue();
            ++keyCounter;
        }
    }

    @Override
    public void setStringValues() {
        this.setTitle(MessagesService.getString("LeCToTranslateDialog.this.title.text"));
        this.infoFlagIconMessage = MessagesService.getString("LeCToTranslateDialog.infoFlagIconMessage.text");
        this.warningMessageCancel = MessagesService.getString("LeCToTranslateDialog.warningMessageCancel.text");
        this.warningMessageSave = MessagesService.getString("LeCToTranslateDialog.warningMessageSave.text");
        this.lblCountry.setText(String.valueOf(MessagesService.getString("LeCToTranslateDialog.lblCountry.text")) + ":");
        this.lblLanguage.setText(String.valueOf(MessagesService.getString("LeCToTranslateDialog.lblLanguage.text")) + ":");
        this.btnAddIconImage.setText(MessagesService.getString("LeCToTranslateDialog.btnAddIconImage.text"));
        this.lblIcon.setText(String.valueOf(MessagesService.getString("LeCToTranslateDialog.lblIcon.text")) + ":");
        this.columnNames = new Object[]{MessagesService.getString("LeCToTranslateDialog.columnName.key.text"), MessagesService.getString("LeCToTranslateDialog.columnName.value.text")};
        this.saveButton.setText(MessagesService.getString("LeCToTranslateDialog.saveButton.text"));
        this.cancelButton.setText(MessagesService.getString("LeCToTranslateDialog.cancelButton.text"));
        this.lblHelpCountry.setToolTipText(MessagesService.getString("LeCToTranslateDialog.lblHelpCountry.tooltipText"));
        this.lblHelpLanguage.setToolTipText(MessagesService.getString("LeCToTranslateDialog.lblHelpLanguage.tooltipText"));
        this.lblHelpImage.setToolTipText(MessagesService.getString("LeCToTranslateDialog.lblHelpImage.tooltipText"));
        this.languageTranslateSuccess = MessagesService.getString("LeCToTranslateDialog.languageTranslateSuccess.text");
        this.languageTranslateError = MessagesService.getString("LeCToTranslateDialog.languageTranslateError.text");
    }

    public Boolean getSave() {
        return this.save;
    }

    private static enum CaseType {
        UPPER_CASE,
        LOWER_CASE,
        NONE;

    }

    public class MaxLengthTextDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;
        private int maxChars;
        private CaseType caseType;

        public MaxLengthTextDocument(int maxChars, CaseType caseType) {
            this.maxChars = maxChars;
            this.caseType = caseType;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a2) throws BadLocationException {
            if (!str.matches("[a-zA-Z]")) {
                return;
            }
            if (str != null && this.getLength() + str.length() <= this.maxChars) {
                switch (this.caseType) {
                    case UPPER_CASE: {
                        str = str.toUpperCase();
                        break;
                    }
                    case LOWER_CASE: {
                        str = str.toLowerCase();
                        break;
                    }
                }
                super.insertString(offs, str, a2);
            }
        }
    }

    class VariableRowHeightRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public VariableRowHeightRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                if (table.isCellEditable(row, column)) {
                    super.setForeground(UIManager.getColor("Table.focusCellForeground"));
                    super.setBackground(UIManager.getColor("Table.focusCellBackground"));
                }
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            }
            this.setText((String)value);
            String text = table.getValueAt(row, 1).toString();
            int wordFound = StringUtil.countOccurrences(text, "<br/>");
            table.setRowHeight(row, this.getPreferredSize().height + this.getPreferredSize().height * wordFound);
            this.setHorizontalAlignment(2);
            return this;
        }
    }
}

