/*
 * Decompiled with CFR 0.152.
 */
package fer.lss.lecto.model;

import fer.lss.lecto.LeCTo;
import fer.lss.lecto.model.mediaoptions.MediaOptions;
import fer.lss.lecto.model.mediaoptions.impl.MediaOptionsLinux;
import fer.lss.lecto.model.mediaoptions.impl.MediaOptionsMacOSX;
import fer.lss.lecto.model.mediaoptions.impl.MediaOptionsWindows;
import fer.lss.lecto.services.MessagesService;
import fer.lss.lecto.services.encoding.EncodingService;
import fer.lss.lecto.services.usersettings.UserSettingsService;
import java.util.List;

public enum DefaultEncodingParameters {
    LOW(MessagesService.getString("DefaultEncodingParameters.LOW.text"), "512", "20", "128", "512", "20", "300", "28", "44.1", "640x480", "1024x768"),
    MEDIUM(MessagesService.getString("DefaultEncodingParameters.MEDIUM.text"), "1536", "20", "128", "1536", "20", "300", "23", "44.1", "800x600", "1024x768"),
    HIGH(MessagesService.getString("DefaultEncodingParameters.HIGH.text"), "2048", "20", "256", "2048", "20", "300", "18", "44.1", "1024x768", "1920x1080");

    private String presetName;
    private String vbCamera;
    private String fpsCamera;
    private String ab;
    private String vbScreen;
    private String fpsScreen;
    private String cachingScreen;
    private String samplingRate;
    private String crf;
    private String resolutionCamera;
    private String resolutionScreen;

    private DefaultEncodingParameters(String presetName, String vbCamera, String fpsCamera, String ab2, String vbScreen, String fpsScreen, String cachingScreen, String crf, String samplingRate, String resolutionCamera, String resolutionScreen) {
        this.presetName = presetName;
        this.vbCamera = vbCamera;
        this.fpsCamera = fpsCamera;
        this.ab = ab2;
        this.vbScreen = vbScreen;
        this.fpsScreen = fpsScreen;
        this.cachingScreen = cachingScreen;
        this.samplingRate = samplingRate;
        this.crf = crf;
        this.resolutionCamera = resolutionCamera;
        this.resolutionScreen = resolutionScreen;
    }

    public static void updatePresetNames() {
        LOW.setPresetName(MessagesService.getString("DefaultEncodingParameters.LOW.text"));
        MEDIUM.setPresetName(MessagesService.getString("DefaultEncodingParameters.MEDIUM.text"));
        HIGH.setPresetName(MessagesService.getString("DefaultEncodingParameters.HIGH.text"));
    }

    public static String getCrfMinValue() {
        return "0";
    }

    public static String getCrfMaxValue() {
        return "51";
    }

    public static String getPresetName(DefaultEncodingParameters defaultEncodingParameters) {
        DefaultEncodingParameters[] defaultEncodingParametersArray = DefaultEncodingParameters.values();
        int n2 = defaultEncodingParametersArray.length;
        int n3 = 0;
        while (n3 < n2) {
            DefaultEncodingParameters parameters = defaultEncodingParametersArray[n3];
            if (defaultEncodingParameters.equals((Object)parameters)) {
                return parameters.getPresetName();
            }
            ++n3;
        }
        return null;
    }

    public static DefaultEncodingParameters getDefaultEncodingParametersByPresetName(String presetName) {
        DefaultEncodingParameters[] defaultEncodingParametersArray = DefaultEncodingParameters.values();
        int n2 = defaultEncodingParametersArray.length;
        int n3 = 0;
        while (n3 < n2) {
            DefaultEncodingParameters parameters = defaultEncodingParametersArray[n3];
            if (parameters.getPresetName().equals(presetName)) {
                return parameters;
            }
            ++n3;
        }
        return null;
    }

    public static String getVbCamera(DefaultEncodingParameters defaultEncodingParameters) {
        DefaultEncodingParameters[] defaultEncodingParametersArray = DefaultEncodingParameters.values();
        int n2 = defaultEncodingParametersArray.length;
        int n3 = 0;
        while (n3 < n2) {
            DefaultEncodingParameters parameters = defaultEncodingParametersArray[n3];
            if (defaultEncodingParameters.equals((Object)parameters)) {
                return parameters.getVbCamera();
            }
            ++n3;
        }
        return null;
    }

    public static String getFpsCamera(DefaultEncodingParameters defaultEncodingParameters) {
        DefaultEncodingParameters[] defaultEncodingParametersArray = DefaultEncodingParameters.values();
        int n2 = defaultEncodingParametersArray.length;
        int n3 = 0;
        while (n3 < n2) {
            DefaultEncodingParameters parameters = defaultEncodingParametersArray[n3];
            if (defaultEncodingParameters.equals((Object)parameters)) {
                return parameters.getFpsCamera();
            }
            ++n3;
        }
        return null;
    }

    public static String getAb(DefaultEncodingParameters defaultEncodingParameters) {
        DefaultEncodingParameters[] defaultEncodingParametersArray = DefaultEncodingParameters.values();
        int n2 = defaultEncodingParametersArray.length;
        int n3 = 0;
        while (n3 < n2) {
            DefaultEncodingParameters parameters = defaultEncodingParametersArray[n3];
            if (defaultEncodingParameters.equals((Object)parameters)) {
                return parameters.getAb();
            }
            ++n3;
        }
        return null;
    }

    public static String getVbScreen(DefaultEncodingParameters defaultEncodingParameters) {
        DefaultEncodingParameters[] defaultEncodingParametersArray = DefaultEncodingParameters.values();
        int n2 = defaultEncodingParametersArray.length;
        int n3 = 0;
        while (n3 < n2) {
            DefaultEncodingParameters parameters = defaultEncodingParametersArray[n3];
            if (defaultEncodingParameters.equals((Object)parameters)) {
                return parameters.getVbScreen();
            }
            ++n3;
        }
        return null;
    }

    public static String getFpsScreen(DefaultEncodingParameters defaultEncodingParameters) {
        DefaultEncodingParameters[] defaultEncodingParametersArray = DefaultEncodingParameters.values();
        int n2 = defaultEncodingParametersArray.length;
        int n3 = 0;
        while (n3 < n2) {
            DefaultEncodingParameters parameters = defaultEncodingParametersArray[n3];
            if (defaultEncodingParameters.equals((Object)parameters)) {
                return parameters.getFpsScreen();
            }
            ++n3;
        }
        return null;
    }

    public static String getCachingScreen(DefaultEncodingParameters defaultEncodingParameters) {
        DefaultEncodingParameters[] defaultEncodingParametersArray = DefaultEncodingParameters.values();
        int n2 = defaultEncodingParametersArray.length;
        int n3 = 0;
        while (n3 < n2) {
            DefaultEncodingParameters parameters = defaultEncodingParametersArray[n3];
            if (defaultEncodingParameters.equals((Object)parameters)) {
                return parameters.getCachingScreen();
            }
            ++n3;
        }
        return null;
    }

    public static MediaOptions getDefaultMediaOptionsWithNoVideoInput(DefaultEncodingParameters parameters) {
        MediaOptions options = null;
        String container = UserSettingsService.containers.get(0);
        List<String> videoCodecs = UserSettingsService.videoCodecsForContainer.get(container);
        List<String> audioCodecs = UserSettingsService.audioCodecsForContainer.get(container);
        List<String> res = UserSettingsService.resolutions;
        List<String> presets = UserSettingsService.presets;
        switch (LeCTo.operatingSystem.getFamily()) {
            case WINDOWS: {
                options = new MediaOptionsWindows(EncodingService.getEmptyVideoSource(), videoCodecs.get(0), DefaultEncodingParameters.getVbCamera(parameters), DefaultEncodingParameters.getFpsCamera(parameters), EncodingService.getEmptyAudioSource(), DefaultEncodingParameters.getAb(parameters), null, null, null, EncodingService.getCameraDeviceDefaultOutputFileName(), EncodingService.getCameraDeviceDefaultOutputFilePath(), DefaultEncodingParameters.getResolutionCamera(parameters), audioCodecs.get(0), container, DefaultEncodingParameters.getSamplingRate(parameters), DefaultEncodingParameters.getCrf(parameters), presets.get(0));
                break;
            }
            case LINUX: {
                options = new MediaOptionsLinux(EncodingService.getEmptyVideoSource(), videoCodecs.get(0), DefaultEncodingParameters.getVbCamera(parameters), DefaultEncodingParameters.getFpsCamera(parameters), EncodingService.getEmptyAudioSource(), DefaultEncodingParameters.getAb(parameters), null, null, null, EncodingService.getCameraDeviceDefaultOutputFileName(), EncodingService.getCameraDeviceDefaultOutputFilePath(), DefaultEncodingParameters.getResolutionCamera(parameters), audioCodecs.get(0), container, DefaultEncodingParameters.getSamplingRate(parameters), DefaultEncodingParameters.getCrf(parameters), presets.get(0));
                break;
            }
            case MAC: {
                options = new MediaOptionsMacOSX(EncodingService.getEmptyVideoSource(), videoCodecs.get(0), DefaultEncodingParameters.getVbCamera(parameters), DefaultEncodingParameters.getFpsCamera(parameters), EncodingService.getEmptyAudioSource(), DefaultEncodingParameters.getAb(parameters), null, null, null, EncodingService.getCameraDeviceDefaultOutputFileName(), EncodingService.getCameraDeviceDefaultOutputFilePath(), DefaultEncodingParameters.getResolutionCamera(parameters), audioCodecs.get(0), container, DefaultEncodingParameters.getSamplingRate(parameters), DefaultEncodingParameters.getCrf(parameters));
            }
        }
        return options;
    }

    public static MediaOptions getDefaultMediaOptionsForCamera(DefaultEncodingParameters parameters) {
        MediaOptions options = null;
        String container = UserSettingsService.containers.get(0);
        List<String> videoCodecs = UserSettingsService.videoCodecsForContainer.get(container);
        List<String> audioCodecs = UserSettingsService.audioCodecsForContainer.get(container);
        List<String> res = UserSettingsService.resolutions;
        List<String> presets = UserSettingsService.presets;
        switch (LeCTo.operatingSystem.getFamily()) {
            case WINDOWS: {
                options = new MediaOptionsWindows(EncodingService.getDefaultCameraDevice(), videoCodecs.get(0), DefaultEncodingParameters.getVbCamera(parameters), DefaultEncodingParameters.getFpsCamera(parameters), EncodingService.getDefaultAudioDevice(), DefaultEncodingParameters.getAb(parameters), DefaultEncodingParameters.getVbScreen(parameters), DefaultEncodingParameters.getFpsScreen(parameters), null, EncodingService.getCameraDeviceDefaultOutputFileName(), EncodingService.getCameraDeviceDefaultOutputFilePath(), DefaultEncodingParameters.getResolutionCamera(parameters), audioCodecs.get(0), container, DefaultEncodingParameters.getSamplingRate(parameters), DefaultEncodingParameters.getCrf(parameters), presets.get(0));
                break;
            }
            case LINUX: {
                options = new MediaOptionsLinux(EncodingService.getDefaultCameraDevice(), videoCodecs.get(0), DefaultEncodingParameters.getVbCamera(parameters), DefaultEncodingParameters.getFpsCamera(parameters), EncodingService.getDefaultAudioDevice(), DefaultEncodingParameters.getAb(parameters), DefaultEncodingParameters.getVbScreen(parameters), DefaultEncodingParameters.getFpsScreen(parameters), null, EncodingService.getCameraDeviceDefaultOutputFileName(), EncodingService.getCameraDeviceDefaultOutputFilePath(), DefaultEncodingParameters.getResolutionCamera(parameters), audioCodecs.get(0), container, DefaultEncodingParameters.getSamplingRate(parameters), DefaultEncodingParameters.getCrf(parameters), presets.get(0));
                break;
            }
            case MAC: {
                options = new MediaOptionsMacOSX(EncodingService.getDefaultCameraDevice(), videoCodecs.get(0), DefaultEncodingParameters.getVbCamera(parameters), DefaultEncodingParameters.getFpsCamera(parameters), EncodingService.getDefaultAudioDevice(), DefaultEncodingParameters.getAb(parameters), null, null, null, EncodingService.getCameraDeviceDefaultOutputFileName(), EncodingService.getCameraDeviceDefaultOutputFilePath(), DefaultEncodingParameters.getResolutionCamera(parameters), audioCodecs.get(0), container, DefaultEncodingParameters.getSamplingRate(parameters), DefaultEncodingParameters.getCrf(parameters));
            }
        }
        return options;
    }

    public static MediaOptions getDefaultMediaOptionsForScreen(DefaultEncodingParameters parameters) {
        MediaOptions options = null;
        String container = UserSettingsService.containers.get(0);
        List<String> videoCodecs = UserSettingsService.videoCodecsForContainer.get(container);
        List<String> audioCodecs = UserSettingsService.audioCodecsForContainer.get(container);
        List<String> res = UserSettingsService.resolutions;
        List<String> presets = UserSettingsService.presets;
        switch (LeCTo.operatingSystem.getFamily()) {
            case WINDOWS: {
                options = new MediaOptionsWindows(EncodingService.getScreenDevice(), videoCodecs.get(0), DefaultEncodingParameters.getVbScreen(parameters), DefaultEncodingParameters.getFpsScreen(parameters), EncodingService.getEmptyAudioSource(), DefaultEncodingParameters.getAb(parameters), DefaultEncodingParameters.getVbScreen(parameters), DefaultEncodingParameters.getFpsScreen(parameters), DefaultEncodingParameters.getCachingScreen(parameters), EncodingService.getScreenDefaultOutputFileName(), EncodingService.getScreenDefaultOutputFilePath(), DefaultEncodingParameters.getResolutionScreen(parameters), audioCodecs.get(0), container, DefaultEncodingParameters.getSamplingRate(parameters), DefaultEncodingParameters.getCrf(parameters), presets.get(0));
                break;
            }
            case LINUX: {
                options = new MediaOptionsLinux(EncodingService.getScreenDevice(), videoCodecs.get(0), DefaultEncodingParameters.getVbScreen(parameters), DefaultEncodingParameters.getFpsScreen(parameters), EncodingService.getEmptyAudioSource(), DefaultEncodingParameters.getAb(parameters), DefaultEncodingParameters.getVbScreen(parameters), DefaultEncodingParameters.getFpsScreen(parameters), DefaultEncodingParameters.getCachingScreen(parameters), EncodingService.getScreenDefaultOutputFileName(), EncodingService.getScreenDefaultOutputFilePath(), DefaultEncodingParameters.getResolutionScreen(parameters), audioCodecs.get(0), container, DefaultEncodingParameters.getSamplingRate(parameters), DefaultEncodingParameters.getCrf(parameters), presets.get(0));
                break;
            }
            case MAC: {
                options = new MediaOptionsMacOSX(EncodingService.getScreenDevice(), videoCodecs.get(0), null, null, EncodingService.getEmptyAudioSource(), DefaultEncodingParameters.getAb(parameters), DefaultEncodingParameters.getVbScreen(parameters), DefaultEncodingParameters.getFpsScreen(parameters), DefaultEncodingParameters.getCachingScreen(parameters), EncodingService.getScreenDefaultOutputFileName(), EncodingService.getScreenDefaultOutputFilePath(), DefaultEncodingParameters.getResolutionScreen(parameters), audioCodecs.get(0), container, DefaultEncodingParameters.getSamplingRate(parameters), DefaultEncodingParameters.getCrf(parameters));
            }
        }
        return options;
    }

    public static String getSamplingRate(DefaultEncodingParameters defaultEncodingParameters) {
        DefaultEncodingParameters[] defaultEncodingParametersArray = DefaultEncodingParameters.values();
        int n2 = defaultEncodingParametersArray.length;
        int n3 = 0;
        while (n3 < n2) {
            DefaultEncodingParameters parameters = defaultEncodingParametersArray[n3];
            if (defaultEncodingParameters.equals((Object)parameters)) {
                return parameters.getSamplingRate();
            }
            ++n3;
        }
        return null;
    }

    public static String getCrf(DefaultEncodingParameters defaultEncodingParameters) {
        DefaultEncodingParameters[] defaultEncodingParametersArray = DefaultEncodingParameters.values();
        int n2 = defaultEncodingParametersArray.length;
        int n3 = 0;
        while (n3 < n2) {
            DefaultEncodingParameters parameters = defaultEncodingParametersArray[n3];
            if (defaultEncodingParameters.equals((Object)parameters)) {
                return parameters.getCrf();
            }
            ++n3;
        }
        return null;
    }

    public static String getResolutionCamera(DefaultEncodingParameters defaultEncodingParameters) {
        DefaultEncodingParameters[] defaultEncodingParametersArray = DefaultEncodingParameters.values();
        int n2 = defaultEncodingParametersArray.length;
        int n3 = 0;
        while (n3 < n2) {
            DefaultEncodingParameters parameters = defaultEncodingParametersArray[n3];
            if (defaultEncodingParameters.equals((Object)parameters)) {
                return parameters.getResolutionCamera();
            }
            ++n3;
        }
        return null;
    }

    public static String getResolutionScreen(DefaultEncodingParameters defaultEncodingParameters) {
        DefaultEncodingParameters[] defaultEncodingParametersArray = DefaultEncodingParameters.values();
        int n2 = defaultEncodingParametersArray.length;
        int n3 = 0;
        while (n3 < n2) {
            DefaultEncodingParameters parameters = defaultEncodingParametersArray[n3];
            if (defaultEncodingParameters.equals((Object)parameters)) {
                return parameters.getResolutionScreen();
            }
            ++n3;
        }
        return null;
    }

    public String getSamplingRate() {
        return this.samplingRate;
    }

    public void setSamplingRate(String samplingRate) {
        this.samplingRate = samplingRate;
    }

    public String getCrf() {
        return this.crf;
    }

    public void setCrf(String crf) {
        this.crf = crf;
    }

    public String getPresetName() {
        return this.presetName;
    }

    public void setPresetName(String presetName) {
        this.presetName = presetName;
    }

    public String getVbCamera() {
        return this.vbCamera;
    }

    public void setVbCamera(String vbCamera) {
        this.vbCamera = vbCamera;
    }

    public String getFpsCamera() {
        return this.fpsCamera;
    }

    public void setFpsCamera(String fpsCamera) {
        this.fpsCamera = fpsCamera;
    }

    public String getAb() {
        return this.ab;
    }

    public void setAb(String ab2) {
        this.ab = ab2;
    }

    public String getVbScreen() {
        return this.vbScreen;
    }

    public void setVbScreen(String vbScreen) {
        this.vbScreen = vbScreen;
    }

    public String getFpsScreen() {
        return this.fpsScreen;
    }

    public void setFpsScreen(String fpsScreen) {
        this.fpsScreen = fpsScreen;
    }

    public String getCachingScreen() {
        return this.cachingScreen;
    }

    public void setCachingScreen(String cachingScreen) {
        this.cachingScreen = cachingScreen;
    }

    public String getResolutionCamera() {
        return this.resolutionCamera;
    }

    public String getResolutionScreen() {
        return this.resolutionScreen;
    }

    public void setResolutionScreen(String resolution) {
        this.resolutionScreen = resolution;
    }

    public void setResolutionCamera(String resolution) {
        this.resolutionCamera = resolution;
    }
}

