/*
 * Decompiled with CFR 0.152.
 */
package fer.lss.lecto.model.mediaoptions;

import fer.lss.lecto.model.mediaoptions.AudioDevice;
import fer.lss.lecto.model.mediaoptions.EncodingType;
import fer.lss.lecto.model.mediaoptions.VideoDevice;
import fer.lss.lecto.services.encoding.EncodingService;
import java.io.File;

public abstract class MediaOptions {
    protected EncodingType encodingType;
    protected VideoDevice videoInput;
    protected String videoCodec;
    protected Boolean hasVideo;
    protected Boolean hasAudio;
    protected String mrl;
    protected AudioDevice audioInput;
    protected String fileName;
    protected String fileFullPath;
    protected String vbCamera;
    protected String fpsCamera;
    protected String samplingRate;
    protected String crf;
    protected String ab;
    protected String vbScreen;
    protected String fpsScreen;
    protected String cachingScreen;
    protected String resolution;
    protected String audioCodec;
    protected String container;
    protected String preset;

    public String getPreset() {
        return this.preset;
    }

    public void setPreset(String preset) {
        this.preset = preset;
    }

    public String getContainer() {
        return this.container;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public String getResolution() {
        return this.resolution;
    }

    public void setResolution(String resolution) {
        this.resolution = resolution;
    }

    public String getAudioCodec() {
        return this.audioCodec;
    }

    public void setAudioCodec(String audioCodec) {
        this.audioCodec = audioCodec;
    }

    public String getFileFullName() {
        return String.valueOf(this.fileFullPath) + File.separator + this.fileName + "." + this.container;
    }

    public String getSamplingRate() {
        return this.samplingRate;
    }

    public void setSamplingRate(String samplingRate) {
        this.samplingRate = samplingRate;
    }

    public String getCrf() {
        return this.crf;
    }

    public void setCrf(String crf) {
        this.crf = crf;
    }

    public String getFileNameWithExtension() {
        return String.valueOf(this.fileName) + "." + this.container;
    }

    public VideoDevice getVideoInput() {
        return this.videoInput;
    }

    public void setVideoInput(VideoDevice videoInput) {
        if (videoInput.equals(EncodingService.getScreenDevice())) {
            this.mrl = EncodingService.getScreenMrl();
            this.encodingType = EncodingType.DESKTOP;
            this.hasVideo = true;
        } else if (videoInput.equals(EncodingService.getEmptyVideoSource())) {
            this.mrl = EncodingService.getCameraDeviceMrl();
            this.encodingType = EncodingType.AUDIO_ONLY_OR_NONE;
            this.hasVideo = false;
        } else {
            this.mrl = EncodingService.getCameraDeviceMrl();
            this.encodingType = EncodingType.CAMERA;
            this.hasVideo = true;
        }
        this.videoInput = videoInput;
    }

    public AudioDevice getAudioInput() {
        return this.audioInput;
    }

    public void setAudioInput(AudioDevice audioInput) {
        this.hasAudio = audioInput.equals(EncodingService.getEmptyAudioSource()) ? Boolean.valueOf(false) : Boolean.valueOf(true);
        this.audioInput = audioInput;
    }

    public String getVideoCodec() {
        return this.videoCodec;
    }

    public void setVideoCodec(String videoCodec) {
        this.videoCodec = videoCodec;
    }

    public String getFps() {
        switch (this.encodingType) {
            case CAMERA: {
                return this.fpsCamera;
            }
            case DESKTOP: {
                return this.fpsScreen;
            }
        }
        return null;
    }

    public void setFps(String fps) {
        switch (this.encodingType) {
            case CAMERA: {
                this.setFpsCamera(fps);
                break;
            }
            case DESKTOP: {
                this.setFpsScreen(fps);
            }
        }
    }

    public String getVB() {
        switch (this.encodingType) {
            case CAMERA: {
                return this.vbCamera;
            }
            case DESKTOP: {
                return this.vbScreen;
            }
        }
        return null;
    }

    public void setVB(String vB) {
        switch (this.encodingType) {
            case CAMERA: {
                this.setVbCamera(vB);
                break;
            }
            case DESKTOP: {
                this.setVbScreen(vB);
            }
        }
    }

    public EncodingType getEncodingType() {
        return this.encodingType;
    }

    public void setEncodingType(EncodingType encodingType) {
        this.encodingType = encodingType;
    }

    public Boolean getHasVideo() {
        return this.hasVideo;
    }

    public void setHasVideo(Boolean hasVideo) {
        this.hasVideo = hasVideo;
    }

    public Boolean getHasAudio() {
        return this.hasAudio;
    }

    public void setHasAudio(Boolean hasAudio) {
        this.hasAudio = hasAudio;
    }

    public String getMrl() {
        return this.mrl;
    }

    public void setMrl(String mrl) {
        this.mrl = mrl;
    }

    public String getFpsCamera() {
        return this.fpsCamera;
    }

    public void setFpsCamera(String fpsCamera) {
        this.fpsCamera = fpsCamera;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileFullPath() {
        return this.fileFullPath;
    }

    public void setFileFullPath(String fileFullPath) {
        this.fileFullPath = fileFullPath;
    }

    public String getVbCamera() {
        return this.vbCamera;
    }

    public void setVbCamera(String vbCamera) {
        this.vbCamera = vbCamera;
    }

    public String getAB() {
        return this.ab;
    }

    public void setAB(String ab2) {
        this.ab = ab2;
    }

    public String getVbScreen() {
        return this.vbScreen;
    }

    public void setVbScreen(String vbScreen) {
        this.vbScreen = vbScreen;
    }

    public String getFpsScreen() {
        return this.fpsScreen;
    }

    public void setFpsScreen(String fpsScreen) {
        this.fpsScreen = fpsScreen;
    }

    public String getCachingScreen() {
        return this.cachingScreen;
    }

    public void setCachingScreen(String cachingScreen) {
        this.cachingScreen = cachingScreen;
    }

    public String toString() {
        return String.valueOf(this.mrl) + " -- " + this.videoInput;
    }
}

