/*
 * Decompiled with CFR 0.152.
 */
package fer.lss.lecto.model.os;

import fer.lss.lecto.model.os.OperatingSystemFamily;

public enum OperatingSystem {
    LINUX_OS("Linux", OperatingSystemFamily.LINUX),
    MAC_OSX("Mac OS X", OperatingSystemFamily.MAC),
    WINDOWS_XP("Windows XP", OperatingSystemFamily.WINDOWS),
    WINDOWS_VISTA("Windows Vista", OperatingSystemFamily.WINDOWS),
    WINDOWS_7("Windows 7", OperatingSystemFamily.WINDOWS),
    WINDOWS_8("Windows 8", OperatingSystemFamily.WINDOWS),
    WINDOWS_8_1("Windows 8.1", OperatingSystemFamily.WINDOWS);

    private final String label;
    private final OperatingSystemFamily family;

    private OperatingSystem(String label, OperatingSystemFamily family) {
        this.label = label;
        this.family = family;
    }

    public String getLabel() {
        return this.label;
    }

    public OperatingSystemFamily getFamily() {
        return this.family;
    }

    public static OperatingSystem resolve(String osName) {
        OperatingSystem[] operatingSystemArray = OperatingSystem.values();
        int n2 = operatingSystemArray.length;
        int n3 = 0;
        while (n3 < n2) {
            OperatingSystem os = operatingSystemArray[n3];
            if (os.label.equalsIgnoreCase(osName)) {
                return os;
            }
            ++n3;
        }
        return null;
    }
}

