/*
 * Decompiled with CFR 0.152.
 */
package fer.lss.lecto.services.encoding.impl;

import fer.lss.lecto.constants.LinuxConstants;
import fer.lss.lecto.model.mediaoptions.AudioDevice;
import fer.lss.lecto.model.mediaoptions.VideoDevice;
import fer.lss.lecto.model.mediaoptions.VideoDeviceType;
import fer.lss.lecto.services.encoding.impl.FFMPEGDeviceProvider;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;

public class EncodingServiceLinux {
    public static List<VideoDevice> getAvailableCameraDevices() {
        ArrayList<VideoDevice> availableCameras = new ArrayList<VideoDevice>();
        File file = new File(LinuxConstants.CAMERAS_ROOT_FOLDER);
        if (file.isDirectory()) {
            String[] fileNames;
            String[] stringArray = fileNames = file.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String fileName) {
                    return fileName.matches(LinuxConstants.CAMERA_FILE_NAME_REGEX);
                }
            });
            int n2 = fileNames.length;
            int n3 = 0;
            while (n3 < n2) {
                String camera = stringArray[n3];
                availableCameras.add(new VideoDevice(camera, camera, VideoDeviceType.CAMERA));
                ++n3;
            }
        }
        availableCameras.add(new VideoDevice("Desktop", "x11grab", VideoDeviceType.DESKTOP));
        return availableCameras;
    }

    public static VideoDevice getDefaultCameraDevice() {
        return EncodingServiceLinux.getAvailableCameraDevices().get(0);
    }

    public static VideoDevice getEmptyVideoSource() {
        return new VideoDevice("none", "none", VideoDeviceType.CAMERA);
    }

    public static AudioDevice getEmptyAudioSource() {
        return new AudioDevice("none", "");
    }

    public static String getCameraDeviceMrl() {
        return "v4l2://";
    }

    public static String getCameraDeviceDefaultOutputFilePath() {
        return LinuxConstants.LECTO_VIDEOS_FOLDER_LOCATION;
    }

    public static String getScreenDefaultOutputFilePath() {
        return LinuxConstants.LECTO_VIDEOS_FOLDER_LOCATION;
    }

    public static List<AudioDevice> getAvailableAudioDevices() {
        String[] devices;
        ArrayList<AudioDevice> availableAudioInputs = new ArrayList<AudioDevice>();
        String commandOutputString = FFMPEGDeviceProvider.getAvailableAudioDevicesString();
        String[] stringArray = devices = commandOutputString.split("\\n");
        int n2 = devices.length;
        int n3 = 0;
        while (n3 < n2) {
            String string = stringArray[n3];
            if (string.startsWith("card")) {
                int deviceStartIndex = string.indexOf("device");
                string = string.substring(deviceStartIndex);
                String[] tokens = string.split(" ");
                String name = "";
                int i2 = 2;
                while (i2 < tokens.length) {
                    name = String.valueOf(name) + tokens[i2] + " ";
                    ++i2;
                }
                availableAudioInputs.add(new AudioDevice(name, tokens[1].replace(":", "")));
            }
            ++n3;
        }
        return availableAudioInputs;
    }

    public static AudioDevice getDefaultAudioDevice() {
        return EncodingServiceLinux.getAvailableAudioDevices().get(0);
    }

    public static VideoDevice getDefaultScreenDevice() {
        List<VideoDevice> availableVideoInputs = EncodingServiceLinux.getAvailableCameraDevices();
        for (VideoDevice videoDevice : availableVideoInputs) {
            if (videoDevice.getVideoDeviceType() != VideoDeviceType.DESKTOP) continue;
            return videoDevice;
        }
        return null;
    }
}

