/*
 * Decompiled with CFR 0.152.
 */
package fer.lss.lecto.services.encoding.impl;

import fer.lss.lecto.model.mediaoptions.AudioDevice;
import fer.lss.lecto.model.mediaoptions.VideoDevice;
import fer.lss.lecto.model.mediaoptions.VideoDeviceType;
import fer.lss.lecto.services.encoding.impl.FFMPEGDeviceProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class EncodingServiceMacOSX {
    public static List<VideoDevice> getAvailableCameraDevices() {
        ArrayList<VideoDevice> availableCameras = new ArrayList<VideoDevice>();
        String commandOutputString = FFMPEGDeviceProvider.getAvailableVideoDevicesString();
        int startIndex = commandOutputString.indexOf("[AVF");
        int endIndex = commandOutputString.lastIndexOf("[AVF");
        String devicesString = commandOutputString.substring(startIndex, endIndex);
        String[] devices = devicesString.split("\\n");
        int i2 = 0;
        while (i2 < devices.length) {
            String string = devices[i2];
            if ((string = string.substring(string.lastIndexOf("]") + 1, string.length()).trim()).indexOf("screen") != -1) {
                availableCameras.add(new VideoDevice(string, "" + i2, VideoDeviceType.DESKTOP));
            } else {
                availableCameras.add(new VideoDevice(string, "" + i2, VideoDeviceType.CAMERA));
            }
            ++i2;
        }
        return availableCameras;
    }

    public static VideoDevice getDefaultCameraDevice() {
        return EncodingServiceMacOSX.getAvailableCameraDevices().get(0);
    }

    public static VideoDevice getEmptyVideoSource() {
        return new VideoDevice("none", "none", VideoDeviceType.CAMERA);
    }

    public static AudioDevice getEmptyAudioSource() {
        return new AudioDevice("none", "none");
    }

    public static String getCameraDeviceMrl() {
        return "qtcapture://";
    }

    public static String getCameraDeviceDefaultOutputFilePath() {
        File dir = new File(System.getProperty("user.home"), "Videos" + File.separator + "LeCTo");
        dir.mkdirs();
        return dir.getAbsolutePath();
    }

    public static String getScreenDefaultOutputFilePath() {
        File dir = new File(System.getProperty("user.home"), "Videos" + File.separator + "LeCTo");
        dir.mkdirs();
        return dir.getAbsolutePath();
    }

    public static List<AudioDevice> getAvailableAudioDevices() {
        ArrayList<AudioDevice> availableAudioInputs = new ArrayList<AudioDevice>();
        String commandOutputString = FFMPEGDeviceProvider.getAvailableAudioDevicesString();
        int startIndex = commandOutputString.indexOf("[AVF");
        int endIndex = commandOutputString.lastIndexOf("\"");
        String devicesString = commandOutputString.substring(startIndex, endIndex);
        String[] devices = devicesString.split("\\n");
        int i2 = 0;
        while (i2 < devices.length) {
            String string = devices[i2];
            string = string.substring(string.lastIndexOf("]") + 1, string.length()).trim();
            availableAudioInputs.add(new AudioDevice(string, "" + i2));
            ++i2;
        }
        return availableAudioInputs;
    }

    public static AudioDevice getDefaultAudioDevice() {
        return EncodingServiceMacOSX.getAvailableAudioDevices().get(0);
    }

    public static VideoDevice getDefaultScreenDevice() {
        List<VideoDevice> availableVideoInputs = EncodingServiceMacOSX.getAvailableCameraDevices();
        for (VideoDevice videoDevice : availableVideoInputs) {
            if (videoDevice.getVideoDeviceType() != VideoDeviceType.DESKTOP) continue;
            return videoDevice;
        }
        return null;
    }
}

