/*
 * Decompiled with CFR 0.152.
 */
package fer.lss.lecto.services.encoding.impl;

import fer.lss.lecto.constants.WindowsConstants;
import fer.lss.lecto.model.mediaoptions.AudioDevice;
import fer.lss.lecto.model.mediaoptions.VideoDevice;
import fer.lss.lecto.model.mediaoptions.VideoDeviceType;
import fer.lss.lecto.services.encoding.impl.FFMPEGDeviceProvider;
import fer.lss.lecto.utils.FilesUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class EncodingServiceWindows {
    public static List<VideoDevice> getAvailableCameraDevices() {
        String[] devices;
        ArrayList<VideoDevice> availableCameras = new ArrayList<VideoDevice>();
        String commandOutputString = FFMPEGDeviceProvider.getAvailableVideoDevicesString();
        int startIndex = commandOutputString.indexOf("[dshow");
        int endIndex = commandOutputString.lastIndexOf("[dshow");
        String devicesString = commandOutputString.substring(startIndex, endIndex);
        String[] stringArray = devices = devicesString.split("\\n");
        int n2 = devices.length;
        int n3 = 0;
        while (n3 < n2) {
            String string = stringArray[n3];
            if ((string = string.substring(string.lastIndexOf("]") + 1, string.length()).trim()).startsWith("\"")) {
                if ((string = string.replace("\"", "")).indexOf("creen") != -1) {
                    availableCameras.add(new VideoDevice(string, string, VideoDeviceType.DESKTOP));
                } else {
                    availableCameras.add(new VideoDevice(string, string, VideoDeviceType.CAMERA));
                }
            }
            ++n3;
        }
        return availableCameras;
    }

    public static VideoDevice getDefaultCameraDevice() {
        if (EncodingServiceWindows.getAvailableCameraDevices().size() > 0) {
            return EncodingServiceWindows.getAvailableCameraDevices().get(0);
        }
        return EncodingServiceWindows.getEmptyVideoSource();
    }

    public static VideoDevice getEmptyVideoSource() {
        return new VideoDevice("none", "none", VideoDeviceType.CAMERA);
    }

    public static AudioDevice getEmptyAudioSource() {
        return new AudioDevice("none", "none");
    }

    public static String getCameraDeviceMrl() {
        return "dshow://";
    }

    public static String getCameraDeviceDefaultOutputFilePath() {
        return WindowsConstants.LECTO_VIDEOS_FOLDER_LOCATION;
    }

    public static String getScreenDefaultOutputFilePath() {
        return WindowsConstants.LECTO_VIDEOS_FOLDER_LOCATION;
    }

    public static List<AudioDevice> getAvailableAudioDevices() {
        ArrayList<AudioDevice> availableAudioInputs = new ArrayList<AudioDevice>();
        String commandOutputString = FFMPEGDeviceProvider.getAvailableAudioDevicesString();
        int startIndex = commandOutputString.indexOf("DirectShow audio devices");
        int endIndex = commandOutputString.lastIndexOf("]");
        String devicesString = commandOutputString.substring(startIndex, endIndex);
        String[] devices = devicesString.split("\\n");
        int i2 = 0;
        while (i2 < devices.length) {
            String string = devices[i2];
            if ((string = string.substring(string.lastIndexOf("]") + 1, string.length()).trim()).startsWith("\"")) {
                string = string.replace("\"", "");
                availableAudioInputs.add(new AudioDevice(string, "" + i2));
            }
            ++i2;
        }
        return availableAudioInputs;
    }

    public static AudioDevice getDefaultAudioDevice() {
        return EncodingServiceWindows.getAvailableAudioDevices().get(0);
    }

    public static String getMouseIconPath() throws IOException {
        String filePath = WindowsConstants.LECTO_FILES_LOCATION;
        String fileName = "mouseIcon.png";
        File file = new File(String.valueOf(filePath) + "/" + fileName);
        if (!file.exists()) {
            System.out.println("File does not exist, loading it from resources");
            file = FilesUtil.copyResourceToFile("/images", fileName, filePath);
        }
        return file.getAbsolutePath();
    }

    public static VideoDevice getDefaultScreenDevice() {
        List<VideoDevice> availableVideoInputs = EncodingServiceWindows.getAvailableCameraDevices();
        for (VideoDevice videoDevice : availableVideoInputs) {
            if (videoDevice.getVideoDeviceType() != VideoDeviceType.DESKTOP) continue;
            return videoDevice;
        }
        return EncodingServiceWindows.getEmptyVideoSource();
    }
}

